// // Copyright (c) 2022 Tencent. All rights reserved.
// Autogenerated from Pigeon (v9.0.4), do not edit directly.
// See also: https://pub.dev/packages/pigeon

package com.tencent.vod.flutter.messages;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.plugin.common.BasicMessageChannel;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MessageCodec;
import io.flutter.plugin.common.StandardMessageCodec;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** Generated class from Pigeon. */
@SuppressWarnings({"unused", "unchecked", "CodeBlock2Expr", "RedundantSuppression"})
public class FtxMessages {
  @NonNull
  private static ArrayList<Object> wrapError(@NonNull Throwable exception) {
    ArrayList<Object> errorList = new ArrayList<Object>(3);
    errorList.add(exception.toString());
    errorList.add(exception.getClass().getSimpleName());
    errorList.add(
      "Cause: " + exception.getCause() + ", Stacktrace: " + Log.getStackTraceString(exception));
    return errorList;
  }

  /**
   * pigeon原始原件，由此文件生成messages原生通信代码
   * 生成命令如下
   *
   * Generated class from Pigeon that represents data sent in messages.
   */
  public static final class PlayerMsg {
    private @Nullable Long playerId;

    public @Nullable Long getPlayerId() {
      return playerId;
    }

    public void setPlayerId(@Nullable Long setterArg) {
      this.playerId = setterArg;
    }

    public static final class Builder {

      private @Nullable Long playerId;

      public @NonNull Builder setPlayerId(@Nullable Long setterArg) {
        this.playerId = setterArg;
        return this;
      }

      public @NonNull PlayerMsg build() {
        PlayerMsg pigeonReturn = new PlayerMsg();
        pigeonReturn.setPlayerId(playerId);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(1);
      toListResult.add(playerId);
      return toListResult;
    }

    static @NonNull PlayerMsg fromList(@NonNull ArrayList<Object> list) {
      PlayerMsg pigeonResult = new PlayerMsg();
      Object playerId = list.get(0);
      pigeonResult.setPlayerId((playerId == null) ? null : ((playerId instanceof Integer) ? (Integer) playerId : (Long) playerId));
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class LicenseMsg {
    private @Nullable String licenseUrl;

    public @Nullable String getLicenseUrl() {
      return licenseUrl;
    }

    public void setLicenseUrl(@Nullable String setterArg) {
      this.licenseUrl = setterArg;
    }

    private @Nullable String licenseKey;

    public @Nullable String getLicenseKey() {
      return licenseKey;
    }

    public void setLicenseKey(@Nullable String setterArg) {
      this.licenseKey = setterArg;
    }

    public static final class Builder {

      private @Nullable String licenseUrl;

      public @NonNull Builder setLicenseUrl(@Nullable String setterArg) {
        this.licenseUrl = setterArg;
        return this;
      }

      private @Nullable String licenseKey;

      public @NonNull Builder setLicenseKey(@Nullable String setterArg) {
        this.licenseKey = setterArg;
        return this;
      }

      public @NonNull LicenseMsg build() {
        LicenseMsg pigeonReturn = new LicenseMsg();
        pigeonReturn.setLicenseUrl(licenseUrl);
        pigeonReturn.setLicenseKey(licenseKey);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(2);
      toListResult.add(licenseUrl);
      toListResult.add(licenseKey);
      return toListResult;
    }

    static @NonNull LicenseMsg fromList(@NonNull ArrayList<Object> list) {
      LicenseMsg pigeonResult = new LicenseMsg();
      Object licenseUrl = list.get(0);
      pigeonResult.setLicenseUrl((String) licenseUrl);
      Object licenseKey = list.get(1);
      pigeonResult.setLicenseKey((String) licenseKey);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class TXPlayInfoParamsPlayerMsg {
    private @Nullable Long playerId;

    public @Nullable Long getPlayerId() {
      return playerId;
    }

    public void setPlayerId(@Nullable Long setterArg) {
      this.playerId = setterArg;
    }

    private @Nullable Long appId;

    public @Nullable Long getAppId() {
      return appId;
    }

    public void setAppId(@Nullable Long setterArg) {
      this.appId = setterArg;
    }

    private @Nullable String fileId;

    public @Nullable String getFileId() {
      return fileId;
    }

    public void setFileId(@Nullable String setterArg) {
      this.fileId = setterArg;
    }

    private @Nullable String psign;

    public @Nullable String getPsign() {
      return psign;
    }

    public void setPsign(@Nullable String setterArg) {
      this.psign = setterArg;
    }

    public static final class Builder {

      private @Nullable Long playerId;

      public @NonNull Builder setPlayerId(@Nullable Long setterArg) {
        this.playerId = setterArg;
        return this;
      }

      private @Nullable Long appId;

      public @NonNull Builder setAppId(@Nullable Long setterArg) {
        this.appId = setterArg;
        return this;
      }

      private @Nullable String fileId;

      public @NonNull Builder setFileId(@Nullable String setterArg) {
        this.fileId = setterArg;
        return this;
      }

      private @Nullable String psign;

      public @NonNull Builder setPsign(@Nullable String setterArg) {
        this.psign = setterArg;
        return this;
      }

      public @NonNull TXPlayInfoParamsPlayerMsg build() {
        TXPlayInfoParamsPlayerMsg pigeonReturn = new TXPlayInfoParamsPlayerMsg();
        pigeonReturn.setPlayerId(playerId);
        pigeonReturn.setAppId(appId);
        pigeonReturn.setFileId(fileId);
        pigeonReturn.setPsign(psign);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(4);
      toListResult.add(playerId);
      toListResult.add(appId);
      toListResult.add(fileId);
      toListResult.add(psign);
      return toListResult;
    }

    static @NonNull TXPlayInfoParamsPlayerMsg fromList(@NonNull ArrayList<Object> list) {
      TXPlayInfoParamsPlayerMsg pigeonResult = new TXPlayInfoParamsPlayerMsg();
      Object playerId = list.get(0);
      pigeonResult.setPlayerId((playerId == null) ? null : ((playerId instanceof Integer) ? (Integer) playerId : (Long) playerId));
      Object appId = list.get(1);
      pigeonResult.setAppId((appId == null) ? null : ((appId instanceof Integer) ? (Integer) appId : (Long) appId));
      Object fileId = list.get(2);
      pigeonResult.setFileId((String) fileId);
      Object psign = list.get(3);
      pigeonResult.setPsign((String) psign);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class PipParamsPlayerMsg {
    private @Nullable Long playerId;

    public @Nullable Long getPlayerId() {
      return playerId;
    }

    public void setPlayerId(@Nullable Long setterArg) {
      this.playerId = setterArg;
    }

    private @Nullable String backIconForAndroid;

    public @Nullable String getBackIconForAndroid() {
      return backIconForAndroid;
    }

    public void setBackIconForAndroid(@Nullable String setterArg) {
      this.backIconForAndroid = setterArg;
    }

    private @Nullable String playIconForAndroid;

    public @Nullable String getPlayIconForAndroid() {
      return playIconForAndroid;
    }

    public void setPlayIconForAndroid(@Nullable String setterArg) {
      this.playIconForAndroid = setterArg;
    }

    private @Nullable String pauseIconForAndroid;

    public @Nullable String getPauseIconForAndroid() {
      return pauseIconForAndroid;
    }

    public void setPauseIconForAndroid(@Nullable String setterArg) {
      this.pauseIconForAndroid = setterArg;
    }

    private @Nullable String forwardIconForAndroid;

    public @Nullable String getForwardIconForAndroid() {
      return forwardIconForAndroid;
    }

    public void setForwardIconForAndroid(@Nullable String setterArg) {
      this.forwardIconForAndroid = setterArg;
    }

    public static final class Builder {

      private @Nullable Long playerId;

      public @NonNull Builder setPlayerId(@Nullable Long setterArg) {
        this.playerId = setterArg;
        return this;
      }

      private @Nullable String backIconForAndroid;

      public @NonNull Builder setBackIconForAndroid(@Nullable String setterArg) {
        this.backIconForAndroid = setterArg;
        return this;
      }

      private @Nullable String playIconForAndroid;

      public @NonNull Builder setPlayIconForAndroid(@Nullable String setterArg) {
        this.playIconForAndroid = setterArg;
        return this;
      }

      private @Nullable String pauseIconForAndroid;

      public @NonNull Builder setPauseIconForAndroid(@Nullable String setterArg) {
        this.pauseIconForAndroid = setterArg;
        return this;
      }

      private @Nullable String forwardIconForAndroid;

      public @NonNull Builder setForwardIconForAndroid(@Nullable String setterArg) {
        this.forwardIconForAndroid = setterArg;
        return this;
      }

      public @NonNull PipParamsPlayerMsg build() {
        PipParamsPlayerMsg pigeonReturn = new PipParamsPlayerMsg();
        pigeonReturn.setPlayerId(playerId);
        pigeonReturn.setBackIconForAndroid(backIconForAndroid);
        pigeonReturn.setPlayIconForAndroid(playIconForAndroid);
        pigeonReturn.setPauseIconForAndroid(pauseIconForAndroid);
        pigeonReturn.setForwardIconForAndroid(forwardIconForAndroid);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(5);
      toListResult.add(playerId);
      toListResult.add(backIconForAndroid);
      toListResult.add(playIconForAndroid);
      toListResult.add(pauseIconForAndroid);
      toListResult.add(forwardIconForAndroid);
      return toListResult;
    }

    static @NonNull PipParamsPlayerMsg fromList(@NonNull ArrayList<Object> list) {
      PipParamsPlayerMsg pigeonResult = new PipParamsPlayerMsg();
      Object playerId = list.get(0);
      pigeonResult.setPlayerId((playerId == null) ? null : ((playerId instanceof Integer) ? (Integer) playerId : (Long) playerId));
      Object backIconForAndroid = list.get(1);
      pigeonResult.setBackIconForAndroid((String) backIconForAndroid);
      Object playIconForAndroid = list.get(2);
      pigeonResult.setPlayIconForAndroid((String) playIconForAndroid);
      Object pauseIconForAndroid = list.get(3);
      pigeonResult.setPauseIconForAndroid((String) pauseIconForAndroid);
      Object forwardIconForAndroid = list.get(4);
      pigeonResult.setForwardIconForAndroid((String) forwardIconForAndroid);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class StringListPlayerMsg {
    private @Nullable Long playerId;

    public @Nullable Long getPlayerId() {
      return playerId;
    }

    public void setPlayerId(@Nullable Long setterArg) {
      this.playerId = setterArg;
    }

    private @Nullable String vvtUrl;

    public @Nullable String getVvtUrl() {
      return vvtUrl;
    }

    public void setVvtUrl(@Nullable String setterArg) {
      this.vvtUrl = setterArg;
    }

    private @Nullable List<String> imageUrls;

    public @Nullable List<String> getImageUrls() {
      return imageUrls;
    }

    public void setImageUrls(@Nullable List<String> setterArg) {
      this.imageUrls = setterArg;
    }

    public static final class Builder {

      private @Nullable Long playerId;

      public @NonNull Builder setPlayerId(@Nullable Long setterArg) {
        this.playerId = setterArg;
        return this;
      }

      private @Nullable String vvtUrl;

      public @NonNull Builder setVvtUrl(@Nullable String setterArg) {
        this.vvtUrl = setterArg;
        return this;
      }

      private @Nullable List<String> imageUrls;

      public @NonNull Builder setImageUrls(@Nullable List<String> setterArg) {
        this.imageUrls = setterArg;
        return this;
      }

      public @NonNull StringListPlayerMsg build() {
        StringListPlayerMsg pigeonReturn = new StringListPlayerMsg();
        pigeonReturn.setPlayerId(playerId);
        pigeonReturn.setVvtUrl(vvtUrl);
        pigeonReturn.setImageUrls(imageUrls);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(3);
      toListResult.add(playerId);
      toListResult.add(vvtUrl);
      toListResult.add(imageUrls);
      return toListResult;
    }

    static @NonNull StringListPlayerMsg fromList(@NonNull ArrayList<Object> list) {
      StringListPlayerMsg pigeonResult = new StringListPlayerMsg();
      Object playerId = list.get(0);
      pigeonResult.setPlayerId((playerId == null) ? null : ((playerId instanceof Integer) ? (Integer) playerId : (Long) playerId));
      Object vvtUrl = list.get(1);
      pigeonResult.setVvtUrl((String) vvtUrl);
      Object imageUrls = list.get(2);
      pigeonResult.setImageUrls((List<String>) imageUrls);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class BoolPlayerMsg {
    private @Nullable Long playerId;

    public @Nullable Long getPlayerId() {
      return playerId;
    }

    public void setPlayerId(@Nullable Long setterArg) {
      this.playerId = setterArg;
    }

    private @Nullable Boolean value;

    public @Nullable Boolean getValue() {
      return value;
    }

    public void setValue(@Nullable Boolean setterArg) {
      this.value = setterArg;
    }

    public static final class Builder {

      private @Nullable Long playerId;

      public @NonNull Builder setPlayerId(@Nullable Long setterArg) {
        this.playerId = setterArg;
        return this;
      }

      private @Nullable Boolean value;

      public @NonNull Builder setValue(@Nullable Boolean setterArg) {
        this.value = setterArg;
        return this;
      }

      public @NonNull BoolPlayerMsg build() {
        BoolPlayerMsg pigeonReturn = new BoolPlayerMsg();
        pigeonReturn.setPlayerId(playerId);
        pigeonReturn.setValue(value);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(2);
      toListResult.add(playerId);
      toListResult.add(value);
      return toListResult;
    }

    static @NonNull BoolPlayerMsg fromList(@NonNull ArrayList<Object> list) {
      BoolPlayerMsg pigeonResult = new BoolPlayerMsg();
      Object playerId = list.get(0);
      pigeonResult.setPlayerId((playerId == null) ? null : ((playerId instanceof Integer) ? (Integer) playerId : (Long) playerId));
      Object value = list.get(1);
      pigeonResult.setValue((Boolean) value);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class StringIntPlayerMsg {
    private @Nullable Long playerId;

    public @Nullable Long getPlayerId() {
      return playerId;
    }

    public void setPlayerId(@Nullable Long setterArg) {
      this.playerId = setterArg;
    }

    private @Nullable String strValue;

    public @Nullable String getStrValue() {
      return strValue;
    }

    public void setStrValue(@Nullable String setterArg) {
      this.strValue = setterArg;
    }

    private @Nullable Long intValue;

    public @Nullable Long getIntValue() {
      return intValue;
    }

    public void setIntValue(@Nullable Long setterArg) {
      this.intValue = setterArg;
    }

    public static final class Builder {

      private @Nullable Long playerId;

      public @NonNull Builder setPlayerId(@Nullable Long setterArg) {
        this.playerId = setterArg;
        return this;
      }

      private @Nullable String strValue;

      public @NonNull Builder setStrValue(@Nullable String setterArg) {
        this.strValue = setterArg;
        return this;
      }

      private @Nullable Long intValue;

      public @NonNull Builder setIntValue(@Nullable Long setterArg) {
        this.intValue = setterArg;
        return this;
      }

      public @NonNull StringIntPlayerMsg build() {
        StringIntPlayerMsg pigeonReturn = new StringIntPlayerMsg();
        pigeonReturn.setPlayerId(playerId);
        pigeonReturn.setStrValue(strValue);
        pigeonReturn.setIntValue(intValue);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(3);
      toListResult.add(playerId);
      toListResult.add(strValue);
      toListResult.add(intValue);
      return toListResult;
    }

    static @NonNull StringIntPlayerMsg fromList(@NonNull ArrayList<Object> list) {
      StringIntPlayerMsg pigeonResult = new StringIntPlayerMsg();
      Object playerId = list.get(0);
      pigeonResult.setPlayerId((playerId == null) ? null : ((playerId instanceof Integer) ? (Integer) playerId : (Long) playerId));
      Object strValue = list.get(1);
      pigeonResult.setStrValue((String) strValue);
      Object intValue = list.get(2);
      pigeonResult.setIntValue((intValue == null) ? null : ((intValue instanceof Integer) ? (Integer) intValue : (Long) intValue));
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class StringPlayerMsg {
    private @Nullable Long playerId;

    public @Nullable Long getPlayerId() {
      return playerId;
    }

    public void setPlayerId(@Nullable Long setterArg) {
      this.playerId = setterArg;
    }

    private @Nullable String value;

    public @Nullable String getValue() {
      return value;
    }

    public void setValue(@Nullable String setterArg) {
      this.value = setterArg;
    }

    public static final class Builder {

      private @Nullable Long playerId;

      public @NonNull Builder setPlayerId(@Nullable Long setterArg) {
        this.playerId = setterArg;
        return this;
      }

      private @Nullable String value;

      public @NonNull Builder setValue(@Nullable String setterArg) {
        this.value = setterArg;
        return this;
      }

      public @NonNull StringPlayerMsg build() {
        StringPlayerMsg pigeonReturn = new StringPlayerMsg();
        pigeonReturn.setPlayerId(playerId);
        pigeonReturn.setValue(value);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(2);
      toListResult.add(playerId);
      toListResult.add(value);
      return toListResult;
    }

    static @NonNull StringPlayerMsg fromList(@NonNull ArrayList<Object> list) {
      StringPlayerMsg pigeonResult = new StringPlayerMsg();
      Object playerId = list.get(0);
      pigeonResult.setPlayerId((playerId == null) ? null : ((playerId instanceof Integer) ? (Integer) playerId : (Long) playerId));
      Object value = list.get(1);
      pigeonResult.setValue((String) value);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class DoublePlayerMsg {
    private @Nullable Long playerId;

    public @Nullable Long getPlayerId() {
      return playerId;
    }

    public void setPlayerId(@Nullable Long setterArg) {
      this.playerId = setterArg;
    }

    private @Nullable Double value;

    public @Nullable Double getValue() {
      return value;
    }

    public void setValue(@Nullable Double setterArg) {
      this.value = setterArg;
    }

    public static final class Builder {

      private @Nullable Long playerId;

      public @NonNull Builder setPlayerId(@Nullable Long setterArg) {
        this.playerId = setterArg;
        return this;
      }

      private @Nullable Double value;

      public @NonNull Builder setValue(@Nullable Double setterArg) {
        this.value = setterArg;
        return this;
      }

      public @NonNull DoublePlayerMsg build() {
        DoublePlayerMsg pigeonReturn = new DoublePlayerMsg();
        pigeonReturn.setPlayerId(playerId);
        pigeonReturn.setValue(value);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(2);
      toListResult.add(playerId);
      toListResult.add(value);
      return toListResult;
    }

    static @NonNull DoublePlayerMsg fromList(@NonNull ArrayList<Object> list) {
      DoublePlayerMsg pigeonResult = new DoublePlayerMsg();
      Object playerId = list.get(0);
      pigeonResult.setPlayerId((playerId == null) ? null : ((playerId instanceof Integer) ? (Integer) playerId : (Long) playerId));
      Object value = list.get(1);
      pigeonResult.setValue((Double) value);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class IntPlayerMsg {
    private @Nullable Long playerId;

    public @Nullable Long getPlayerId() {
      return playerId;
    }

    public void setPlayerId(@Nullable Long setterArg) {
      this.playerId = setterArg;
    }

    private @Nullable Long value;

    public @Nullable Long getValue() {
      return value;
    }

    public void setValue(@Nullable Long setterArg) {
      this.value = setterArg;
    }

    public static final class Builder {

      private @Nullable Long playerId;

      public @NonNull Builder setPlayerId(@Nullable Long setterArg) {
        this.playerId = setterArg;
        return this;
      }

      private @Nullable Long value;

      public @NonNull Builder setValue(@Nullable Long setterArg) {
        this.value = setterArg;
        return this;
      }

      public @NonNull IntPlayerMsg build() {
        IntPlayerMsg pigeonReturn = new IntPlayerMsg();
        pigeonReturn.setPlayerId(playerId);
        pigeonReturn.setValue(value);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(2);
      toListResult.add(playerId);
      toListResult.add(value);
      return toListResult;
    }

    static @NonNull IntPlayerMsg fromList(@NonNull ArrayList<Object> list) {
      IntPlayerMsg pigeonResult = new IntPlayerMsg();
      Object playerId = list.get(0);
      pigeonResult.setPlayerId((playerId == null) ? null : ((playerId instanceof Integer) ? (Integer) playerId : (Long) playerId));
      Object value = list.get(1);
      pigeonResult.setValue((value == null) ? null : ((value instanceof Integer) ? (Integer) value : (Long) value));
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class FTXVodPlayConfigPlayerMsg {
    private @Nullable Long playerId;

    public @Nullable Long getPlayerId() {
      return playerId;
    }

    public void setPlayerId(@Nullable Long setterArg) {
      this.playerId = setterArg;
    }

    private @Nullable Long connectRetryCount;

    public @Nullable Long getConnectRetryCount() {
      return connectRetryCount;
    }

    public void setConnectRetryCount(@Nullable Long setterArg) {
      this.connectRetryCount = setterArg;
    }

    private @Nullable Long connectRetryInterval;

    public @Nullable Long getConnectRetryInterval() {
      return connectRetryInterval;
    }

    public void setConnectRetryInterval(@Nullable Long setterArg) {
      this.connectRetryInterval = setterArg;
    }

    private @Nullable Long timeout;

    public @Nullable Long getTimeout() {
      return timeout;
    }

    public void setTimeout(@Nullable Long setterArg) {
      this.timeout = setterArg;
    }

    private @Nullable Long playerType;

    public @Nullable Long getPlayerType() {
      return playerType;
    }

    public void setPlayerType(@Nullable Long setterArg) {
      this.playerType = setterArg;
    }

    private @Nullable Map<String, String> headers;

    public @Nullable Map<String, String> getHeaders() {
      return headers;
    }

    public void setHeaders(@Nullable Map<String, String> setterArg) {
      this.headers = setterArg;
    }

    private @Nullable Boolean enableAccurateSeek;

    public @Nullable Boolean getEnableAccurateSeek() {
      return enableAccurateSeek;
    }

    public void setEnableAccurateSeek(@Nullable Boolean setterArg) {
      this.enableAccurateSeek = setterArg;
    }

    private @Nullable Boolean autoRotate;

    public @Nullable Boolean getAutoRotate() {
      return autoRotate;
    }

    public void setAutoRotate(@Nullable Boolean setterArg) {
      this.autoRotate = setterArg;
    }

    private @Nullable Boolean smoothSwitchBitrate;

    public @Nullable Boolean getSmoothSwitchBitrate() {
      return smoothSwitchBitrate;
    }

    public void setSmoothSwitchBitrate(@Nullable Boolean setterArg) {
      this.smoothSwitchBitrate = setterArg;
    }

    private @Nullable String cacheMp4ExtName;

    public @Nullable String getCacheMp4ExtName() {
      return cacheMp4ExtName;
    }

    public void setCacheMp4ExtName(@Nullable String setterArg) {
      this.cacheMp4ExtName = setterArg;
    }

    private @Nullable Long progressInterval;

    public @Nullable Long getProgressInterval() {
      return progressInterval;
    }

    public void setProgressInterval(@Nullable Long setterArg) {
      this.progressInterval = setterArg;
    }

    private @Nullable Long maxBufferSize;

    public @Nullable Long getMaxBufferSize() {
      return maxBufferSize;
    }

    public void setMaxBufferSize(@Nullable Long setterArg) {
      this.maxBufferSize = setterArg;
    }

    private @Nullable Long maxPreloadSize;

    public @Nullable Long getMaxPreloadSize() {
      return maxPreloadSize;
    }

    public void setMaxPreloadSize(@Nullable Long setterArg) {
      this.maxPreloadSize = setterArg;
    }

    private @Nullable Long firstStartPlayBufferTime;

    public @Nullable Long getFirstStartPlayBufferTime() {
      return firstStartPlayBufferTime;
    }

    public void setFirstStartPlayBufferTime(@Nullable Long setterArg) {
      this.firstStartPlayBufferTime = setterArg;
    }

    private @Nullable Long nextStartPlayBufferTime;

    public @Nullable Long getNextStartPlayBufferTime() {
      return nextStartPlayBufferTime;
    }

    public void setNextStartPlayBufferTime(@Nullable Long setterArg) {
      this.nextStartPlayBufferTime = setterArg;
    }

    private @Nullable String overlayKey;

    public @Nullable String getOverlayKey() {
      return overlayKey;
    }

    public void setOverlayKey(@Nullable String setterArg) {
      this.overlayKey = setterArg;
    }

    private @Nullable String overlayIv;

    public @Nullable String getOverlayIv() {
      return overlayIv;
    }

    public void setOverlayIv(@Nullable String setterArg) {
      this.overlayIv = setterArg;
    }

    private @Nullable Map<String, Object> extInfoMap;

    public @Nullable Map<String, Object> getExtInfoMap() {
      return extInfoMap;
    }

    public void setExtInfoMap(@Nullable Map<String, Object> setterArg) {
      this.extInfoMap = setterArg;
    }

    private @Nullable Boolean enableRenderProcess;

    public @Nullable Boolean getEnableRenderProcess() {
      return enableRenderProcess;
    }

    public void setEnableRenderProcess(@Nullable Boolean setterArg) {
      this.enableRenderProcess = setterArg;
    }

    private @Nullable Long preferredResolution;

    public @Nullable Long getPreferredResolution() {
      return preferredResolution;
    }

    public void setPreferredResolution(@Nullable Long setterArg) {
      this.preferredResolution = setterArg;
    }

    public static final class Builder {

      private @Nullable Long playerId;

      public @NonNull Builder setPlayerId(@Nullable Long setterArg) {
        this.playerId = setterArg;
        return this;
      }

      private @Nullable Long connectRetryCount;

      public @NonNull Builder setConnectRetryCount(@Nullable Long setterArg) {
        this.connectRetryCount = setterArg;
        return this;
      }

      private @Nullable Long connectRetryInterval;

      public @NonNull Builder setConnectRetryInterval(@Nullable Long setterArg) {
        this.connectRetryInterval = setterArg;
        return this;
      }

      private @Nullable Long timeout;

      public @NonNull Builder setTimeout(@Nullable Long setterArg) {
        this.timeout = setterArg;
        return this;
      }

      private @Nullable Long playerType;

      public @NonNull Builder setPlayerType(@Nullable Long setterArg) {
        this.playerType = setterArg;
        return this;
      }

      private @Nullable Map<String, String> headers;

      public @NonNull Builder setHeaders(@Nullable Map<String, String> setterArg) {
        this.headers = setterArg;
        return this;
      }

      private @Nullable Boolean enableAccurateSeek;

      public @NonNull Builder setEnableAccurateSeek(@Nullable Boolean setterArg) {
        this.enableAccurateSeek = setterArg;
        return this;
      }

      private @Nullable Boolean autoRotate;

      public @NonNull Builder setAutoRotate(@Nullable Boolean setterArg) {
        this.autoRotate = setterArg;
        return this;
      }

      private @Nullable Boolean smoothSwitchBitrate;

      public @NonNull Builder setSmoothSwitchBitrate(@Nullable Boolean setterArg) {
        this.smoothSwitchBitrate = setterArg;
        return this;
      }

      private @Nullable String cacheMp4ExtName;

      public @NonNull Builder setCacheMp4ExtName(@Nullable String setterArg) {
        this.cacheMp4ExtName = setterArg;
        return this;
      }

      private @Nullable Long progressInterval;

      public @NonNull Builder setProgressInterval(@Nullable Long setterArg) {
        this.progressInterval = setterArg;
        return this;
      }

      private @Nullable Long maxBufferSize;

      public @NonNull Builder setMaxBufferSize(@Nullable Long setterArg) {
        this.maxBufferSize = setterArg;
        return this;
      }

      private @Nullable Long maxPreloadSize;

      public @NonNull Builder setMaxPreloadSize(@Nullable Long setterArg) {
        this.maxPreloadSize = setterArg;
        return this;
      }

      private @Nullable Long firstStartPlayBufferTime;

      public @NonNull Builder setFirstStartPlayBufferTime(@Nullable Long setterArg) {
        this.firstStartPlayBufferTime = setterArg;
        return this;
      }

      private @Nullable Long nextStartPlayBufferTime;

      public @NonNull Builder setNextStartPlayBufferTime(@Nullable Long setterArg) {
        this.nextStartPlayBufferTime = setterArg;
        return this;
      }

      private @Nullable String overlayKey;

      public @NonNull Builder setOverlayKey(@Nullable String setterArg) {
        this.overlayKey = setterArg;
        return this;
      }

      private @Nullable String overlayIv;

      public @NonNull Builder setOverlayIv(@Nullable String setterArg) {
        this.overlayIv = setterArg;
        return this;
      }

      private @Nullable Map<String, Object> extInfoMap;

      public @NonNull Builder setExtInfoMap(@Nullable Map<String, Object> setterArg) {
        this.extInfoMap = setterArg;
        return this;
      }

      private @Nullable Boolean enableRenderProcess;

      public @NonNull Builder setEnableRenderProcess(@Nullable Boolean setterArg) {
        this.enableRenderProcess = setterArg;
        return this;
      }

      private @Nullable Long preferredResolution;

      public @NonNull Builder setPreferredResolution(@Nullable Long setterArg) {
        this.preferredResolution = setterArg;
        return this;
      }

      public @NonNull FTXVodPlayConfigPlayerMsg build() {
        FTXVodPlayConfigPlayerMsg pigeonReturn = new FTXVodPlayConfigPlayerMsg();
        pigeonReturn.setPlayerId(playerId);
        pigeonReturn.setConnectRetryCount(connectRetryCount);
        pigeonReturn.setConnectRetryInterval(connectRetryInterval);
        pigeonReturn.setTimeout(timeout);
        pigeonReturn.setPlayerType(playerType);
        pigeonReturn.setHeaders(headers);
        pigeonReturn.setEnableAccurateSeek(enableAccurateSeek);
        pigeonReturn.setAutoRotate(autoRotate);
        pigeonReturn.setSmoothSwitchBitrate(smoothSwitchBitrate);
        pigeonReturn.setCacheMp4ExtName(cacheMp4ExtName);
        pigeonReturn.setProgressInterval(progressInterval);
        pigeonReturn.setMaxBufferSize(maxBufferSize);
        pigeonReturn.setMaxPreloadSize(maxPreloadSize);
        pigeonReturn.setFirstStartPlayBufferTime(firstStartPlayBufferTime);
        pigeonReturn.setNextStartPlayBufferTime(nextStartPlayBufferTime);
        pigeonReturn.setOverlayKey(overlayKey);
        pigeonReturn.setOverlayIv(overlayIv);
        pigeonReturn.setExtInfoMap(extInfoMap);
        pigeonReturn.setEnableRenderProcess(enableRenderProcess);
        pigeonReturn.setPreferredResolution(preferredResolution);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(20);
      toListResult.add(playerId);
      toListResult.add(connectRetryCount);
      toListResult.add(connectRetryInterval);
      toListResult.add(timeout);
      toListResult.add(playerType);
      toListResult.add(headers);
      toListResult.add(enableAccurateSeek);
      toListResult.add(autoRotate);
      toListResult.add(smoothSwitchBitrate);
      toListResult.add(cacheMp4ExtName);
      toListResult.add(progressInterval);
      toListResult.add(maxBufferSize);
      toListResult.add(maxPreloadSize);
      toListResult.add(firstStartPlayBufferTime);
      toListResult.add(nextStartPlayBufferTime);
      toListResult.add(overlayKey);
      toListResult.add(overlayIv);
      toListResult.add(extInfoMap);
      toListResult.add(enableRenderProcess);
      toListResult.add(preferredResolution);
      return toListResult;
    }

    static @NonNull FTXVodPlayConfigPlayerMsg fromList(@NonNull ArrayList<Object> list) {
      FTXVodPlayConfigPlayerMsg pigeonResult = new FTXVodPlayConfigPlayerMsg();
      Object playerId = list.get(0);
      pigeonResult.setPlayerId((playerId == null) ? null : ((playerId instanceof Integer) ? (Integer) playerId : (Long) playerId));
      Object connectRetryCount = list.get(1);
      pigeonResult.setConnectRetryCount((connectRetryCount == null) ? null : ((connectRetryCount instanceof Integer) ? (Integer) connectRetryCount : (Long) connectRetryCount));
      Object connectRetryInterval = list.get(2);
      pigeonResult.setConnectRetryInterval((connectRetryInterval == null) ? null : ((connectRetryInterval instanceof Integer) ? (Integer) connectRetryInterval : (Long) connectRetryInterval));
      Object timeout = list.get(3);
      pigeonResult.setTimeout((timeout == null) ? null : ((timeout instanceof Integer) ? (Integer) timeout : (Long) timeout));
      Object playerType = list.get(4);
      pigeonResult.setPlayerType((playerType == null) ? null : ((playerType instanceof Integer) ? (Integer) playerType : (Long) playerType));
      Object headers = list.get(5);
      pigeonResult.setHeaders((Map<String, String>) headers);
      Object enableAccurateSeek = list.get(6);
      pigeonResult.setEnableAccurateSeek((Boolean) enableAccurateSeek);
      Object autoRotate = list.get(7);
      pigeonResult.setAutoRotate((Boolean) autoRotate);
      Object smoothSwitchBitrate = list.get(8);
      pigeonResult.setSmoothSwitchBitrate((Boolean) smoothSwitchBitrate);
      Object cacheMp4ExtName = list.get(9);
      pigeonResult.setCacheMp4ExtName((String) cacheMp4ExtName);
      Object progressInterval = list.get(10);
      pigeonResult.setProgressInterval((progressInterval == null) ? null : ((progressInterval instanceof Integer) ? (Integer) progressInterval : (Long) progressInterval));
      Object maxBufferSize = list.get(11);
      pigeonResult.setMaxBufferSize((maxBufferSize == null) ? null : ((maxBufferSize instanceof Integer) ? (Integer) maxBufferSize : (Long) maxBufferSize));
      Object maxPreloadSize = list.get(12);
      pigeonResult.setMaxPreloadSize((maxPreloadSize == null) ? null : ((maxPreloadSize instanceof Integer) ? (Integer) maxPreloadSize : (Long) maxPreloadSize));
      Object firstStartPlayBufferTime = list.get(13);
      pigeonResult.setFirstStartPlayBufferTime((firstStartPlayBufferTime == null) ? null : ((firstStartPlayBufferTime instanceof Integer) ? (Integer) firstStartPlayBufferTime : (Long) firstStartPlayBufferTime));
      Object nextStartPlayBufferTime = list.get(14);
      pigeonResult.setNextStartPlayBufferTime((nextStartPlayBufferTime == null) ? null : ((nextStartPlayBufferTime instanceof Integer) ? (Integer) nextStartPlayBufferTime : (Long) nextStartPlayBufferTime));
      Object overlayKey = list.get(15);
      pigeonResult.setOverlayKey((String) overlayKey);
      Object overlayIv = list.get(16);
      pigeonResult.setOverlayIv((String) overlayIv);
      Object extInfoMap = list.get(17);
      pigeonResult.setExtInfoMap((Map<String, Object>) extInfoMap);
      Object enableRenderProcess = list.get(18);
      pigeonResult.setEnableRenderProcess((Boolean) enableRenderProcess);
      Object preferredResolution = list.get(19);
      pigeonResult.setPreferredResolution((preferredResolution == null) ? null : ((preferredResolution instanceof Integer) ? (Integer) preferredResolution : (Long) preferredResolution));
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class FTXLivePlayConfigPlayerMsg {
    private @Nullable Long playerId;

    public @Nullable Long getPlayerId() {
      return playerId;
    }

    public void setPlayerId(@Nullable Long setterArg) {
      this.playerId = setterArg;
    }

    private @Nullable Double cacheTime;

    public @Nullable Double getCacheTime() {
      return cacheTime;
    }

    public void setCacheTime(@Nullable Double setterArg) {
      this.cacheTime = setterArg;
    }

    private @Nullable Double maxAutoAdjustCacheTime;

    public @Nullable Double getMaxAutoAdjustCacheTime() {
      return maxAutoAdjustCacheTime;
    }

    public void setMaxAutoAdjustCacheTime(@Nullable Double setterArg) {
      this.maxAutoAdjustCacheTime = setterArg;
    }

    private @Nullable Double minAutoAdjustCacheTime;

    public @Nullable Double getMinAutoAdjustCacheTime() {
      return minAutoAdjustCacheTime;
    }

    public void setMinAutoAdjustCacheTime(@Nullable Double setterArg) {
      this.minAutoAdjustCacheTime = setterArg;
    }

    private @Nullable Long videoBlockThreshold;

    public @Nullable Long getVideoBlockThreshold() {
      return videoBlockThreshold;
    }

    public void setVideoBlockThreshold(@Nullable Long setterArg) {
      this.videoBlockThreshold = setterArg;
    }

    private @Nullable Long connectRetryCount;

    public @Nullable Long getConnectRetryCount() {
      return connectRetryCount;
    }

    public void setConnectRetryCount(@Nullable Long setterArg) {
      this.connectRetryCount = setterArg;
    }

    private @Nullable Long connectRetryInterval;

    public @Nullable Long getConnectRetryInterval() {
      return connectRetryInterval;
    }

    public void setConnectRetryInterval(@Nullable Long setterArg) {
      this.connectRetryInterval = setterArg;
    }

    private @Nullable Boolean autoAdjustCacheTime;

    public @Nullable Boolean getAutoAdjustCacheTime() {
      return autoAdjustCacheTime;
    }

    public void setAutoAdjustCacheTime(@Nullable Boolean setterArg) {
      this.autoAdjustCacheTime = setterArg;
    }

    private @Nullable Boolean enableAec;

    public @Nullable Boolean getEnableAec() {
      return enableAec;
    }

    public void setEnableAec(@Nullable Boolean setterArg) {
      this.enableAec = setterArg;
    }

    private @Nullable Boolean enableMessage;

    public @Nullable Boolean getEnableMessage() {
      return enableMessage;
    }

    public void setEnableMessage(@Nullable Boolean setterArg) {
      this.enableMessage = setterArg;
    }

    private @Nullable Boolean enableMetaData;

    public @Nullable Boolean getEnableMetaData() {
      return enableMetaData;
    }

    public void setEnableMetaData(@Nullable Boolean setterArg) {
      this.enableMetaData = setterArg;
    }

    private @Nullable String flvSessionKey;

    public @Nullable String getFlvSessionKey() {
      return flvSessionKey;
    }

    public void setFlvSessionKey(@Nullable String setterArg) {
      this.flvSessionKey = setterArg;
    }

    public static final class Builder {

      private @Nullable Long playerId;

      public @NonNull Builder setPlayerId(@Nullable Long setterArg) {
        this.playerId = setterArg;
        return this;
      }

      private @Nullable Double cacheTime;

      public @NonNull Builder setCacheTime(@Nullable Double setterArg) {
        this.cacheTime = setterArg;
        return this;
      }

      private @Nullable Double maxAutoAdjustCacheTime;

      public @NonNull Builder setMaxAutoAdjustCacheTime(@Nullable Double setterArg) {
        this.maxAutoAdjustCacheTime = setterArg;
        return this;
      }

      private @Nullable Double minAutoAdjustCacheTime;

      public @NonNull Builder setMinAutoAdjustCacheTime(@Nullable Double setterArg) {
        this.minAutoAdjustCacheTime = setterArg;
        return this;
      }

      private @Nullable Long videoBlockThreshold;

      public @NonNull Builder setVideoBlockThreshold(@Nullable Long setterArg) {
        this.videoBlockThreshold = setterArg;
        return this;
      }

      private @Nullable Long connectRetryCount;

      public @NonNull Builder setConnectRetryCount(@Nullable Long setterArg) {
        this.connectRetryCount = setterArg;
        return this;
      }

      private @Nullable Long connectRetryInterval;

      public @NonNull Builder setConnectRetryInterval(@Nullable Long setterArg) {
        this.connectRetryInterval = setterArg;
        return this;
      }

      private @Nullable Boolean autoAdjustCacheTime;

      public @NonNull Builder setAutoAdjustCacheTime(@Nullable Boolean setterArg) {
        this.autoAdjustCacheTime = setterArg;
        return this;
      }

      private @Nullable Boolean enableAec;

      public @NonNull Builder setEnableAec(@Nullable Boolean setterArg) {
        this.enableAec = setterArg;
        return this;
      }

      private @Nullable Boolean enableMessage;

      public @NonNull Builder setEnableMessage(@Nullable Boolean setterArg) {
        this.enableMessage = setterArg;
        return this;
      }

      private @Nullable Boolean enableMetaData;

      public @NonNull Builder setEnableMetaData(@Nullable Boolean setterArg) {
        this.enableMetaData = setterArg;
        return this;
      }

      private @Nullable String flvSessionKey;

      public @NonNull Builder setFlvSessionKey(@Nullable String setterArg) {
        this.flvSessionKey = setterArg;
        return this;
      }

      public @NonNull FTXLivePlayConfigPlayerMsg build() {
        FTXLivePlayConfigPlayerMsg pigeonReturn = new FTXLivePlayConfigPlayerMsg();
        pigeonReturn.setPlayerId(playerId);
        pigeonReturn.setCacheTime(cacheTime);
        pigeonReturn.setMaxAutoAdjustCacheTime(maxAutoAdjustCacheTime);
        pigeonReturn.setMinAutoAdjustCacheTime(minAutoAdjustCacheTime);
        pigeonReturn.setVideoBlockThreshold(videoBlockThreshold);
        pigeonReturn.setConnectRetryCount(connectRetryCount);
        pigeonReturn.setConnectRetryInterval(connectRetryInterval);
        pigeonReturn.setAutoAdjustCacheTime(autoAdjustCacheTime);
        pigeonReturn.setEnableAec(enableAec);
        pigeonReturn.setEnableMessage(enableMessage);
        pigeonReturn.setEnableMetaData(enableMetaData);
        pigeonReturn.setFlvSessionKey(flvSessionKey);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(12);
      toListResult.add(playerId);
      toListResult.add(cacheTime);
      toListResult.add(maxAutoAdjustCacheTime);
      toListResult.add(minAutoAdjustCacheTime);
      toListResult.add(videoBlockThreshold);
      toListResult.add(connectRetryCount);
      toListResult.add(connectRetryInterval);
      toListResult.add(autoAdjustCacheTime);
      toListResult.add(enableAec);
      toListResult.add(enableMessage);
      toListResult.add(enableMetaData);
      toListResult.add(flvSessionKey);
      return toListResult;
    }

    static @NonNull FTXLivePlayConfigPlayerMsg fromList(@NonNull ArrayList<Object> list) {
      FTXLivePlayConfigPlayerMsg pigeonResult = new FTXLivePlayConfigPlayerMsg();
      Object playerId = list.get(0);
      pigeonResult.setPlayerId((playerId == null) ? null : ((playerId instanceof Integer) ? (Integer) playerId : (Long) playerId));
      Object cacheTime = list.get(1);
      pigeonResult.setCacheTime((Double) cacheTime);
      Object maxAutoAdjustCacheTime = list.get(2);
      pigeonResult.setMaxAutoAdjustCacheTime((Double) maxAutoAdjustCacheTime);
      Object minAutoAdjustCacheTime = list.get(3);
      pigeonResult.setMinAutoAdjustCacheTime((Double) minAutoAdjustCacheTime);
      Object videoBlockThreshold = list.get(4);
      pigeonResult.setVideoBlockThreshold((videoBlockThreshold == null) ? null : ((videoBlockThreshold instanceof Integer) ? (Integer) videoBlockThreshold : (Long) videoBlockThreshold));
      Object connectRetryCount = list.get(5);
      pigeonResult.setConnectRetryCount((connectRetryCount == null) ? null : ((connectRetryCount instanceof Integer) ? (Integer) connectRetryCount : (Long) connectRetryCount));
      Object connectRetryInterval = list.get(6);
      pigeonResult.setConnectRetryInterval((connectRetryInterval == null) ? null : ((connectRetryInterval instanceof Integer) ? (Integer) connectRetryInterval : (Long) connectRetryInterval));
      Object autoAdjustCacheTime = list.get(7);
      pigeonResult.setAutoAdjustCacheTime((Boolean) autoAdjustCacheTime);
      Object enableAec = list.get(8);
      pigeonResult.setEnableAec((Boolean) enableAec);
      Object enableMessage = list.get(9);
      pigeonResult.setEnableMessage((Boolean) enableMessage);
      Object enableMetaData = list.get(10);
      pigeonResult.setEnableMetaData((Boolean) enableMetaData);
      Object flvSessionKey = list.get(11);
      pigeonResult.setFlvSessionKey((String) flvSessionKey);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class TXVodDownloadMediaMsg {
    /** 缓存地址 */
    private @Nullable String playPath;

    public @Nullable String getPlayPath() {
      return playPath;
    }

    public void setPlayPath(@Nullable String setterArg) {
      this.playPath = setterArg;
    }

    /** 下载进度 */
    private @Nullable Double progress;

    public @Nullable Double getProgress() {
      return progress;
    }

    public void setProgress(@Nullable Double setterArg) {
      this.progress = setterArg;
    }

    /** 下载状态 */
    private @Nullable Long downloadState;

    public @Nullable Long getDownloadState() {
      return downloadState;
    }

    public void setDownloadState(@Nullable Long setterArg) {
      this.downloadState = setterArg;
    }

    /** 账户名称,用于url下载设置账户名称 */
    private @Nullable String userName;

    public @Nullable String getUserName() {
      return userName;
    }

    public void setUserName(@Nullable String setterArg) {
      this.userName = setterArg;
    }

    /** 总时长 */
    private @Nullable Long duration;

    public @Nullable Long getDuration() {
      return duration;
    }

    public void setDuration(@Nullable Long setterArg) {
      this.duration = setterArg;
    }

    /** 已下载的可播放时长 */
    private @Nullable Long playableDuration;

    public @Nullable Long getPlayableDuration() {
      return playableDuration;
    }

    public void setPlayableDuration(@Nullable Long setterArg) {
      this.playableDuration = setterArg;
    }

    /** 文件总大小，单位：byte */
    private @Nullable Long size;

    public @Nullable Long getSize() {
      return size;
    }

    public void setSize(@Nullable Long setterArg) {
      this.size = setterArg;
    }

    /** 已下载大小，单位：byte */
    private @Nullable Long downloadSize;

    public @Nullable Long getDownloadSize() {
      return downloadSize;
    }

    public void setDownloadSize(@Nullable Long setterArg) {
      this.downloadSize = setterArg;
    }

    /**
     * 需要下载的视频url，url下载必填
     * <h1>
     * url下载不支持嵌套m3u8和mp4下载
     * </h1>
     */
    private @Nullable String url;

    public @Nullable String getUrl() {
      return url;
    }

    public void setUrl(@Nullable String setterArg) {
      this.url = setterArg;
    }

    /** 下载文件对应的appId，fileId下载必填 */
    private @Nullable Long appId;

    public @Nullable Long getAppId() {
      return appId;
    }

    public void setAppId(@Nullable Long setterArg) {
      this.appId = setterArg;
    }

    /** 下载文件Id，fileId下载必填 */
    private @Nullable String fileId;

    public @Nullable String getFileId() {
      return fileId;
    }

    public void setFileId(@Nullable String setterArg) {
      this.fileId = setterArg;
    }

    /** 加密签名，加密视频必填 */
    private @Nullable String pSign;

    public @Nullable String getPSign() {
      return pSign;
    }

    public void setPSign(@Nullable String setterArg) {
      this.pSign = setterArg;
    }

    /** 清晰度ID */
    private @Nullable Long quality;

    public @Nullable Long getQuality() {
      return quality;
    }

    public void setQuality(@Nullable Long setterArg) {
      this.quality = setterArg;
    }

    /** 加密token */
    private @Nullable String token;

    public @Nullable String getToken() {
      return token;
    }

    public void setToken(@Nullable String setterArg) {
      this.token = setterArg;
    }

    public static final class Builder {

      private @Nullable String playPath;

      public @NonNull Builder setPlayPath(@Nullable String setterArg) {
        this.playPath = setterArg;
        return this;
      }

      private @Nullable Double progress;

      public @NonNull Builder setProgress(@Nullable Double setterArg) {
        this.progress = setterArg;
        return this;
      }

      private @Nullable Long downloadState;

      public @NonNull Builder setDownloadState(@Nullable Long setterArg) {
        this.downloadState = setterArg;
        return this;
      }

      private @Nullable String userName;

      public @NonNull Builder setUserName(@Nullable String setterArg) {
        this.userName = setterArg;
        return this;
      }

      private @Nullable Long duration;

      public @NonNull Builder setDuration(@Nullable Long setterArg) {
        this.duration = setterArg;
        return this;
      }

      private @Nullable Long playableDuration;

      public @NonNull Builder setPlayableDuration(@Nullable Long setterArg) {
        this.playableDuration = setterArg;
        return this;
      }

      private @Nullable Long size;

      public @NonNull Builder setSize(@Nullable Long setterArg) {
        this.size = setterArg;
        return this;
      }

      private @Nullable Long downloadSize;

      public @NonNull Builder setDownloadSize(@Nullable Long setterArg) {
        this.downloadSize = setterArg;
        return this;
      }

      private @Nullable String url;

      public @NonNull Builder setUrl(@Nullable String setterArg) {
        this.url = setterArg;
        return this;
      }

      private @Nullable Long appId;

      public @NonNull Builder setAppId(@Nullable Long setterArg) {
        this.appId = setterArg;
        return this;
      }

      private @Nullable String fileId;

      public @NonNull Builder setFileId(@Nullable String setterArg) {
        this.fileId = setterArg;
        return this;
      }

      private @Nullable String pSign;

      public @NonNull Builder setPSign(@Nullable String setterArg) {
        this.pSign = setterArg;
        return this;
      }

      private @Nullable Long quality;

      public @NonNull Builder setQuality(@Nullable Long setterArg) {
        this.quality = setterArg;
        return this;
      }

      private @Nullable String token;

      public @NonNull Builder setToken(@Nullable String setterArg) {
        this.token = setterArg;
        return this;
      }

      public @NonNull TXVodDownloadMediaMsg build() {
        TXVodDownloadMediaMsg pigeonReturn = new TXVodDownloadMediaMsg();
        pigeonReturn.setPlayPath(playPath);
        pigeonReturn.setProgress(progress);
        pigeonReturn.setDownloadState(downloadState);
        pigeonReturn.setUserName(userName);
        pigeonReturn.setDuration(duration);
        pigeonReturn.setPlayableDuration(playableDuration);
        pigeonReturn.setSize(size);
        pigeonReturn.setDownloadSize(downloadSize);
        pigeonReturn.setUrl(url);
        pigeonReturn.setAppId(appId);
        pigeonReturn.setFileId(fileId);
        pigeonReturn.setPSign(pSign);
        pigeonReturn.setQuality(quality);
        pigeonReturn.setToken(token);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(14);
      toListResult.add(playPath);
      toListResult.add(progress);
      toListResult.add(downloadState);
      toListResult.add(userName);
      toListResult.add(duration);
      toListResult.add(playableDuration);
      toListResult.add(size);
      toListResult.add(downloadSize);
      toListResult.add(url);
      toListResult.add(appId);
      toListResult.add(fileId);
      toListResult.add(pSign);
      toListResult.add(quality);
      toListResult.add(token);
      return toListResult;
    }

    static @NonNull TXVodDownloadMediaMsg fromList(@NonNull ArrayList<Object> list) {
      TXVodDownloadMediaMsg pigeonResult = new TXVodDownloadMediaMsg();
      Object playPath = list.get(0);
      pigeonResult.setPlayPath((String) playPath);
      Object progress = list.get(1);
      pigeonResult.setProgress((Double) progress);
      Object downloadState = list.get(2);
      pigeonResult.setDownloadState((downloadState == null) ? null : ((downloadState instanceof Integer) ? (Integer) downloadState : (Long) downloadState));
      Object userName = list.get(3);
      pigeonResult.setUserName((String) userName);
      Object duration = list.get(4);
      pigeonResult.setDuration((duration == null) ? null : ((duration instanceof Integer) ? (Integer) duration : (Long) duration));
      Object playableDuration = list.get(5);
      pigeonResult.setPlayableDuration((playableDuration == null) ? null : ((playableDuration instanceof Integer) ? (Integer) playableDuration : (Long) playableDuration));
      Object size = list.get(6);
      pigeonResult.setSize((size == null) ? null : ((size instanceof Integer) ? (Integer) size : (Long) size));
      Object downloadSize = list.get(7);
      pigeonResult.setDownloadSize((downloadSize == null) ? null : ((downloadSize instanceof Integer) ? (Integer) downloadSize : (Long) downloadSize));
      Object url = list.get(8);
      pigeonResult.setUrl((String) url);
      Object appId = list.get(9);
      pigeonResult.setAppId((appId == null) ? null : ((appId instanceof Integer) ? (Integer) appId : (Long) appId));
      Object fileId = list.get(10);
      pigeonResult.setFileId((String) fileId);
      Object pSign = list.get(11);
      pigeonResult.setPSign((String) pSign);
      Object quality = list.get(12);
      pigeonResult.setQuality((quality == null) ? null : ((quality instanceof Integer) ? (Integer) quality : (Long) quality));
      Object token = list.get(13);
      pigeonResult.setToken((String) token);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class TXDownloadListMsg {
    private @Nullable List<TXVodDownloadMediaMsg> infoList;

    public @Nullable List<TXVodDownloadMediaMsg> getInfoList() {
      return infoList;
    }

    public void setInfoList(@Nullable List<TXVodDownloadMediaMsg> setterArg) {
      this.infoList = setterArg;
    }

    public static final class Builder {

      private @Nullable List<TXVodDownloadMediaMsg> infoList;

      public @NonNull Builder setInfoList(@Nullable List<TXVodDownloadMediaMsg> setterArg) {
        this.infoList = setterArg;
        return this;
      }

      public @NonNull TXDownloadListMsg build() {
        TXDownloadListMsg pigeonReturn = new TXDownloadListMsg();
        pigeonReturn.setInfoList(infoList);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(1);
      toListResult.add(infoList);
      return toListResult;
    }

    static @NonNull TXDownloadListMsg fromList(@NonNull ArrayList<Object> list) {
      TXDownloadListMsg pigeonResult = new TXDownloadListMsg();
      Object infoList = list.get(0);
      pigeonResult.setInfoList((List<TXVodDownloadMediaMsg>) infoList);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class UInt8ListMsg {
    private @Nullable byte[] value;

    public @Nullable byte[] getValue() {
      return value;
    }

    public void setValue(@Nullable byte[] setterArg) {
      this.value = setterArg;
    }

    public static final class Builder {

      private @Nullable byte[] value;

      public @NonNull Builder setValue(@Nullable byte[] setterArg) {
        this.value = setterArg;
        return this;
      }

      public @NonNull UInt8ListMsg build() {
        UInt8ListMsg pigeonReturn = new UInt8ListMsg();
        pigeonReturn.setValue(value);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(1);
      toListResult.add(value);
      return toListResult;
    }

    static @NonNull UInt8ListMsg fromList(@NonNull ArrayList<Object> list) {
      UInt8ListMsg pigeonResult = new UInt8ListMsg();
      Object value = list.get(0);
      pigeonResult.setValue((byte[]) value);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class ListMsg {
    private @Nullable List<Object> value;

    public @Nullable List<Object> getValue() {
      return value;
    }

    public void setValue(@Nullable List<Object> setterArg) {
      this.value = setterArg;
    }

    public static final class Builder {

      private @Nullable List<Object> value;

      public @NonNull Builder setValue(@Nullable List<Object> setterArg) {
        this.value = setterArg;
        return this;
      }

      public @NonNull ListMsg build() {
        ListMsg pigeonReturn = new ListMsg();
        pigeonReturn.setValue(value);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(1);
      toListResult.add(value);
      return toListResult;
    }

    static @NonNull ListMsg fromList(@NonNull ArrayList<Object> list) {
      ListMsg pigeonResult = new ListMsg();
      Object value = list.get(0);
      pigeonResult.setValue((List<Object>) value);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class BoolMsg {
    private @Nullable Boolean value;

    public @Nullable Boolean getValue() {
      return value;
    }

    public void setValue(@Nullable Boolean setterArg) {
      this.value = setterArg;
    }

    public static final class Builder {

      private @Nullable Boolean value;

      public @NonNull Builder setValue(@Nullable Boolean setterArg) {
        this.value = setterArg;
        return this;
      }

      public @NonNull BoolMsg build() {
        BoolMsg pigeonReturn = new BoolMsg();
        pigeonReturn.setValue(value);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(1);
      toListResult.add(value);
      return toListResult;
    }

    static @NonNull BoolMsg fromList(@NonNull ArrayList<Object> list) {
      BoolMsg pigeonResult = new BoolMsg();
      Object value = list.get(0);
      pigeonResult.setValue((Boolean) value);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class IntMsg {
    private @Nullable Long value;

    public @Nullable Long getValue() {
      return value;
    }

    public void setValue(@Nullable Long setterArg) {
      this.value = setterArg;
    }

    public static final class Builder {

      private @Nullable Long value;

      public @NonNull Builder setValue(@Nullable Long setterArg) {
        this.value = setterArg;
        return this;
      }

      public @NonNull IntMsg build() {
        IntMsg pigeonReturn = new IntMsg();
        pigeonReturn.setValue(value);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(1);
      toListResult.add(value);
      return toListResult;
    }

    static @NonNull IntMsg fromList(@NonNull ArrayList<Object> list) {
      IntMsg pigeonResult = new IntMsg();
      Object value = list.get(0);
      pigeonResult.setValue((value == null) ? null : ((value instanceof Integer) ? (Integer) value : (Long) value));
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class StringMsg {
    private @Nullable String value;

    public @Nullable String getValue() {
      return value;
    }

    public void setValue(@Nullable String setterArg) {
      this.value = setterArg;
    }

    public static final class Builder {

      private @Nullable String value;

      public @NonNull Builder setValue(@Nullable String setterArg) {
        this.value = setterArg;
        return this;
      }

      public @NonNull StringMsg build() {
        StringMsg pigeonReturn = new StringMsg();
        pigeonReturn.setValue(value);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(1);
      toListResult.add(value);
      return toListResult;
    }

    static @NonNull StringMsg fromList(@NonNull ArrayList<Object> list) {
      StringMsg pigeonResult = new StringMsg();
      Object value = list.get(0);
      pigeonResult.setValue((String) value);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class DoubleMsg {
    private @Nullable Double value;

    public @Nullable Double getValue() {
      return value;
    }

    public void setValue(@Nullable Double setterArg) {
      this.value = setterArg;
    }

    public static final class Builder {

      private @Nullable Double value;

      public @NonNull Builder setValue(@Nullable Double setterArg) {
        this.value = setterArg;
        return this;
      }

      public @NonNull DoubleMsg build() {
        DoubleMsg pigeonReturn = new DoubleMsg();
        pigeonReturn.setValue(value);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(1);
      toListResult.add(value);
      return toListResult;
    }

    static @NonNull DoubleMsg fromList(@NonNull ArrayList<Object> list) {
      DoubleMsg pigeonResult = new DoubleMsg();
      Object value = list.get(0);
      pigeonResult.setValue((Double) value);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class PreLoadMsg {
    private @Nullable String playUrl;

    public @Nullable String getPlayUrl() {
      return playUrl;
    }

    public void setPlayUrl(@Nullable String setterArg) {
      this.playUrl = setterArg;
    }

    private @Nullable Long preloadSizeMB;

    public @Nullable Long getPreloadSizeMB() {
      return preloadSizeMB;
    }

    public void setPreloadSizeMB(@Nullable Long setterArg) {
      this.preloadSizeMB = setterArg;
    }

    private @Nullable Long preferredResolution;

    public @Nullable Long getPreferredResolution() {
      return preferredResolution;
    }

    public void setPreferredResolution(@Nullable Long setterArg) {
      this.preferredResolution = setterArg;
    }

    public static final class Builder {

      private @Nullable String playUrl;

      public @NonNull Builder setPlayUrl(@Nullable String setterArg) {
        this.playUrl = setterArg;
        return this;
      }

      private @Nullable Long preloadSizeMB;

      public @NonNull Builder setPreloadSizeMB(@Nullable Long setterArg) {
        this.preloadSizeMB = setterArg;
        return this;
      }

      private @Nullable Long preferredResolution;

      public @NonNull Builder setPreferredResolution(@Nullable Long setterArg) {
        this.preferredResolution = setterArg;
        return this;
      }

      public @NonNull PreLoadMsg build() {
        PreLoadMsg pigeonReturn = new PreLoadMsg();
        pigeonReturn.setPlayUrl(playUrl);
        pigeonReturn.setPreloadSizeMB(preloadSizeMB);
        pigeonReturn.setPreferredResolution(preferredResolution);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(3);
      toListResult.add(playUrl);
      toListResult.add(preloadSizeMB);
      toListResult.add(preferredResolution);
      return toListResult;
    }

    static @NonNull PreLoadMsg fromList(@NonNull ArrayList<Object> list) {
      PreLoadMsg pigeonResult = new PreLoadMsg();
      Object playUrl = list.get(0);
      pigeonResult.setPlayUrl((String) playUrl);
      Object preloadSizeMB = list.get(1);
      pigeonResult.setPreloadSizeMB((preloadSizeMB == null) ? null : ((preloadSizeMB instanceof Integer) ? (Integer) preloadSizeMB : (Long) preloadSizeMB));
      Object preferredResolution = list.get(2);
      pigeonResult.setPreferredResolution((preferredResolution == null) ? null : ((preferredResolution instanceof Integer) ? (Integer) preferredResolution : (Long) preferredResolution));
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class MapMsg {
    private @Nullable Map<String, String> map;

    public @Nullable Map<String, String> getMap() {
      return map;
    }

    public void setMap(@Nullable Map<String, String> setterArg) {
      this.map = setterArg;
    }

    public static final class Builder {

      private @Nullable Map<String, String> map;

      public @NonNull Builder setMap(@Nullable Map<String, String> setterArg) {
        this.map = setterArg;
        return this;
      }

      public @NonNull MapMsg build() {
        MapMsg pigeonReturn = new MapMsg();
        pigeonReturn.setMap(map);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<Object>(1);
      toListResult.add(map);
      return toListResult;
    }

    static @NonNull MapMsg fromList(@NonNull ArrayList<Object> list) {
      MapMsg pigeonResult = new MapMsg();
      Object map = list.get(0);
      pigeonResult.setMap((Map<String, String>) map);
      return pigeonResult;
    }
  }

  private static class TXFlutterSuperPlayerPluginAPICodec extends StandardMessageCodec {
    public static final TXFlutterSuperPlayerPluginAPICodec INSTANCE = new TXFlutterSuperPlayerPluginAPICodec();

    private TXFlutterSuperPlayerPluginAPICodec() {}

    @Override
    protected Object readValueOfType(byte type, @NonNull ByteBuffer buffer) {
      switch (type) {
        case (byte) 128:
          return BoolMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 129:
          return IntMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 130:
          return LicenseMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 131:
          return PlayerMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 132:
          return StringMsg.fromList((ArrayList<Object>) readValue(buffer));
        default:
          return super.readValueOfType(type, buffer);
      }
    }

    @Override
    protected void writeValue(@NonNull ByteArrayOutputStream stream, Object value) {
      if (value instanceof BoolMsg) {
        stream.write(128);
        writeValue(stream, ((BoolMsg) value).toList());
      } else if (value instanceof IntMsg) {
        stream.write(129);
        writeValue(stream, ((IntMsg) value).toList());
      } else if (value instanceof LicenseMsg) {
        stream.write(130);
        writeValue(stream, ((LicenseMsg) value).toList());
      } else if (value instanceof PlayerMsg) {
        stream.write(131);
        writeValue(stream, ((PlayerMsg) value).toList());
      } else if (value instanceof StringMsg) {
        stream.write(132);
        writeValue(stream, ((StringMsg) value).toList());
      } else {
        super.writeValue(stream, value);
      }
    }
  }

  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface TXFlutterSuperPlayerPluginAPI {

    @NonNull 
    StringMsg getPlatformVersion();
    /** 创建点播播放器 */
    @NonNull 
    PlayerMsg createVodPlayer();
    /** 创建直播播放器 */
    @NonNull 
    PlayerMsg createLivePlayer();
    /** 开关log输出 */
    void setConsoleEnabled(@NonNull BoolMsg enabled);
    /** 释放播放器资源 */
    void releasePlayer(@NonNull PlayerMsg playerId);
    /**
     * 设置播放引擎的最大缓存大小。设置后会根据设定值自动清理Cache目录的文件
     * @param size 最大缓存大小（单位：MB)
     */
    void setGlobalMaxCacheSize(@NonNull IntMsg size);
    /**
     * 在短视频播放场景中，视频文件的本地缓存是很刚需的一个特性，对于普通用户而言，一个已经看过的视频再次观看时，不应该再消耗一次流量。
     *  @格式支持：SDK 支持 HLS(m3u8) 和 MP4 两种常见点播格式的缓存功能。
     *  @开启时机：SDK 并不默认开启缓存功能，对于用户回看率不高的场景，也并不推荐您开启此功能。
     *  @开启方式：全局生效，在使用播放器开启。开启此功能需要配置两个参数：本地缓存目录及缓存大小。
     *
     * 该缓存路径默认设置到app沙盒目录下，postfixPath只需要传递相对缓存目录即可，不需要传递整个绝对路径。
     * e.g. postfixPath = 'testCache'
     * Android 平台：视频将会缓存到sdcard的Android/data/your-pkg-name/files/testCache 目录。
     * iOS 平台：视频将会缓存到沙盒的Documents/testCache 目录。
     * @param postfixPath 缓存目录
     * @return true 设置成功 false 设置失败
     */
    @NonNull 
    BoolMsg setGlobalCacheFolderPath(@NonNull StringMsg postfixPath);
    /** 设置全局license */
    void setGlobalLicense(@NonNull LicenseMsg licenseMsg);
    /** 设置log输出级别 [TXLogLevel] */
    void setLogLevel(@NonNull IntMsg logLevel);
    /** 获取依赖Native端的 LiteAVSDK 的版本 */
    @NonNull 
    StringMsg getLiteAVSDKVersion();
    /**
     *
     * 设置 liteav SDK 接入的环境。
     * 腾讯云在全球各地区部署的环境，按照各地区政策法规要求，需要接入不同地区接入点。
     *
     * @param envConfig 需要接入的环境，SDK 默认接入的环境是：默认正式环境。
     * @return 0：成功；其他：错误
     * @note 目标市场为中国大陆的客户请不要调用此接口，如果目标市场为海外用户，请通过技术支持联系我们，了解 env_config 的配置方法，以确保 App 遵守 GDPR 标准。
     *
     */
    @NonNull 
    IntMsg setGlobalEnv(@NonNull StringMsg envConfig);
    /**
     *
     * 开始监听设备旋转方向，开启之后，如果设备自动旋转打开，播放器会自动根据当前设备方向来旋转视频方向。
     * <h1>该接口目前只适用安卓端，IOS端会自动开启该能力</h1>
     * 在调用该接口前，请务必向用户告知隐私风险。
     * 如有需要，请确认是否有获取旋转sensor的权限。
     * @return true : 开启成功
     *         false : 开启失败，如开启过早，还未等到上下文初始化、获取sensor失败等原因
     */
    @NonNull 
    BoolMsg startVideoOrientationService();

    /** The codec used by TXFlutterSuperPlayerPluginAPI. */
    static MessageCodec<Object> getCodec() {
      return TXFlutterSuperPlayerPluginAPICodec.INSTANCE;
    }
    /**Sets up an instance of `TXFlutterSuperPlayerPluginAPI` to handle messages through the `binaryMessenger`. */
    static void setup(BinaryMessenger binaryMessenger, TXFlutterSuperPlayerPluginAPI api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterSuperPlayerPluginAPI.getPlatformVersion", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  StringMsg output = api.getPlatformVersion();
                  wrapped.add(0, output);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterSuperPlayerPluginAPI.createVodPlayer", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  PlayerMsg output = api.createVodPlayer();
                  wrapped.add(0, output);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterSuperPlayerPluginAPI.createLivePlayer", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  PlayerMsg output = api.createLivePlayer();
                  wrapped.add(0, output);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterSuperPlayerPluginAPI.setConsoleEnabled", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  BoolMsg enabledArg = (BoolMsg) args.get(0);
                  if (enabledArg == null) {
                    throw new NullPointerException("enabledArg unexpectedly null.");
                  }
                  api.setConsoleEnabled(enabledArg);
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterSuperPlayerPluginAPI.releasePlayer", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  PlayerMsg playerIdArg = (PlayerMsg) args.get(0);
                  if (playerIdArg == null) {
                    throw new NullPointerException("playerIdArg unexpectedly null.");
                  }
                  api.releasePlayer(playerIdArg);
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterSuperPlayerPluginAPI.setGlobalMaxCacheSize", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  IntMsg sizeArg = (IntMsg) args.get(0);
                  if (sizeArg == null) {
                    throw new NullPointerException("sizeArg unexpectedly null.");
                  }
                  api.setGlobalMaxCacheSize(sizeArg);
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterSuperPlayerPluginAPI.setGlobalCacheFolderPath", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  StringMsg postfixPathArg = (StringMsg) args.get(0);
                  if (postfixPathArg == null) {
                    throw new NullPointerException("postfixPathArg unexpectedly null.");
                  }
                  BoolMsg output = api.setGlobalCacheFolderPath(postfixPathArg);
                  wrapped.add(0, output);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterSuperPlayerPluginAPI.setGlobalLicense", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  LicenseMsg licenseMsgArg = (LicenseMsg) args.get(0);
                  if (licenseMsgArg == null) {
                    throw new NullPointerException("licenseMsgArg unexpectedly null.");
                  }
                  api.setGlobalLicense(licenseMsgArg);
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterSuperPlayerPluginAPI.setLogLevel", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  IntMsg logLevelArg = (IntMsg) args.get(0);
                  if (logLevelArg == null) {
                    throw new NullPointerException("logLevelArg unexpectedly null.");
                  }
                  api.setLogLevel(logLevelArg);
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterSuperPlayerPluginAPI.getLiteAVSDKVersion", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  StringMsg output = api.getLiteAVSDKVersion();
                  wrapped.add(0, output);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterSuperPlayerPluginAPI.setGlobalEnv", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  StringMsg envConfigArg = (StringMsg) args.get(0);
                  if (envConfigArg == null) {
                    throw new NullPointerException("envConfigArg unexpectedly null.");
                  }
                  IntMsg output = api.setGlobalEnv(envConfigArg);
                  wrapped.add(0, output);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterSuperPlayerPluginAPI.startVideoOrientationService", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  BoolMsg output = api.startVideoOrientationService();
                  wrapped.add(0, output);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }

  private static class TXFlutterNativeAPICodec extends StandardMessageCodec {
    public static final TXFlutterNativeAPICodec INSTANCE = new TXFlutterNativeAPICodec();

    private TXFlutterNativeAPICodec() {}

    @Override
    protected Object readValueOfType(byte type, @NonNull ByteBuffer buffer) {
      switch (type) {
        case (byte) 128:
          return DoubleMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 129:
          return IntMsg.fromList((ArrayList<Object>) readValue(buffer));
        default:
          return super.readValueOfType(type, buffer);
      }
    }

    @Override
    protected void writeValue(@NonNull ByteArrayOutputStream stream, Object value) {
      if (value instanceof DoubleMsg) {
        stream.write(128);
        writeValue(stream, ((DoubleMsg) value).toList());
      } else if (value instanceof IntMsg) {
        stream.write(129);
        writeValue(stream, ((IntMsg) value).toList());
      } else {
        super.writeValue(stream, value);
      }
    }
  }

  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface TXFlutterNativeAPI {
    /** 修改当前界面亮度 */
    void setBrightness(@NonNull DoubleMsg brightness);
    /** 恢复当前界面亮度 */
    void restorePageBrightness();
    /** 获得当前界面亮度 0.0 ~ 1.0 */
    @NonNull 
    DoubleMsg getBrightness();
    /** 设置当前系统音量，0.0 ~ 1.0 */
    void setSystemVolume(@NonNull DoubleMsg volume);
    /** 获得当前系统音量，范围：0.0 ~ 1.0 */
    @NonNull 
    DoubleMsg getSystemVolume();
    /** 释放音频焦点，只用于安卓端 */
    void abandonAudioFocus();
    /** 请求获得音频焦点，只用于安卓端 */
    void requestAudioFocus();
    /**
     * 当前设备是否支持画中画模式
     * @return [TXVodPlayEvent]
     *  0 可开启画中画模式
     *  -101  android版本过低
     *  -102  画中画权限关闭/设备不支持画中画
     *  -103  当前界面已销毁
     */
    @NonNull 
    IntMsg isDeviceSupportPip();

    /** The codec used by TXFlutterNativeAPI. */
    static MessageCodec<Object> getCodec() {
      return TXFlutterNativeAPICodec.INSTANCE;
    }
    /**Sets up an instance of `TXFlutterNativeAPI` to handle messages through the `binaryMessenger`. */
    static void setup(BinaryMessenger binaryMessenger, TXFlutterNativeAPI api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterNativeAPI.setBrightness", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  DoubleMsg brightnessArg = (DoubleMsg) args.get(0);
                  if (brightnessArg == null) {
                    throw new NullPointerException("brightnessArg unexpectedly null.");
                  }
                  api.setBrightness(brightnessArg);
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterNativeAPI.restorePageBrightness", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  api.restorePageBrightness();
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterNativeAPI.getBrightness", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  DoubleMsg output = api.getBrightness();
                  wrapped.add(0, output);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterNativeAPI.setSystemVolume", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  DoubleMsg volumeArg = (DoubleMsg) args.get(0);
                  if (volumeArg == null) {
                    throw new NullPointerException("volumeArg unexpectedly null.");
                  }
                  api.setSystemVolume(volumeArg);
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterNativeAPI.getSystemVolume", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  DoubleMsg output = api.getSystemVolume();
                  wrapped.add(0, output);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterNativeAPI.abandonAudioFocus", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  api.abandonAudioFocus();
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterNativeAPI.requestAudioFocus", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  api.requestAudioFocus();
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterNativeAPI.isDeviceSupportPip", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  IntMsg output = api.isDeviceSupportPip();
                  wrapped.add(0, output);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }

  private static class TXFlutterVodPlayerApiCodec extends StandardMessageCodec {
    public static final TXFlutterVodPlayerApiCodec INSTANCE = new TXFlutterVodPlayerApiCodec();

    private TXFlutterVodPlayerApiCodec() {}

    @Override
    protected Object readValueOfType(byte type, @NonNull ByteBuffer buffer) {
      switch (type) {
        case (byte) 128:
          return BoolMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 129:
          return BoolPlayerMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 130:
          return DoubleMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 131:
          return DoublePlayerMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 132:
          return FTXVodPlayConfigPlayerMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 133:
          return IntMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 134:
          return IntPlayerMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 135:
          return ListMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 136:
          return PipParamsPlayerMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 137:
          return PlayerMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 138:
          return StringListPlayerMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 139:
          return StringPlayerMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 140:
          return TXPlayInfoParamsPlayerMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 141:
          return UInt8ListMsg.fromList((ArrayList<Object>) readValue(buffer));
        default:
          return super.readValueOfType(type, buffer);
      }
    }

    @Override
    protected void writeValue(@NonNull ByteArrayOutputStream stream, Object value) {
      if (value instanceof BoolMsg) {
        stream.write(128);
        writeValue(stream, ((BoolMsg) value).toList());
      } else if (value instanceof BoolPlayerMsg) {
        stream.write(129);
        writeValue(stream, ((BoolPlayerMsg) value).toList());
      } else if (value instanceof DoubleMsg) {
        stream.write(130);
        writeValue(stream, ((DoubleMsg) value).toList());
      } else if (value instanceof DoublePlayerMsg) {
        stream.write(131);
        writeValue(stream, ((DoublePlayerMsg) value).toList());
      } else if (value instanceof FTXVodPlayConfigPlayerMsg) {
        stream.write(132);
        writeValue(stream, ((FTXVodPlayConfigPlayerMsg) value).toList());
      } else if (value instanceof IntMsg) {
        stream.write(133);
        writeValue(stream, ((IntMsg) value).toList());
      } else if (value instanceof IntPlayerMsg) {
        stream.write(134);
        writeValue(stream, ((IntPlayerMsg) value).toList());
      } else if (value instanceof ListMsg) {
        stream.write(135);
        writeValue(stream, ((ListMsg) value).toList());
      } else if (value instanceof PipParamsPlayerMsg) {
        stream.write(136);
        writeValue(stream, ((PipParamsPlayerMsg) value).toList());
      } else if (value instanceof PlayerMsg) {
        stream.write(137);
        writeValue(stream, ((PlayerMsg) value).toList());
      } else if (value instanceof StringListPlayerMsg) {
        stream.write(138);
        writeValue(stream, ((StringListPlayerMsg) value).toList());
      } else if (value instanceof StringPlayerMsg) {
        stream.write(139);
        writeValue(stream, ((StringPlayerMsg) value).toList());
      } else if (value instanceof TXPlayInfoParamsPlayerMsg) {
        stream.write(140);
        writeValue(stream, ((TXPlayInfoParamsPlayerMsg) value).toList());
      } else if (value instanceof UInt8ListMsg) {
        stream.write(141);
        writeValue(stream, ((UInt8ListMsg) value).toList());
      } else {
        super.writeValue(stream, value);
      }
    }
  }

  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface TXFlutterVodPlayerApi {
    /**
     * 播放器初始化，创建共享纹理、初始化播放器
     * @param onlyAudio 是否是纯音频模式
     */
    @NonNull 
    IntMsg initialize(@NonNull BoolPlayerMsg onlyAudio);
    /**
     * 通过url开始播放视频
     * 10.7版本开始，startPlay变更为startVodPlay，需要通过 {@link SuperPlayerPlugin#setGlobalLicense} 设置 Licence 后方可成功播放，
     * 否则将播放失败（黑屏），全局仅设置一次即可。直播 Licence、短视频 Licence 和视频播放 Licence 均可使用，若您暂未获取上述 Licence ，
     * 可[快速免费申请测试版 Licence](https://cloud.tencent.com/act/event/License) 以正常播放，正式版 License 需[购买]
     * (https://cloud.tencent.com/document/product/881/74588#.E8.B4.AD.E4.B9.B0.E5.B9.B6.E6.96.B0.E5.BB.BA.E6.AD.A3.E5.BC.8F.E7.89.88-license)。
     * @param url : 视频播放地址
     * return 是否播放成功
     */
    @NonNull 
    BoolMsg startVodPlay(@NonNull StringPlayerMsg url);
    /**
     * 通过fileId播放视频
     * 10.7版本开始，startPlayWithParams变更为startVodPlayWithParams，需要通过 {@link SuperPlayerPlugin#setGlobalLicense} 设置 Licence 后方可成功播放，
     * 否则将播放失败（黑屏），全局仅设置一次即可。直播 Licence、短视频 Licence 和视频播放 Licence 均可使用，若您暂未获取上述 Licence ，
     * 可[快速免费申请测试版 Licence](https://cloud.tencent.com/act/event/License) 以正常播放，正式版 License 需[购买]
     * (https://cloud.tencent.com/document/product/881/74588#.E8.B4.AD.E4.B9.B0.E5.B9.B6.E6.96.B0.E5.BB.BA.E6.AD.A3.E5.BC.8F.E7.89.88-license)。
     * @params : 见[TXPlayInfoParams]
     * return 是否播放成功
     */
    void startVodPlayWithParams(@NonNull TXPlayInfoParamsPlayerMsg params);
    /** 设置是否自动播放 */
    void setAutoPlay(@NonNull BoolPlayerMsg isAutoPlay);
    /**
     * 停止播放
     * return 是否停止成功
     */
    @NonNull 
    BoolMsg stop(@NonNull BoolPlayerMsg isNeedClear);
    /** 视频是否处于正在播放中 */
    @NonNull 
    BoolMsg isPlaying(@NonNull PlayerMsg playerMsg);
    /** 视频暂停，必须在播放器开始播放的时候调用 */
    void pause(@NonNull PlayerMsg playerMsg);
    /** 继续播放，在暂停的时候调用 */
    void resume(@NonNull PlayerMsg playerMsg);
    /** 设置是否静音 */
    void setMute(@NonNull BoolPlayerMsg mute);
    /** 设置是否循环播放 */
    void setLoop(@NonNull BoolPlayerMsg loop);
    /**
     * 将视频播放进度定位到指定的进度进行播放
     * progress 要定位的视频时间，单位 秒
     */
    void seek(@NonNull DoublePlayerMsg progress);
    /** 设置播放速率，默认速率 1 */
    void setRate(@NonNull DoublePlayerMsg rate);
    /**
     * 获得播放视频解析出来的码率信息
     * return List<Map>
     * Bitrate键值：index 码率序号，width 码率对应视频宽度，
     *             height 码率对应视频高度, bitrate 码率值
     */
    @NonNull 
    ListMsg getSupportedBitrate(@NonNull PlayerMsg playerMsg);
    /** 获得当前设置的码率序号 */
    @NonNull 
    IntMsg getBitrateIndex(@NonNull PlayerMsg playerMsg);
    /** 设置码率序号 */
    void setBitrateIndex(@NonNull IntPlayerMsg index);
    /** 设置视频播放开始时间，单位 秒 */
    void setStartTime(@NonNull DoublePlayerMsg startTime);
    /** 设置视频声音 0~100 */
    void setAudioPlayOutVolume(@NonNull IntPlayerMsg volume);
    /** 请求获得音频焦点 */
    @NonNull 
    BoolMsg setRequestAudioFocus(@NonNull BoolPlayerMsg focus);
    /**
     * 设置播放器配置
     * config @see [FTXVodPlayConfigPlayerMsg]
     */
    void setConfig(@NonNull FTXVodPlayConfigPlayerMsg config);
    /** 获得当前已经播放的时间，单位 秒 */
    @NonNull 
    DoubleMsg getCurrentPlaybackTime(@NonNull PlayerMsg playerMsg);
    /** 获得当前视频已缓存的时间 */
    @NonNull 
    DoubleMsg getBufferDuration(@NonNull PlayerMsg playerMsg);
    /** 获得当前视频的可播放时间 */
    @NonNull 
    DoubleMsg getPlayableDuration(@NonNull PlayerMsg playerMsg);
    /** 获得当前播放视频的宽度 */
    @NonNull 
    IntMsg getWidth(@NonNull PlayerMsg playerMsg);
    /** 获得当前播放视频的高度 */
    @NonNull 
    IntMsg getHeight(@NonNull PlayerMsg playerMsg);
    /** 设置播放视频的token */
    void setToken(@NonNull StringPlayerMsg token);
    /** 当前播放的视频是否循环播放 */
    @NonNull 
    BoolMsg isLoop(@NonNull PlayerMsg playerMsg);
    /** 开启/关闭硬件编码 */
    @NonNull 
    BoolMsg enableHardwareDecode(@NonNull BoolPlayerMsg enable);
    /**
     * 进入画中画模式，进入画中画模式，需要适配画中画模式的界面，安卓只支持7.0以上机型
     * <h1>
     * 由于android系统限制，传递的图标大小不得超过1M，否则无法显示
     * </h1>
     * @param backIcon playIcon pauseIcon forwardIcon 为播放后退、播放、暂停、前进的图标，如果赋值的话，将会使用传递的图标，否则
     * 使用系统默认图标，只支持flutter本地资源图片，传递的时候，与flutter使用图片资源一致，例如： images/back_icon.png
     */
    @NonNull 
    IntMsg enterPictureInPictureMode(@NonNull PipParamsPlayerMsg pipParamsMsg);
    /** 退出画中画，如果该播放器处于画中画模式 */
    void exitPictureInPictureMode(@NonNull PlayerMsg playerMsg);

    void initImageSprite(@NonNull StringListPlayerMsg spriteInfo);

    @NonNull 
    UInt8ListMsg getImageSprite(@NonNull DoublePlayerMsg time);
    /** 获取总时长 */
    @NonNull 
    DoubleMsg getDuration(@NonNull PlayerMsg playerMsg);

    /** The codec used by TXFlutterVodPlayerApi. */
    static MessageCodec<Object> getCodec() {
      return TXFlutterVodPlayerApiCodec.INSTANCE;
    }
    /**Sets up an instance of `TXFlutterVodPlayerApi` to handle messages through the `binaryMessenger`. */
    static void setup(BinaryMessenger binaryMessenger, TXFlutterVodPlayerApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterVodPlayerApi.initialize", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  BoolPlayerMsg onlyAudioArg = (BoolPlayerMsg) args.get(0);
                  if (onlyAudioArg == null) {
                    throw new NullPointerException("onlyAudioArg unexpectedly null.");
                  }
                  IntMsg output = api.initialize(onlyAudioArg);
                  wrapped.add(0, output);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterVodPlayerApi.startVodPlay", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  StringPlayerMsg urlArg = (StringPlayerMsg) args.get(0);
                  if (urlArg == null) {
                    throw new NullPointerException("urlArg unexpectedly null.");
                  }
                  BoolMsg output = api.startVodPlay(urlArg);
                  wrapped.add(0, output);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterVodPlayerApi.startVodPlayWithParams", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  TXPlayInfoParamsPlayerMsg paramsArg = (TXPlayInfoParamsPlayerMsg) args.get(0);
                  if (paramsArg == null) {
                    throw new NullPointerException("paramsArg unexpectedly null.");
                  }
                  api.startVodPlayWithParams(paramsArg);
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterVodPlayerApi.setAutoPlay", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  BoolPlayerMsg isAutoPlayArg = (BoolPlayerMsg) args.get(0);
                  if (isAutoPlayArg == null) {
                    throw new NullPointerException("isAutoPlayArg unexpectedly null.");
                  }
                  api.setAutoPlay(isAutoPlayArg);
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterVodPlayerApi.stop", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  BoolPlayerMsg isNeedClearArg = (BoolPlayerMsg) args.get(0);
                  if (isNeedClearArg == null) {
                    throw new NullPointerException("isNeedClearArg unexpectedly null.");
                  }
                  BoolMsg output = api.stop(isNeedClearArg);
                  wrapped.add(0, output);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterVodPlayerApi.isPlaying", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                  if (playerMsgArg == null) {
                    throw new NullPointerException("playerMsgArg unexpectedly null.");
                  }
                  BoolMsg output = api.isPlaying(playerMsgArg);
                  wrapped.add(0, output);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterVodPlayerApi.pause", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                  if (playerMsgArg == null) {
                    throw new NullPointerException("playerMsgArg unexpectedly null.");
                  }
                  api.pause(playerMsgArg);
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterVodPlayerApi.resume", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                  if (playerMsgArg == null) {
                    throw new NullPointerException("playerMsgArg unexpectedly null.");
                  }
                  api.resume(playerMsgArg);
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterVodPlayerApi.setMute", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  BoolPlayerMsg muteArg = (BoolPlayerMsg) args.get(0);
                  if (muteArg == null) {
                    throw new NullPointerException("muteArg unexpectedly null.");
                  }
                  api.setMute(muteArg);
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterVodPlayerApi.setLoop", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  BoolPlayerMsg loopArg = (BoolPlayerMsg) args.get(0);
                  if (loopArg == null) {
                    throw new NullPointerException("loopArg unexpectedly null.");
                  }
                  api.setLoop(loopArg);
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterVodPlayerApi.seek", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  DoublePlayerMsg progressArg = (DoublePlayerMsg) args.get(0);
                  if (progressArg == null) {
                    throw new NullPointerException("progressArg unexpectedly null.");
                  }
                  api.seek(progressArg);
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterVodPlayerApi.setRate", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  DoublePlayerMsg rateArg = (DoublePlayerMsg) args.get(0);
                  if (rateArg == null) {
                    throw new NullPointerException("rateArg unexpectedly null.");
                  }
                  api.setRate(rateArg);
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterVodPlayerApi.getSupportedBitrate", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                  if (playerMsgArg == null) {
                    throw new NullPointerException("playerMsgArg unexpectedly null.");
                  }
                  ListMsg output = api.getSupportedBitrate(playerMsgArg);
                  wrapped.add(0, output);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterVodPlayerApi.getBitrateIndex", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                  if (playerMsgArg == null) {
                    throw new NullPointerException("playerMsgArg unexpectedly null.");
                  }
                  IntMsg output = api.getBitrateIndex(playerMsgArg);
                  wrapped.add(0, output);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterVodPlayerApi.setBitrateIndex", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  IntPlayerMsg indexArg = (IntPlayerMsg) args.get(0);
                  if (indexArg == null) {
                    throw new NullPointerException("indexArg unexpectedly null.");
                  }
                  api.setBitrateIndex(indexArg);
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterVodPlayerApi.setStartTime", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  DoublePlayerMsg startTimeArg = (DoublePlayerMsg) args.get(0);
                  if (startTimeArg == null) {
                    throw new NullPointerException("startTimeArg unexpectedly null.");
                  }
                  api.setStartTime(startTimeArg);
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterVodPlayerApi.setAudioPlayOutVolume", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  IntPlayerMsg volumeArg = (IntPlayerMsg) args.get(0);
                  if (volumeArg == null) {
                    throw new NullPointerException("volumeArg unexpectedly null.");
                  }
                  api.setAudioPlayOutVolume(volumeArg);
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterVodPlayerApi.setRequestAudioFocus", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  BoolPlayerMsg focusArg = (BoolPlayerMsg) args.get(0);
                  if (focusArg == null) {
                    throw new NullPointerException("focusArg unexpectedly null.");
                  }
                  BoolMsg output = api.setRequestAudioFocus(focusArg);
                  wrapped.add(0, output);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterVodPlayerApi.setConfig", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  FTXVodPlayConfigPlayerMsg configArg = (FTXVodPlayConfigPlayerMsg) args.get(0);
                  if (configArg == null) {
                    throw new NullPointerException("configArg unexpectedly null.");
                  }
                  api.setConfig(configArg);
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterVodPlayerApi.getCurrentPlaybackTime", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                  if (playerMsgArg == null) {
                    throw new NullPointerException("playerMsgArg unexpectedly null.");
                  }
                  DoubleMsg output = api.getCurrentPlaybackTime(playerMsgArg);
                  wrapped.add(0, output);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterVodPlayerApi.getBufferDuration", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                  if (playerMsgArg == null) {
                    throw new NullPointerException("playerMsgArg unexpectedly null.");
                  }
                  DoubleMsg output = api.getBufferDuration(playerMsgArg);
                  wrapped.add(0, output);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterVodPlayerApi.getPlayableDuration", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                  if (playerMsgArg == null) {
                    throw new NullPointerException("playerMsgArg unexpectedly null.");
                  }
                  DoubleMsg output = api.getPlayableDuration(playerMsgArg);
                  wrapped.add(0, output);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterVodPlayerApi.getWidth", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                  if (playerMsgArg == null) {
                    throw new NullPointerException("playerMsgArg unexpectedly null.");
                  }
                  IntMsg output = api.getWidth(playerMsgArg);
                  wrapped.add(0, output);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterVodPlayerApi.getHeight", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                  if (playerMsgArg == null) {
                    throw new NullPointerException("playerMsgArg unexpectedly null.");
                  }
                  IntMsg output = api.getHeight(playerMsgArg);
                  wrapped.add(0, output);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterVodPlayerApi.setToken", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  StringPlayerMsg tokenArg = (StringPlayerMsg) args.get(0);
                  if (tokenArg == null) {
                    throw new NullPointerException("tokenArg unexpectedly null.");
                  }
                  api.setToken(tokenArg);
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterVodPlayerApi.isLoop", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                  if (playerMsgArg == null) {
                    throw new NullPointerException("playerMsgArg unexpectedly null.");
                  }
                  BoolMsg output = api.isLoop(playerMsgArg);
                  wrapped.add(0, output);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterVodPlayerApi.enableHardwareDecode", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  BoolPlayerMsg enableArg = (BoolPlayerMsg) args.get(0);
                  if (enableArg == null) {
                    throw new NullPointerException("enableArg unexpectedly null.");
                  }
                  BoolMsg output = api.enableHardwareDecode(enableArg);
                  wrapped.add(0, output);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterVodPlayerApi.enterPictureInPictureMode", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  PipParamsPlayerMsg pipParamsMsgArg = (PipParamsPlayerMsg) args.get(0);
                  if (pipParamsMsgArg == null) {
                    throw new NullPointerException("pipParamsMsgArg unexpectedly null.");
                  }
                  IntMsg output = api.enterPictureInPictureMode(pipParamsMsgArg);
                  wrapped.add(0, output);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterVodPlayerApi.exitPictureInPictureMode", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                  if (playerMsgArg == null) {
                    throw new NullPointerException("playerMsgArg unexpectedly null.");
                  }
                  api.exitPictureInPictureMode(playerMsgArg);
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterVodPlayerApi.initImageSprite", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  StringListPlayerMsg spriteInfoArg = (StringListPlayerMsg) args.get(0);
                  if (spriteInfoArg == null) {
                    throw new NullPointerException("spriteInfoArg unexpectedly null.");
                  }
                  api.initImageSprite(spriteInfoArg);
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterVodPlayerApi.getImageSprite", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  DoublePlayerMsg timeArg = (DoublePlayerMsg) args.get(0);
                  if (timeArg == null) {
                    throw new NullPointerException("timeArg unexpectedly null.");
                  }
                  UInt8ListMsg output = api.getImageSprite(timeArg);
                  wrapped.add(0, output);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterVodPlayerApi.getDuration", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                  if (playerMsgArg == null) {
                    throw new NullPointerException("playerMsgArg unexpectedly null.");
                  }
                  DoubleMsg output = api.getDuration(playerMsgArg);
                  wrapped.add(0, output);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }

  private static class TXFlutterLivePlayerApiCodec extends StandardMessageCodec {
    public static final TXFlutterLivePlayerApiCodec INSTANCE = new TXFlutterLivePlayerApiCodec();

    private TXFlutterLivePlayerApiCodec() {}

    @Override
    protected Object readValueOfType(byte type, @NonNull ByteBuffer buffer) {
      switch (type) {
        case (byte) 128:
          return BoolMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 129:
          return BoolPlayerMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 130:
          return DoublePlayerMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 131:
          return FTXLivePlayConfigPlayerMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 132:
          return IntMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 133:
          return IntPlayerMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 134:
          return PipParamsPlayerMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 135:
          return PlayerMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 136:
          return StringIntPlayerMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 137:
          return StringPlayerMsg.fromList((ArrayList<Object>) readValue(buffer));
        default:
          return super.readValueOfType(type, buffer);
      }
    }

    @Override
    protected void writeValue(@NonNull ByteArrayOutputStream stream, Object value) {
      if (value instanceof BoolMsg) {
        stream.write(128);
        writeValue(stream, ((BoolMsg) value).toList());
      } else if (value instanceof BoolPlayerMsg) {
        stream.write(129);
        writeValue(stream, ((BoolPlayerMsg) value).toList());
      } else if (value instanceof DoublePlayerMsg) {
        stream.write(130);
        writeValue(stream, ((DoublePlayerMsg) value).toList());
      } else if (value instanceof FTXLivePlayConfigPlayerMsg) {
        stream.write(131);
        writeValue(stream, ((FTXLivePlayConfigPlayerMsg) value).toList());
      } else if (value instanceof IntMsg) {
        stream.write(132);
        writeValue(stream, ((IntMsg) value).toList());
      } else if (value instanceof IntPlayerMsg) {
        stream.write(133);
        writeValue(stream, ((IntPlayerMsg) value).toList());
      } else if (value instanceof PipParamsPlayerMsg) {
        stream.write(134);
        writeValue(stream, ((PipParamsPlayerMsg) value).toList());
      } else if (value instanceof PlayerMsg) {
        stream.write(135);
        writeValue(stream, ((PlayerMsg) value).toList());
      } else if (value instanceof StringIntPlayerMsg) {
        stream.write(136);
        writeValue(stream, ((StringIntPlayerMsg) value).toList());
      } else if (value instanceof StringPlayerMsg) {
        stream.write(137);
        writeValue(stream, ((StringPlayerMsg) value).toList());
      } else {
        super.writeValue(stream, value);
      }
    }
  }

  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface TXFlutterLivePlayerApi {
    /**
     * 播放器初始化，创建共享纹理、初始化播放器
     * @param onlyAudio 是否是纯音频模式
     */
    @NonNull 
    IntMsg initialize(@NonNull BoolPlayerMsg onlyAudio);
    /**
     *
     * 当设置[LivePlayer] 类型播放器时，需要参数[playType]
     * 参考: [PlayType.LIVE_RTMP] ...
     * 10.7版本开始，startPlay变更为startLivePlay，需要通过 {@link SuperPlayerPlugin#setGlobalLicense} 设置 Licence 后方可成功播放，
     * 否则将播放失败（黑屏），全局仅设置一次即可。直播 Licence、短视频 Licence 和视频播放 Licence 均可使用，若您暂未获取上述 Licence ，
     * 可[快速免费申请测试版 Licence](https://cloud.tencent.com/act/event/License) 以正常播放，正式版 License 需[购买]
     * (https://cloud.tencent.com/document/product/881/74588#.E8.B4.AD.E4.B9.B0.E5.B9.B6.E6.96.B0.E5.BB.BA.E6.AD.A3.E5.BC.8F.E7.89.88-license)。
     */
    @NonNull 
    BoolMsg startLivePlay(@NonNull StringIntPlayerMsg playerMsg);
    /** 设置是否自动播放 */
    void setAutoPlay(@NonNull BoolPlayerMsg isAutoPlay);
    /**
     * 停止播放
     * return 是否停止成功
     */
    @NonNull 
    BoolMsg stop(@NonNull BoolPlayerMsg isNeedClear);
    /** 视频是否处于正在播放中 */
    @NonNull 
    BoolMsg isPlaying(@NonNull PlayerMsg playerMsg);
    /** 视频暂停，必须在播放器开始播放的时候调用 */
    void pause(@NonNull PlayerMsg playerMsg);
    /** 继续播放，在暂停的时候调用 */
    void resume(@NonNull PlayerMsg playerMsg);
    /** 设置直播模式，see TXPlayerLiveMode */
    void setLiveMode(@NonNull IntPlayerMsg mode);
    /** 设置视频声音 0~100 */
    void setVolume(@NonNull IntPlayerMsg volume);
    /** 设置是否静音 */
    void setMute(@NonNull BoolPlayerMsg mute);
    /** 切换播放流 */
    @NonNull 
    IntMsg switchStream(@NonNull StringPlayerMsg url);
    /**
     * 将视频播放进度定位到指定的进度进行播放
     * progress 要定位的视频时间，单位 秒
     */
    void seek(@NonNull DoublePlayerMsg progress);
    /** 设置appId */
    void setAppID(@NonNull StringPlayerMsg appId);
    /**
     * 时移 暂不支持
     * @param domain
     * @param bizId
     */
    void prepareLiveSeek(@NonNull StringIntPlayerMsg playerMsg);
    /** 停止时移播放，返回直播 */
    @NonNull 
    IntMsg resumeLive(@NonNull PlayerMsg playerMsg);
    /** 设置播放速率,暂不支持 */
    void setRate(@NonNull DoublePlayerMsg rate);
    /**
     * 设置播放器配置
     * config @see [FTXLivePlayConfig]
     */
    void setConfig(@NonNull FTXLivePlayConfigPlayerMsg config);
    /** 开启/关闭硬件编码 */
    @NonNull 
    BoolMsg enableHardwareDecode(@NonNull BoolPlayerMsg enable);
    /**
     * 进入画中画模式，进入画中画模式，需要适配画中画模式的界面，安卓只支持7.0以上机型
     * <h1>
     * 由于android系统限制，传递的图标大小不得超过1M，否则无法显示
     * </h1>
     * @param backIcon playIcon pauseIcon forwardIcon 为播放后退、播放、暂停、前进的图标，仅适用于android，如果赋值的话，将会使用传递的图标，否则
     * 使用系统默认图标，只支持flutter本地资源图片，传递的时候，与flutter使用图片资源一致，例如： images/back_icon.png
     */
    @NonNull 
    IntMsg enterPictureInPictureMode(@NonNull PipParamsPlayerMsg pipParamsMsg);
    /** 退出画中画，如果该播放器处于画中画模式 */
    void exitPictureInPictureMode(@NonNull PlayerMsg playerMsg);

    /** The codec used by TXFlutterLivePlayerApi. */
    static MessageCodec<Object> getCodec() {
      return TXFlutterLivePlayerApiCodec.INSTANCE;
    }
    /**Sets up an instance of `TXFlutterLivePlayerApi` to handle messages through the `binaryMessenger`. */
    static void setup(BinaryMessenger binaryMessenger, TXFlutterLivePlayerApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterLivePlayerApi.initialize", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  BoolPlayerMsg onlyAudioArg = (BoolPlayerMsg) args.get(0);
                  if (onlyAudioArg == null) {
                    throw new NullPointerException("onlyAudioArg unexpectedly null.");
                  }
                  IntMsg output = api.initialize(onlyAudioArg);
                  wrapped.add(0, output);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterLivePlayerApi.startLivePlay", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  StringIntPlayerMsg playerMsgArg = (StringIntPlayerMsg) args.get(0);
                  if (playerMsgArg == null) {
                    throw new NullPointerException("playerMsgArg unexpectedly null.");
                  }
                  BoolMsg output = api.startLivePlay(playerMsgArg);
                  wrapped.add(0, output);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterLivePlayerApi.setAutoPlay", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  BoolPlayerMsg isAutoPlayArg = (BoolPlayerMsg) args.get(0);
                  if (isAutoPlayArg == null) {
                    throw new NullPointerException("isAutoPlayArg unexpectedly null.");
                  }
                  api.setAutoPlay(isAutoPlayArg);
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterLivePlayerApi.stop", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  BoolPlayerMsg isNeedClearArg = (BoolPlayerMsg) args.get(0);
                  if (isNeedClearArg == null) {
                    throw new NullPointerException("isNeedClearArg unexpectedly null.");
                  }
                  BoolMsg output = api.stop(isNeedClearArg);
                  wrapped.add(0, output);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterLivePlayerApi.isPlaying", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                  if (playerMsgArg == null) {
                    throw new NullPointerException("playerMsgArg unexpectedly null.");
                  }
                  BoolMsg output = api.isPlaying(playerMsgArg);
                  wrapped.add(0, output);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterLivePlayerApi.pause", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                  if (playerMsgArg == null) {
                    throw new NullPointerException("playerMsgArg unexpectedly null.");
                  }
                  api.pause(playerMsgArg);
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterLivePlayerApi.resume", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                  if (playerMsgArg == null) {
                    throw new NullPointerException("playerMsgArg unexpectedly null.");
                  }
                  api.resume(playerMsgArg);
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterLivePlayerApi.setLiveMode", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  IntPlayerMsg modeArg = (IntPlayerMsg) args.get(0);
                  if (modeArg == null) {
                    throw new NullPointerException("modeArg unexpectedly null.");
                  }
                  api.setLiveMode(modeArg);
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterLivePlayerApi.setVolume", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  IntPlayerMsg volumeArg = (IntPlayerMsg) args.get(0);
                  if (volumeArg == null) {
                    throw new NullPointerException("volumeArg unexpectedly null.");
                  }
                  api.setVolume(volumeArg);
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterLivePlayerApi.setMute", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  BoolPlayerMsg muteArg = (BoolPlayerMsg) args.get(0);
                  if (muteArg == null) {
                    throw new NullPointerException("muteArg unexpectedly null.");
                  }
                  api.setMute(muteArg);
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterLivePlayerApi.switchStream", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  StringPlayerMsg urlArg = (StringPlayerMsg) args.get(0);
                  if (urlArg == null) {
                    throw new NullPointerException("urlArg unexpectedly null.");
                  }
                  IntMsg output = api.switchStream(urlArg);
                  wrapped.add(0, output);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterLivePlayerApi.seek", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  DoublePlayerMsg progressArg = (DoublePlayerMsg) args.get(0);
                  if (progressArg == null) {
                    throw new NullPointerException("progressArg unexpectedly null.");
                  }
                  api.seek(progressArg);
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterLivePlayerApi.setAppID", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  StringPlayerMsg appIdArg = (StringPlayerMsg) args.get(0);
                  if (appIdArg == null) {
                    throw new NullPointerException("appIdArg unexpectedly null.");
                  }
                  api.setAppID(appIdArg);
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterLivePlayerApi.prepareLiveSeek", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  StringIntPlayerMsg playerMsgArg = (StringIntPlayerMsg) args.get(0);
                  if (playerMsgArg == null) {
                    throw new NullPointerException("playerMsgArg unexpectedly null.");
                  }
                  api.prepareLiveSeek(playerMsgArg);
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterLivePlayerApi.resumeLive", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                  if (playerMsgArg == null) {
                    throw new NullPointerException("playerMsgArg unexpectedly null.");
                  }
                  IntMsg output = api.resumeLive(playerMsgArg);
                  wrapped.add(0, output);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterLivePlayerApi.setRate", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  DoublePlayerMsg rateArg = (DoublePlayerMsg) args.get(0);
                  if (rateArg == null) {
                    throw new NullPointerException("rateArg unexpectedly null.");
                  }
                  api.setRate(rateArg);
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterLivePlayerApi.setConfig", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  FTXLivePlayConfigPlayerMsg configArg = (FTXLivePlayConfigPlayerMsg) args.get(0);
                  if (configArg == null) {
                    throw new NullPointerException("configArg unexpectedly null.");
                  }
                  api.setConfig(configArg);
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterLivePlayerApi.enableHardwareDecode", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  BoolPlayerMsg enableArg = (BoolPlayerMsg) args.get(0);
                  if (enableArg == null) {
                    throw new NullPointerException("enableArg unexpectedly null.");
                  }
                  BoolMsg output = api.enableHardwareDecode(enableArg);
                  wrapped.add(0, output);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterLivePlayerApi.enterPictureInPictureMode", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  PipParamsPlayerMsg pipParamsMsgArg = (PipParamsPlayerMsg) args.get(0);
                  if (pipParamsMsgArg == null) {
                    throw new NullPointerException("pipParamsMsgArg unexpectedly null.");
                  }
                  IntMsg output = api.enterPictureInPictureMode(pipParamsMsgArg);
                  wrapped.add(0, output);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterLivePlayerApi.exitPictureInPictureMode", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                  if (playerMsgArg == null) {
                    throw new NullPointerException("playerMsgArg unexpectedly null.");
                  }
                  api.exitPictureInPictureMode(playerMsgArg);
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }

  private static class TXFlutterDownloadApiCodec extends StandardMessageCodec {
    public static final TXFlutterDownloadApiCodec INSTANCE = new TXFlutterDownloadApiCodec();

    private TXFlutterDownloadApiCodec() {}

    @Override
    protected Object readValueOfType(byte type, @NonNull ByteBuffer buffer) {
      switch (type) {
        case (byte) 128:
          return BoolMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 129:
          return IntMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 130:
          return MapMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 131:
          return PreLoadMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 132:
          return TXDownloadListMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 133:
          return TXVodDownloadMediaMsg.fromList((ArrayList<Object>) readValue(buffer));
        default:
          return super.readValueOfType(type, buffer);
      }
    }

    @Override
    protected void writeValue(@NonNull ByteArrayOutputStream stream, Object value) {
      if (value instanceof BoolMsg) {
        stream.write(128);
        writeValue(stream, ((BoolMsg) value).toList());
      } else if (value instanceof IntMsg) {
        stream.write(129);
        writeValue(stream, ((IntMsg) value).toList());
      } else if (value instanceof MapMsg) {
        stream.write(130);
        writeValue(stream, ((MapMsg) value).toList());
      } else if (value instanceof PreLoadMsg) {
        stream.write(131);
        writeValue(stream, ((PreLoadMsg) value).toList());
      } else if (value instanceof TXDownloadListMsg) {
        stream.write(132);
        writeValue(stream, ((TXDownloadListMsg) value).toList());
      } else if (value instanceof TXVodDownloadMediaMsg) {
        stream.write(133);
        writeValue(stream, ((TXVodDownloadMediaMsg) value).toList());
      } else {
        super.writeValue(stream, value);
      }
    }
  }

  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface TXFlutterDownloadApi {
    /**
     * 启动预下载。
     * playUrl: 要预下载的url
     * preloadSizeMB: 预下载的大小（单位：MB）
     * preferredResolution 期望分辨率，long类型，值为高x宽。可参考如720*1080。不支持多分辨率或不需指定时，传-1。
     * 返回值：任务ID，可用这个任务ID停止预下载 [stopPreload]
     */
    @NonNull 
    IntMsg startPreLoad(@NonNull PreLoadMsg msg);
    /**
     * 停止预下载。
     * taskId： 任务id
     */
    void stopPreLoad(@NonNull IntMsg msg);
    /**
     * 开始下载
     * videoDownloadModel: 下载构造体
     */
    void startDownload(@NonNull TXVodDownloadMediaMsg msg);
    /**
     * 继续下载，与开始下载接口有区别，该接口会寻找对应的缓存，复用之前的缓存来续点下载，
     * 而开始下载接口会启动一个全新的下载
     * videoDownloadModel: 下载构造体
     */
    void resumeDownload(@NonNull TXVodDownloadMediaMsg msg);
    /**
     * 停止下载
     * videoDownloadModel: 下载构造体
     */
    void stopDownload(@NonNull TXVodDownloadMediaMsg msg);
    /** 设置下载请求头 */
    void setDownloadHeaders(@NonNull MapMsg headers);
    /** 获取所有视频下载列表 */
    @NonNull 
    TXDownloadListMsg getDownloadList();
    /** 获得指定视频的下载信息 */
    @NonNull 
    TXVodDownloadMediaMsg getDownloadInfo(@NonNull TXVodDownloadMediaMsg msg);
    /** 删除下载任务 */
    @NonNull 
    BoolMsg deleteDownloadMediaInfo(@NonNull TXVodDownloadMediaMsg msg);

    /** The codec used by TXFlutterDownloadApi. */
    static MessageCodec<Object> getCodec() {
      return TXFlutterDownloadApiCodec.INSTANCE;
    }
    /**Sets up an instance of `TXFlutterDownloadApi` to handle messages through the `binaryMessenger`. */
    static void setup(BinaryMessenger binaryMessenger, TXFlutterDownloadApi api) {
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterDownloadApi.startPreLoad", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  PreLoadMsg msgArg = (PreLoadMsg) args.get(0);
                  if (msgArg == null) {
                    throw new NullPointerException("msgArg unexpectedly null.");
                  }
                  IntMsg output = api.startPreLoad(msgArg);
                  wrapped.add(0, output);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterDownloadApi.stopPreLoad", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  IntMsg msgArg = (IntMsg) args.get(0);
                  if (msgArg == null) {
                    throw new NullPointerException("msgArg unexpectedly null.");
                  }
                  api.stopPreLoad(msgArg);
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterDownloadApi.startDownload", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  TXVodDownloadMediaMsg msgArg = (TXVodDownloadMediaMsg) args.get(0);
                  if (msgArg == null) {
                    throw new NullPointerException("msgArg unexpectedly null.");
                  }
                  api.startDownload(msgArg);
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterDownloadApi.resumeDownload", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  TXVodDownloadMediaMsg msgArg = (TXVodDownloadMediaMsg) args.get(0);
                  if (msgArg == null) {
                    throw new NullPointerException("msgArg unexpectedly null.");
                  }
                  api.resumeDownload(msgArg);
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterDownloadApi.stopDownload", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  TXVodDownloadMediaMsg msgArg = (TXVodDownloadMediaMsg) args.get(0);
                  if (msgArg == null) {
                    throw new NullPointerException("msgArg unexpectedly null.");
                  }
                  api.stopDownload(msgArg);
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterDownloadApi.setDownloadHeaders", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  MapMsg headersArg = (MapMsg) args.get(0);
                  if (headersArg == null) {
                    throw new NullPointerException("headersArg unexpectedly null.");
                  }
                  api.setDownloadHeaders(headersArg);
                  wrapped.add(0, null);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterDownloadApi.getDownloadList", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  TXDownloadListMsg output = api.getDownloadList();
                  wrapped.add(0, output);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterDownloadApi.getDownloadInfo", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  TXVodDownloadMediaMsg msgArg = (TXVodDownloadMediaMsg) args.get(0);
                  if (msgArg == null) {
                    throw new NullPointerException("msgArg unexpectedly null.");
                  }
                  TXVodDownloadMediaMsg output = api.getDownloadInfo(msgArg);
                  wrapped.add(0, output);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.TXFlutterDownloadApi.deleteDownloadMediaInfo", getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<Object>();
                try {
                  ArrayList<Object> args = (ArrayList<Object>) message;
                  assert args != null;
                  TXVodDownloadMediaMsg msgArg = (TXVodDownloadMediaMsg) args.get(0);
                  if (msgArg == null) {
                    throw new NullPointerException("msgArg unexpectedly null.");
                  }
                  BoolMsg output = api.deleteDownloadMediaInfo(msgArg);
                  wrapped.add(0, output);
                } catch (Error | RuntimeException exception) {
                  ArrayList<Object> wrappedError = wrapError(exception);
                  wrapped = wrappedError;
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
}
