// Copyright (c) 2024 Tencent. All rights reserved.
#ifndef SUPERPLAYER_FLUTTER_IOS_CLASSES_COMMON_FTXPLAYERCONSTANTS_H_
#define SUPERPLAYER_FLUTTER_IOS_CLASSES_COMMON_FTXPLAYERCONSTANTS_H_

#import "FTXLiteAVSDKHeader.h"

// 点播高级套餐 Feature
#define TUI_FEATURE_PLAYER_PREMIUM     (0b10000000)
// 点播企业套餐 Feature
#define TUI_FEATURE_PLAYER_ENTERPRISE  (0b100000000)


// pip status
typedef NS_ENUM(NSInteger, FTX_LIVE_PIP_ERROR) {
    /// 无错误
    FTX_VOD_PLAYER_PIP_ERROR_TYPE_NONE = TX_VOD_PLAYER_PIP_ERROR_TYPE_NONE,

    /// 设备或系统版本不支持（iPad iOS9+ 才支持PIP）
    FTX_VOD_PLAYER_PIP_ERROR_TYPE_DEVICE_NOT_SUPPORT = TX_VOD_PLAYER_PIP_ERROR_TYPE_DEVICE_NOT_SUPPORT,
    
    /// 播放器不支持
    FTX_VOD_PLAYER_PIP_ERROR_TYPE_PLAYER_NOT_SUPPORT = TX_VOD_PLAYER_PIP_ERROR_TYPE_PLAYER_NOT_SUPPORT,

    /// 视频不支持
    FTX_VOD_PLAYER_PIP_ERROR_TYPE_VIDEO_NOT_SUPPORT = TX_VOD_PLAYER_PIP_ERROR_TYPE_VIDEO_NOT_SUPPORT,

    /// PIP控制器不可用
    FTX_VOD_PLAYER_PIP_ERROR_TYPE_PIP_IS_NOT_POSSIBLE = TX_VOD_PLAYER_PIP_ERROR_TYPE_PIP_IS_NOT_POSSIBLE,

    /// PIP控制器报错
    FTX_VOD_PLAYER_PIP_ERROR_TYPE_ERROR_FROM_SYSTEM = TX_VOD_PLAYER_PIP_ERROR_TYPE_ERROR_FROM_SYSTEM,

    /// 播放器对象不存在
    FTX_VOD_PLAYER_PIP_ERROR_TYPE_PLAYER_NOT_EXIST = TX_VOD_PLAYER_PIP_ERROR_TYPE_PLAYER_NOT_EXIST,

    /// PIP功能已经运行
    FTX_VOD_PLAYER_PIP_ERROR_TYPE_PIP_IS_RUNNING = TX_VOD_PLAYER_PIP_ERROR_TYPE_PIP_IS_RUNNING,

    /// PIP功能没有启动
    FTX_VOD_PLAYER_PIP_ERROR_TYPE_PIP_NOT_RUNNING = TX_VOD_PLAYER_PIP_ERROR_TYPE_PIP_NOT_RUNNING,

    /// PIP启动超时
    FTX_VOD_PLAYER_PIP_ERROR_TYPE_PIP_START_TIMEOUT = TX_VOD_PLAYER_PIP_ERROR_TYPE_PIP_START_TIMEOUT,

    /// pip 没有 sdk 权限
    FTX_VOD_PLAYER_PIP_ERROR_TYPE_PIP_AUTH_DENIED = 101,
    // 缺乏画中画 bundle 资源
    FTX_VOD_PLAYER_PIP_ERROR_TYPE_PIP_MISS_RESOURCE = 102,
};

/**
 后台画中画播放器的播放状态
 */
typedef NS_ENUM(NSInteger, FTXAVPlayerState) {
    FTXAVPlayerStateIdle = 0,     // 初始状态
    FTXAVPlayerStatePrepared,     // 播放准备完毕
    FTXAVPlayerStatePlaying,      // 播放中
    FTXAVPlayerStatePaused,       // 播放暂停
    FTXAVPlayerStateStopped,      // 播放停止
    FTXAVPlayerStateComplete,     // 播放完毕
    FTXAVPlayerStateError,        // 播放失败
};

#endif  // SUPERPLAYER_FLUTTER_IOS_CLASSES_COMMON_FTXPLAYERCONSTANTS_H_
