import 'package:flutter/services.dart';
import 'package:flutter_test/flutter_test.dart';
import 'package:super_player/super_player.dart';

void main() {
  const MethodChannel channel = MethodChannel('flutter_super_player');

  TestWidgetsFlutterBinding.ensureInitialized();

  setUp(() {
    channel.setMockMethodCallHandler((MethodCall methodCall) async {
      return '42';
    });
  });

  tearDown(() {
    channel.setMockMethodCallHandler(null);
  });

  test('getPlatformVersion', () async {
    expect(await SuperPlayerPlugin.platformVersion, '42');
  });
}
