简体中文| [English](./点播播放器-EN.md)

## SDK 下载

腾讯云视立方 Flutter 超级播放器项目的地址是 [SuperPlayer Flutter](https://github.com/LiteAVSDK/Player_Flutter/tree/main/Flutter)。

## 阅读对象

本文档部分内容为腾讯云专属能力，使用前请开通 [腾讯云](https://cloud.tencent.com/) 相关服务，未注册用户可注册账号 [免费试用](https://cloud.tencent.com/login)。

## 通过本文你可以学会
* 如何集成腾讯云视立方 Flutter 播放器SDK
* 如何使用播放器 SDK 进行点播播放
* 如何使用播放器 SDK 底层能力实现更多功能

## 基础知识
本文主要介绍视频云 SDK 的点播播放功能，在此之前，先了解如下一些基本知识会大有裨益：

- **直播和点播**
  直播（LIVE）的视频源是主播实时推送的。因此，主播停止推送后，播放端的画面也会随即停止，而且由于是实时直播，所以播放器在播直播 URL 的时候是没有进度条的。

点播（VOD）的视频源是云端的一个视频文件，只要未被从云端移除，视频就可以随时播放， 播放中您可以通过进度条控制播放位置，腾讯视频和优酷土豆等视频网站上的视频观看就是典型的点播场景。

- **协议的支持**
  通常使用的点播协议如下，现在比较流行的是 HLS（以“http”打头，以“.m3u8”结尾）的点播地址：
  ![](https://mc.qcloudimg.com/static/img/4b42a00bb7ce2f58f362f35397734177/image.jpg)

## 特别说明
视频云 SDK **不会对播放地址的来源做限制**，即您可以用它来播放腾讯云或非腾讯云的播放地址。但视频云 SDK 中的播放器只支持 FLV 、RTMP 和 HLS（m3u8）三种格式的直播地址，以及 MP4、HLS（m3u8）和 FLV 三种格式的点播地址。

## 共享纹理原理
内部原理上讲，我们了解到flutter提供一种机制，可以将native的纹理共享给flutter来进行渲染，以 iOS 为例，看看官方提供的外接纹理机制究竟是怎样运行的。

![](texture_arch.png)

图中红色块，是我们自己要编写的native代码，黄色是flutter engine的内部代码逻辑。整体流程分为注册纹理，和整体的纹理渲染逻辑。

### 注册纹理

1. 创建一个对象，实现 `FlutterTexture` 协议，该对象用来管理具体的纹理数据
2. 通过 `FlutterTextureRegistry` 来注册第一步的 `FlutterTexture `对象，获取一个flutter纹理id
3. 将该id通过channel机制传递给dart侧，dart侧就能够通过 `Texture` 这个widget来使用纹理了，参数就是id

### 纹理渲染

1. 创建一个对象，实现 `FlutterTexture` 协议，该对象用来管理具体的纹理数据
2. 通过 `FlutterTextureRegistry` 来注册第一步的 `FlutterTexture `对象，获取一个flutter纹理id
3. 将该id通过channel机制传递给dart侧，dart侧就能够通过 `Texture` 这个widget来使用纹理了，参数就是id
4. flutter engine调用 `copyPixelBuffer` 拿到具体的纹理数据，然后交由底层进行gpu渲染


## 集成指引[](id:Guide)

1. `pubspec.yaml`中增加配置。
```yaml
super_player:
  git:
    url: https://github.com/LiteAVSDK/Player_Flutter
    path: Flutter
```

2. 更新依赖包。
```yaml
flutter pub upgrade
```

3. 如果使用Professional版本，则`pubspec.yaml`中配置改为

```yaml
super_player:
  git:
    url: https://github.com/tencentyun/SuperPlayer
    path: Flutter
    ref: Professional
```

4. 添加原生配置。

### Android 配置[](id:Android_config)

在 Android 的`AndroidManifest.xml`中增加如下配置。

```xml
<!--网络权限-->
<uses-permission android:name="android.permission.INTERNET" />
<uses-permission android:name="android.permission.ACCESS_NETWORK_STATE" />
<uses-permission android:name="android.permission.ACCESS_WIFI_STATE" />
<!--点播播放器悬浮窗权限-->
<uses-permission android:name="android.permission.SYSTEM_ALERT_WINDOW" />
<!--存储-->
<uses-permission android:name="android.permission.WRITE_EXTERNAL_STORAGE" />
<uses-permission android:name="android.permission.READ_EXTERNAL_STORAGE" />
```

### iOS 配置[](id:iOS_config)

在 iOS 的`Info.plist`中增加如下配置：
```xml
<key>NSAppTransportSecurity</key>
<dict>
    <key>NSAllowsArbitraryLoads</key>
    <true/>
</dict>
```

如果需要改变项目内依赖的liteAVSDK版本。可在podfile文件中依赖指定版本，例如 TXLiteAVSDK_Player','9.5.29016'，如果不写，则会使用最新版本
```xml
pod 'TXLiteAVSDK_Player'
```

## SDK集成[](id:stepone)

### 步骤1：申请视频播放能力License和集成[](id:step1)

集成播放器前，需要[注册腾讯云账户](https://cloud.tencent.com/login)，注册成功后申请视频播放能力License， 然后通过下面方式集成，建议在应用启动时进行。

如果没有集成license，播放过程中可能会出现异常。

```dart
String licenceURL = ""; // 获取到的 licence url
String licenceKey = ""; // 获取到的 licence key
SuperPlayerPlugin.setGlobalLicense(licenceURL, licenceKey);
```

### 步骤2：创建controller[](id:step2)

```dart
TXVodPlayerController _controller = TXVodPlayerController();
```

### 步骤3：设置监听事件[](id:step3)

```dart
// 监听视频宽高变化，设置合适的宽高比例,也可自行设置宽高比例，视频纹理也会根据比例进行相应拉伸
_controller.onPlayerNetStatusBroadcast.listen((event) async {
  double w = (event["VIDEO_WIDTH"]).toDouble();
  double h = (event["VIDEO_HEIGHT"]).toDouble();

  if (w > 0 && h > 0) {
    setState(() {
      _aspectRatio = 1.0 * w / h;
    });
  }
});
```

### 步骤4：添加布局[](id:step4)
```dart
@override
Widget build(BuildContext context) {
return Container(
  decoration: BoxDecoration(
      image: DecorationImage(
        image: AssetImage("images/ic_new_vod_bg.png"),
        fit: BoxFit.cover,
      )),
  child: Scaffold(
      backgroundColor: Colors.transparent,
      appBar: AppBar(
        backgroundColor: Colors.transparent,
        title: const Text('点播'),
      ),
      body: SafeArea(
          child: Container(
            height: 150,
            color: Colors.black,
            child: Center(
              child: _aspectRatio > 0
                  ? AspectRatio(
                aspectRatio: _aspectRatio,
                child: TXPlayerVideo(controller: _controller),
              ) : Container(),
            ),
          ))));
}
```

### 步骤5：播放器初始化[](id:step5)

```dart
// 初始化播放器，分配共享纹理
await _controller.initialize();
```

### 步骤6：启动播放[](id:step6)
::: 通过url方式
TXVodPlayerController 内部会自动识别播放协议，您只需要将您的播放 URL 传给 startPlay 函数即可。
```dart
// 播放视频资源
String _url =
    "http://1400329073.vod2.myqcloud.com/d62d88a7vodtranscq1400329073/59c68fe75285890800381567412/adp.10.m3u8";
await _controller.startPlay(_url);
```
:::
::: 通过field方式
```dart
TXPlayerAuthParams authParams = TXPlayerAuthParams();
authParams.appId = 1252463788;
authParams.fileId = "4564972819220421305";
await _controller.startPlayWithParams(authParams);
```
在 [媒资管理](https://console.cloud.tencent.com/vod/media) 找到对应的视频文件。在文件名下方可以看到 FileId。

通过 FileId 方式播放，播放器会向后台请求真实的播放地址。如果此时网络异常或 FileId 不存在，则会收到`TXLiveConstants.PLAY_ERR_GET_PLAYINFO_FAIL`事件，反之收到`TXLiveConstants.PLAY_EVT_GET_PLAYINFO_SUCC`表示请求成功。
:::
</dx-tabs>

### 步骤7：结束播放[](id:step7)
结束播放时**记得调用controller的销毁方法**，尤其是在下次 startPlay 之前，否则可能会产生大量的内存泄露以及闪屏问题。
```dart
@override
void dispose() {
  _controller.dispose();
  super.dispose();
}
```


## SDK 接口列表[](id:sdkList)

#### 初始化播放器

**说明**

初始化controller，请求分配共享纹理

**接口**

```dart
await _controller.initialize();
```

#### url播放

**说明**

通过播视频url进行播放

**接口**

```dart
_controller.startPlay(url);
```

**参数说明**

| 参数名 | 类型   | 描述               |
| ------ | ------ | ------------------ |
| url | String | 要播放的视频url |

#### field播放

**说明**

通过视频field进行播放

**接口**

```dart
TXPlayerAuthParams params = TXPlayerAuthParams();
params.appId = 1252463788;
params.fileId = "4564972819220421305";
_controller.startPlayWithParams(params);
```

**参数说明**

| 参数名 | 类型   | 描述               |
| ------ | ------ | ------------------ |
| appId | int | 应用appId。必填 |
| fileId | String | 文件id。必填 |
| timeout | String | 加密链接超时时间戳，转换为16进制小写字符串，腾讯云 CDN 服务器会根据该时间判断该链接是否有效 |
| exper | String | 试看时长，单位：秒 |
| us | String | 唯一标识请求，增加链接唯一性 |
| sign | String | 防盗链签名，参考防盗链产品文档: https://cloud.tencent.com/document/product/266/11243 |
| https | String | 是否用https请求。默认false |

#### 暂停播放

**说明**

暂停当前正在播放的视频

**接口**

```dart
_controller.pause();
```

#### 恢复播放

**说明**

将当前处于暂停状态的视频恢复播放

**接口**

```dart
_controller.resume();
```

#### 停止播放

**说明**

停止当前正在播放的视频

**接口**

```dart
_controller.stop();
```
**参数说明**

| 参数名 | 类型   | 描述               |
| ------ | ------ | ------------------ |
| isNeedClear | bool | 是否清除最后一帧画面 |

#### 设置是否自动播放

**说明**

设置即将播放的视频，在startPlay加载视频地址之后，是否直接自动播放

**接口**

```dart
_controller.setIsAutoPlay(true);
```

**参数说明**

| 参数名 | 类型   | 描述               |
| ------ | ------ | ------------------ |
| isAutoPlay | bool | 是否自动播放 |

#### 播放器是否在播放中

**说明**

当前播放器是否正在播放

**接口**

```dart
_controller.isPlaying();
```

#### 设置静音

**说明**

设置当前播放是否静音

**接口**

```dart
_controller.setMute(true);
```

**参数说明**

| 参数名 | 类型   | 描述               |
| ------ | ------ | ------------------ |
| mute | bool | 是否静音 |

#### 循环播放

**说明**

视频播放完成之后是否循环播放

**接口**

```dart
_controller.setLoop(true);
```

**参数说明**

| 参数名 | 类型   | 描述               |
| ------ | ------ | ------------------ |
| loop | bool | 是否循环播放 |

#### 调整进度(seek)

**说明**

将进度调整到指定位置

**接口**

```dart
_controller.seek(progress);
```

**参数说明**

| 参数名 | 类型   | 描述               |
| ------ | ------ | ------------------ |
| progress | double | 需要调整到的播放时间，单位 秒。|

#### 设置播放速率

**说明**

设置视频播放的速率

**接口**

```dart
_controller.setRate(rate);
```

**参数说明**

| 参数名 | 类型   | 描述               |
| ------ | ------ | ------------------ |
| rate | double | 视频的播放速率。默认1.0 |

#### 获取码率信息

**说明**

获得当前正在播放的视频支持的码率

**接口**

```dart
_controller.getSupportedBitrates();
```

**返回值说明**

| 返回值 | 类型   | 描述               |
| ------ | ------ | ------------------ |
| index | int | 码率序号 |
| width | int | 码率对应视频宽度 |
| height | int | 码率对应视频高度 |
| bitrate | int | 码率值 |

#### 获取设置的码率

**说明**

获得设置过的码率序号

**接口**

```dart
_controller.getBitrateIndex();
```

#### 设置码率

**说明**

通过码率序号，设置当前码率

**接口**

```dart
_controller.setBitrateIndex(index);
```

#### 指定时间开始播放

**说明**

指定播放开始时间

**接口**

```dart
_controller.setStartTime(startTime);
```

#### 设置视频声音大小

**说明**

设置视频的声音大小

**接口**

```dart
_controller.setAudioPlayoutVolume(volume);
```

**参数说明**

| 参数名 | 类型   | 描述               |
| ------ | ------ | ------------------ |
| volume | int | 视频声音大小，范围0~100 |

#### 请求获得音频焦点

**说明**

请求获得音频焦点

**接口**

```dart
_controller.setRequestAudioFocus(focus);
```

#### 配置播放器

**说明**

给播放器进行配置

**接口**

```dart
_controller.setConfig(config);
```

**参数说明**

| 参数名 | 类型   | 描述               |
| ------ | ------ | ------------------ |
| connectRetryCount | int | 播放器重连次数，当SDK与服务器异常断开连接时,SDK会尝试与服务器重连.通过该值设置SDK重连次数 |
| connectRetryInterval | int | 播放器重连间隔，当SDK与服务器异常断开连接时,SDK会尝试与服务器重连.通过该值设置两次重连间隔时间 |
| timeout | int | 播放器连接超时时间 |
| playerType | int | 播放器类型,0 点播，1 直播，2 直播回看 |
| headers | Map | 自定义http headers |
| enableAccurateSeek | bool | 是否精确seek，默认true |
| autoRotate | bool | 播放mp4文件时，若设为true则根据文件中的旋转角度自动旋转。旋转角度可在PLAY_EVT_CHANGE_ROTATION事件中获得。默认true |
| smoothSwitchBitrate | bool | 平滑切换多码率HLS，默认false。设为false时，可提高多码率地址打开速度; 设为true，在IDR对齐时可平滑切换码率 |
| cacheMp4ExtName | String | 缓存mp4文件扩展名,默认mp4 |
| progressInterval | int | 设置进度回调间隔,若不设置，SDK默认间隔0.5秒回调一次,单位毫秒 |
| maxBufferSize | int | 最大播放缓冲大小，单位 MB。此设置会影响playableDuration，设置越大，提前缓存的越多|
| maxPreloadSize | int | 预加载最大缓冲大小，单位：MB|
| firstStartPlayBufferTime | int | 首缓需要加载的数据时长，单位ms，默认值为100ms|
| nextStartPlayBufferTime | int | 缓冲时（缓冲数据不够引起的二次缓冲，或者seek引起的拖动缓冲）最少要缓存多长的数据才能结束缓冲，单位ms，默认值为250ms|
| overlayKey | String | HLS安全加固加解密key|
| overlayIv | String | HLS安全加固加解密Iv|
| extInfoMap | Map | 一些不必周知的特殊配置|
| enableRenderProcess | bool | 是否允许加载后渲染后处理服务,默认开启，开启后超分插件如果存在，默认加载|
| preferredResolution | int | 优先播放的分辨率，preferredResolution = width * height|

#### 配置全局缓存配置

**说明**

配置缓存文件个数和缓存目录

**接口**

```dart
// 设置点播缓存目录。点播MP4、HLS有效
SuperPlayerPlugin.setGlobalMaxCacheSize(size);
// 设置最大缓存文件个数
SuperPlayerPlugin.setGlobalCacheFolderPath(path);
```

#### 获得当前播放时间

**说明**

获得当前播放时间,单位 秒

**接口**

```dart
_controller.getCurrentPlaybackTime();
```

#### 获得当前视频缓存时间

**说明**

获得当前视频已缓存的时间，单位 秒

**接口**

```dart
_controller.getBufferDuration();
```

#### 获得可播放时间

**说明**

获得当前正在播放视频的可播放时间,单位 秒

**接口**

```dart
_controller.getPlayableDuration();
```

#### 获得视频的宽度

**说明**

获得当前正在播放视频的宽度

**接口**

```dart
_controller.getWidth();
```

#### 获得视频的高度

**说明**

获得当前正在播放视频的高度

**接口**

```dart
_controller.getHeight();
```

#### 设置token

**说明**

加密HLS的token。设置此值后，播放器自动在URL中的文件名之前增加voddrm.token

**接口**

```dart
_controller.setToken(token);
```

#### 是否循环播放

**说明**

获得当前播放器是否循环播放的状态

**接口**

```dart
_controller.isLoop();
```

#### 是否循环播放

**说明**

开启/关闭硬解播放，设置后不会立即生效，需要重新播放才可生效

**接口**

```dart
_controller.enableHardwareDecode(enable);
```

#### 销毁controller

**说明**

销毁controller，调用该方法会销毁掉所有通知事件，释放掉播放器

**接口**

```dart
_controller.dispose();
```

## 事件通知

#### 播放事件监听

**说明**

监听播放器播放的各种状态

**代码**

```dart
_controller.onPlayerEventBroadcast.listen((event) async {
  if (event["event"] == TXVodPlayEvent.PLAY_EVT_PLAY_BEGIN || event["event"] == TXVodPlayEvent.PLAY_EVT_RCV_FIRST_I_FRAME) {
    // code ...
  } else if (event["event"] == TXVodPlayEvent.PLAY_EVT_PLAY_PROGRESS) {
   // code ...
  }
});
```

**事件说明**

可参考 [播放事件](https://cloud.tencent.com/document/product/454/7886#.E6.92.AD.E6.94.BE.E4.BA.8B.E4.BB.B6) 中的事件说明

#### 播放器网络事件监听

**说明**

监听播放器网络状态

**代码**

```dart
_controller.onPlayerNetStatusBroadcast.listen((event) async { });
```

**事件说明**

可参考 [网络事件](https://cloud.tencent.com/document/product/454/7886#.E5.AE.9A.E6.97.B6.E8.A7.A6.E5.8F.91.E7.9A.84.E7.8A.B6.E6.80.81.E9.80.9A.E7.9F.A5) 中的事件说明

#### 播放状态监听

**说明**

监听视频播放的状态，封装后的状态变化

**代码**

```dart
_controller.onPlayerState.listen((val) { });
```

**事件说明**

事件通过枚举类TXPlayerState来传递事件

| 状态 | 含义   |
| ------ | ------ |
| paused | 暂停播放 |
| failed | 播放失败 |
| buffering | 缓冲中 |
| playing | 播放中 |
| stopped | 停止播放 |
| disposed | 控件释放了 |

## 进阶功能

### 预加载
在短视频播放场景中，预加载功能对于流畅的观看体验很有帮助：在观看当前视频的同时，在后台加载即将要播放的下一个视频 URL，这样一来，当用户真正切换到下一个视频时，已经不需要从头开始加载了，而是可以做到立刻播放。

这就是视频播放中无缝切换的背后技术支撑，您可以使用 TXVodPlayerController 中的 isAutoPlay 开关来实现这个功能，具体做法如下：

![](https://qcloudimg.tencent-cloud.cn/raw/f43ea6105d9f80c4162241ca0605b8f0.png)

```dart
// 播放视频 A: 如果将 isAutoPlay 设置为 true， 那么 startPlay 调用会立刻开始视频的加载和播放
String url_A = "http://1252463788.vod2.myqcloud.com/xxxxx/v.f10.mp4";
await _controller_A.setIsAutoPlay(isAutoPlay: true);
await _controller_A.play(url_A);

// 在播放视频 A 的同时，预加载视频 B，做法是将 isAutoPlay 设置为 false
String url_B = "http://1252463788.vod2.myqcloud.com/xxxxx/v.f20.mp4";
await _controller_B.setIsAutoPlay(isAutoPlay: false);
await _controller_B.play(url_B);
```

等到视频 A 播放结束，自动（或者用户手动切换到）视频 B 时，调用 resume 函数即可实现立刻播放。
```dart
_controller.onPlayerEventBroadcast.listen((event) async {//订阅状态变化
  if(event["event"] == TXVodPlayEvent.PLAY_EVT_PLAY_END) { //详细请查看iOS或者安卓原生SDK状态码
    await _controller_A.stop();
    await _controller_B.resume();
  }
});
```

## 进度展示

点播进度分为两个指标：**加载进度**和**播放进度**，SDK 目前是以事件通知的方式将这两个进度实时通知出来的。

![](https://mc.qcloudimg.com/static/img/6ac5e2fe87e642e6c2e6342d72464f4a/image.png)

```dart
_controller.onPlayerEventBroadcast.listen((event) async {
  if(event["event"] == TXVodPlayEvent.PLAY_EVT_PLAY_PROGRESS) {// 更多详细请查看iOS或者安卓原生SDK状态码
    // 可播放时长，即加载进度, 单位是毫秒
    double playableDuration = event[TXVodPlayEvent.EVT_PLAYABLE_DURATION_MS].toDouble();
    // 播放进度, 单位是秒
    int progress = event[TXVodPlayEvent.EVT_PLAY_PROGRESS].toInt();
    // 视频总长, 单位是秒
    int duration = event[TXVodPlayEvent.EVT_PLAY_DURATION].toInt();
  }
});
```













