part of demo_super_player_lib;

/// superplayer's bridge between widget and controller
class _SuperPlayerObserver {
  Function onPlayPrepare;
  Function(String name) onPlayBegin;
  Function onPlayPause;
  Function onPlayStop;
  Function onPlayLoading;
  Function(int current, int duration) onPlayProgress;
  Function(double position) onSeek;
  Function(bool success, SuperPlayerType playerType, VideoQuality quality) onSwitchStreamStart;
  Function(bool success, SuperPlayerType playerType, VideoQuality quality) onSwitchStreamEnd;
  Function(int code, String msg) onError;
  Function(SuperPlayerType playerType) onPlayerTypeChange;
  Function(TXLivePlayerController controller, String url) onPlayTimeShiftLive;
  Function(List<VideoQuality>? qualityList, VideoQuality? defaultQuality) onVideoQualityListChange;
  Function(PlayImageSpriteInfo? info, List<PlayKeyFrameDescInfo>? list) onVideoImageSpriteAndKeyFrameChanged;
  Function onRcvFirstIframe;
  Function onSysBackPress;
  Function onNewVideoPlay;
  Function onDispose;

  _SuperPlayerObserver(
      this.onNewVideoPlay,
      this.onPlayPrepare,
      this.onPlayBegin,
      this.onPlayPause,
      this.onPlayStop,
      this.onRcvFirstIframe,
      this.onPlayLoading,
      this.onPlayProgress,
      this.onSeek,
      this.onSwitchStreamStart,
      /// only support live
      this.onSwitchStreamEnd,
      this.onError,
      this.onPlayerTypeChange,
      /// only support live
      this.onPlayTimeShiftLive,
      this.onVideoQualityListChange,
      this.onVideoImageSpriteAndKeyFrameChanged,
      this.onSysBackPress,
      this.onDispose);
}
