// // Copyright (c) 2022 Tencent. All rights reserved.
// Autogenerated from Pigeon (v9.0.7), do not edit directly.
// See also: https://pub.dev/packages/pigeon

#import "FtxMessages.h"
#import <Flutter/Flutter.h>

#if !__has_feature(objc_arc)
#error File requires ARC to be enabled.
#endif

static NSArray *wrapResult(id result, FlutterError *error) {
  if (error) {
    return @[
      error.code ?: [NSNull null], error.message ?: [NSNull null], error.details ?: [NSNull null]
    ];
  }
  return @[ result ?: [NSNull null] ];
}
static id GetNullableObjectAtIndex(NSArray *array, NSInteger key) {
  id result = array[key];
  return (result == [NSNull null]) ? nil : result;
}

@interface PlayerMsg ()
+ (PlayerMsg *)fromList:(NSArray *)list;
+ (nullable PlayerMsg *)nullableFromList:(NSArray *)list;
- (NSArray *)toList;
@end

@interface LicenseMsg ()
+ (LicenseMsg *)fromList:(NSArray *)list;
+ (nullable LicenseMsg *)nullableFromList:(NSArray *)list;
- (NSArray *)toList;
@end

@interface TXPlayInfoParamsPlayerMsg ()
+ (TXPlayInfoParamsPlayerMsg *)fromList:(NSArray *)list;
+ (nullable TXPlayInfoParamsPlayerMsg *)nullableFromList:(NSArray *)list;
- (NSArray *)toList;
@end

@interface PipParamsPlayerMsg ()
+ (PipParamsPlayerMsg *)fromList:(NSArray *)list;
+ (nullable PipParamsPlayerMsg *)nullableFromList:(NSArray *)list;
- (NSArray *)toList;
@end

@interface StringListPlayerMsg ()
+ (StringListPlayerMsg *)fromList:(NSArray *)list;
+ (nullable StringListPlayerMsg *)nullableFromList:(NSArray *)list;
- (NSArray *)toList;
@end

@interface BoolPlayerMsg ()
+ (BoolPlayerMsg *)fromList:(NSArray *)list;
+ (nullable BoolPlayerMsg *)nullableFromList:(NSArray *)list;
- (NSArray *)toList;
@end

@interface StringIntPlayerMsg ()
+ (StringIntPlayerMsg *)fromList:(NSArray *)list;
+ (nullable StringIntPlayerMsg *)nullableFromList:(NSArray *)list;
- (NSArray *)toList;
@end

@interface StringPlayerMsg ()
+ (StringPlayerMsg *)fromList:(NSArray *)list;
+ (nullable StringPlayerMsg *)nullableFromList:(NSArray *)list;
- (NSArray *)toList;
@end

@interface DoublePlayerMsg ()
+ (DoublePlayerMsg *)fromList:(NSArray *)list;
+ (nullable DoublePlayerMsg *)nullableFromList:(NSArray *)list;
- (NSArray *)toList;
@end

@interface IntPlayerMsg ()
+ (IntPlayerMsg *)fromList:(NSArray *)list;
+ (nullable IntPlayerMsg *)nullableFromList:(NSArray *)list;
- (NSArray *)toList;
@end

@interface FTXVodPlayConfigPlayerMsg ()
+ (FTXVodPlayConfigPlayerMsg *)fromList:(NSArray *)list;
+ (nullable FTXVodPlayConfigPlayerMsg *)nullableFromList:(NSArray *)list;
- (NSArray *)toList;
@end

@interface FTXLivePlayConfigPlayerMsg ()
+ (FTXLivePlayConfigPlayerMsg *)fromList:(NSArray *)list;
+ (nullable FTXLivePlayConfigPlayerMsg *)nullableFromList:(NSArray *)list;
- (NSArray *)toList;
@end

@interface TXVodDownloadMediaMsg ()
+ (TXVodDownloadMediaMsg *)fromList:(NSArray *)list;
+ (nullable TXVodDownloadMediaMsg *)nullableFromList:(NSArray *)list;
- (NSArray *)toList;
@end

@interface TXDownloadListMsg ()
+ (TXDownloadListMsg *)fromList:(NSArray *)list;
+ (nullable TXDownloadListMsg *)nullableFromList:(NSArray *)list;
- (NSArray *)toList;
@end

@interface UInt8ListMsg ()
+ (UInt8ListMsg *)fromList:(NSArray *)list;
+ (nullable UInt8ListMsg *)nullableFromList:(NSArray *)list;
- (NSArray *)toList;
@end

@interface ListMsg ()
+ (ListMsg *)fromList:(NSArray *)list;
+ (nullable ListMsg *)nullableFromList:(NSArray *)list;
- (NSArray *)toList;
@end

@interface BoolMsg ()
+ (BoolMsg *)fromList:(NSArray *)list;
+ (nullable BoolMsg *)nullableFromList:(NSArray *)list;
- (NSArray *)toList;
@end

@interface IntMsg ()
+ (IntMsg *)fromList:(NSArray *)list;
+ (nullable IntMsg *)nullableFromList:(NSArray *)list;
- (NSArray *)toList;
@end

@interface StringMsg ()
+ (StringMsg *)fromList:(NSArray *)list;
+ (nullable StringMsg *)nullableFromList:(NSArray *)list;
- (NSArray *)toList;
@end

@interface DoubleMsg ()
+ (DoubleMsg *)fromList:(NSArray *)list;
+ (nullable DoubleMsg *)nullableFromList:(NSArray *)list;
- (NSArray *)toList;
@end

@interface PreLoadMsg ()
+ (PreLoadMsg *)fromList:(NSArray *)list;
+ (nullable PreLoadMsg *)nullableFromList:(NSArray *)list;
- (NSArray *)toList;
@end

@interface MapMsg ()
+ (MapMsg *)fromList:(NSArray *)list;
+ (nullable MapMsg *)nullableFromList:(NSArray *)list;
- (NSArray *)toList;
@end

@implementation PlayerMsg
+ (instancetype)makeWithPlayerId:(nullable NSNumber *)playerId {
  PlayerMsg* pigeonResult = [[PlayerMsg alloc] init];
  pigeonResult.playerId = playerId;
  return pigeonResult;
}
+ (PlayerMsg *)fromList:(NSArray *)list {
  PlayerMsg *pigeonResult = [[PlayerMsg alloc] init];
  pigeonResult.playerId = GetNullableObjectAtIndex(list, 0);
  return pigeonResult;
}
+ (nullable PlayerMsg *)nullableFromList:(NSArray *)list {
  return (list) ? [PlayerMsg fromList:list] : nil;
}
- (NSArray *)toList {
  return @[
    (self.playerId ?: [NSNull null]),
  ];
}
@end

@implementation LicenseMsg
+ (instancetype)makeWithLicenseUrl:(nullable NSString *)licenseUrl
    licenseKey:(nullable NSString *)licenseKey {
  LicenseMsg* pigeonResult = [[LicenseMsg alloc] init];
  pigeonResult.licenseUrl = licenseUrl;
  pigeonResult.licenseKey = licenseKey;
  return pigeonResult;
}
+ (LicenseMsg *)fromList:(NSArray *)list {
  LicenseMsg *pigeonResult = [[LicenseMsg alloc] init];
  pigeonResult.licenseUrl = GetNullableObjectAtIndex(list, 0);
  pigeonResult.licenseKey = GetNullableObjectAtIndex(list, 1);
  return pigeonResult;
}
+ (nullable LicenseMsg *)nullableFromList:(NSArray *)list {
  return (list) ? [LicenseMsg fromList:list] : nil;
}
- (NSArray *)toList {
  return @[
    (self.licenseUrl ?: [NSNull null]),
    (self.licenseKey ?: [NSNull null]),
  ];
}
@end

@implementation TXPlayInfoParamsPlayerMsg
+ (instancetype)makeWithPlayerId:(nullable NSNumber *)playerId
    appId:(nullable NSNumber *)appId
    fileId:(nullable NSString *)fileId
    psign:(nullable NSString *)psign {
  TXPlayInfoParamsPlayerMsg* pigeonResult = [[TXPlayInfoParamsPlayerMsg alloc] init];
  pigeonResult.playerId = playerId;
  pigeonResult.appId = appId;
  pigeonResult.fileId = fileId;
  pigeonResult.psign = psign;
  return pigeonResult;
}
+ (TXPlayInfoParamsPlayerMsg *)fromList:(NSArray *)list {
  TXPlayInfoParamsPlayerMsg *pigeonResult = [[TXPlayInfoParamsPlayerMsg alloc] init];
  pigeonResult.playerId = GetNullableObjectAtIndex(list, 0);
  pigeonResult.appId = GetNullableObjectAtIndex(list, 1);
  pigeonResult.fileId = GetNullableObjectAtIndex(list, 2);
  pigeonResult.psign = GetNullableObjectAtIndex(list, 3);
  return pigeonResult;
}
+ (nullable TXPlayInfoParamsPlayerMsg *)nullableFromList:(NSArray *)list {
  return (list) ? [TXPlayInfoParamsPlayerMsg fromList:list] : nil;
}
- (NSArray *)toList {
  return @[
    (self.playerId ?: [NSNull null]),
    (self.appId ?: [NSNull null]),
    (self.fileId ?: [NSNull null]),
    (self.psign ?: [NSNull null]),
  ];
}
@end

@implementation PipParamsPlayerMsg
+ (instancetype)makeWithPlayerId:(nullable NSNumber *)playerId
    backIconForAndroid:(nullable NSString *)backIconForAndroid
    playIconForAndroid:(nullable NSString *)playIconForAndroid
    pauseIconForAndroid:(nullable NSString *)pauseIconForAndroid
    forwardIconForAndroid:(nullable NSString *)forwardIconForAndroid {
  PipParamsPlayerMsg* pigeonResult = [[PipParamsPlayerMsg alloc] init];
  pigeonResult.playerId = playerId;
  pigeonResult.backIconForAndroid = backIconForAndroid;
  pigeonResult.playIconForAndroid = playIconForAndroid;
  pigeonResult.pauseIconForAndroid = pauseIconForAndroid;
  pigeonResult.forwardIconForAndroid = forwardIconForAndroid;
  return pigeonResult;
}
+ (PipParamsPlayerMsg *)fromList:(NSArray *)list {
  PipParamsPlayerMsg *pigeonResult = [[PipParamsPlayerMsg alloc] init];
  pigeonResult.playerId = GetNullableObjectAtIndex(list, 0);
  pigeonResult.backIconForAndroid = GetNullableObjectAtIndex(list, 1);
  pigeonResult.playIconForAndroid = GetNullableObjectAtIndex(list, 2);
  pigeonResult.pauseIconForAndroid = GetNullableObjectAtIndex(list, 3);
  pigeonResult.forwardIconForAndroid = GetNullableObjectAtIndex(list, 4);
  return pigeonResult;
}
+ (nullable PipParamsPlayerMsg *)nullableFromList:(NSArray *)list {
  return (list) ? [PipParamsPlayerMsg fromList:list] : nil;
}
- (NSArray *)toList {
  return @[
    (self.playerId ?: [NSNull null]),
    (self.backIconForAndroid ?: [NSNull null]),
    (self.playIconForAndroid ?: [NSNull null]),
    (self.pauseIconForAndroid ?: [NSNull null]),
    (self.forwardIconForAndroid ?: [NSNull null]),
  ];
}
@end

@implementation StringListPlayerMsg
+ (instancetype)makeWithPlayerId:(nullable NSNumber *)playerId
    vvtUrl:(nullable NSString *)vvtUrl
    imageUrls:(nullable NSArray<NSString *> *)imageUrls {
  StringListPlayerMsg* pigeonResult = [[StringListPlayerMsg alloc] init];
  pigeonResult.playerId = playerId;
  pigeonResult.vvtUrl = vvtUrl;
  pigeonResult.imageUrls = imageUrls;
  return pigeonResult;
}
+ (StringListPlayerMsg *)fromList:(NSArray *)list {
  StringListPlayerMsg *pigeonResult = [[StringListPlayerMsg alloc] init];
  pigeonResult.playerId = GetNullableObjectAtIndex(list, 0);
  pigeonResult.vvtUrl = GetNullableObjectAtIndex(list, 1);
  pigeonResult.imageUrls = GetNullableObjectAtIndex(list, 2);
  return pigeonResult;
}
+ (nullable StringListPlayerMsg *)nullableFromList:(NSArray *)list {
  return (list) ? [StringListPlayerMsg fromList:list] : nil;
}
- (NSArray *)toList {
  return @[
    (self.playerId ?: [NSNull null]),
    (self.vvtUrl ?: [NSNull null]),
    (self.imageUrls ?: [NSNull null]),
  ];
}
@end

@implementation BoolPlayerMsg
+ (instancetype)makeWithPlayerId:(nullable NSNumber *)playerId
    value:(nullable NSNumber *)value {
  BoolPlayerMsg* pigeonResult = [[BoolPlayerMsg alloc] init];
  pigeonResult.playerId = playerId;
  pigeonResult.value = value;
  return pigeonResult;
}
+ (BoolPlayerMsg *)fromList:(NSArray *)list {
  BoolPlayerMsg *pigeonResult = [[BoolPlayerMsg alloc] init];
  pigeonResult.playerId = GetNullableObjectAtIndex(list, 0);
  pigeonResult.value = GetNullableObjectAtIndex(list, 1);
  return pigeonResult;
}
+ (nullable BoolPlayerMsg *)nullableFromList:(NSArray *)list {
  return (list) ? [BoolPlayerMsg fromList:list] : nil;
}
- (NSArray *)toList {
  return @[
    (self.playerId ?: [NSNull null]),
    (self.value ?: [NSNull null]),
  ];
}
@end

@implementation StringIntPlayerMsg
+ (instancetype)makeWithPlayerId:(nullable NSNumber *)playerId
    strValue:(nullable NSString *)strValue
    intValue:(nullable NSNumber *)intValue {
  StringIntPlayerMsg* pigeonResult = [[StringIntPlayerMsg alloc] init];
  pigeonResult.playerId = playerId;
  pigeonResult.strValue = strValue;
  pigeonResult.intValue = intValue;
  return pigeonResult;
}
+ (StringIntPlayerMsg *)fromList:(NSArray *)list {
  StringIntPlayerMsg *pigeonResult = [[StringIntPlayerMsg alloc] init];
  pigeonResult.playerId = GetNullableObjectAtIndex(list, 0);
  pigeonResult.strValue = GetNullableObjectAtIndex(list, 1);
  pigeonResult.intValue = GetNullableObjectAtIndex(list, 2);
  return pigeonResult;
}
+ (nullable StringIntPlayerMsg *)nullableFromList:(NSArray *)list {
  return (list) ? [StringIntPlayerMsg fromList:list] : nil;
}
- (NSArray *)toList {
  return @[
    (self.playerId ?: [NSNull null]),
    (self.strValue ?: [NSNull null]),
    (self.intValue ?: [NSNull null]),
  ];
}
@end

@implementation StringPlayerMsg
+ (instancetype)makeWithPlayerId:(nullable NSNumber *)playerId
    value:(nullable NSString *)value {
  StringPlayerMsg* pigeonResult = [[StringPlayerMsg alloc] init];
  pigeonResult.playerId = playerId;
  pigeonResult.value = value;
  return pigeonResult;
}
+ (StringPlayerMsg *)fromList:(NSArray *)list {
  StringPlayerMsg *pigeonResult = [[StringPlayerMsg alloc] init];
  pigeonResult.playerId = GetNullableObjectAtIndex(list, 0);
  pigeonResult.value = GetNullableObjectAtIndex(list, 1);
  return pigeonResult;
}
+ (nullable StringPlayerMsg *)nullableFromList:(NSArray *)list {
  return (list) ? [StringPlayerMsg fromList:list] : nil;
}
- (NSArray *)toList {
  return @[
    (self.playerId ?: [NSNull null]),
    (self.value ?: [NSNull null]),
  ];
}
@end

@implementation DoublePlayerMsg
+ (instancetype)makeWithPlayerId:(nullable NSNumber *)playerId
    value:(nullable NSNumber *)value {
  DoublePlayerMsg* pigeonResult = [[DoublePlayerMsg alloc] init];
  pigeonResult.playerId = playerId;
  pigeonResult.value = value;
  return pigeonResult;
}
+ (DoublePlayerMsg *)fromList:(NSArray *)list {
  DoublePlayerMsg *pigeonResult = [[DoublePlayerMsg alloc] init];
  pigeonResult.playerId = GetNullableObjectAtIndex(list, 0);
  pigeonResult.value = GetNullableObjectAtIndex(list, 1);
  return pigeonResult;
}
+ (nullable DoublePlayerMsg *)nullableFromList:(NSArray *)list {
  return (list) ? [DoublePlayerMsg fromList:list] : nil;
}
- (NSArray *)toList {
  return @[
    (self.playerId ?: [NSNull null]),
    (self.value ?: [NSNull null]),
  ];
}
@end

@implementation IntPlayerMsg
+ (instancetype)makeWithPlayerId:(nullable NSNumber *)playerId
    value:(nullable NSNumber *)value {
  IntPlayerMsg* pigeonResult = [[IntPlayerMsg alloc] init];
  pigeonResult.playerId = playerId;
  pigeonResult.value = value;
  return pigeonResult;
}
+ (IntPlayerMsg *)fromList:(NSArray *)list {
  IntPlayerMsg *pigeonResult = [[IntPlayerMsg alloc] init];
  pigeonResult.playerId = GetNullableObjectAtIndex(list, 0);
  pigeonResult.value = GetNullableObjectAtIndex(list, 1);
  return pigeonResult;
}
+ (nullable IntPlayerMsg *)nullableFromList:(NSArray *)list {
  return (list) ? [IntPlayerMsg fromList:list] : nil;
}
- (NSArray *)toList {
  return @[
    (self.playerId ?: [NSNull null]),
    (self.value ?: [NSNull null]),
  ];
}
@end

@implementation FTXVodPlayConfigPlayerMsg
+ (instancetype)makeWithPlayerId:(nullable NSNumber *)playerId
    connectRetryCount:(nullable NSNumber *)connectRetryCount
    connectRetryInterval:(nullable NSNumber *)connectRetryInterval
    timeout:(nullable NSNumber *)timeout
    playerType:(nullable NSNumber *)playerType
    headers:(nullable NSDictionary<NSString *, NSString *> *)headers
    enableAccurateSeek:(nullable NSNumber *)enableAccurateSeek
    autoRotate:(nullable NSNumber *)autoRotate
    smoothSwitchBitrate:(nullable NSNumber *)smoothSwitchBitrate
    cacheMp4ExtName:(nullable NSString *)cacheMp4ExtName
    progressInterval:(nullable NSNumber *)progressInterval
    maxBufferSize:(nullable NSNumber *)maxBufferSize
    maxPreloadSize:(nullable NSNumber *)maxPreloadSize
    firstStartPlayBufferTime:(nullable NSNumber *)firstStartPlayBufferTime
    nextStartPlayBufferTime:(nullable NSNumber *)nextStartPlayBufferTime
    overlayKey:(nullable NSString *)overlayKey
    overlayIv:(nullable NSString *)overlayIv
    extInfoMap:(nullable NSDictionary<NSString *, id> *)extInfoMap
    enableRenderProcess:(nullable NSNumber *)enableRenderProcess
    preferredResolution:(nullable NSNumber *)preferredResolution {
  FTXVodPlayConfigPlayerMsg* pigeonResult = [[FTXVodPlayConfigPlayerMsg alloc] init];
  pigeonResult.playerId = playerId;
  pigeonResult.connectRetryCount = connectRetryCount;
  pigeonResult.connectRetryInterval = connectRetryInterval;
  pigeonResult.timeout = timeout;
  pigeonResult.playerType = playerType;
  pigeonResult.headers = headers;
  pigeonResult.enableAccurateSeek = enableAccurateSeek;
  pigeonResult.autoRotate = autoRotate;
  pigeonResult.smoothSwitchBitrate = smoothSwitchBitrate;
  pigeonResult.cacheMp4ExtName = cacheMp4ExtName;
  pigeonResult.progressInterval = progressInterval;
  pigeonResult.maxBufferSize = maxBufferSize;
  pigeonResult.maxPreloadSize = maxPreloadSize;
  pigeonResult.firstStartPlayBufferTime = firstStartPlayBufferTime;
  pigeonResult.nextStartPlayBufferTime = nextStartPlayBufferTime;
  pigeonResult.overlayKey = overlayKey;
  pigeonResult.overlayIv = overlayIv;
  pigeonResult.extInfoMap = extInfoMap;
  pigeonResult.enableRenderProcess = enableRenderProcess;
  pigeonResult.preferredResolution = preferredResolution;
  return pigeonResult;
}
+ (FTXVodPlayConfigPlayerMsg *)fromList:(NSArray *)list {
  FTXVodPlayConfigPlayerMsg *pigeonResult = [[FTXVodPlayConfigPlayerMsg alloc] init];
  pigeonResult.playerId = GetNullableObjectAtIndex(list, 0);
  pigeonResult.connectRetryCount = GetNullableObjectAtIndex(list, 1);
  pigeonResult.connectRetryInterval = GetNullableObjectAtIndex(list, 2);
  pigeonResult.timeout = GetNullableObjectAtIndex(list, 3);
  pigeonResult.playerType = GetNullableObjectAtIndex(list, 4);
  pigeonResult.headers = GetNullableObjectAtIndex(list, 5);
  pigeonResult.enableAccurateSeek = GetNullableObjectAtIndex(list, 6);
  pigeonResult.autoRotate = GetNullableObjectAtIndex(list, 7);
  pigeonResult.smoothSwitchBitrate = GetNullableObjectAtIndex(list, 8);
  pigeonResult.cacheMp4ExtName = GetNullableObjectAtIndex(list, 9);
  pigeonResult.progressInterval = GetNullableObjectAtIndex(list, 10);
  pigeonResult.maxBufferSize = GetNullableObjectAtIndex(list, 11);
  pigeonResult.maxPreloadSize = GetNullableObjectAtIndex(list, 12);
  pigeonResult.firstStartPlayBufferTime = GetNullableObjectAtIndex(list, 13);
  pigeonResult.nextStartPlayBufferTime = GetNullableObjectAtIndex(list, 14);
  pigeonResult.overlayKey = GetNullableObjectAtIndex(list, 15);
  pigeonResult.overlayIv = GetNullableObjectAtIndex(list, 16);
  pigeonResult.extInfoMap = GetNullableObjectAtIndex(list, 17);
  pigeonResult.enableRenderProcess = GetNullableObjectAtIndex(list, 18);
  pigeonResult.preferredResolution = GetNullableObjectAtIndex(list, 19);
  return pigeonResult;
}
+ (nullable FTXVodPlayConfigPlayerMsg *)nullableFromList:(NSArray *)list {
  return (list) ? [FTXVodPlayConfigPlayerMsg fromList:list] : nil;
}
- (NSArray *)toList {
  return @[
    (self.playerId ?: [NSNull null]),
    (self.connectRetryCount ?: [NSNull null]),
    (self.connectRetryInterval ?: [NSNull null]),
    (self.timeout ?: [NSNull null]),
    (self.playerType ?: [NSNull null]),
    (self.headers ?: [NSNull null]),
    (self.enableAccurateSeek ?: [NSNull null]),
    (self.autoRotate ?: [NSNull null]),
    (self.smoothSwitchBitrate ?: [NSNull null]),
    (self.cacheMp4ExtName ?: [NSNull null]),
    (self.progressInterval ?: [NSNull null]),
    (self.maxBufferSize ?: [NSNull null]),
    (self.maxPreloadSize ?: [NSNull null]),
    (self.firstStartPlayBufferTime ?: [NSNull null]),
    (self.nextStartPlayBufferTime ?: [NSNull null]),
    (self.overlayKey ?: [NSNull null]),
    (self.overlayIv ?: [NSNull null]),
    (self.extInfoMap ?: [NSNull null]),
    (self.enableRenderProcess ?: [NSNull null]),
    (self.preferredResolution ?: [NSNull null]),
  ];
}
@end

@implementation FTXLivePlayConfigPlayerMsg
+ (instancetype)makeWithPlayerId:(nullable NSNumber *)playerId
    cacheTime:(nullable NSNumber *)cacheTime
    maxAutoAdjustCacheTime:(nullable NSNumber *)maxAutoAdjustCacheTime
    minAutoAdjustCacheTime:(nullable NSNumber *)minAutoAdjustCacheTime
    videoBlockThreshold:(nullable NSNumber *)videoBlockThreshold
    connectRetryCount:(nullable NSNumber *)connectRetryCount
    connectRetryInterval:(nullable NSNumber *)connectRetryInterval
    autoAdjustCacheTime:(nullable NSNumber *)autoAdjustCacheTime
    enableAec:(nullable NSNumber *)enableAec
    enableMessage:(nullable NSNumber *)enableMessage
    enableMetaData:(nullable NSNumber *)enableMetaData
    flvSessionKey:(nullable NSString *)flvSessionKey {
  FTXLivePlayConfigPlayerMsg* pigeonResult = [[FTXLivePlayConfigPlayerMsg alloc] init];
  pigeonResult.playerId = playerId;
  pigeonResult.cacheTime = cacheTime;
  pigeonResult.maxAutoAdjustCacheTime = maxAutoAdjustCacheTime;
  pigeonResult.minAutoAdjustCacheTime = minAutoAdjustCacheTime;
  pigeonResult.videoBlockThreshold = videoBlockThreshold;
  pigeonResult.connectRetryCount = connectRetryCount;
  pigeonResult.connectRetryInterval = connectRetryInterval;
  pigeonResult.autoAdjustCacheTime = autoAdjustCacheTime;
  pigeonResult.enableAec = enableAec;
  pigeonResult.enableMessage = enableMessage;
  pigeonResult.enableMetaData = enableMetaData;
  pigeonResult.flvSessionKey = flvSessionKey;
  return pigeonResult;
}
+ (FTXLivePlayConfigPlayerMsg *)fromList:(NSArray *)list {
  FTXLivePlayConfigPlayerMsg *pigeonResult = [[FTXLivePlayConfigPlayerMsg alloc] init];
  pigeonResult.playerId = GetNullableObjectAtIndex(list, 0);
  pigeonResult.cacheTime = GetNullableObjectAtIndex(list, 1);
  pigeonResult.maxAutoAdjustCacheTime = GetNullableObjectAtIndex(list, 2);
  pigeonResult.minAutoAdjustCacheTime = GetNullableObjectAtIndex(list, 3);
  pigeonResult.videoBlockThreshold = GetNullableObjectAtIndex(list, 4);
  pigeonResult.connectRetryCount = GetNullableObjectAtIndex(list, 5);
  pigeonResult.connectRetryInterval = GetNullableObjectAtIndex(list, 6);
  pigeonResult.autoAdjustCacheTime = GetNullableObjectAtIndex(list, 7);
  pigeonResult.enableAec = GetNullableObjectAtIndex(list, 8);
  pigeonResult.enableMessage = GetNullableObjectAtIndex(list, 9);
  pigeonResult.enableMetaData = GetNullableObjectAtIndex(list, 10);
  pigeonResult.flvSessionKey = GetNullableObjectAtIndex(list, 11);
  return pigeonResult;
}
+ (nullable FTXLivePlayConfigPlayerMsg *)nullableFromList:(NSArray *)list {
  return (list) ? [FTXLivePlayConfigPlayerMsg fromList:list] : nil;
}
- (NSArray *)toList {
  return @[
    (self.playerId ?: [NSNull null]),
    (self.cacheTime ?: [NSNull null]),
    (self.maxAutoAdjustCacheTime ?: [NSNull null]),
    (self.minAutoAdjustCacheTime ?: [NSNull null]),
    (self.videoBlockThreshold ?: [NSNull null]),
    (self.connectRetryCount ?: [NSNull null]),
    (self.connectRetryInterval ?: [NSNull null]),
    (self.autoAdjustCacheTime ?: [NSNull null]),
    (self.enableAec ?: [NSNull null]),
    (self.enableMessage ?: [NSNull null]),
    (self.enableMetaData ?: [NSNull null]),
    (self.flvSessionKey ?: [NSNull null]),
  ];
}
@end

@implementation TXVodDownloadMediaMsg
+ (instancetype)makeWithPlayPath:(nullable NSString *)playPath
    progress:(nullable NSNumber *)progress
    downloadState:(nullable NSNumber *)downloadState
    userName:(nullable NSString *)userName
    duration:(nullable NSNumber *)duration
    playableDuration:(nullable NSNumber *)playableDuration
    size:(nullable NSNumber *)size
    downloadSize:(nullable NSNumber *)downloadSize
    url:(nullable NSString *)url
    appId:(nullable NSNumber *)appId
    fileId:(nullable NSString *)fileId
    pSign:(nullable NSString *)pSign
    quality:(nullable NSNumber *)quality
    token:(nullable NSString *)token
    speed:(nullable NSNumber *)speed
    isResourceBroken:(nullable NSNumber *)isResourceBroken {
  TXVodDownloadMediaMsg* pigeonResult = [[TXVodDownloadMediaMsg alloc] init];
  pigeonResult.playPath = playPath;
  pigeonResult.progress = progress;
  pigeonResult.downloadState = downloadState;
  pigeonResult.userName = userName;
  pigeonResult.duration = duration;
  pigeonResult.playableDuration = playableDuration;
  pigeonResult.size = size;
  pigeonResult.downloadSize = downloadSize;
  pigeonResult.url = url;
  pigeonResult.appId = appId;
  pigeonResult.fileId = fileId;
  pigeonResult.pSign = pSign;
  pigeonResult.quality = quality;
  pigeonResult.token = token;
  pigeonResult.speed = speed;
  pigeonResult.isResourceBroken = isResourceBroken;
  return pigeonResult;
}
+ (TXVodDownloadMediaMsg *)fromList:(NSArray *)list {
  TXVodDownloadMediaMsg *pigeonResult = [[TXVodDownloadMediaMsg alloc] init];
  pigeonResult.playPath = GetNullableObjectAtIndex(list, 0);
  pigeonResult.progress = GetNullableObjectAtIndex(list, 1);
  pigeonResult.downloadState = GetNullableObjectAtIndex(list, 2);
  pigeonResult.userName = GetNullableObjectAtIndex(list, 3);
  pigeonResult.duration = GetNullableObjectAtIndex(list, 4);
  pigeonResult.playableDuration = GetNullableObjectAtIndex(list, 5);
  pigeonResult.size = GetNullableObjectAtIndex(list, 6);
  pigeonResult.downloadSize = GetNullableObjectAtIndex(list, 7);
  pigeonResult.url = GetNullableObjectAtIndex(list, 8);
  pigeonResult.appId = GetNullableObjectAtIndex(list, 9);
  pigeonResult.fileId = GetNullableObjectAtIndex(list, 10);
  pigeonResult.pSign = GetNullableObjectAtIndex(list, 11);
  pigeonResult.quality = GetNullableObjectAtIndex(list, 12);
  pigeonResult.token = GetNullableObjectAtIndex(list, 13);
  pigeonResult.speed = GetNullableObjectAtIndex(list, 14);
  pigeonResult.isResourceBroken = GetNullableObjectAtIndex(list, 15);
  return pigeonResult;
}
+ (nullable TXVodDownloadMediaMsg *)nullableFromList:(NSArray *)list {
  return (list) ? [TXVodDownloadMediaMsg fromList:list] : nil;
}
- (NSArray *)toList {
  return @[
    (self.playPath ?: [NSNull null]),
    (self.progress ?: [NSNull null]),
    (self.downloadState ?: [NSNull null]),
    (self.userName ?: [NSNull null]),
    (self.duration ?: [NSNull null]),
    (self.playableDuration ?: [NSNull null]),
    (self.size ?: [NSNull null]),
    (self.downloadSize ?: [NSNull null]),
    (self.url ?: [NSNull null]),
    (self.appId ?: [NSNull null]),
    (self.fileId ?: [NSNull null]),
    (self.pSign ?: [NSNull null]),
    (self.quality ?: [NSNull null]),
    (self.token ?: [NSNull null]),
    (self.speed ?: [NSNull null]),
    (self.isResourceBroken ?: [NSNull null]),
  ];
}
@end

@implementation TXDownloadListMsg
+ (instancetype)makeWithInfoList:(nullable NSArray<TXVodDownloadMediaMsg *> *)infoList {
  TXDownloadListMsg* pigeonResult = [[TXDownloadListMsg alloc] init];
  pigeonResult.infoList = infoList;
  return pigeonResult;
}
+ (TXDownloadListMsg *)fromList:(NSArray *)list {
  TXDownloadListMsg *pigeonResult = [[TXDownloadListMsg alloc] init];
  pigeonResult.infoList = GetNullableObjectAtIndex(list, 0);
  return pigeonResult;
}
+ (nullable TXDownloadListMsg *)nullableFromList:(NSArray *)list {
  return (list) ? [TXDownloadListMsg fromList:list] : nil;
}
- (NSArray *)toList {
  return @[
    (self.infoList ?: [NSNull null]),
  ];
}
@end

@implementation UInt8ListMsg
+ (instancetype)makeWithValue:(nullable FlutterStandardTypedData *)value {
  UInt8ListMsg* pigeonResult = [[UInt8ListMsg alloc] init];
  pigeonResult.value = value;
  return pigeonResult;
}
+ (UInt8ListMsg *)fromList:(NSArray *)list {
  UInt8ListMsg *pigeonResult = [[UInt8ListMsg alloc] init];
  pigeonResult.value = GetNullableObjectAtIndex(list, 0);
  return pigeonResult;
}
+ (nullable UInt8ListMsg *)nullableFromList:(NSArray *)list {
  return (list) ? [UInt8ListMsg fromList:list] : nil;
}
- (NSArray *)toList {
  return @[
    (self.value ?: [NSNull null]),
  ];
}
@end

@implementation ListMsg
+ (instancetype)makeWithValue:(nullable NSArray *)value {
  ListMsg* pigeonResult = [[ListMsg alloc] init];
  pigeonResult.value = value;
  return pigeonResult;
}
+ (ListMsg *)fromList:(NSArray *)list {
  ListMsg *pigeonResult = [[ListMsg alloc] init];
  pigeonResult.value = GetNullableObjectAtIndex(list, 0);
  return pigeonResult;
}
+ (nullable ListMsg *)nullableFromList:(NSArray *)list {
  return (list) ? [ListMsg fromList:list] : nil;
}
- (NSArray *)toList {
  return @[
    (self.value ?: [NSNull null]),
  ];
}
@end

@implementation BoolMsg
+ (instancetype)makeWithValue:(nullable NSNumber *)value {
  BoolMsg* pigeonResult = [[BoolMsg alloc] init];
  pigeonResult.value = value;
  return pigeonResult;
}
+ (BoolMsg *)fromList:(NSArray *)list {
  BoolMsg *pigeonResult = [[BoolMsg alloc] init];
  pigeonResult.value = GetNullableObjectAtIndex(list, 0);
  return pigeonResult;
}
+ (nullable BoolMsg *)nullableFromList:(NSArray *)list {
  return (list) ? [BoolMsg fromList:list] : nil;
}
- (NSArray *)toList {
  return @[
    (self.value ?: [NSNull null]),
  ];
}
@end

@implementation IntMsg
+ (instancetype)makeWithValue:(nullable NSNumber *)value {
  IntMsg* pigeonResult = [[IntMsg alloc] init];
  pigeonResult.value = value;
  return pigeonResult;
}
+ (IntMsg *)fromList:(NSArray *)list {
  IntMsg *pigeonResult = [[IntMsg alloc] init];
  pigeonResult.value = GetNullableObjectAtIndex(list, 0);
  return pigeonResult;
}
+ (nullable IntMsg *)nullableFromList:(NSArray *)list {
  return (list) ? [IntMsg fromList:list] : nil;
}
- (NSArray *)toList {
  return @[
    (self.value ?: [NSNull null]),
  ];
}
@end

@implementation StringMsg
+ (instancetype)makeWithValue:(nullable NSString *)value {
  StringMsg* pigeonResult = [[StringMsg alloc] init];
  pigeonResult.value = value;
  return pigeonResult;
}
+ (StringMsg *)fromList:(NSArray *)list {
  StringMsg *pigeonResult = [[StringMsg alloc] init];
  pigeonResult.value = GetNullableObjectAtIndex(list, 0);
  return pigeonResult;
}
+ (nullable StringMsg *)nullableFromList:(NSArray *)list {
  return (list) ? [StringMsg fromList:list] : nil;
}
- (NSArray *)toList {
  return @[
    (self.value ?: [NSNull null]),
  ];
}
@end

@implementation DoubleMsg
+ (instancetype)makeWithValue:(nullable NSNumber *)value {
  DoubleMsg* pigeonResult = [[DoubleMsg alloc] init];
  pigeonResult.value = value;
  return pigeonResult;
}
+ (DoubleMsg *)fromList:(NSArray *)list {
  DoubleMsg *pigeonResult = [[DoubleMsg alloc] init];
  pigeonResult.value = GetNullableObjectAtIndex(list, 0);
  return pigeonResult;
}
+ (nullable DoubleMsg *)nullableFromList:(NSArray *)list {
  return (list) ? [DoubleMsg fromList:list] : nil;
}
- (NSArray *)toList {
  return @[
    (self.value ?: [NSNull null]),
  ];
}
@end

@implementation PreLoadMsg
+ (instancetype)makeWithPlayUrl:(nullable NSString *)playUrl
    preloadSizeMB:(nullable NSNumber *)preloadSizeMB
    preferredResolution:(nullable NSNumber *)preferredResolution {
  PreLoadMsg* pigeonResult = [[PreLoadMsg alloc] init];
  pigeonResult.playUrl = playUrl;
  pigeonResult.preloadSizeMB = preloadSizeMB;
  pigeonResult.preferredResolution = preferredResolution;
  return pigeonResult;
}
+ (PreLoadMsg *)fromList:(NSArray *)list {
  PreLoadMsg *pigeonResult = [[PreLoadMsg alloc] init];
  pigeonResult.playUrl = GetNullableObjectAtIndex(list, 0);
  pigeonResult.preloadSizeMB = GetNullableObjectAtIndex(list, 1);
  pigeonResult.preferredResolution = GetNullableObjectAtIndex(list, 2);
  return pigeonResult;
}
+ (nullable PreLoadMsg *)nullableFromList:(NSArray *)list {
  return (list) ? [PreLoadMsg fromList:list] : nil;
}
- (NSArray *)toList {
  return @[
    (self.playUrl ?: [NSNull null]),
    (self.preloadSizeMB ?: [NSNull null]),
    (self.preferredResolution ?: [NSNull null]),
  ];
}
@end

@implementation MapMsg
+ (instancetype)makeWithMap:(nullable NSDictionary<NSString *, NSString *> *)map {
  MapMsg* pigeonResult = [[MapMsg alloc] init];
  pigeonResult.map = map;
  return pigeonResult;
}
+ (MapMsg *)fromList:(NSArray *)list {
  MapMsg *pigeonResult = [[MapMsg alloc] init];
  pigeonResult.map = GetNullableObjectAtIndex(list, 0);
  return pigeonResult;
}
+ (nullable MapMsg *)nullableFromList:(NSArray *)list {
  return (list) ? [MapMsg fromList:list] : nil;
}
- (NSArray *)toList {
  return @[
    (self.map ?: [NSNull null]),
  ];
}
@end

@interface TXFlutterSuperPlayerPluginAPICodecReader : FlutterStandardReader
@end
@implementation TXFlutterSuperPlayerPluginAPICodecReader
- (nullable id)readValueOfType:(UInt8)type {
  switch (type) {
    case 128: 
      return [BoolMsg fromList:[self readValue]];
    case 129: 
      return [IntMsg fromList:[self readValue]];
    case 130: 
      return [LicenseMsg fromList:[self readValue]];
    case 131: 
      return [PlayerMsg fromList:[self readValue]];
    case 132: 
      return [StringMsg fromList:[self readValue]];
    default:
      return [super readValueOfType:type];
  }
}
@end

@interface TXFlutterSuperPlayerPluginAPICodecWriter : FlutterStandardWriter
@end
@implementation TXFlutterSuperPlayerPluginAPICodecWriter
- (void)writeValue:(id)value {
  if ([value isKindOfClass:[BoolMsg class]]) {
    [self writeByte:128];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[IntMsg class]]) {
    [self writeByte:129];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[LicenseMsg class]]) {
    [self writeByte:130];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[PlayerMsg class]]) {
    [self writeByte:131];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[StringMsg class]]) {
    [self writeByte:132];
    [self writeValue:[value toList]];
  } else {
    [super writeValue:value];
  }
}
@end

@interface TXFlutterSuperPlayerPluginAPICodecReaderWriter : FlutterStandardReaderWriter
@end
@implementation TXFlutterSuperPlayerPluginAPICodecReaderWriter
- (FlutterStandardWriter *)writerWithData:(NSMutableData *)data {
  return [[TXFlutterSuperPlayerPluginAPICodecWriter alloc] initWithData:data];
}
- (FlutterStandardReader *)readerWithData:(NSData *)data {
  return [[TXFlutterSuperPlayerPluginAPICodecReader alloc] initWithData:data];
}
@end

NSObject<FlutterMessageCodec> *TXFlutterSuperPlayerPluginAPIGetCodec() {
  static FlutterStandardMessageCodec *sSharedObject = nil;
  static dispatch_once_t sPred = 0;
  dispatch_once(&sPred, ^{
    TXFlutterSuperPlayerPluginAPICodecReaderWriter *readerWriter = [[TXFlutterSuperPlayerPluginAPICodecReaderWriter alloc] init];
    sSharedObject = [FlutterStandardMessageCodec codecWithReaderWriter:readerWriter];
  });
  return sSharedObject;
}

void TXFlutterSuperPlayerPluginAPISetup(id<FlutterBinaryMessenger> binaryMessenger, NSObject<TXFlutterSuperPlayerPluginAPI> *api) {
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterSuperPlayerPluginAPI.getPlatformVersion"
        binaryMessenger:binaryMessenger
        codec:TXFlutterSuperPlayerPluginAPIGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getPlatformVersionWithError:)], @"TXFlutterSuperPlayerPluginAPI api (%@) doesn't respond to @selector(getPlatformVersionWithError:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        FlutterError *error;
        StringMsg *output = [api getPlatformVersionWithError:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 创建点播播放器
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterSuperPlayerPluginAPI.createVodPlayer"
        binaryMessenger:binaryMessenger
        codec:TXFlutterSuperPlayerPluginAPIGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(createVodPlayerWithError:)], @"TXFlutterSuperPlayerPluginAPI api (%@) doesn't respond to @selector(createVodPlayerWithError:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        FlutterError *error;
        PlayerMsg *output = [api createVodPlayerWithError:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 创建直播播放器
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterSuperPlayerPluginAPI.createLivePlayer"
        binaryMessenger:binaryMessenger
        codec:TXFlutterSuperPlayerPluginAPIGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(createLivePlayerWithError:)], @"TXFlutterSuperPlayerPluginAPI api (%@) doesn't respond to @selector(createLivePlayerWithError:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        FlutterError *error;
        PlayerMsg *output = [api createLivePlayerWithError:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 开关log输出
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterSuperPlayerPluginAPI.setConsoleEnabled"
        binaryMessenger:binaryMessenger
        codec:TXFlutterSuperPlayerPluginAPIGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setConsoleEnabledEnabled:error:)], @"TXFlutterSuperPlayerPluginAPI api (%@) doesn't respond to @selector(setConsoleEnabledEnabled:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        BoolMsg *arg_enabled = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setConsoleEnabledEnabled:arg_enabled error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 释放播放器资源
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterSuperPlayerPluginAPI.releasePlayer"
        binaryMessenger:binaryMessenger
        codec:TXFlutterSuperPlayerPluginAPIGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(releasePlayerPlayerId:error:)], @"TXFlutterSuperPlayerPluginAPI api (%@) doesn't respond to @selector(releasePlayerPlayerId:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        PlayerMsg *arg_playerId = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api releasePlayerPlayerId:arg_playerId error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置播放引擎的最大缓存大小。设置后会根据设定值自动清理Cache目录的文件
  /// @param size 最大缓存大小（单位：MB)
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterSuperPlayerPluginAPI.setGlobalMaxCacheSize"
        binaryMessenger:binaryMessenger
        codec:TXFlutterSuperPlayerPluginAPIGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setGlobalMaxCacheSizeSize:error:)], @"TXFlutterSuperPlayerPluginAPI api (%@) doesn't respond to @selector(setGlobalMaxCacheSizeSize:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        IntMsg *arg_size = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setGlobalMaxCacheSizeSize:arg_size error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 在短视频播放场景中，视频文件的本地缓存是很刚需的一个特性，对于普通用户而言，一个已经看过的视频再次观看时，不应该再消耗一次流量。
  ///  @格式支持：SDK 支持 HLS(m3u8) 和 MP4 两种常见点播格式的缓存功能。
  ///  @开启时机：SDK 并不默认开启缓存功能，对于用户回看率不高的场景，也并不推荐您开启此功能。
  ///  @开启方式：全局生效，在使用播放器开启。开启此功能需要配置两个参数：本地缓存目录及缓存大小。
  ///
  /// 该缓存路径默认设置到app沙盒目录下，postfixPath只需要传递相对缓存目录即可，不需要传递整个绝对路径。
  /// e.g. postfixPath = 'testCache'
  /// Android 平台：视频将会缓存到sdcard的Android/data/your-pkg-name/files/testCache 目录。
  /// iOS 平台：视频将会缓存到沙盒的Documents/testCache 目录。
  /// @param postfixPath 缓存目录
  /// @return true 设置成功 false 设置失败
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterSuperPlayerPluginAPI.setGlobalCacheFolderPath"
        binaryMessenger:binaryMessenger
        codec:TXFlutterSuperPlayerPluginAPIGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setGlobalCacheFolderPathPostfixPath:error:)], @"TXFlutterSuperPlayerPluginAPI api (%@) doesn't respond to @selector(setGlobalCacheFolderPathPostfixPath:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        StringMsg *arg_postfixPath = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        BoolMsg *output = [api setGlobalCacheFolderPathPostfixPath:arg_postfixPath error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置全局license
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterSuperPlayerPluginAPI.setGlobalLicense"
        binaryMessenger:binaryMessenger
        codec:TXFlutterSuperPlayerPluginAPIGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setGlobalLicenseLicenseMsg:error:)], @"TXFlutterSuperPlayerPluginAPI api (%@) doesn't respond to @selector(setGlobalLicenseLicenseMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        LicenseMsg *arg_licenseMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setGlobalLicenseLicenseMsg:arg_licenseMsg error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置log输出级别 [TXLogLevel]
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterSuperPlayerPluginAPI.setLogLevel"
        binaryMessenger:binaryMessenger
        codec:TXFlutterSuperPlayerPluginAPIGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setLogLevelLogLevel:error:)], @"TXFlutterSuperPlayerPluginAPI api (%@) doesn't respond to @selector(setLogLevelLogLevel:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        IntMsg *arg_logLevel = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setLogLevelLogLevel:arg_logLevel error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 获取依赖Native端的 LiteAVSDK 的版本
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterSuperPlayerPluginAPI.getLiteAVSDKVersion"
        binaryMessenger:binaryMessenger
        codec:TXFlutterSuperPlayerPluginAPIGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getLiteAVSDKVersionWithError:)], @"TXFlutterSuperPlayerPluginAPI api (%@) doesn't respond to @selector(getLiteAVSDKVersionWithError:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        FlutterError *error;
        StringMsg *output = [api getLiteAVSDKVersionWithError:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  ///
  /// 设置 liteav SDK 接入的环境。
  /// 腾讯云在全球各地区部署的环境，按照各地区政策法规要求，需要接入不同地区接入点。
  ///
  /// @param envConfig 需要接入的环境，SDK 默认接入的环境是：默认正式环境。
  /// @return 0：成功；其他：错误
  /// @note 目标市场为中国大陆的客户请不要调用此接口，如果目标市场为海外用户，请通过技术支持联系我们，了解 env_config 的配置方法，以确保 App 遵守 GDPR 标准。
  ///
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterSuperPlayerPluginAPI.setGlobalEnv"
        binaryMessenger:binaryMessenger
        codec:TXFlutterSuperPlayerPluginAPIGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setGlobalEnvEnvConfig:error:)], @"TXFlutterSuperPlayerPluginAPI api (%@) doesn't respond to @selector(setGlobalEnvEnvConfig:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        StringMsg *arg_envConfig = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        IntMsg *output = [api setGlobalEnvEnvConfig:arg_envConfig error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  ///
  /// 开始监听设备旋转方向，开启之后，如果设备自动旋转打开，播放器会自动根据当前设备方向来旋转视频方向。
  /// <h1>该接口目前只适用安卓端，IOS端会自动开启该能力</h1>
  /// 在调用该接口前，请务必向用户告知隐私风险。
  /// 如有需要，请确认是否有获取旋转sensor的权限。
  /// @return true : 开启成功
  ///         false : 开启失败，如开启过早，还未等到上下文初始化、获取sensor失败等原因
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterSuperPlayerPluginAPI.startVideoOrientationService"
        binaryMessenger:binaryMessenger
        codec:TXFlutterSuperPlayerPluginAPIGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(startVideoOrientationServiceWithError:)], @"TXFlutterSuperPlayerPluginAPI api (%@) doesn't respond to @selector(startVideoOrientationServiceWithError:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        FlutterError *error;
        BoolMsg *output = [api startVideoOrientationServiceWithError:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
}
@interface TXFlutterNativeAPICodecReader : FlutterStandardReader
@end
@implementation TXFlutterNativeAPICodecReader
- (nullable id)readValueOfType:(UInt8)type {
  switch (type) {
    case 128: 
      return [DoubleMsg fromList:[self readValue]];
    case 129: 
      return [IntMsg fromList:[self readValue]];
    default:
      return [super readValueOfType:type];
  }
}
@end

@interface TXFlutterNativeAPICodecWriter : FlutterStandardWriter
@end
@implementation TXFlutterNativeAPICodecWriter
- (void)writeValue:(id)value {
  if ([value isKindOfClass:[DoubleMsg class]]) {
    [self writeByte:128];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[IntMsg class]]) {
    [self writeByte:129];
    [self writeValue:[value toList]];
  } else {
    [super writeValue:value];
  }
}
@end

@interface TXFlutterNativeAPICodecReaderWriter : FlutterStandardReaderWriter
@end
@implementation TXFlutterNativeAPICodecReaderWriter
- (FlutterStandardWriter *)writerWithData:(NSMutableData *)data {
  return [[TXFlutterNativeAPICodecWriter alloc] initWithData:data];
}
- (FlutterStandardReader *)readerWithData:(NSData *)data {
  return [[TXFlutterNativeAPICodecReader alloc] initWithData:data];
}
@end

NSObject<FlutterMessageCodec> *TXFlutterNativeAPIGetCodec() {
  static FlutterStandardMessageCodec *sSharedObject = nil;
  static dispatch_once_t sPred = 0;
  dispatch_once(&sPred, ^{
    TXFlutterNativeAPICodecReaderWriter *readerWriter = [[TXFlutterNativeAPICodecReaderWriter alloc] init];
    sSharedObject = [FlutterStandardMessageCodec codecWithReaderWriter:readerWriter];
  });
  return sSharedObject;
}

void TXFlutterNativeAPISetup(id<FlutterBinaryMessenger> binaryMessenger, NSObject<TXFlutterNativeAPI> *api) {
  /// 修改当前界面亮度
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterNativeAPI.setBrightness"
        binaryMessenger:binaryMessenger
        codec:TXFlutterNativeAPIGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setBrightnessBrightness:error:)], @"TXFlutterNativeAPI api (%@) doesn't respond to @selector(setBrightnessBrightness:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        DoubleMsg *arg_brightness = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setBrightnessBrightness:arg_brightness error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 恢复当前界面亮度
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterNativeAPI.restorePageBrightness"
        binaryMessenger:binaryMessenger
        codec:TXFlutterNativeAPIGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(restorePageBrightnessWithError:)], @"TXFlutterNativeAPI api (%@) doesn't respond to @selector(restorePageBrightnessWithError:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        FlutterError *error;
        [api restorePageBrightnessWithError:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 获得当前界面亮度 0.0 ~ 1.0
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterNativeAPI.getBrightness"
        binaryMessenger:binaryMessenger
        codec:TXFlutterNativeAPIGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getBrightnessWithError:)], @"TXFlutterNativeAPI api (%@) doesn't respond to @selector(getBrightnessWithError:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        FlutterError *error;
        DoubleMsg *output = [api getBrightnessWithError:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 获取系统界面亮度，IOS系统与界面亮度一致，安卓可能会有差异
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterNativeAPI.getSysBrightness"
        binaryMessenger:binaryMessenger
        codec:TXFlutterNativeAPIGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getSysBrightnessWithError:)], @"TXFlutterNativeAPI api (%@) doesn't respond to @selector(getSysBrightnessWithError:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        FlutterError *error;
        DoubleMsg *output = [api getSysBrightnessWithError:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置当前系统音量，0.0 ~ 1.0
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterNativeAPI.setSystemVolume"
        binaryMessenger:binaryMessenger
        codec:TXFlutterNativeAPIGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setSystemVolumeVolume:error:)], @"TXFlutterNativeAPI api (%@) doesn't respond to @selector(setSystemVolumeVolume:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        DoubleMsg *arg_volume = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setSystemVolumeVolume:arg_volume error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 获得当前系统音量，范围：0.0 ~ 1.0
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterNativeAPI.getSystemVolume"
        binaryMessenger:binaryMessenger
        codec:TXFlutterNativeAPIGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getSystemVolumeWithError:)], @"TXFlutterNativeAPI api (%@) doesn't respond to @selector(getSystemVolumeWithError:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        FlutterError *error;
        DoubleMsg *output = [api getSystemVolumeWithError:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 释放音频焦点，只用于安卓端
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterNativeAPI.abandonAudioFocus"
        binaryMessenger:binaryMessenger
        codec:TXFlutterNativeAPIGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(abandonAudioFocusWithError:)], @"TXFlutterNativeAPI api (%@) doesn't respond to @selector(abandonAudioFocusWithError:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        FlutterError *error;
        [api abandonAudioFocusWithError:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 请求获得音频焦点，只用于安卓端
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterNativeAPI.requestAudioFocus"
        binaryMessenger:binaryMessenger
        codec:TXFlutterNativeAPIGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(requestAudioFocusWithError:)], @"TXFlutterNativeAPI api (%@) doesn't respond to @selector(requestAudioFocusWithError:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        FlutterError *error;
        [api requestAudioFocusWithError:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 当前设备是否支持画中画模式
  /// @return [TXVodPlayEvent]
  ///  0 可开启画中画模式
  ///  -101  android版本过低
  ///  -102  画中画权限关闭/设备不支持画中画
  ///  -103  当前界面已销毁
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterNativeAPI.isDeviceSupportPip"
        binaryMessenger:binaryMessenger
        codec:TXFlutterNativeAPIGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(isDeviceSupportPipWithError:)], @"TXFlutterNativeAPI api (%@) doesn't respond to @selector(isDeviceSupportPipWithError:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        FlutterError *error;
        IntMsg *output = [api isDeviceSupportPipWithError:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
}
@interface TXFlutterVodPlayerApiCodecReader : FlutterStandardReader
@end
@implementation TXFlutterVodPlayerApiCodecReader
- (nullable id)readValueOfType:(UInt8)type {
  switch (type) {
    case 128: 
      return [BoolMsg fromList:[self readValue]];
    case 129: 
      return [BoolPlayerMsg fromList:[self readValue]];
    case 130: 
      return [DoubleMsg fromList:[self readValue]];
    case 131: 
      return [DoublePlayerMsg fromList:[self readValue]];
    case 132: 
      return [FTXVodPlayConfigPlayerMsg fromList:[self readValue]];
    case 133: 
      return [IntMsg fromList:[self readValue]];
    case 134: 
      return [IntPlayerMsg fromList:[self readValue]];
    case 135: 
      return [ListMsg fromList:[self readValue]];
    case 136: 
      return [PipParamsPlayerMsg fromList:[self readValue]];
    case 137: 
      return [PlayerMsg fromList:[self readValue]];
    case 138: 
      return [StringListPlayerMsg fromList:[self readValue]];
    case 139: 
      return [StringPlayerMsg fromList:[self readValue]];
    case 140: 
      return [TXPlayInfoParamsPlayerMsg fromList:[self readValue]];
    case 141: 
      return [UInt8ListMsg fromList:[self readValue]];
    default:
      return [super readValueOfType:type];
  }
}
@end

@interface TXFlutterVodPlayerApiCodecWriter : FlutterStandardWriter
@end
@implementation TXFlutterVodPlayerApiCodecWriter
- (void)writeValue:(id)value {
  if ([value isKindOfClass:[BoolMsg class]]) {
    [self writeByte:128];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[BoolPlayerMsg class]]) {
    [self writeByte:129];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[DoubleMsg class]]) {
    [self writeByte:130];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[DoublePlayerMsg class]]) {
    [self writeByte:131];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[FTXVodPlayConfigPlayerMsg class]]) {
    [self writeByte:132];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[IntMsg class]]) {
    [self writeByte:133];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[IntPlayerMsg class]]) {
    [self writeByte:134];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[ListMsg class]]) {
    [self writeByte:135];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[PipParamsPlayerMsg class]]) {
    [self writeByte:136];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[PlayerMsg class]]) {
    [self writeByte:137];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[StringListPlayerMsg class]]) {
    [self writeByte:138];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[StringPlayerMsg class]]) {
    [self writeByte:139];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[TXPlayInfoParamsPlayerMsg class]]) {
    [self writeByte:140];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[UInt8ListMsg class]]) {
    [self writeByte:141];
    [self writeValue:[value toList]];
  } else {
    [super writeValue:value];
  }
}
@end

@interface TXFlutterVodPlayerApiCodecReaderWriter : FlutterStandardReaderWriter
@end
@implementation TXFlutterVodPlayerApiCodecReaderWriter
- (FlutterStandardWriter *)writerWithData:(NSMutableData *)data {
  return [[TXFlutterVodPlayerApiCodecWriter alloc] initWithData:data];
}
- (FlutterStandardReader *)readerWithData:(NSData *)data {
  return [[TXFlutterVodPlayerApiCodecReader alloc] initWithData:data];
}
@end

NSObject<FlutterMessageCodec> *TXFlutterVodPlayerApiGetCodec() {
  static FlutterStandardMessageCodec *sSharedObject = nil;
  static dispatch_once_t sPred = 0;
  dispatch_once(&sPred, ^{
    TXFlutterVodPlayerApiCodecReaderWriter *readerWriter = [[TXFlutterVodPlayerApiCodecReaderWriter alloc] init];
    sSharedObject = [FlutterStandardMessageCodec codecWithReaderWriter:readerWriter];
  });
  return sSharedObject;
}

void TXFlutterVodPlayerApiSetup(id<FlutterBinaryMessenger> binaryMessenger, NSObject<TXFlutterVodPlayerApi> *api) {
  /// 播放器初始化，创建共享纹理、初始化播放器
  /// @param onlyAudio 是否是纯音频模式
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterVodPlayerApi.initialize"
        binaryMessenger:binaryMessenger
        codec:TXFlutterVodPlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(initializeOnlyAudio:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(initializeOnlyAudio:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        BoolPlayerMsg *arg_onlyAudio = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        IntMsg *output = [api initializeOnlyAudio:arg_onlyAudio error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 通过url开始播放视频
  /// 10.7版本开始，startPlay变更为startVodPlay，需要通过 {@link SuperPlayerPlugin#setGlobalLicense} 设置 Licence 后方可成功播放，
  /// 否则将播放失败（黑屏），全局仅设置一次即可。直播 Licence、短视频 Licence 和视频播放 Licence 均可使用，若您暂未获取上述 Licence ，
  /// 可[快速免费申请测试版 Licence](https://cloud.tencent.com/act/event/License) 以正常播放，正式版 License 需[购买]
  /// (https://cloud.tencent.com/document/product/881/74588#.E8.B4.AD.E4.B9.B0.E5.B9.B6.E6.96.B0.E5.BB.BA.E6.AD.A3.E5.BC.8F.E7.89.88-license)。
  /// @param url : 视频播放地址
  /// return 是否播放成功
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterVodPlayerApi.startVodPlay"
        binaryMessenger:binaryMessenger
        codec:TXFlutterVodPlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(startVodPlayUrl:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(startVodPlayUrl:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        StringPlayerMsg *arg_url = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        BoolMsg *output = [api startVodPlayUrl:arg_url error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 通过fileId播放视频
  /// 10.7版本开始，startPlayWithParams变更为startVodPlayWithParams，需要通过 {@link SuperPlayerPlugin#setGlobalLicense} 设置 Licence 后方可成功播放，
  /// 否则将播放失败（黑屏），全局仅设置一次即可。直播 Licence、短视频 Licence 和视频播放 Licence 均可使用，若您暂未获取上述 Licence ，
  /// 可[快速免费申请测试版 Licence](https://cloud.tencent.com/act/event/License) 以正常播放，正式版 License 需[购买]
  /// (https://cloud.tencent.com/document/product/881/74588#.E8.B4.AD.E4.B9.B0.E5.B9.B6.E6.96.B0.E5.BB.BA.E6.AD.A3.E5.BC.8F.E7.89.88-license)。
  /// @params : 见[TXPlayInfoParams]
  /// return 是否播放成功
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterVodPlayerApi.startVodPlayWithParams"
        binaryMessenger:binaryMessenger
        codec:TXFlutterVodPlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(startVodPlayWithParamsParams:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(startVodPlayWithParamsParams:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        TXPlayInfoParamsPlayerMsg *arg_params = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api startVodPlayWithParamsParams:arg_params error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置是否自动播放
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterVodPlayerApi.setAutoPlay"
        binaryMessenger:binaryMessenger
        codec:TXFlutterVodPlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setAutoPlayIsAutoPlay:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(setAutoPlayIsAutoPlay:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        BoolPlayerMsg *arg_isAutoPlay = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setAutoPlayIsAutoPlay:arg_isAutoPlay error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 停止播放
  /// return 是否停止成功
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterVodPlayerApi.stop"
        binaryMessenger:binaryMessenger
        codec:TXFlutterVodPlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(stopIsNeedClear:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(stopIsNeedClear:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        BoolPlayerMsg *arg_isNeedClear = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        BoolMsg *output = [api stopIsNeedClear:arg_isNeedClear error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 视频是否处于正在播放中
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterVodPlayerApi.isPlaying"
        binaryMessenger:binaryMessenger
        codec:TXFlutterVodPlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(isPlayingPlayerMsg:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(isPlayingPlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        BoolMsg *output = [api isPlayingPlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 视频暂停，必须在播放器开始播放的时候调用
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterVodPlayerApi.pause"
        binaryMessenger:binaryMessenger
        codec:TXFlutterVodPlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(pausePlayerMsg:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(pausePlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api pausePlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 继续播放，在暂停的时候调用
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterVodPlayerApi.resume"
        binaryMessenger:binaryMessenger
        codec:TXFlutterVodPlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(resumePlayerMsg:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(resumePlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api resumePlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置是否静音
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterVodPlayerApi.setMute"
        binaryMessenger:binaryMessenger
        codec:TXFlutterVodPlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setMuteMute:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(setMuteMute:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        BoolPlayerMsg *arg_mute = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setMuteMute:arg_mute error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置是否循环播放
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterVodPlayerApi.setLoop"
        binaryMessenger:binaryMessenger
        codec:TXFlutterVodPlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setLoopLoop:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(setLoopLoop:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        BoolPlayerMsg *arg_loop = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setLoopLoop:arg_loop error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 将视频播放进度定位到指定的进度进行播放
  /// progress 要定位的视频时间，单位 秒
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterVodPlayerApi.seek"
        binaryMessenger:binaryMessenger
        codec:TXFlutterVodPlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(seekProgress:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(seekProgress:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        DoublePlayerMsg *arg_progress = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api seekProgress:arg_progress error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置播放速率，默认速率 1
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterVodPlayerApi.setRate"
        binaryMessenger:binaryMessenger
        codec:TXFlutterVodPlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setRateRate:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(setRateRate:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        DoublePlayerMsg *arg_rate = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setRateRate:arg_rate error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 获得播放视频解析出来的码率信息
  /// return List<Map>
  /// Bitrate键值：index 码率序号，width 码率对应视频宽度，
  ///             height 码率对应视频高度, bitrate 码率值
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterVodPlayerApi.getSupportedBitrate"
        binaryMessenger:binaryMessenger
        codec:TXFlutterVodPlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getSupportedBitratePlayerMsg:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(getSupportedBitratePlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        ListMsg *output = [api getSupportedBitratePlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 获得当前设置的码率序号
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterVodPlayerApi.getBitrateIndex"
        binaryMessenger:binaryMessenger
        codec:TXFlutterVodPlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getBitrateIndexPlayerMsg:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(getBitrateIndexPlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        IntMsg *output = [api getBitrateIndexPlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置码率序号
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterVodPlayerApi.setBitrateIndex"
        binaryMessenger:binaryMessenger
        codec:TXFlutterVodPlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setBitrateIndexIndex:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(setBitrateIndexIndex:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        IntPlayerMsg *arg_index = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setBitrateIndexIndex:arg_index error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置视频播放开始时间，单位 秒
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterVodPlayerApi.setStartTime"
        binaryMessenger:binaryMessenger
        codec:TXFlutterVodPlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setStartTimeStartTime:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(setStartTimeStartTime:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        DoublePlayerMsg *arg_startTime = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setStartTimeStartTime:arg_startTime error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置视频声音 0~100
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterVodPlayerApi.setAudioPlayOutVolume"
        binaryMessenger:binaryMessenger
        codec:TXFlutterVodPlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setAudioPlayOutVolumeVolume:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(setAudioPlayOutVolumeVolume:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        IntPlayerMsg *arg_volume = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setAudioPlayOutVolumeVolume:arg_volume error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 请求获得音频焦点
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterVodPlayerApi.setRequestAudioFocus"
        binaryMessenger:binaryMessenger
        codec:TXFlutterVodPlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setRequestAudioFocusFocus:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(setRequestAudioFocusFocus:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        BoolPlayerMsg *arg_focus = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        BoolMsg *output = [api setRequestAudioFocusFocus:arg_focus error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置播放器配置
  /// config @see [FTXVodPlayConfigPlayerMsg]
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterVodPlayerApi.setConfig"
        binaryMessenger:binaryMessenger
        codec:TXFlutterVodPlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setConfigConfig:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(setConfigConfig:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        FTXVodPlayConfigPlayerMsg *arg_config = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setConfigConfig:arg_config error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 获得当前已经播放的时间，单位 秒
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterVodPlayerApi.getCurrentPlaybackTime"
        binaryMessenger:binaryMessenger
        codec:TXFlutterVodPlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getCurrentPlaybackTimePlayerMsg:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(getCurrentPlaybackTimePlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        DoubleMsg *output = [api getCurrentPlaybackTimePlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 获得当前视频已缓存的时间
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterVodPlayerApi.getBufferDuration"
        binaryMessenger:binaryMessenger
        codec:TXFlutterVodPlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getBufferDurationPlayerMsg:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(getBufferDurationPlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        DoubleMsg *output = [api getBufferDurationPlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 获得当前视频的可播放时间
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterVodPlayerApi.getPlayableDuration"
        binaryMessenger:binaryMessenger
        codec:TXFlutterVodPlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getPlayableDurationPlayerMsg:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(getPlayableDurationPlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        DoubleMsg *output = [api getPlayableDurationPlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 获得当前播放视频的宽度
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterVodPlayerApi.getWidth"
        binaryMessenger:binaryMessenger
        codec:TXFlutterVodPlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getWidthPlayerMsg:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(getWidthPlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        IntMsg *output = [api getWidthPlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 获得当前播放视频的高度
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterVodPlayerApi.getHeight"
        binaryMessenger:binaryMessenger
        codec:TXFlutterVodPlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getHeightPlayerMsg:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(getHeightPlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        IntMsg *output = [api getHeightPlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置播放视频的token
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterVodPlayerApi.setToken"
        binaryMessenger:binaryMessenger
        codec:TXFlutterVodPlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setTokenToken:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(setTokenToken:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        StringPlayerMsg *arg_token = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setTokenToken:arg_token error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 当前播放的视频是否循环播放
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterVodPlayerApi.isLoop"
        binaryMessenger:binaryMessenger
        codec:TXFlutterVodPlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(isLoopPlayerMsg:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(isLoopPlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        BoolMsg *output = [api isLoopPlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 开启/关闭硬件编码
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterVodPlayerApi.enableHardwareDecode"
        binaryMessenger:binaryMessenger
        codec:TXFlutterVodPlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(enableHardwareDecodeEnable:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(enableHardwareDecodeEnable:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        BoolPlayerMsg *arg_enable = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        BoolMsg *output = [api enableHardwareDecodeEnable:arg_enable error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 进入画中画模式，进入画中画模式，需要适配画中画模式的界面，安卓只支持7.0以上机型
  /// <h1>
  /// 由于android系统限制，传递的图标大小不得超过1M，否则无法显示
  /// </h1>
  /// @param backIcon playIcon pauseIcon forwardIcon 为播放后退、播放、暂停、前进的图标，如果赋值的话，将会使用传递的图标，否则
  /// 使用系统默认图标，只支持flutter本地资源图片，传递的时候，与flutter使用图片资源一致，例如： images/back_icon.png
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterVodPlayerApi.enterPictureInPictureMode"
        binaryMessenger:binaryMessenger
        codec:TXFlutterVodPlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(enterPictureInPictureModePipParamsMsg:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(enterPictureInPictureModePipParamsMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        PipParamsPlayerMsg *arg_pipParamsMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        IntMsg *output = [api enterPictureInPictureModePipParamsMsg:arg_pipParamsMsg error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 退出画中画，如果该播放器处于画中画模式
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterVodPlayerApi.exitPictureInPictureMode"
        binaryMessenger:binaryMessenger
        codec:TXFlutterVodPlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(exitPictureInPictureModePlayerMsg:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(exitPictureInPictureModePlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api exitPictureInPictureModePlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterVodPlayerApi.initImageSprite"
        binaryMessenger:binaryMessenger
        codec:TXFlutterVodPlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(initImageSpriteSpriteInfo:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(initImageSpriteSpriteInfo:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        StringListPlayerMsg *arg_spriteInfo = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api initImageSpriteSpriteInfo:arg_spriteInfo error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterVodPlayerApi.getImageSprite"
        binaryMessenger:binaryMessenger
        codec:TXFlutterVodPlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getImageSpriteTime:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(getImageSpriteTime:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        DoublePlayerMsg *arg_time = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        UInt8ListMsg *output = [api getImageSpriteTime:arg_time error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 获取总时长
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterVodPlayerApi.getDuration"
        binaryMessenger:binaryMessenger
        codec:TXFlutterVodPlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getDurationPlayerMsg:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(getDurationPlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        DoubleMsg *output = [api getDurationPlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
}
@interface TXFlutterLivePlayerApiCodecReader : FlutterStandardReader
@end
@implementation TXFlutterLivePlayerApiCodecReader
- (nullable id)readValueOfType:(UInt8)type {
  switch (type) {
    case 128: 
      return [BoolMsg fromList:[self readValue]];
    case 129: 
      return [BoolPlayerMsg fromList:[self readValue]];
    case 130: 
      return [DoublePlayerMsg fromList:[self readValue]];
    case 131: 
      return [FTXLivePlayConfigPlayerMsg fromList:[self readValue]];
    case 132: 
      return [IntMsg fromList:[self readValue]];
    case 133: 
      return [IntPlayerMsg fromList:[self readValue]];
    case 134: 
      return [PipParamsPlayerMsg fromList:[self readValue]];
    case 135: 
      return [PlayerMsg fromList:[self readValue]];
    case 136: 
      return [StringIntPlayerMsg fromList:[self readValue]];
    case 137: 
      return [StringPlayerMsg fromList:[self readValue]];
    default:
      return [super readValueOfType:type];
  }
}
@end

@interface TXFlutterLivePlayerApiCodecWriter : FlutterStandardWriter
@end
@implementation TXFlutterLivePlayerApiCodecWriter
- (void)writeValue:(id)value {
  if ([value isKindOfClass:[BoolMsg class]]) {
    [self writeByte:128];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[BoolPlayerMsg class]]) {
    [self writeByte:129];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[DoublePlayerMsg class]]) {
    [self writeByte:130];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[FTXLivePlayConfigPlayerMsg class]]) {
    [self writeByte:131];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[IntMsg class]]) {
    [self writeByte:132];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[IntPlayerMsg class]]) {
    [self writeByte:133];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[PipParamsPlayerMsg class]]) {
    [self writeByte:134];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[PlayerMsg class]]) {
    [self writeByte:135];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[StringIntPlayerMsg class]]) {
    [self writeByte:136];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[StringPlayerMsg class]]) {
    [self writeByte:137];
    [self writeValue:[value toList]];
  } else {
    [super writeValue:value];
  }
}
@end

@interface TXFlutterLivePlayerApiCodecReaderWriter : FlutterStandardReaderWriter
@end
@implementation TXFlutterLivePlayerApiCodecReaderWriter
- (FlutterStandardWriter *)writerWithData:(NSMutableData *)data {
  return [[TXFlutterLivePlayerApiCodecWriter alloc] initWithData:data];
}
- (FlutterStandardReader *)readerWithData:(NSData *)data {
  return [[TXFlutterLivePlayerApiCodecReader alloc] initWithData:data];
}
@end

NSObject<FlutterMessageCodec> *TXFlutterLivePlayerApiGetCodec() {
  static FlutterStandardMessageCodec *sSharedObject = nil;
  static dispatch_once_t sPred = 0;
  dispatch_once(&sPred, ^{
    TXFlutterLivePlayerApiCodecReaderWriter *readerWriter = [[TXFlutterLivePlayerApiCodecReaderWriter alloc] init];
    sSharedObject = [FlutterStandardMessageCodec codecWithReaderWriter:readerWriter];
  });
  return sSharedObject;
}

void TXFlutterLivePlayerApiSetup(id<FlutterBinaryMessenger> binaryMessenger, NSObject<TXFlutterLivePlayerApi> *api) {
  /// 播放器初始化，创建共享纹理、初始化播放器
  /// @param onlyAudio 是否是纯音频模式
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterLivePlayerApi.initialize"
        binaryMessenger:binaryMessenger
        codec:TXFlutterLivePlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(initializeOnlyAudio:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(initializeOnlyAudio:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        BoolPlayerMsg *arg_onlyAudio = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        IntMsg *output = [api initializeOnlyAudio:arg_onlyAudio error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  ///
  /// 当设置[LivePlayer] 类型播放器时，需要参数[playType]
  /// 参考: [PlayType.LIVE_RTMP] ...
  /// 10.7版本开始，startPlay变更为startLivePlay，需要通过 {@link SuperPlayerPlugin#setGlobalLicense} 设置 Licence 后方可成功播放，
  /// 否则将播放失败（黑屏），全局仅设置一次即可。直播 Licence、短视频 Licence 和视频播放 Licence 均可使用，若您暂未获取上述 Licence ，
  /// 可[快速免费申请测试版 Licence](https://cloud.tencent.com/act/event/License) 以正常播放，正式版 License 需[购买]
  /// (https://cloud.tencent.com/document/product/881/74588#.E8.B4.AD.E4.B9.B0.E5.B9.B6.E6.96.B0.E5.BB.BA.E6.AD.A3.E5.BC.8F.E7.89.88-license)。
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterLivePlayerApi.startLivePlay"
        binaryMessenger:binaryMessenger
        codec:TXFlutterLivePlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(startLivePlayPlayerMsg:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(startLivePlayPlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        StringIntPlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        BoolMsg *output = [api startLivePlayPlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置是否自动播放
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterLivePlayerApi.setAutoPlay"
        binaryMessenger:binaryMessenger
        codec:TXFlutterLivePlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setAutoPlayIsAutoPlay:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(setAutoPlayIsAutoPlay:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        BoolPlayerMsg *arg_isAutoPlay = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setAutoPlayIsAutoPlay:arg_isAutoPlay error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 停止播放
  /// return 是否停止成功
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterLivePlayerApi.stop"
        binaryMessenger:binaryMessenger
        codec:TXFlutterLivePlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(stopIsNeedClear:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(stopIsNeedClear:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        BoolPlayerMsg *arg_isNeedClear = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        BoolMsg *output = [api stopIsNeedClear:arg_isNeedClear error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 视频是否处于正在播放中
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterLivePlayerApi.isPlaying"
        binaryMessenger:binaryMessenger
        codec:TXFlutterLivePlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(isPlayingPlayerMsg:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(isPlayingPlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        BoolMsg *output = [api isPlayingPlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 视频暂停，必须在播放器开始播放的时候调用
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterLivePlayerApi.pause"
        binaryMessenger:binaryMessenger
        codec:TXFlutterLivePlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(pausePlayerMsg:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(pausePlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api pausePlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 继续播放，在暂停的时候调用
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterLivePlayerApi.resume"
        binaryMessenger:binaryMessenger
        codec:TXFlutterLivePlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(resumePlayerMsg:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(resumePlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api resumePlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置直播模式，see TXPlayerLiveMode
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterLivePlayerApi.setLiveMode"
        binaryMessenger:binaryMessenger
        codec:TXFlutterLivePlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setLiveModeMode:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(setLiveModeMode:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        IntPlayerMsg *arg_mode = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setLiveModeMode:arg_mode error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置视频声音 0~100
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterLivePlayerApi.setVolume"
        binaryMessenger:binaryMessenger
        codec:TXFlutterLivePlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setVolumeVolume:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(setVolumeVolume:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        IntPlayerMsg *arg_volume = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setVolumeVolume:arg_volume error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置是否静音
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterLivePlayerApi.setMute"
        binaryMessenger:binaryMessenger
        codec:TXFlutterLivePlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setMuteMute:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(setMuteMute:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        BoolPlayerMsg *arg_mute = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setMuteMute:arg_mute error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 切换播放流
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterLivePlayerApi.switchStream"
        binaryMessenger:binaryMessenger
        codec:TXFlutterLivePlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(switchStreamUrl:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(switchStreamUrl:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        StringPlayerMsg *arg_url = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        IntMsg *output = [api switchStreamUrl:arg_url error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 将视频播放进度定位到指定的进度进行播放
  /// progress 要定位的视频时间，单位 秒
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterLivePlayerApi.seek"
        binaryMessenger:binaryMessenger
        codec:TXFlutterLivePlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(seekProgress:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(seekProgress:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        DoublePlayerMsg *arg_progress = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api seekProgress:arg_progress error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置appId
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterLivePlayerApi.setAppID"
        binaryMessenger:binaryMessenger
        codec:TXFlutterLivePlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setAppIDAppId:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(setAppIDAppId:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        StringPlayerMsg *arg_appId = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setAppIDAppId:arg_appId error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 时移 暂不支持
  /// @param domain
  /// @param bizId
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterLivePlayerApi.prepareLiveSeek"
        binaryMessenger:binaryMessenger
        codec:TXFlutterLivePlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(prepareLiveSeekPlayerMsg:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(prepareLiveSeekPlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        StringIntPlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api prepareLiveSeekPlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 停止时移播放，返回直播
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterLivePlayerApi.resumeLive"
        binaryMessenger:binaryMessenger
        codec:TXFlutterLivePlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(resumeLivePlayerMsg:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(resumeLivePlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        IntMsg *output = [api resumeLivePlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置播放速率,暂不支持
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterLivePlayerApi.setRate"
        binaryMessenger:binaryMessenger
        codec:TXFlutterLivePlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setRateRate:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(setRateRate:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        DoublePlayerMsg *arg_rate = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setRateRate:arg_rate error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置播放器配置
  /// config @see [FTXLivePlayConfig]
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterLivePlayerApi.setConfig"
        binaryMessenger:binaryMessenger
        codec:TXFlutterLivePlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setConfigConfig:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(setConfigConfig:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        FTXLivePlayConfigPlayerMsg *arg_config = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setConfigConfig:arg_config error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 开启/关闭硬件编码
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterLivePlayerApi.enableHardwareDecode"
        binaryMessenger:binaryMessenger
        codec:TXFlutterLivePlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(enableHardwareDecodeEnable:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(enableHardwareDecodeEnable:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        BoolPlayerMsg *arg_enable = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        BoolMsg *output = [api enableHardwareDecodeEnable:arg_enable error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 进入画中画模式，进入画中画模式，需要适配画中画模式的界面，安卓只支持7.0以上机型
  /// <h1>
  /// 由于android系统限制，传递的图标大小不得超过1M，否则无法显示
  /// </h1>
  /// @param backIcon playIcon pauseIcon forwardIcon 为播放后退、播放、暂停、前进的图标，仅适用于android，如果赋值的话，将会使用传递的图标，否则
  /// 使用系统默认图标，只支持flutter本地资源图片，传递的时候，与flutter使用图片资源一致，例如： images/back_icon.png
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterLivePlayerApi.enterPictureInPictureMode"
        binaryMessenger:binaryMessenger
        codec:TXFlutterLivePlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(enterPictureInPictureModePipParamsMsg:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(enterPictureInPictureModePipParamsMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        PipParamsPlayerMsg *arg_pipParamsMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        IntMsg *output = [api enterPictureInPictureModePipParamsMsg:arg_pipParamsMsg error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 退出画中画，如果该播放器处于画中画模式
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterLivePlayerApi.exitPictureInPictureMode"
        binaryMessenger:binaryMessenger
        codec:TXFlutterLivePlayerApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(exitPictureInPictureModePlayerMsg:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(exitPictureInPictureModePlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api exitPictureInPictureModePlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
}
@interface TXFlutterDownloadApiCodecReader : FlutterStandardReader
@end
@implementation TXFlutterDownloadApiCodecReader
- (nullable id)readValueOfType:(UInt8)type {
  switch (type) {
    case 128: 
      return [BoolMsg fromList:[self readValue]];
    case 129: 
      return [IntMsg fromList:[self readValue]];
    case 130: 
      return [MapMsg fromList:[self readValue]];
    case 131: 
      return [PreLoadMsg fromList:[self readValue]];
    case 132: 
      return [TXDownloadListMsg fromList:[self readValue]];
    case 133: 
      return [TXVodDownloadMediaMsg fromList:[self readValue]];
    default:
      return [super readValueOfType:type];
  }
}
@end

@interface TXFlutterDownloadApiCodecWriter : FlutterStandardWriter
@end
@implementation TXFlutterDownloadApiCodecWriter
- (void)writeValue:(id)value {
  if ([value isKindOfClass:[BoolMsg class]]) {
    [self writeByte:128];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[IntMsg class]]) {
    [self writeByte:129];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[MapMsg class]]) {
    [self writeByte:130];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[PreLoadMsg class]]) {
    [self writeByte:131];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[TXDownloadListMsg class]]) {
    [self writeByte:132];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[TXVodDownloadMediaMsg class]]) {
    [self writeByte:133];
    [self writeValue:[value toList]];
  } else {
    [super writeValue:value];
  }
}
@end

@interface TXFlutterDownloadApiCodecReaderWriter : FlutterStandardReaderWriter
@end
@implementation TXFlutterDownloadApiCodecReaderWriter
- (FlutterStandardWriter *)writerWithData:(NSMutableData *)data {
  return [[TXFlutterDownloadApiCodecWriter alloc] initWithData:data];
}
- (FlutterStandardReader *)readerWithData:(NSData *)data {
  return [[TXFlutterDownloadApiCodecReader alloc] initWithData:data];
}
@end

NSObject<FlutterMessageCodec> *TXFlutterDownloadApiGetCodec() {
  static FlutterStandardMessageCodec *sSharedObject = nil;
  static dispatch_once_t sPred = 0;
  dispatch_once(&sPred, ^{
    TXFlutterDownloadApiCodecReaderWriter *readerWriter = [[TXFlutterDownloadApiCodecReaderWriter alloc] init];
    sSharedObject = [FlutterStandardMessageCodec codecWithReaderWriter:readerWriter];
  });
  return sSharedObject;
}

void TXFlutterDownloadApiSetup(id<FlutterBinaryMessenger> binaryMessenger, NSObject<TXFlutterDownloadApi> *api) {
  /// 启动预下载。
  /// playUrl: 要预下载的url
  /// preloadSizeMB: 预下载的大小（单位：MB）
  /// preferredResolution 期望分辨率，long类型，值为高x宽。可参考如720*1080。不支持多分辨率或不需指定时，传-1。
  /// 返回值：任务ID，可用这个任务ID停止预下载 [stopPreload]
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterDownloadApi.startPreLoad"
        binaryMessenger:binaryMessenger
        codec:TXFlutterDownloadApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(startPreLoadMsg:error:)], @"TXFlutterDownloadApi api (%@) doesn't respond to @selector(startPreLoadMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        PreLoadMsg *arg_msg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        IntMsg *output = [api startPreLoadMsg:arg_msg error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 停止预下载。
  /// taskId： 任务id
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterDownloadApi.stopPreLoad"
        binaryMessenger:binaryMessenger
        codec:TXFlutterDownloadApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(stopPreLoadMsg:error:)], @"TXFlutterDownloadApi api (%@) doesn't respond to @selector(stopPreLoadMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        IntMsg *arg_msg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api stopPreLoadMsg:arg_msg error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 开始下载
  /// videoDownloadModel: 下载构造体
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterDownloadApi.startDownload"
        binaryMessenger:binaryMessenger
        codec:TXFlutterDownloadApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(startDownloadMsg:error:)], @"TXFlutterDownloadApi api (%@) doesn't respond to @selector(startDownloadMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        TXVodDownloadMediaMsg *arg_msg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api startDownloadMsg:arg_msg error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 继续下载，与开始下载接口有区别，该接口会寻找对应的缓存，复用之前的缓存来续点下载，
  /// 而开始下载接口会启动一个全新的下载
  /// videoDownloadModel: 下载构造体
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterDownloadApi.resumeDownload"
        binaryMessenger:binaryMessenger
        codec:TXFlutterDownloadApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(resumeDownloadMsg:error:)], @"TXFlutterDownloadApi api (%@) doesn't respond to @selector(resumeDownloadMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        TXVodDownloadMediaMsg *arg_msg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api resumeDownloadMsg:arg_msg error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 停止下载
  /// videoDownloadModel: 下载构造体
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterDownloadApi.stopDownload"
        binaryMessenger:binaryMessenger
        codec:TXFlutterDownloadApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(stopDownloadMsg:error:)], @"TXFlutterDownloadApi api (%@) doesn't respond to @selector(stopDownloadMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        TXVodDownloadMediaMsg *arg_msg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api stopDownloadMsg:arg_msg error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置下载请求头
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterDownloadApi.setDownloadHeaders"
        binaryMessenger:binaryMessenger
        codec:TXFlutterDownloadApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setDownloadHeadersHeaders:error:)], @"TXFlutterDownloadApi api (%@) doesn't respond to @selector(setDownloadHeadersHeaders:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        MapMsg *arg_headers = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setDownloadHeadersHeaders:arg_headers error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 获取所有视频下载列表
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterDownloadApi.getDownloadList"
        binaryMessenger:binaryMessenger
        codec:TXFlutterDownloadApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getDownloadListWithError:)], @"TXFlutterDownloadApi api (%@) doesn't respond to @selector(getDownloadListWithError:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        FlutterError *error;
        TXDownloadListMsg *output = [api getDownloadListWithError:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 获得指定视频的下载信息
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterDownloadApi.getDownloadInfo"
        binaryMessenger:binaryMessenger
        codec:TXFlutterDownloadApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getDownloadInfoMsg:error:)], @"TXFlutterDownloadApi api (%@) doesn't respond to @selector(getDownloadInfoMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        TXVodDownloadMediaMsg *arg_msg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        TXVodDownloadMediaMsg *output = [api getDownloadInfoMsg:arg_msg error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 删除下载任务
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:@"dev.flutter.pigeon.TXFlutterDownloadApi.deleteDownloadMediaInfo"
        binaryMessenger:binaryMessenger
        codec:TXFlutterDownloadApiGetCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(deleteDownloadMediaInfoMsg:error:)], @"TXFlutterDownloadApi api (%@) doesn't respond to @selector(deleteDownloadMediaInfoMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray *args = message;
        TXVodDownloadMediaMsg *arg_msg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        BoolMsg *output = [api deleteDownloadMediaInfoMsg:arg_msg error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
}
