// Copyright (c) 2022 Tencent. All rights reserved.
// Autogenerated from Pigeon (v22.6.1), do not edit directly.
// See also: https://pub.dev/packages/pigeon

#import "FtxMessages.h"

#if TARGET_OS_OSX
#import <FlutterMacOS/FlutterMacOS.h>
#else
#import <Flutter/Flutter.h>
#endif

#if !__has_feature(objc_arc)
#error File requires ARC to be enabled.
#endif

static NSArray<id> *wrapResult(id result, FlutterError *error) {
  if (error) {
    return @[
      error.code ?: [NSNull null], error.message ?: [NSNull null], error.details ?: [NSNull null]
    ];
  }
  return @[ result ?: [NSNull null] ];
}

static FlutterError *createConnectionError(NSString *channelName) {
  return [FlutterError errorWithCode:@"channel-error" message:[NSString stringWithFormat:@"%@/%@/%@", @"Unable to establish connection on channel: '", channelName, @"'."] details:@""];
}

static id GetNullableObjectAtIndex(NSArray<id> *array, NSInteger key) {
  id result = array[key];
  return (result == [NSNull null]) ? nil : result;
}

@interface PlayerMsg ()
+ (PlayerMsg *)fromList:(NSArray<id> *)list;
+ (nullable PlayerMsg *)nullableFromList:(NSArray<id> *)list;
- (NSArray<id> *)toList;
@end

@interface LicenseMsg ()
+ (LicenseMsg *)fromList:(NSArray<id> *)list;
+ (nullable LicenseMsg *)nullableFromList:(NSArray<id> *)list;
- (NSArray<id> *)toList;
@end

@interface TXPlayInfoParamsPlayerMsg ()
+ (TXPlayInfoParamsPlayerMsg *)fromList:(NSArray<id> *)list;
+ (nullable TXPlayInfoParamsPlayerMsg *)nullableFromList:(NSArray<id> *)list;
- (NSArray<id> *)toList;
@end

@interface TXPlayerDrmMsg ()
+ (TXPlayerDrmMsg *)fromList:(NSArray<id> *)list;
+ (nullable TXPlayerDrmMsg *)nullableFromList:(NSArray<id> *)list;
- (NSArray<id> *)toList;
@end

@interface PipParamsPlayerMsg ()
+ (PipParamsPlayerMsg *)fromList:(NSArray<id> *)list;
+ (nullable PipParamsPlayerMsg *)nullableFromList:(NSArray<id> *)list;
- (NSArray<id> *)toList;
@end

@interface StringListPlayerMsg ()
+ (StringListPlayerMsg *)fromList:(NSArray<id> *)list;
+ (nullable StringListPlayerMsg *)nullableFromList:(NSArray<id> *)list;
- (NSArray<id> *)toList;
@end

@interface BoolPlayerMsg ()
+ (BoolPlayerMsg *)fromList:(NSArray<id> *)list;
+ (nullable BoolPlayerMsg *)nullableFromList:(NSArray<id> *)list;
- (NSArray<id> *)toList;
@end

@interface StringIntPlayerMsg ()
+ (StringIntPlayerMsg *)fromList:(NSArray<id> *)list;
+ (nullable StringIntPlayerMsg *)nullableFromList:(NSArray<id> *)list;
- (NSArray<id> *)toList;
@end

@interface StringPlayerMsg ()
+ (StringPlayerMsg *)fromList:(NSArray<id> *)list;
+ (nullable StringPlayerMsg *)nullableFromList:(NSArray<id> *)list;
- (NSArray<id> *)toList;
@end

@interface DoublePlayerMsg ()
+ (DoublePlayerMsg *)fromList:(NSArray<id> *)list;
+ (nullable DoublePlayerMsg *)nullableFromList:(NSArray<id> *)list;
- (NSArray<id> *)toList;
@end

@interface IntPlayerMsg ()
+ (IntPlayerMsg *)fromList:(NSArray<id> *)list;
+ (nullable IntPlayerMsg *)nullableFromList:(NSArray<id> *)list;
- (NSArray<id> *)toList;
@end

@interface FTXVodPlayConfigPlayerMsg ()
+ (FTXVodPlayConfigPlayerMsg *)fromList:(NSArray<id> *)list;
+ (nullable FTXVodPlayConfigPlayerMsg *)nullableFromList:(NSArray<id> *)list;
- (NSArray<id> *)toList;
@end

@interface FTXLivePlayConfigPlayerMsg ()
+ (FTXLivePlayConfigPlayerMsg *)fromList:(NSArray<id> *)list;
+ (nullable FTXLivePlayConfigPlayerMsg *)nullableFromList:(NSArray<id> *)list;
- (NSArray<id> *)toList;
@end

@interface TXVodDownloadMediaMsg ()
+ (TXVodDownloadMediaMsg *)fromList:(NSArray<id> *)list;
+ (nullable TXVodDownloadMediaMsg *)nullableFromList:(NSArray<id> *)list;
- (NSArray<id> *)toList;
@end

@interface TXDownloadListMsg ()
+ (TXDownloadListMsg *)fromList:(NSArray<id> *)list;
+ (nullable TXDownloadListMsg *)nullableFromList:(NSArray<id> *)list;
- (NSArray<id> *)toList;
@end

@interface UInt8ListMsg ()
+ (UInt8ListMsg *)fromList:(NSArray<id> *)list;
+ (nullable UInt8ListMsg *)nullableFromList:(NSArray<id> *)list;
- (NSArray<id> *)toList;
@end

@interface ListMsg ()
+ (ListMsg *)fromList:(NSArray<id> *)list;
+ (nullable ListMsg *)nullableFromList:(NSArray<id> *)list;
- (NSArray<id> *)toList;
@end

@interface BoolMsg ()
+ (BoolMsg *)fromList:(NSArray<id> *)list;
+ (nullable BoolMsg *)nullableFromList:(NSArray<id> *)list;
- (NSArray<id> *)toList;
@end

@interface IntMsg ()
+ (IntMsg *)fromList:(NSArray<id> *)list;
+ (nullable IntMsg *)nullableFromList:(NSArray<id> *)list;
- (NSArray<id> *)toList;
@end

@interface StringMsg ()
+ (StringMsg *)fromList:(NSArray<id> *)list;
+ (nullable StringMsg *)nullableFromList:(NSArray<id> *)list;
- (NSArray<id> *)toList;
@end

@interface CachePathMsg ()
+ (CachePathMsg *)fromList:(NSArray<id> *)list;
+ (nullable CachePathMsg *)nullableFromList:(NSArray<id> *)list;
- (NSArray<id> *)toList;
@end

@interface DoubleMsg ()
+ (DoubleMsg *)fromList:(NSArray<id> *)list;
+ (nullable DoubleMsg *)nullableFromList:(NSArray<id> *)list;
- (NSArray<id> *)toList;
@end

@interface PreLoadMsg ()
+ (PreLoadMsg *)fromList:(NSArray<id> *)list;
+ (nullable PreLoadMsg *)nullableFromList:(NSArray<id> *)list;
- (NSArray<id> *)toList;
@end

@interface PreLoadInfoMsg ()
+ (PreLoadInfoMsg *)fromList:(NSArray<id> *)list;
+ (nullable PreLoadInfoMsg *)nullableFromList:(NSArray<id> *)list;
- (NSArray<id> *)toList;
@end

@interface MapMsg ()
+ (MapMsg *)fromList:(NSArray<id> *)list;
+ (nullable MapMsg *)nullableFromList:(NSArray<id> *)list;
- (NSArray<id> *)toList;
@end

@interface SubTitlePlayerMsg ()
+ (SubTitlePlayerMsg *)fromList:(NSArray<id> *)list;
+ (nullable SubTitlePlayerMsg *)nullableFromList:(NSArray<id> *)list;
- (NSArray<id> *)toList;
@end

@interface SubTitleRenderModelPlayerMsg ()
+ (SubTitleRenderModelPlayerMsg *)fromList:(NSArray<id> *)list;
+ (nullable SubTitleRenderModelPlayerMsg *)nullableFromList:(NSArray<id> *)list;
- (NSArray<id> *)toList;
@end

@interface StringOptionPlayerMsg ()
+ (StringOptionPlayerMsg *)fromList:(NSArray<id> *)list;
+ (nullable StringOptionPlayerMsg *)nullableFromList:(NSArray<id> *)list;
- (NSArray<id> *)toList;
@end

@implementation PlayerMsg
+ (instancetype)makeWithPlayerId:(nullable NSNumber *)playerId {
  PlayerMsg* pigeonResult = [[PlayerMsg alloc] init];
  pigeonResult.playerId = playerId;
  return pigeonResult;
}
+ (PlayerMsg *)fromList:(NSArray<id> *)list {
  PlayerMsg *pigeonResult = [[PlayerMsg alloc] init];
  pigeonResult.playerId = GetNullableObjectAtIndex(list, 0);
  return pigeonResult;
}
+ (nullable PlayerMsg *)nullableFromList:(NSArray<id> *)list {
  return (list) ? [PlayerMsg fromList:list] : nil;
}
- (NSArray<id> *)toList {
  return @[
    self.playerId ?: [NSNull null],
  ];
}
@end

@implementation LicenseMsg
+ (instancetype)makeWithLicenseUrl:(nullable NSString *)licenseUrl
    licenseKey:(nullable NSString *)licenseKey {
  LicenseMsg* pigeonResult = [[LicenseMsg alloc] init];
  pigeonResult.licenseUrl = licenseUrl;
  pigeonResult.licenseKey = licenseKey;
  return pigeonResult;
}
+ (LicenseMsg *)fromList:(NSArray<id> *)list {
  LicenseMsg *pigeonResult = [[LicenseMsg alloc] init];
  pigeonResult.licenseUrl = GetNullableObjectAtIndex(list, 0);
  pigeonResult.licenseKey = GetNullableObjectAtIndex(list, 1);
  return pigeonResult;
}
+ (nullable LicenseMsg *)nullableFromList:(NSArray<id> *)list {
  return (list) ? [LicenseMsg fromList:list] : nil;
}
- (NSArray<id> *)toList {
  return @[
    self.licenseUrl ?: [NSNull null],
    self.licenseKey ?: [NSNull null],
  ];
}
@end

@implementation TXPlayInfoParamsPlayerMsg
+ (instancetype)makeWithPlayerId:(nullable NSNumber *)playerId
    appId:(nullable NSNumber *)appId
    fileId:(nullable NSString *)fileId
    psign:(nullable NSString *)psign
    url:(nullable NSString *)url {
  TXPlayInfoParamsPlayerMsg* pigeonResult = [[TXPlayInfoParamsPlayerMsg alloc] init];
  pigeonResult.playerId = playerId;
  pigeonResult.appId = appId;
  pigeonResult.fileId = fileId;
  pigeonResult.psign = psign;
  pigeonResult.url = url;
  return pigeonResult;
}
+ (TXPlayInfoParamsPlayerMsg *)fromList:(NSArray<id> *)list {
  TXPlayInfoParamsPlayerMsg *pigeonResult = [[TXPlayInfoParamsPlayerMsg alloc] init];
  pigeonResult.playerId = GetNullableObjectAtIndex(list, 0);
  pigeonResult.appId = GetNullableObjectAtIndex(list, 1);
  pigeonResult.fileId = GetNullableObjectAtIndex(list, 2);
  pigeonResult.psign = GetNullableObjectAtIndex(list, 3);
  pigeonResult.url = GetNullableObjectAtIndex(list, 4);
  return pigeonResult;
}
+ (nullable TXPlayInfoParamsPlayerMsg *)nullableFromList:(NSArray<id> *)list {
  return (list) ? [TXPlayInfoParamsPlayerMsg fromList:list] : nil;
}
- (NSArray<id> *)toList {
  return @[
    self.playerId ?: [NSNull null],
    self.appId ?: [NSNull null],
    self.fileId ?: [NSNull null],
    self.psign ?: [NSNull null],
    self.url ?: [NSNull null],
  ];
}
@end

@implementation TXPlayerDrmMsg
+ (instancetype)makeWithLicenseUrl:(NSString *)licenseUrl
    playUrl:(NSString *)playUrl
    playerId:(nullable NSNumber *)playerId
    deviceCertificateUrl:(nullable NSString *)deviceCertificateUrl {
  TXPlayerDrmMsg* pigeonResult = [[TXPlayerDrmMsg alloc] init];
  pigeonResult.licenseUrl = licenseUrl;
  pigeonResult.playUrl = playUrl;
  pigeonResult.playerId = playerId;
  pigeonResult.deviceCertificateUrl = deviceCertificateUrl;
  return pigeonResult;
}
+ (TXPlayerDrmMsg *)fromList:(NSArray<id> *)list {
  TXPlayerDrmMsg *pigeonResult = [[TXPlayerDrmMsg alloc] init];
  pigeonResult.licenseUrl = GetNullableObjectAtIndex(list, 0);
  pigeonResult.playUrl = GetNullableObjectAtIndex(list, 1);
  pigeonResult.playerId = GetNullableObjectAtIndex(list, 2);
  pigeonResult.deviceCertificateUrl = GetNullableObjectAtIndex(list, 3);
  return pigeonResult;
}
+ (nullable TXPlayerDrmMsg *)nullableFromList:(NSArray<id> *)list {
  return (list) ? [TXPlayerDrmMsg fromList:list] : nil;
}
- (NSArray<id> *)toList {
  return @[
    self.licenseUrl ?: [NSNull null],
    self.playUrl ?: [NSNull null],
    self.playerId ?: [NSNull null],
    self.deviceCertificateUrl ?: [NSNull null],
  ];
}
@end

@implementation PipParamsPlayerMsg
+ (instancetype)makeWithPlayerId:(nullable NSNumber *)playerId
    backIconForAndroid:(nullable NSString *)backIconForAndroid
    playIconForAndroid:(nullable NSString *)playIconForAndroid
    pauseIconForAndroid:(nullable NSString *)pauseIconForAndroid
    forwardIconForAndroid:(nullable NSString *)forwardIconForAndroid {
  PipParamsPlayerMsg* pigeonResult = [[PipParamsPlayerMsg alloc] init];
  pigeonResult.playerId = playerId;
  pigeonResult.backIconForAndroid = backIconForAndroid;
  pigeonResult.playIconForAndroid = playIconForAndroid;
  pigeonResult.pauseIconForAndroid = pauseIconForAndroid;
  pigeonResult.forwardIconForAndroid = forwardIconForAndroid;
  return pigeonResult;
}
+ (PipParamsPlayerMsg *)fromList:(NSArray<id> *)list {
  PipParamsPlayerMsg *pigeonResult = [[PipParamsPlayerMsg alloc] init];
  pigeonResult.playerId = GetNullableObjectAtIndex(list, 0);
  pigeonResult.backIconForAndroid = GetNullableObjectAtIndex(list, 1);
  pigeonResult.playIconForAndroid = GetNullableObjectAtIndex(list, 2);
  pigeonResult.pauseIconForAndroid = GetNullableObjectAtIndex(list, 3);
  pigeonResult.forwardIconForAndroid = GetNullableObjectAtIndex(list, 4);
  return pigeonResult;
}
+ (nullable PipParamsPlayerMsg *)nullableFromList:(NSArray<id> *)list {
  return (list) ? [PipParamsPlayerMsg fromList:list] : nil;
}
- (NSArray<id> *)toList {
  return @[
    self.playerId ?: [NSNull null],
    self.backIconForAndroid ?: [NSNull null],
    self.playIconForAndroid ?: [NSNull null],
    self.pauseIconForAndroid ?: [NSNull null],
    self.forwardIconForAndroid ?: [NSNull null],
  ];
}
@end

@implementation StringListPlayerMsg
+ (instancetype)makeWithPlayerId:(nullable NSNumber *)playerId
    vvtUrl:(nullable NSString *)vvtUrl
    imageUrls:(nullable NSArray<NSString *> *)imageUrls {
  StringListPlayerMsg* pigeonResult = [[StringListPlayerMsg alloc] init];
  pigeonResult.playerId = playerId;
  pigeonResult.vvtUrl = vvtUrl;
  pigeonResult.imageUrls = imageUrls;
  return pigeonResult;
}
+ (StringListPlayerMsg *)fromList:(NSArray<id> *)list {
  StringListPlayerMsg *pigeonResult = [[StringListPlayerMsg alloc] init];
  pigeonResult.playerId = GetNullableObjectAtIndex(list, 0);
  pigeonResult.vvtUrl = GetNullableObjectAtIndex(list, 1);
  pigeonResult.imageUrls = GetNullableObjectAtIndex(list, 2);
  return pigeonResult;
}
+ (nullable StringListPlayerMsg *)nullableFromList:(NSArray<id> *)list {
  return (list) ? [StringListPlayerMsg fromList:list] : nil;
}
- (NSArray<id> *)toList {
  return @[
    self.playerId ?: [NSNull null],
    self.vvtUrl ?: [NSNull null],
    self.imageUrls ?: [NSNull null],
  ];
}
@end

@implementation BoolPlayerMsg
+ (instancetype)makeWithPlayerId:(nullable NSNumber *)playerId
    value:(nullable NSNumber *)value {
  BoolPlayerMsg* pigeonResult = [[BoolPlayerMsg alloc] init];
  pigeonResult.playerId = playerId;
  pigeonResult.value = value;
  return pigeonResult;
}
+ (BoolPlayerMsg *)fromList:(NSArray<id> *)list {
  BoolPlayerMsg *pigeonResult = [[BoolPlayerMsg alloc] init];
  pigeonResult.playerId = GetNullableObjectAtIndex(list, 0);
  pigeonResult.value = GetNullableObjectAtIndex(list, 1);
  return pigeonResult;
}
+ (nullable BoolPlayerMsg *)nullableFromList:(NSArray<id> *)list {
  return (list) ? [BoolPlayerMsg fromList:list] : nil;
}
- (NSArray<id> *)toList {
  return @[
    self.playerId ?: [NSNull null],
    self.value ?: [NSNull null],
  ];
}
@end

@implementation StringIntPlayerMsg
+ (instancetype)makeWithPlayerId:(nullable NSNumber *)playerId
    strValue:(nullable NSString *)strValue
    intValue:(nullable NSNumber *)intValue {
  StringIntPlayerMsg* pigeonResult = [[StringIntPlayerMsg alloc] init];
  pigeonResult.playerId = playerId;
  pigeonResult.strValue = strValue;
  pigeonResult.intValue = intValue;
  return pigeonResult;
}
+ (StringIntPlayerMsg *)fromList:(NSArray<id> *)list {
  StringIntPlayerMsg *pigeonResult = [[StringIntPlayerMsg alloc] init];
  pigeonResult.playerId = GetNullableObjectAtIndex(list, 0);
  pigeonResult.strValue = GetNullableObjectAtIndex(list, 1);
  pigeonResult.intValue = GetNullableObjectAtIndex(list, 2);
  return pigeonResult;
}
+ (nullable StringIntPlayerMsg *)nullableFromList:(NSArray<id> *)list {
  return (list) ? [StringIntPlayerMsg fromList:list] : nil;
}
- (NSArray<id> *)toList {
  return @[
    self.playerId ?: [NSNull null],
    self.strValue ?: [NSNull null],
    self.intValue ?: [NSNull null],
  ];
}
@end

@implementation StringPlayerMsg
+ (instancetype)makeWithPlayerId:(nullable NSNumber *)playerId
    value:(nullable NSString *)value {
  StringPlayerMsg* pigeonResult = [[StringPlayerMsg alloc] init];
  pigeonResult.playerId = playerId;
  pigeonResult.value = value;
  return pigeonResult;
}
+ (StringPlayerMsg *)fromList:(NSArray<id> *)list {
  StringPlayerMsg *pigeonResult = [[StringPlayerMsg alloc] init];
  pigeonResult.playerId = GetNullableObjectAtIndex(list, 0);
  pigeonResult.value = GetNullableObjectAtIndex(list, 1);
  return pigeonResult;
}
+ (nullable StringPlayerMsg *)nullableFromList:(NSArray<id> *)list {
  return (list) ? [StringPlayerMsg fromList:list] : nil;
}
- (NSArray<id> *)toList {
  return @[
    self.playerId ?: [NSNull null],
    self.value ?: [NSNull null],
  ];
}
@end

@implementation DoublePlayerMsg
+ (instancetype)makeWithPlayerId:(nullable NSNumber *)playerId
    value:(nullable NSNumber *)value {
  DoublePlayerMsg* pigeonResult = [[DoublePlayerMsg alloc] init];
  pigeonResult.playerId = playerId;
  pigeonResult.value = value;
  return pigeonResult;
}
+ (DoublePlayerMsg *)fromList:(NSArray<id> *)list {
  DoublePlayerMsg *pigeonResult = [[DoublePlayerMsg alloc] init];
  pigeonResult.playerId = GetNullableObjectAtIndex(list, 0);
  pigeonResult.value = GetNullableObjectAtIndex(list, 1);
  return pigeonResult;
}
+ (nullable DoublePlayerMsg *)nullableFromList:(NSArray<id> *)list {
  return (list) ? [DoublePlayerMsg fromList:list] : nil;
}
- (NSArray<id> *)toList {
  return @[
    self.playerId ?: [NSNull null],
    self.value ?: [NSNull null],
  ];
}
@end

@implementation IntPlayerMsg
+ (instancetype)makeWithPlayerId:(nullable NSNumber *)playerId
    value:(nullable NSNumber *)value {
  IntPlayerMsg* pigeonResult = [[IntPlayerMsg alloc] init];
  pigeonResult.playerId = playerId;
  pigeonResult.value = value;
  return pigeonResult;
}
+ (IntPlayerMsg *)fromList:(NSArray<id> *)list {
  IntPlayerMsg *pigeonResult = [[IntPlayerMsg alloc] init];
  pigeonResult.playerId = GetNullableObjectAtIndex(list, 0);
  pigeonResult.value = GetNullableObjectAtIndex(list, 1);
  return pigeonResult;
}
+ (nullable IntPlayerMsg *)nullableFromList:(NSArray<id> *)list {
  return (list) ? [IntPlayerMsg fromList:list] : nil;
}
- (NSArray<id> *)toList {
  return @[
    self.playerId ?: [NSNull null],
    self.value ?: [NSNull null],
  ];
}
@end

@implementation FTXVodPlayConfigPlayerMsg
+ (instancetype)makeWithPlayerId:(nullable NSNumber *)playerId
    connectRetryCount:(nullable NSNumber *)connectRetryCount
    connectRetryInterval:(nullable NSNumber *)connectRetryInterval
    timeout:(nullable NSNumber *)timeout
    playerType:(nullable NSNumber *)playerType
    headers:(nullable NSDictionary<NSString *, NSString *> *)headers
    enableAccurateSeek:(nullable NSNumber *)enableAccurateSeek
    autoRotate:(nullable NSNumber *)autoRotate
    smoothSwitchBitrate:(nullable NSNumber *)smoothSwitchBitrate
    cacheMp4ExtName:(nullable NSString *)cacheMp4ExtName
    progressInterval:(nullable NSNumber *)progressInterval
    maxBufferSize:(nullable NSNumber *)maxBufferSize
    maxPreloadSize:(nullable NSNumber *)maxPreloadSize
    firstStartPlayBufferTime:(nullable NSNumber *)firstStartPlayBufferTime
    nextStartPlayBufferTime:(nullable NSNumber *)nextStartPlayBufferTime
    overlayKey:(nullable NSString *)overlayKey
    overlayIv:(nullable NSString *)overlayIv
    extInfoMap:(nullable NSDictionary<NSString *, id> *)extInfoMap
    enableRenderProcess:(nullable NSNumber *)enableRenderProcess
    preferredResolution:(nullable NSNumber *)preferredResolution
    mediaType:(nullable NSNumber *)mediaType
    encryptedMp4Level:(nullable NSNumber *)encryptedMp4Level {
  FTXVodPlayConfigPlayerMsg* pigeonResult = [[FTXVodPlayConfigPlayerMsg alloc] init];
  pigeonResult.playerId = playerId;
  pigeonResult.connectRetryCount = connectRetryCount;
  pigeonResult.connectRetryInterval = connectRetryInterval;
  pigeonResult.timeout = timeout;
  pigeonResult.playerType = playerType;
  pigeonResult.headers = headers;
  pigeonResult.enableAccurateSeek = enableAccurateSeek;
  pigeonResult.autoRotate = autoRotate;
  pigeonResult.smoothSwitchBitrate = smoothSwitchBitrate;
  pigeonResult.cacheMp4ExtName = cacheMp4ExtName;
  pigeonResult.progressInterval = progressInterval;
  pigeonResult.maxBufferSize = maxBufferSize;
  pigeonResult.maxPreloadSize = maxPreloadSize;
  pigeonResult.firstStartPlayBufferTime = firstStartPlayBufferTime;
  pigeonResult.nextStartPlayBufferTime = nextStartPlayBufferTime;
  pigeonResult.overlayKey = overlayKey;
  pigeonResult.overlayIv = overlayIv;
  pigeonResult.extInfoMap = extInfoMap;
  pigeonResult.enableRenderProcess = enableRenderProcess;
  pigeonResult.preferredResolution = preferredResolution;
  pigeonResult.mediaType = mediaType;
  pigeonResult.encryptedMp4Level = encryptedMp4Level;
  return pigeonResult;
}
+ (FTXVodPlayConfigPlayerMsg *)fromList:(NSArray<id> *)list {
  FTXVodPlayConfigPlayerMsg *pigeonResult = [[FTXVodPlayConfigPlayerMsg alloc] init];
  pigeonResult.playerId = GetNullableObjectAtIndex(list, 0);
  pigeonResult.connectRetryCount = GetNullableObjectAtIndex(list, 1);
  pigeonResult.connectRetryInterval = GetNullableObjectAtIndex(list, 2);
  pigeonResult.timeout = GetNullableObjectAtIndex(list, 3);
  pigeonResult.playerType = GetNullableObjectAtIndex(list, 4);
  pigeonResult.headers = GetNullableObjectAtIndex(list, 5);
  pigeonResult.enableAccurateSeek = GetNullableObjectAtIndex(list, 6);
  pigeonResult.autoRotate = GetNullableObjectAtIndex(list, 7);
  pigeonResult.smoothSwitchBitrate = GetNullableObjectAtIndex(list, 8);
  pigeonResult.cacheMp4ExtName = GetNullableObjectAtIndex(list, 9);
  pigeonResult.progressInterval = GetNullableObjectAtIndex(list, 10);
  pigeonResult.maxBufferSize = GetNullableObjectAtIndex(list, 11);
  pigeonResult.maxPreloadSize = GetNullableObjectAtIndex(list, 12);
  pigeonResult.firstStartPlayBufferTime = GetNullableObjectAtIndex(list, 13);
  pigeonResult.nextStartPlayBufferTime = GetNullableObjectAtIndex(list, 14);
  pigeonResult.overlayKey = GetNullableObjectAtIndex(list, 15);
  pigeonResult.overlayIv = GetNullableObjectAtIndex(list, 16);
  pigeonResult.extInfoMap = GetNullableObjectAtIndex(list, 17);
  pigeonResult.enableRenderProcess = GetNullableObjectAtIndex(list, 18);
  pigeonResult.preferredResolution = GetNullableObjectAtIndex(list, 19);
  pigeonResult.mediaType = GetNullableObjectAtIndex(list, 20);
  pigeonResult.encryptedMp4Level = GetNullableObjectAtIndex(list, 21);
  return pigeonResult;
}
+ (nullable FTXVodPlayConfigPlayerMsg *)nullableFromList:(NSArray<id> *)list {
  return (list) ? [FTXVodPlayConfigPlayerMsg fromList:list] : nil;
}
- (NSArray<id> *)toList {
  return @[
    self.playerId ?: [NSNull null],
    self.connectRetryCount ?: [NSNull null],
    self.connectRetryInterval ?: [NSNull null],
    self.timeout ?: [NSNull null],
    self.playerType ?: [NSNull null],
    self.headers ?: [NSNull null],
    self.enableAccurateSeek ?: [NSNull null],
    self.autoRotate ?: [NSNull null],
    self.smoothSwitchBitrate ?: [NSNull null],
    self.cacheMp4ExtName ?: [NSNull null],
    self.progressInterval ?: [NSNull null],
    self.maxBufferSize ?: [NSNull null],
    self.maxPreloadSize ?: [NSNull null],
    self.firstStartPlayBufferTime ?: [NSNull null],
    self.nextStartPlayBufferTime ?: [NSNull null],
    self.overlayKey ?: [NSNull null],
    self.overlayIv ?: [NSNull null],
    self.extInfoMap ?: [NSNull null],
    self.enableRenderProcess ?: [NSNull null],
    self.preferredResolution ?: [NSNull null],
    self.mediaType ?: [NSNull null],
    self.encryptedMp4Level ?: [NSNull null],
  ];
}
@end

@implementation FTXLivePlayConfigPlayerMsg
+ (instancetype)makeWithPlayerId:(nullable NSNumber *)playerId
    cacheTime:(nullable NSNumber *)cacheTime
    maxAutoAdjustCacheTime:(nullable NSNumber *)maxAutoAdjustCacheTime
    minAutoAdjustCacheTime:(nullable NSNumber *)minAutoAdjustCacheTime
    videoBlockThreshold:(nullable NSNumber *)videoBlockThreshold
    connectRetryCount:(nullable NSNumber *)connectRetryCount
    connectRetryInterval:(nullable NSNumber *)connectRetryInterval
    autoAdjustCacheTime:(nullable NSNumber *)autoAdjustCacheTime
    enableAec:(nullable NSNumber *)enableAec
    enableMessage:(nullable NSNumber *)enableMessage
    enableMetaData:(nullable NSNumber *)enableMetaData
    flvSessionKey:(nullable NSString *)flvSessionKey {
  FTXLivePlayConfigPlayerMsg* pigeonResult = [[FTXLivePlayConfigPlayerMsg alloc] init];
  pigeonResult.playerId = playerId;
  pigeonResult.cacheTime = cacheTime;
  pigeonResult.maxAutoAdjustCacheTime = maxAutoAdjustCacheTime;
  pigeonResult.minAutoAdjustCacheTime = minAutoAdjustCacheTime;
  pigeonResult.videoBlockThreshold = videoBlockThreshold;
  pigeonResult.connectRetryCount = connectRetryCount;
  pigeonResult.connectRetryInterval = connectRetryInterval;
  pigeonResult.autoAdjustCacheTime = autoAdjustCacheTime;
  pigeonResult.enableAec = enableAec;
  pigeonResult.enableMessage = enableMessage;
  pigeonResult.enableMetaData = enableMetaData;
  pigeonResult.flvSessionKey = flvSessionKey;
  return pigeonResult;
}
+ (FTXLivePlayConfigPlayerMsg *)fromList:(NSArray<id> *)list {
  FTXLivePlayConfigPlayerMsg *pigeonResult = [[FTXLivePlayConfigPlayerMsg alloc] init];
  pigeonResult.playerId = GetNullableObjectAtIndex(list, 0);
  pigeonResult.cacheTime = GetNullableObjectAtIndex(list, 1);
  pigeonResult.maxAutoAdjustCacheTime = GetNullableObjectAtIndex(list, 2);
  pigeonResult.minAutoAdjustCacheTime = GetNullableObjectAtIndex(list, 3);
  pigeonResult.videoBlockThreshold = GetNullableObjectAtIndex(list, 4);
  pigeonResult.connectRetryCount = GetNullableObjectAtIndex(list, 5);
  pigeonResult.connectRetryInterval = GetNullableObjectAtIndex(list, 6);
  pigeonResult.autoAdjustCacheTime = GetNullableObjectAtIndex(list, 7);
  pigeonResult.enableAec = GetNullableObjectAtIndex(list, 8);
  pigeonResult.enableMessage = GetNullableObjectAtIndex(list, 9);
  pigeonResult.enableMetaData = GetNullableObjectAtIndex(list, 10);
  pigeonResult.flvSessionKey = GetNullableObjectAtIndex(list, 11);
  return pigeonResult;
}
+ (nullable FTXLivePlayConfigPlayerMsg *)nullableFromList:(NSArray<id> *)list {
  return (list) ? [FTXLivePlayConfigPlayerMsg fromList:list] : nil;
}
- (NSArray<id> *)toList {
  return @[
    self.playerId ?: [NSNull null],
    self.cacheTime ?: [NSNull null],
    self.maxAutoAdjustCacheTime ?: [NSNull null],
    self.minAutoAdjustCacheTime ?: [NSNull null],
    self.videoBlockThreshold ?: [NSNull null],
    self.connectRetryCount ?: [NSNull null],
    self.connectRetryInterval ?: [NSNull null],
    self.autoAdjustCacheTime ?: [NSNull null],
    self.enableAec ?: [NSNull null],
    self.enableMessage ?: [NSNull null],
    self.enableMetaData ?: [NSNull null],
    self.flvSessionKey ?: [NSNull null],
  ];
}
@end

@implementation TXVodDownloadMediaMsg
+ (instancetype)makeWithPlayPath:(nullable NSString *)playPath
    progress:(nullable NSNumber *)progress
    downloadState:(nullable NSNumber *)downloadState
    userName:(nullable NSString *)userName
    duration:(nullable NSNumber *)duration
    playableDuration:(nullable NSNumber *)playableDuration
    size:(nullable NSNumber *)size
    downloadSize:(nullable NSNumber *)downloadSize
    url:(nullable NSString *)url
    appId:(nullable NSNumber *)appId
    fileId:(nullable NSString *)fileId
    pSign:(nullable NSString *)pSign
    quality:(nullable NSNumber *)quality
    token:(nullable NSString *)token
    speed:(nullable NSNumber *)speed
    isResourceBroken:(nullable NSNumber *)isResourceBroken {
  TXVodDownloadMediaMsg* pigeonResult = [[TXVodDownloadMediaMsg alloc] init];
  pigeonResult.playPath = playPath;
  pigeonResult.progress = progress;
  pigeonResult.downloadState = downloadState;
  pigeonResult.userName = userName;
  pigeonResult.duration = duration;
  pigeonResult.playableDuration = playableDuration;
  pigeonResult.size = size;
  pigeonResult.downloadSize = downloadSize;
  pigeonResult.url = url;
  pigeonResult.appId = appId;
  pigeonResult.fileId = fileId;
  pigeonResult.pSign = pSign;
  pigeonResult.quality = quality;
  pigeonResult.token = token;
  pigeonResult.speed = speed;
  pigeonResult.isResourceBroken = isResourceBroken;
  return pigeonResult;
}
+ (TXVodDownloadMediaMsg *)fromList:(NSArray<id> *)list {
  TXVodDownloadMediaMsg *pigeonResult = [[TXVodDownloadMediaMsg alloc] init];
  pigeonResult.playPath = GetNullableObjectAtIndex(list, 0);
  pigeonResult.progress = GetNullableObjectAtIndex(list, 1);
  pigeonResult.downloadState = GetNullableObjectAtIndex(list, 2);
  pigeonResult.userName = GetNullableObjectAtIndex(list, 3);
  pigeonResult.duration = GetNullableObjectAtIndex(list, 4);
  pigeonResult.playableDuration = GetNullableObjectAtIndex(list, 5);
  pigeonResult.size = GetNullableObjectAtIndex(list, 6);
  pigeonResult.downloadSize = GetNullableObjectAtIndex(list, 7);
  pigeonResult.url = GetNullableObjectAtIndex(list, 8);
  pigeonResult.appId = GetNullableObjectAtIndex(list, 9);
  pigeonResult.fileId = GetNullableObjectAtIndex(list, 10);
  pigeonResult.pSign = GetNullableObjectAtIndex(list, 11);
  pigeonResult.quality = GetNullableObjectAtIndex(list, 12);
  pigeonResult.token = GetNullableObjectAtIndex(list, 13);
  pigeonResult.speed = GetNullableObjectAtIndex(list, 14);
  pigeonResult.isResourceBroken = GetNullableObjectAtIndex(list, 15);
  return pigeonResult;
}
+ (nullable TXVodDownloadMediaMsg *)nullableFromList:(NSArray<id> *)list {
  return (list) ? [TXVodDownloadMediaMsg fromList:list] : nil;
}
- (NSArray<id> *)toList {
  return @[
    self.playPath ?: [NSNull null],
    self.progress ?: [NSNull null],
    self.downloadState ?: [NSNull null],
    self.userName ?: [NSNull null],
    self.duration ?: [NSNull null],
    self.playableDuration ?: [NSNull null],
    self.size ?: [NSNull null],
    self.downloadSize ?: [NSNull null],
    self.url ?: [NSNull null],
    self.appId ?: [NSNull null],
    self.fileId ?: [NSNull null],
    self.pSign ?: [NSNull null],
    self.quality ?: [NSNull null],
    self.token ?: [NSNull null],
    self.speed ?: [NSNull null],
    self.isResourceBroken ?: [NSNull null],
  ];
}
@end

@implementation TXDownloadListMsg
+ (instancetype)makeWithInfoList:(nullable NSArray<TXVodDownloadMediaMsg *> *)infoList {
  TXDownloadListMsg* pigeonResult = [[TXDownloadListMsg alloc] init];
  pigeonResult.infoList = infoList;
  return pigeonResult;
}
+ (TXDownloadListMsg *)fromList:(NSArray<id> *)list {
  TXDownloadListMsg *pigeonResult = [[TXDownloadListMsg alloc] init];
  pigeonResult.infoList = GetNullableObjectAtIndex(list, 0);
  return pigeonResult;
}
+ (nullable TXDownloadListMsg *)nullableFromList:(NSArray<id> *)list {
  return (list) ? [TXDownloadListMsg fromList:list] : nil;
}
- (NSArray<id> *)toList {
  return @[
    self.infoList ?: [NSNull null],
  ];
}
@end

@implementation UInt8ListMsg
+ (instancetype)makeWithValue:(nullable FlutterStandardTypedData *)value {
  UInt8ListMsg* pigeonResult = [[UInt8ListMsg alloc] init];
  pigeonResult.value = value;
  return pigeonResult;
}
+ (UInt8ListMsg *)fromList:(NSArray<id> *)list {
  UInt8ListMsg *pigeonResult = [[UInt8ListMsg alloc] init];
  pigeonResult.value = GetNullableObjectAtIndex(list, 0);
  return pigeonResult;
}
+ (nullable UInt8ListMsg *)nullableFromList:(NSArray<id> *)list {
  return (list) ? [UInt8ListMsg fromList:list] : nil;
}
- (NSArray<id> *)toList {
  return @[
    self.value ?: [NSNull null],
  ];
}
@end

@implementation ListMsg
+ (instancetype)makeWithValue:(nullable NSArray<id> *)value {
  ListMsg* pigeonResult = [[ListMsg alloc] init];
  pigeonResult.value = value;
  return pigeonResult;
}
+ (ListMsg *)fromList:(NSArray<id> *)list {
  ListMsg *pigeonResult = [[ListMsg alloc] init];
  pigeonResult.value = GetNullableObjectAtIndex(list, 0);
  return pigeonResult;
}
+ (nullable ListMsg *)nullableFromList:(NSArray<id> *)list {
  return (list) ? [ListMsg fromList:list] : nil;
}
- (NSArray<id> *)toList {
  return @[
    self.value ?: [NSNull null],
  ];
}
@end

@implementation BoolMsg
+ (instancetype)makeWithValue:(nullable NSNumber *)value {
  BoolMsg* pigeonResult = [[BoolMsg alloc] init];
  pigeonResult.value = value;
  return pigeonResult;
}
+ (BoolMsg *)fromList:(NSArray<id> *)list {
  BoolMsg *pigeonResult = [[BoolMsg alloc] init];
  pigeonResult.value = GetNullableObjectAtIndex(list, 0);
  return pigeonResult;
}
+ (nullable BoolMsg *)nullableFromList:(NSArray<id> *)list {
  return (list) ? [BoolMsg fromList:list] : nil;
}
- (NSArray<id> *)toList {
  return @[
    self.value ?: [NSNull null],
  ];
}
@end

@implementation IntMsg
+ (instancetype)makeWithValue:(nullable NSNumber *)value {
  IntMsg* pigeonResult = [[IntMsg alloc] init];
  pigeonResult.value = value;
  return pigeonResult;
}
+ (IntMsg *)fromList:(NSArray<id> *)list {
  IntMsg *pigeonResult = [[IntMsg alloc] init];
  pigeonResult.value = GetNullableObjectAtIndex(list, 0);
  return pigeonResult;
}
+ (nullable IntMsg *)nullableFromList:(NSArray<id> *)list {
  return (list) ? [IntMsg fromList:list] : nil;
}
- (NSArray<id> *)toList {
  return @[
    self.value ?: [NSNull null],
  ];
}
@end

@implementation StringMsg
+ (instancetype)makeWithValue:(nullable NSString *)value {
  StringMsg* pigeonResult = [[StringMsg alloc] init];
  pigeonResult.value = value;
  return pigeonResult;
}
+ (StringMsg *)fromList:(NSArray<id> *)list {
  StringMsg *pigeonResult = [[StringMsg alloc] init];
  pigeonResult.value = GetNullableObjectAtIndex(list, 0);
  return pigeonResult;
}
+ (nullable StringMsg *)nullableFromList:(NSArray<id> *)list {
  return (list) ? [StringMsg fromList:list] : nil;
}
- (NSArray<id> *)toList {
  return @[
    self.value ?: [NSNull null],
  ];
}
@end

@implementation CachePathMsg
+ (instancetype)makeWithAndroidAbsolutePath:(nullable NSString *)androidAbsolutePath
    iOSAbsolutePath:(nullable NSString *)iOSAbsolutePath {
  CachePathMsg* pigeonResult = [[CachePathMsg alloc] init];
  pigeonResult.androidAbsolutePath = androidAbsolutePath;
  pigeonResult.iOSAbsolutePath = iOSAbsolutePath;
  return pigeonResult;
}
+ (CachePathMsg *)fromList:(NSArray<id> *)list {
  CachePathMsg *pigeonResult = [[CachePathMsg alloc] init];
  pigeonResult.androidAbsolutePath = GetNullableObjectAtIndex(list, 0);
  pigeonResult.iOSAbsolutePath = GetNullableObjectAtIndex(list, 1);
  return pigeonResult;
}
+ (nullable CachePathMsg *)nullableFromList:(NSArray<id> *)list {
  return (list) ? [CachePathMsg fromList:list] : nil;
}
- (NSArray<id> *)toList {
  return @[
    self.androidAbsolutePath ?: [NSNull null],
    self.iOSAbsolutePath ?: [NSNull null],
  ];
}
@end

@implementation DoubleMsg
+ (instancetype)makeWithValue:(nullable NSNumber *)value {
  DoubleMsg* pigeonResult = [[DoubleMsg alloc] init];
  pigeonResult.value = value;
  return pigeonResult;
}
+ (DoubleMsg *)fromList:(NSArray<id> *)list {
  DoubleMsg *pigeonResult = [[DoubleMsg alloc] init];
  pigeonResult.value = GetNullableObjectAtIndex(list, 0);
  return pigeonResult;
}
+ (nullable DoubleMsg *)nullableFromList:(NSArray<id> *)list {
  return (list) ? [DoubleMsg fromList:list] : nil;
}
- (NSArray<id> *)toList {
  return @[
    self.value ?: [NSNull null],
  ];
}
@end

@implementation PreLoadMsg
+ (instancetype)makeWithPlayUrl:(nullable NSString *)playUrl
    preloadSizeMB:(nullable NSNumber *)preloadSizeMB
    preferredResolution:(nullable NSNumber *)preferredResolution {
  PreLoadMsg* pigeonResult = [[PreLoadMsg alloc] init];
  pigeonResult.playUrl = playUrl;
  pigeonResult.preloadSizeMB = preloadSizeMB;
  pigeonResult.preferredResolution = preferredResolution;
  return pigeonResult;
}
+ (PreLoadMsg *)fromList:(NSArray<id> *)list {
  PreLoadMsg *pigeonResult = [[PreLoadMsg alloc] init];
  pigeonResult.playUrl = GetNullableObjectAtIndex(list, 0);
  pigeonResult.preloadSizeMB = GetNullableObjectAtIndex(list, 1);
  pigeonResult.preferredResolution = GetNullableObjectAtIndex(list, 2);
  return pigeonResult;
}
+ (nullable PreLoadMsg *)nullableFromList:(NSArray<id> *)list {
  return (list) ? [PreLoadMsg fromList:list] : nil;
}
- (NSArray<id> *)toList {
  return @[
    self.playUrl ?: [NSNull null],
    self.preloadSizeMB ?: [NSNull null],
    self.preferredResolution ?: [NSNull null],
  ];
}
@end

@implementation PreLoadInfoMsg
+ (instancetype)makeWithAppId:(nullable NSNumber *)appId
    fileId:(nullable NSString *)fileId
    pSign:(nullable NSString *)pSign
    playUrl:(nullable NSString *)playUrl
    preloadSizeMB:(nullable NSNumber *)preloadSizeMB
    preferredResolution:(nullable NSNumber *)preferredResolution
    tmpPreloadTaskId:(nullable NSNumber *)tmpPreloadTaskId
    httpHeader:(nullable NSDictionary<NSString *, NSString *> *)httpHeader {
  PreLoadInfoMsg* pigeonResult = [[PreLoadInfoMsg alloc] init];
  pigeonResult.appId = appId;
  pigeonResult.fileId = fileId;
  pigeonResult.pSign = pSign;
  pigeonResult.playUrl = playUrl;
  pigeonResult.preloadSizeMB = preloadSizeMB;
  pigeonResult.preferredResolution = preferredResolution;
  pigeonResult.tmpPreloadTaskId = tmpPreloadTaskId;
  pigeonResult.httpHeader = httpHeader;
  return pigeonResult;
}
+ (PreLoadInfoMsg *)fromList:(NSArray<id> *)list {
  PreLoadInfoMsg *pigeonResult = [[PreLoadInfoMsg alloc] init];
  pigeonResult.appId = GetNullableObjectAtIndex(list, 0);
  pigeonResult.fileId = GetNullableObjectAtIndex(list, 1);
  pigeonResult.pSign = GetNullableObjectAtIndex(list, 2);
  pigeonResult.playUrl = GetNullableObjectAtIndex(list, 3);
  pigeonResult.preloadSizeMB = GetNullableObjectAtIndex(list, 4);
  pigeonResult.preferredResolution = GetNullableObjectAtIndex(list, 5);
  pigeonResult.tmpPreloadTaskId = GetNullableObjectAtIndex(list, 6);
  pigeonResult.httpHeader = GetNullableObjectAtIndex(list, 7);
  return pigeonResult;
}
+ (nullable PreLoadInfoMsg *)nullableFromList:(NSArray<id> *)list {
  return (list) ? [PreLoadInfoMsg fromList:list] : nil;
}
- (NSArray<id> *)toList {
  return @[
    self.appId ?: [NSNull null],
    self.fileId ?: [NSNull null],
    self.pSign ?: [NSNull null],
    self.playUrl ?: [NSNull null],
    self.preloadSizeMB ?: [NSNull null],
    self.preferredResolution ?: [NSNull null],
    self.tmpPreloadTaskId ?: [NSNull null],
    self.httpHeader ?: [NSNull null],
  ];
}
@end

@implementation MapMsg
+ (instancetype)makeWithMap:(nullable NSDictionary<NSString *, NSString *> *)map {
  MapMsg* pigeonResult = [[MapMsg alloc] init];
  pigeonResult.map = map;
  return pigeonResult;
}
+ (MapMsg *)fromList:(NSArray<id> *)list {
  MapMsg *pigeonResult = [[MapMsg alloc] init];
  pigeonResult.map = GetNullableObjectAtIndex(list, 0);
  return pigeonResult;
}
+ (nullable MapMsg *)nullableFromList:(NSArray<id> *)list {
  return (list) ? [MapMsg fromList:list] : nil;
}
- (NSArray<id> *)toList {
  return @[
    self.map ?: [NSNull null],
  ];
}
@end

@implementation SubTitlePlayerMsg
+ (instancetype)makeWithUrl:(NSString *)url
    name:(NSString *)name
    mimeType:(nullable NSString *)mimeType
    playerId:(nullable NSNumber *)playerId {
  SubTitlePlayerMsg* pigeonResult = [[SubTitlePlayerMsg alloc] init];
  pigeonResult.url = url;
  pigeonResult.name = name;
  pigeonResult.mimeType = mimeType;
  pigeonResult.playerId = playerId;
  return pigeonResult;
}
+ (SubTitlePlayerMsg *)fromList:(NSArray<id> *)list {
  SubTitlePlayerMsg *pigeonResult = [[SubTitlePlayerMsg alloc] init];
  pigeonResult.url = GetNullableObjectAtIndex(list, 0);
  pigeonResult.name = GetNullableObjectAtIndex(list, 1);
  pigeonResult.mimeType = GetNullableObjectAtIndex(list, 2);
  pigeonResult.playerId = GetNullableObjectAtIndex(list, 3);
  return pigeonResult;
}
+ (nullable SubTitlePlayerMsg *)nullableFromList:(NSArray<id> *)list {
  return (list) ? [SubTitlePlayerMsg fromList:list] : nil;
}
- (NSArray<id> *)toList {
  return @[
    self.url ?: [NSNull null],
    self.name ?: [NSNull null],
    self.mimeType ?: [NSNull null],
    self.playerId ?: [NSNull null],
  ];
}
@end

@implementation SubTitleRenderModelPlayerMsg
+ (instancetype)makeWithCanvasWidth:(nullable NSNumber *)canvasWidth
    canvasHeight:(nullable NSNumber *)canvasHeight
    familyName:(nullable NSString *)familyName
    fontSize:(nullable NSNumber *)fontSize
    fontScale:(nullable NSNumber *)fontScale
    fontColor:(nullable NSNumber *)fontColor
    isBondFontStyle:(nullable NSNumber *)isBondFontStyle
    outlineWidth:(nullable NSNumber *)outlineWidth
    outlineColor:(nullable NSNumber *)outlineColor
    lineSpace:(nullable NSNumber *)lineSpace
    startMargin:(nullable NSNumber *)startMargin
    endMargin:(nullable NSNumber *)endMargin
    verticalMargin:(nullable NSNumber *)verticalMargin
    playerId:(nullable NSNumber *)playerId {
  SubTitleRenderModelPlayerMsg* pigeonResult = [[SubTitleRenderModelPlayerMsg alloc] init];
  pigeonResult.canvasWidth = canvasWidth;
  pigeonResult.canvasHeight = canvasHeight;
  pigeonResult.familyName = familyName;
  pigeonResult.fontSize = fontSize;
  pigeonResult.fontScale = fontScale;
  pigeonResult.fontColor = fontColor;
  pigeonResult.isBondFontStyle = isBondFontStyle;
  pigeonResult.outlineWidth = outlineWidth;
  pigeonResult.outlineColor = outlineColor;
  pigeonResult.lineSpace = lineSpace;
  pigeonResult.startMargin = startMargin;
  pigeonResult.endMargin = endMargin;
  pigeonResult.verticalMargin = verticalMargin;
  pigeonResult.playerId = playerId;
  return pigeonResult;
}
+ (SubTitleRenderModelPlayerMsg *)fromList:(NSArray<id> *)list {
  SubTitleRenderModelPlayerMsg *pigeonResult = [[SubTitleRenderModelPlayerMsg alloc] init];
  pigeonResult.canvasWidth = GetNullableObjectAtIndex(list, 0);
  pigeonResult.canvasHeight = GetNullableObjectAtIndex(list, 1);
  pigeonResult.familyName = GetNullableObjectAtIndex(list, 2);
  pigeonResult.fontSize = GetNullableObjectAtIndex(list, 3);
  pigeonResult.fontScale = GetNullableObjectAtIndex(list, 4);
  pigeonResult.fontColor = GetNullableObjectAtIndex(list, 5);
  pigeonResult.isBondFontStyle = GetNullableObjectAtIndex(list, 6);
  pigeonResult.outlineWidth = GetNullableObjectAtIndex(list, 7);
  pigeonResult.outlineColor = GetNullableObjectAtIndex(list, 8);
  pigeonResult.lineSpace = GetNullableObjectAtIndex(list, 9);
  pigeonResult.startMargin = GetNullableObjectAtIndex(list, 10);
  pigeonResult.endMargin = GetNullableObjectAtIndex(list, 11);
  pigeonResult.verticalMargin = GetNullableObjectAtIndex(list, 12);
  pigeonResult.playerId = GetNullableObjectAtIndex(list, 13);
  return pigeonResult;
}
+ (nullable SubTitleRenderModelPlayerMsg *)nullableFromList:(NSArray<id> *)list {
  return (list) ? [SubTitleRenderModelPlayerMsg fromList:list] : nil;
}
- (NSArray<id> *)toList {
  return @[
    self.canvasWidth ?: [NSNull null],
    self.canvasHeight ?: [NSNull null],
    self.familyName ?: [NSNull null],
    self.fontSize ?: [NSNull null],
    self.fontScale ?: [NSNull null],
    self.fontColor ?: [NSNull null],
    self.isBondFontStyle ?: [NSNull null],
    self.outlineWidth ?: [NSNull null],
    self.outlineColor ?: [NSNull null],
    self.lineSpace ?: [NSNull null],
    self.startMargin ?: [NSNull null],
    self.endMargin ?: [NSNull null],
    self.verticalMargin ?: [NSNull null],
    self.playerId ?: [NSNull null],
  ];
}
@end

@implementation StringOptionPlayerMsg
+ (instancetype)makeWithKey:(nullable NSString *)key
    value:(nullable NSArray<id> *)value
    playerId:(nullable NSNumber *)playerId {
  StringOptionPlayerMsg* pigeonResult = [[StringOptionPlayerMsg alloc] init];
  pigeonResult.key = key;
  pigeonResult.value = value;
  pigeonResult.playerId = playerId;
  return pigeonResult;
}
+ (StringOptionPlayerMsg *)fromList:(NSArray<id> *)list {
  StringOptionPlayerMsg *pigeonResult = [[StringOptionPlayerMsg alloc] init];
  pigeonResult.key = GetNullableObjectAtIndex(list, 0);
  pigeonResult.value = GetNullableObjectAtIndex(list, 1);
  pigeonResult.playerId = GetNullableObjectAtIndex(list, 2);
  return pigeonResult;
}
+ (nullable StringOptionPlayerMsg *)nullableFromList:(NSArray<id> *)list {
  return (list) ? [StringOptionPlayerMsg fromList:list] : nil;
}
- (NSArray<id> *)toList {
  return @[
    self.key ?: [NSNull null],
    self.value ?: [NSNull null],
    self.playerId ?: [NSNull null],
  ];
}
@end

@interface nullFtxMessagesPigeonCodecReader : FlutterStandardReader
@end
@implementation nullFtxMessagesPigeonCodecReader
- (nullable id)readValueOfType:(UInt8)type {
  switch (type) {
    case 129: 
      return [PlayerMsg fromList:[self readValue]];
    case 130: 
      return [LicenseMsg fromList:[self readValue]];
    case 131: 
      return [TXPlayInfoParamsPlayerMsg fromList:[self readValue]];
    case 132: 
      return [TXPlayerDrmMsg fromList:[self readValue]];
    case 133: 
      return [PipParamsPlayerMsg fromList:[self readValue]];
    case 134: 
      return [StringListPlayerMsg fromList:[self readValue]];
    case 135: 
      return [BoolPlayerMsg fromList:[self readValue]];
    case 136: 
      return [StringIntPlayerMsg fromList:[self readValue]];
    case 137: 
      return [StringPlayerMsg fromList:[self readValue]];
    case 138: 
      return [DoublePlayerMsg fromList:[self readValue]];
    case 139: 
      return [IntPlayerMsg fromList:[self readValue]];
    case 140: 
      return [FTXVodPlayConfigPlayerMsg fromList:[self readValue]];
    case 141: 
      return [FTXLivePlayConfigPlayerMsg fromList:[self readValue]];
    case 142: 
      return [TXVodDownloadMediaMsg fromList:[self readValue]];
    case 143: 
      return [TXDownloadListMsg fromList:[self readValue]];
    case 144: 
      return [UInt8ListMsg fromList:[self readValue]];
    case 145: 
      return [ListMsg fromList:[self readValue]];
    case 146: 
      return [BoolMsg fromList:[self readValue]];
    case 147: 
      return [IntMsg fromList:[self readValue]];
    case 148: 
      return [StringMsg fromList:[self readValue]];
    case 149: 
      return [CachePathMsg fromList:[self readValue]];
    case 150: 
      return [DoubleMsg fromList:[self readValue]];
    case 151: 
      return [PreLoadMsg fromList:[self readValue]];
    case 152: 
      return [PreLoadInfoMsg fromList:[self readValue]];
    case 153: 
      return [MapMsg fromList:[self readValue]];
    case 154: 
      return [SubTitlePlayerMsg fromList:[self readValue]];
    case 155: 
      return [SubTitleRenderModelPlayerMsg fromList:[self readValue]];
    case 156: 
      return [StringOptionPlayerMsg fromList:[self readValue]];
    default:
      return [super readValueOfType:type];
  }
}
@end

@interface nullFtxMessagesPigeonCodecWriter : FlutterStandardWriter
@end
@implementation nullFtxMessagesPigeonCodecWriter
- (void)writeValue:(id)value {
  if ([value isKindOfClass:[PlayerMsg class]]) {
    [self writeByte:129];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[LicenseMsg class]]) {
    [self writeByte:130];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[TXPlayInfoParamsPlayerMsg class]]) {
    [self writeByte:131];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[TXPlayerDrmMsg class]]) {
    [self writeByte:132];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[PipParamsPlayerMsg class]]) {
    [self writeByte:133];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[StringListPlayerMsg class]]) {
    [self writeByte:134];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[BoolPlayerMsg class]]) {
    [self writeByte:135];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[StringIntPlayerMsg class]]) {
    [self writeByte:136];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[StringPlayerMsg class]]) {
    [self writeByte:137];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[DoublePlayerMsg class]]) {
    [self writeByte:138];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[IntPlayerMsg class]]) {
    [self writeByte:139];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[FTXVodPlayConfigPlayerMsg class]]) {
    [self writeByte:140];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[FTXLivePlayConfigPlayerMsg class]]) {
    [self writeByte:141];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[TXVodDownloadMediaMsg class]]) {
    [self writeByte:142];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[TXDownloadListMsg class]]) {
    [self writeByte:143];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[UInt8ListMsg class]]) {
    [self writeByte:144];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[ListMsg class]]) {
    [self writeByte:145];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[BoolMsg class]]) {
    [self writeByte:146];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[IntMsg class]]) {
    [self writeByte:147];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[StringMsg class]]) {
    [self writeByte:148];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[CachePathMsg class]]) {
    [self writeByte:149];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[DoubleMsg class]]) {
    [self writeByte:150];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[PreLoadMsg class]]) {
    [self writeByte:151];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[PreLoadInfoMsg class]]) {
    [self writeByte:152];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[MapMsg class]]) {
    [self writeByte:153];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[SubTitlePlayerMsg class]]) {
    [self writeByte:154];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[SubTitleRenderModelPlayerMsg class]]) {
    [self writeByte:155];
    [self writeValue:[value toList]];
  } else if ([value isKindOfClass:[StringOptionPlayerMsg class]]) {
    [self writeByte:156];
    [self writeValue:[value toList]];
  } else {
    [super writeValue:value];
  }
}
@end

@interface nullFtxMessagesPigeonCodecReaderWriter : FlutterStandardReaderWriter
@end
@implementation nullFtxMessagesPigeonCodecReaderWriter
- (FlutterStandardWriter *)writerWithData:(NSMutableData *)data {
  return [[nullFtxMessagesPigeonCodecWriter alloc] initWithData:data];
}
- (FlutterStandardReader *)readerWithData:(NSData *)data {
  return [[nullFtxMessagesPigeonCodecReader alloc] initWithData:data];
}
@end

NSObject<FlutterMessageCodec> *nullGetFtxMessagesCodec(void) {
  static FlutterStandardMessageCodec *sSharedObject = nil;
  static dispatch_once_t sPred = 0;
  dispatch_once(&sPred, ^{
    nullFtxMessagesPigeonCodecReaderWriter *readerWriter = [[nullFtxMessagesPigeonCodecReaderWriter alloc] init];
    sSharedObject = [FlutterStandardMessageCodec codecWithReaderWriter:readerWriter];
  });
  return sSharedObject;
}
void SetUpTXFlutterSuperPlayerPluginAPI(id<FlutterBinaryMessenger> binaryMessenger, NSObject<TXFlutterSuperPlayerPluginAPI> *api) {
  SetUpTXFlutterSuperPlayerPluginAPIWithSuffix(binaryMessenger, api, @"");
}

void SetUpTXFlutterSuperPlayerPluginAPIWithSuffix(id<FlutterBinaryMessenger> binaryMessenger, NSObject<TXFlutterSuperPlayerPluginAPI> *api, NSString *messageChannelSuffix) {
  messageChannelSuffix = messageChannelSuffix.length > 0 ? [NSString stringWithFormat: @".%@", messageChannelSuffix] : @"";
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.getPlatformVersion", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getPlatformVersionWithError:)], @"TXFlutterSuperPlayerPluginAPI api (%@) doesn't respond to @selector(getPlatformVersionWithError:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        FlutterError *error;
        StringMsg *output = [api getPlatformVersionWithError:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 创建点播播放器
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.createVodPlayer", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(createVodPlayerWithError:)], @"TXFlutterSuperPlayerPluginAPI api (%@) doesn't respond to @selector(createVodPlayerWithError:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        FlutterError *error;
        PlayerMsg *output = [api createVodPlayerWithError:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 创建直播播放器
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.createLivePlayer", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(createLivePlayerWithError:)], @"TXFlutterSuperPlayerPluginAPI api (%@) doesn't respond to @selector(createLivePlayerWithError:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        FlutterError *error;
        PlayerMsg *output = [api createLivePlayerWithError:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 开关log输出
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.setConsoleEnabled", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setConsoleEnabledEnabled:error:)], @"TXFlutterSuperPlayerPluginAPI api (%@) doesn't respond to @selector(setConsoleEnabledEnabled:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        BoolMsg *arg_enabled = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setConsoleEnabledEnabled:arg_enabled error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 释放播放器资源
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.releasePlayer", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(releasePlayerPlayerId:error:)], @"TXFlutterSuperPlayerPluginAPI api (%@) doesn't respond to @selector(releasePlayerPlayerId:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        PlayerMsg *arg_playerId = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api releasePlayerPlayerId:arg_playerId error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置播放引擎的最大缓存大小。设置后会根据设定值自动清理Cache目录的文件
  /// @param size 最大缓存大小（单位：MB)
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.setGlobalMaxCacheSize", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setGlobalMaxCacheSizeSize:error:)], @"TXFlutterSuperPlayerPluginAPI api (%@) doesn't respond to @selector(setGlobalMaxCacheSizeSize:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        IntMsg *arg_size = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setGlobalMaxCacheSizeSize:arg_size error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 在短视频播放场景中，视频文件的本地缓存是很刚需的一个特性，对于普通用户而言，一个已经看过的视频再次观看时，不应该再消耗一次流量。
  ///  @格式支持：SDK 支持 HLS(m3u8) 和 MP4 两种常见点播格式的缓存功能。
  ///  @开启时机：SDK 并不默认开启缓存功能，对于用户回看率不高的场景，也并不推荐您开启此功能。
  ///  @开启方式：全局生效，在使用播放器开启。开启此功能需要配置两个参数：本地缓存目录及缓存大小。
  ///
  /// 该缓存路径默认设置到app沙盒目录下，postfixPath只需要传递相对缓存目录即可，不需要传递整个绝对路径。
  /// e.g. postfixPath = 'testCache'
  /// Android 平台：视频将会缓存到sdcard的Android/data/your-pkg-name/files/testCache 目录。
  /// iOS 平台：视频将会缓存到沙盒的Documents/testCache 目录。
  /// @param postfixPath 缓存目录
  /// @return true 设置成功 false 设置失败
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.setGlobalCacheFolderPath", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setGlobalCacheFolderPathPostfixPath:error:)], @"TXFlutterSuperPlayerPluginAPI api (%@) doesn't respond to @selector(setGlobalCacheFolderPathPostfixPath:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        StringMsg *arg_postfixPath = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        BoolMsg *output = [api setGlobalCacheFolderPathPostfixPath:arg_postfixPath error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置播放器资源缓存目录绝对路径，该方法会与 setGlobalCacheFolderPath(String postfixPath) 相互覆盖，调用其中一个即可
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.setGlobalCacheFolderCustomPath", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setGlobalCacheFolderCustomPathCacheMsg:error:)], @"TXFlutterSuperPlayerPluginAPI api (%@) doesn't respond to @selector(setGlobalCacheFolderCustomPathCacheMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        CachePathMsg *arg_cacheMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        BoolMsg *output = [api setGlobalCacheFolderCustomPathCacheMsg:arg_cacheMsg error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置全局license
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.setGlobalLicense", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setGlobalLicenseLicenseMsg:error:)], @"TXFlutterSuperPlayerPluginAPI api (%@) doesn't respond to @selector(setGlobalLicenseLicenseMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        LicenseMsg *arg_licenseMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setGlobalLicenseLicenseMsg:arg_licenseMsg error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置log输出级别 [TXLogLevel]
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.setLogLevel", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setLogLevelLogLevel:error:)], @"TXFlutterSuperPlayerPluginAPI api (%@) doesn't respond to @selector(setLogLevelLogLevel:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        IntMsg *arg_logLevel = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setLogLevelLogLevel:arg_logLevel error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 获取依赖Native端的 LiteAVSDK 的版本
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.getLiteAVSDKVersion", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getLiteAVSDKVersionWithError:)], @"TXFlutterSuperPlayerPluginAPI api (%@) doesn't respond to @selector(getLiteAVSDKVersionWithError:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        FlutterError *error;
        StringMsg *output = [api getLiteAVSDKVersionWithError:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  ///
  /// 设置 liteav SDK 接入的环境。
  /// 腾讯云在全球各地区部署的环境，按照各地区政策法规要求，需要接入不同地区接入点。
  ///
  /// @param envConfig 需要接入的环境，SDK 默认接入的环境是：默认正式环境。
  /// @return 0：成功；其他：错误
  /// @note 目标市场为中国大陆的客户请不要调用此接口，如果目标市场为海外用户，请通过技术支持联系我们，了解 env_config 的配置方法，以确保 App 遵守 GDPR 标准。
  ///
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.setGlobalEnv", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setGlobalEnvEnvConfig:error:)], @"TXFlutterSuperPlayerPluginAPI api (%@) doesn't respond to @selector(setGlobalEnvEnvConfig:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        StringMsg *arg_envConfig = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        IntMsg *output = [api setGlobalEnvEnvConfig:arg_envConfig error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  ///
  /// 开始监听设备旋转方向，开启之后，如果设备自动旋转打开，播放器会自动根据当前设备方向来旋转视频方向。
  /// <h1>该接口目前只适用安卓端，IOS端会自动开启该能力</h1>
  /// 在调用该接口前，请务必向用户告知隐私风险。
  /// 如有需要，请确认是否有获取旋转sensor的权限。
  /// @return true : 开启成功
  ///         false : 开启失败，如开启过早，还未等到上下文初始化、获取sensor失败等原因
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.startVideoOrientationService", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(startVideoOrientationServiceWithError:)], @"TXFlutterSuperPlayerPluginAPI api (%@) doesn't respond to @selector(startVideoOrientationServiceWithError:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        FlutterError *error;
        BoolMsg *output = [api startVideoOrientationServiceWithError:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.setUserId", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setUserIdMsg:error:)], @"TXFlutterSuperPlayerPluginAPI api (%@) doesn't respond to @selector(setUserIdMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        StringMsg *arg_msg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setUserIdMsg:arg_msg error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.setLicenseFlexibleValid", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setLicenseFlexibleValidMsg:error:)], @"TXFlutterSuperPlayerPluginAPI api (%@) doesn't respond to @selector(setLicenseFlexibleValidMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        BoolMsg *arg_msg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setLicenseFlexibleValidMsg:arg_msg error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
}
void SetUpTXFlutterNativeAPI(id<FlutterBinaryMessenger> binaryMessenger, NSObject<TXFlutterNativeAPI> *api) {
  SetUpTXFlutterNativeAPIWithSuffix(binaryMessenger, api, @"");
}

void SetUpTXFlutterNativeAPIWithSuffix(id<FlutterBinaryMessenger> binaryMessenger, NSObject<TXFlutterNativeAPI> *api, NSString *messageChannelSuffix) {
  messageChannelSuffix = messageChannelSuffix.length > 0 ? [NSString stringWithFormat: @".%@", messageChannelSuffix] : @"";
  /// 修改当前界面亮度
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterNativeAPI.setBrightness", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setBrightnessBrightness:error:)], @"TXFlutterNativeAPI api (%@) doesn't respond to @selector(setBrightnessBrightness:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        DoubleMsg *arg_brightness = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setBrightnessBrightness:arg_brightness error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 恢复当前界面亮度
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterNativeAPI.restorePageBrightness", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(restorePageBrightnessWithError:)], @"TXFlutterNativeAPI api (%@) doesn't respond to @selector(restorePageBrightnessWithError:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        FlutterError *error;
        [api restorePageBrightnessWithError:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 获得当前界面亮度 0.0 ~ 1.0
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterNativeAPI.getBrightness", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getBrightnessWithError:)], @"TXFlutterNativeAPI api (%@) doesn't respond to @selector(getBrightnessWithError:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        FlutterError *error;
        DoubleMsg *output = [api getBrightnessWithError:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 获取系统界面亮度，IOS系统与界面亮度一致，安卓可能会有差异
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterNativeAPI.getSysBrightness", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getSysBrightnessWithError:)], @"TXFlutterNativeAPI api (%@) doesn't respond to @selector(getSysBrightnessWithError:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        FlutterError *error;
        DoubleMsg *output = [api getSysBrightnessWithError:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置当前系统音量，0.0 ~ 1.0
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterNativeAPI.setSystemVolume", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setSystemVolumeVolume:error:)], @"TXFlutterNativeAPI api (%@) doesn't respond to @selector(setSystemVolumeVolume:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        DoubleMsg *arg_volume = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setSystemVolumeVolume:arg_volume error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 获得当前系统音量，范围：0.0 ~ 1.0
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterNativeAPI.getSystemVolume", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getSystemVolumeWithError:)], @"TXFlutterNativeAPI api (%@) doesn't respond to @selector(getSystemVolumeWithError:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        FlutterError *error;
        DoubleMsg *output = [api getSystemVolumeWithError:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 释放音频焦点，只用于安卓端
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterNativeAPI.abandonAudioFocus", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(abandonAudioFocusWithError:)], @"TXFlutterNativeAPI api (%@) doesn't respond to @selector(abandonAudioFocusWithError:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        FlutterError *error;
        [api abandonAudioFocusWithError:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 请求获得音频焦点，只用于安卓端
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterNativeAPI.requestAudioFocus", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(requestAudioFocusWithError:)], @"TXFlutterNativeAPI api (%@) doesn't respond to @selector(requestAudioFocusWithError:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        FlutterError *error;
        [api requestAudioFocusWithError:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 当前设备是否支持画中画模式
  /// @return [TXVodPlayEvent]
  ///  0 可开启画中画模式
  ///  -101  android版本过低
  ///  -102  画中画权限关闭/设备不支持画中画
  ///  -103  当前界面已销毁
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterNativeAPI.isDeviceSupportPip", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(isDeviceSupportPipWithError:)], @"TXFlutterNativeAPI api (%@) doesn't respond to @selector(isDeviceSupportPipWithError:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        FlutterError *error;
        IntMsg *output = [api isDeviceSupportPipWithError:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  ///
  /// register or unregister system brightness
  ///
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterNativeAPI.registerSysBrightness", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(registerSysBrightnessIsRegister:error:)], @"TXFlutterNativeAPI api (%@) doesn't respond to @selector(registerSysBrightnessIsRegister:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        BoolMsg *arg_isRegister = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api registerSysBrightnessIsRegister:arg_isRegister error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
}
void SetUpTXFlutterVodPlayerApi(id<FlutterBinaryMessenger> binaryMessenger, NSObject<TXFlutterVodPlayerApi> *api) {
  SetUpTXFlutterVodPlayerApiWithSuffix(binaryMessenger, api, @"");
}

void SetUpTXFlutterVodPlayerApiWithSuffix(id<FlutterBinaryMessenger> binaryMessenger, NSObject<TXFlutterVodPlayerApi> *api, NSString *messageChannelSuffix) {
  messageChannelSuffix = messageChannelSuffix.length > 0 ? [NSString stringWithFormat: @".%@", messageChannelSuffix] : @"";
  /// 播放器初始化，创建共享纹理、初始化播放器
  ///
  /// To initialize the player, you would need to create a shared texture and initialize the player.
  /// @param onlyAudio 是否是纯音频模式 if pure audio mode
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.initialize", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(initializeOnlyAudio:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(initializeOnlyAudio:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        BoolPlayerMsg *arg_onlyAudio = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        IntMsg *output = [api initializeOnlyAudio:arg_onlyAudio error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 通过url开始播放视频
  /// 10.7版本开始，startPlay变更为startVodPlay，需要通过 {@link SuperPlayerPlugin#setGlobalLicense} 设置 Licence 后方可成功播放，
  /// 否则将播放失败（黑屏），全局仅设置一次即可。直播 Licence、短视频 Licence 和视频播放 Licence 均可使用，若您暂未获取上述 Licence ，
  /// 可[快速免费申请测试版 Licence](https://cloud.tencent.com/act/event/License) 以正常播放，正式版 License 需[购买]
  /// (https://cloud.tencent.com/document/product/881/74588#.E8.B4.AD.E4.B9.B0.E5.B9.B6.E6.96.B0.E5.BB.BA.E6.AD.A3.E5.BC.8F.E7.89.88-license)。
  ///
  /// Starting from version 10.7, the method `startPlay` has been changed to `startVodPlay` for playing videos via a URL.
  /// To play videos successfully, it is necessary to set the license by using the method `SuperPlayerPlugin#setGlobalLicense`.
  /// Failure to set the license will result in video playback failure (a black screen).
  /// Live streaming, short video, and video playback licenses can all be used. If you do not have any of the above licenses,
  /// you can apply for a free trial license to play videos normally[Quickly apply for a free trial version Licence]
  /// (https://cloud.tencent.com/act/event/License).Official licenses can be purchased
  /// (https://cloud.tencent.com/document/product/881/74588#.E8.B4.AD.E4.B9.B0.E5.B9.B6.E6.96.B0.E5.BB.BA.E6.AD.A3.E5.BC.8F.E7.89.88-license).
  /// @param url : 视频播放地址 video playback address
  /// return 是否播放成功 if play successfully
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.startVodPlay", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(startVodPlayUrl:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(startVodPlayUrl:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        StringPlayerMsg *arg_url = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        BoolMsg *output = [api startVodPlayUrl:arg_url error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 通过fileId播放视频
  /// 10.7版本开始，startPlayWithParams变更为startVodPlayWithParams，需要通过 {@link SuperPlayerPlugin#setGlobalLicense} 设置 Licence 后方可成功播放，
  /// 否则将播放失败（黑屏），全局仅设置一次即可。直播 Licence、短视频 Licence 和视频播放 Licence 均可使用，若您暂未获取上述 Licence ，
  /// 可[快速免费申请测试版 Licence](https://cloud.tencent.com/act/event/License) 以正常播放，正式版 License 需[购买]
  /// (https://cloud.tencent.com/document/product/881/74588#.E8.B4.AD.E4.B9.B0.E5.B9.B6.E6.96.B0.E5.BB.BA.E6.AD.A3.E5.BC.8F.E7.89.88-license)。
  ///
  /// Starting from version 10.7, the method "startPlayWithParams" has been changed to "startVodPlayWithParams" for playing videos using fileId.
  /// To play the video successfully, you need to set the Licence using "SuperPlayerPlugin#setGlobalLicense" method before playing the video.
  /// If you do not set the Licence, the video will not play (black screen). The Licence for live streaming,
  /// short video, and video playback can all be used. If you have not obtained the Licence, you can apply for a free trial version [here]
  /// (https://cloud.tencent.com/act/event/License) for normal playback. To use the official version, you need to [purchase]
  /// (https://cloud.tencent.com/document/product/881/74588#.E8.B4.AD.E4.B9.B0.E5.B9.B6.E6.96.B0.E5.BB.BA.E6.AD.A3.E5.BC.8F.E7.89.88-license).
  /// @params : see[TXPlayInfoParams]
  /// return 是否播放成功  if play successful
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.startVodPlayWithParams", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(startVodPlayWithParamsParams:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(startVodPlayWithParamsParams:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        TXPlayInfoParamsPlayerMsg *arg_params = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api startVodPlayWithParamsParams:arg_params error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 播放 DRM 加密视频
  ///
  /// Playing DRM-encrypted video.
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.startPlayDrm", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(startPlayDrmParams:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(startPlayDrmParams:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        TXPlayerDrmMsg *arg_params = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        IntMsg *output = [api startPlayDrmParams:arg_params error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置是否自动播放
  ///
  /// set autoplay
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.setAutoPlay", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setAutoPlayIsAutoPlay:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(setAutoPlayIsAutoPlay:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        BoolPlayerMsg *arg_isAutoPlay = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setAutoPlayIsAutoPlay:arg_isAutoPlay error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 停止播放
  ///
  /// Stop playback
  /// return 是否停止成功 if stop successful
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.stop", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(stopIsNeedClear:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(stopIsNeedClear:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        BoolPlayerMsg *arg_isNeedClear = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        BoolMsg *output = [api stopIsNeedClear:arg_isNeedClear error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 视频是否处于正在播放中
  ///
  /// Is the video currently playing
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.isPlaying", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(isPlayingPlayerMsg:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(isPlayingPlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        BoolMsg *output = [api isPlayingPlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 视频暂停，必须在播放器开始播放的时候调用
  ///
  /// pause video, it must be called when the player starts playing
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.pause", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(pausePlayerMsg:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(pausePlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api pausePlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 继续播放，在暂停的时候调用
  ///
  /// resume playback, it should be called when the video is paused
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.resume", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(resumePlayerMsg:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(resumePlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api resumePlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置是否静音
  ///
  /// Set whether to mute or not
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.setMute", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setMuteMute:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(setMuteMute:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        BoolPlayerMsg *arg_mute = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setMuteMute:arg_mute error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置是否循环播放
  ///
  /// Set whether to loop playback or not
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.setLoop", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setLoopLoop:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(setLoopLoop:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        BoolPlayerMsg *arg_loop = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setLoopLoop:arg_loop error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 将视频播放进度定位到指定的进度进行播放
  ///
  /// Set the video playback progress to a specific time and start playing.
  /// progress 要定位的视频时间，单位 秒 The video playback time to be located, in seconds
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.seek", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(seekProgress:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(seekProgress:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        DoublePlayerMsg *arg_progress = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api seekProgress:arg_progress error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 跳转到视频流指定PDT时间点, 可实现视频快进,快退,进度条跳转等功能
  /// 单位毫秒(ms)
  /// 播放器高级版 11.6 版本开始支持
  ///
  /// Jump to the specified PDT time point of the video stream, which can realize video fast forward, fast rewind, progress bar jump and other functions.
  /// Unit millisecond (ms)
  /// Player Premium version 11.6 starts to support
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.seekToPdtTime", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(seekToPdtTimePdtTimeMs:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(seekToPdtTimePdtTimeMs:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        IntPlayerMsg *arg_pdtTimeMs = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api seekToPdtTimePdtTimeMs:arg_pdtTimeMs error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置播放速率，默认速率 1
  ///
  /// Set the playback speed, with a default speed of 1.
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.setRate", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setRateRate:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(setRateRate:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        DoublePlayerMsg *arg_rate = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setRateRate:arg_rate error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 获得播放视频解析出来的码率信息
  ///
  /// get the bitrate information extracted from playing a video
  /// return List<Map>
  /// Bitrate：index 码率序号，
  ///         width 码率对应视频宽度，
  ///         height 码率对应视频高度,
  ///         bitrate 码率值
  ///
  /// Bitrate：index:bitrate index，
  ///         width:the video with of this bitrate，
  ///         height:the video height of this bitrate,
  ///         bitrate:bitrate value
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.getSupportedBitrate", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getSupportedBitratePlayerMsg:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(getSupportedBitratePlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        ListMsg *output = [api getSupportedBitratePlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 获得当前设置的码率序号
  ///
  /// Get the index of the current bitrate setting
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.getBitrateIndex", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getBitrateIndexPlayerMsg:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(getBitrateIndexPlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        IntMsg *output = [api getBitrateIndexPlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置码率序号
  ///
  /// Set the index of the bitrate setting.
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.setBitrateIndex", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setBitrateIndexIndex:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(setBitrateIndexIndex:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        IntPlayerMsg *arg_index = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setBitrateIndexIndex:arg_index error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置视频播放开始时间，单位 秒
  ///
  /// Set the start time of the video playback, in seconds.
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.setStartTime", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setStartTimeStartTime:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(setStartTimeStartTime:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        DoublePlayerMsg *arg_startTime = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setStartTimeStartTime:arg_startTime error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置视频声音 0~100
  ///
  /// Set the volume of the video, ranging from 0 to 100.
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.setAudioPlayOutVolume", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setAudioPlayOutVolumeVolume:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(setAudioPlayOutVolumeVolume:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        IntPlayerMsg *arg_volume = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setAudioPlayOutVolumeVolume:arg_volume error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 请求获得音频焦点
  ///
  /// Request audio focus.
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.setRequestAudioFocus", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setRequestAudioFocusFocus:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(setRequestAudioFocusFocus:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        BoolPlayerMsg *arg_focus = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        BoolMsg *output = [api setRequestAudioFocusFocus:arg_focus error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置播放器配置
  ///
  /// Set player configuration
  /// config @see [FTXVodPlayConfig]
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.setConfig", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setConfigConfig:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(setConfigConfig:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        FTXVodPlayConfigPlayerMsg *arg_config = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setConfigConfig:arg_config error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 获得当前已经播放的时间，单位 秒
  ///
  /// Get the current playback time, in seconds.
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.getCurrentPlaybackTime", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getCurrentPlaybackTimePlayerMsg:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(getCurrentPlaybackTimePlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        DoubleMsg *output = [api getCurrentPlaybackTimePlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 获得当前视频已缓存的时间
  ///
  /// Get the current amount of video that has been buffered.
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.getBufferDuration", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getBufferDurationPlayerMsg:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(getBufferDurationPlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        DoubleMsg *output = [api getBufferDurationPlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 获得当前视频的可播放时间
  ///
  /// Get the current playable duration of the video.
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.getPlayableDuration", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getPlayableDurationPlayerMsg:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(getPlayableDurationPlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        DoubleMsg *output = [api getPlayableDurationPlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 获得当前播放视频的宽度
  ///
  /// Get the width of the currently playing video.
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.getWidth", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getWidthPlayerMsg:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(getWidthPlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        IntMsg *output = [api getWidthPlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 获得当前播放视频的高度
  ///
  /// Get the height of the currently playing video.
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.getHeight", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getHeightPlayerMsg:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(getHeightPlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        IntMsg *output = [api getHeightPlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置播放视频的token
  ///
  /// Set the token for playing the video.
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.setToken", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setTokenToken:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(setTokenToken:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        StringPlayerMsg *arg_token = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setTokenToken:arg_token error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 当前播放的视频是否循环播放
  ///
  /// Is the currently playing video set to loop
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.isLoop", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(isLoopPlayerMsg:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(isLoopPlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        BoolMsg *output = [api isLoopPlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 开启/关闭硬件编码
  ///
  /// Enable/Disable hardware encoding.
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.enableHardwareDecode", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(enableHardwareDecodeEnable:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(enableHardwareDecodeEnable:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        BoolPlayerMsg *arg_enable = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        BoolMsg *output = [api enableHardwareDecodeEnable:arg_enable error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 进入画中画模式，进入画中画模式，需要适配画中画模式的界面，安卓只支持7.0以上机型
  /// <h1>
  /// 由于android系统限制，传递的图标大小不得超过1M，否则无法显示
  /// </h1>
  /// @param backIcon playIcon pauseIcon forwardIcon 为播放后退、播放、暂停、前进的图标，如果赋值的话，将会使用传递的图标，否则
  /// 使用系统默认图标，只支持flutter本地资源图片，传递的时候，与flutter使用图片资源一致，例如： images/back_icon.png
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.enterPictureInPictureMode", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(enterPictureInPictureModePipParamsMsg:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(enterPictureInPictureModePipParamsMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        PipParamsPlayerMsg *arg_pipParamsMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        IntMsg *output = [api enterPictureInPictureModePipParamsMsg:arg_pipParamsMsg error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 退出画中画，如果该播放器处于画中画模式
  ///
  /// Exit picture-in-picture mode if the video player is in picture-in-picture mode.
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.exitPictureInPictureMode", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(exitPictureInPictureModePlayerMsg:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(exitPictureInPictureModePlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api exitPictureInPictureModePlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.initImageSprite", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(initImageSpriteSpriteInfo:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(initImageSpriteSpriteInfo:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        StringListPlayerMsg *arg_spriteInfo = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api initImageSpriteSpriteInfo:arg_spriteInfo error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.getImageSprite", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getImageSpriteTime:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(getImageSpriteTime:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        DoublePlayerMsg *arg_time = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        UInt8ListMsg *output = [api getImageSpriteTime:arg_time error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 获取总时长
  ///
  /// To get the total duration
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.getDuration", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getDurationPlayerMsg:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(getDurationPlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        DoubleMsg *output = [api getDurationPlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.addSubtitleSource", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(addSubtitleSourcePlayerMsg:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(addSubtitleSourcePlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        SubTitlePlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api addSubtitleSourcePlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.getSubtitleTrackInfo", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getSubtitleTrackInfoPlayerMsg:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(getSubtitleTrackInfoPlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        ListMsg *output = [api getSubtitleTrackInfoPlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.getAudioTrackInfo", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getAudioTrackInfoPlayerMsg:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(getAudioTrackInfoPlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        ListMsg *output = [api getAudioTrackInfoPlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.selectTrack", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(selectTrackPlayerMsg:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(selectTrackPlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        IntPlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api selectTrackPlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.deselectTrack", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(deselectTrackPlayerMsg:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(deselectTrackPlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        IntPlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api deselectTrackPlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.setSubtitleStyle", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setSubtitleStylePlayerMsg:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(setSubtitleStylePlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        SubTitleRenderModelPlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setSubtitleStylePlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.setStringOption", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setStringOptionPlayerMsg:error:)], @"TXFlutterVodPlayerApi api (%@) doesn't respond to @selector(setStringOptionPlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        StringOptionPlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setStringOptionPlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
}
void SetUpTXFlutterLivePlayerApi(id<FlutterBinaryMessenger> binaryMessenger, NSObject<TXFlutterLivePlayerApi> *api) {
  SetUpTXFlutterLivePlayerApiWithSuffix(binaryMessenger, api, @"");
}

void SetUpTXFlutterLivePlayerApiWithSuffix(id<FlutterBinaryMessenger> binaryMessenger, NSObject<TXFlutterLivePlayerApi> *api, NSString *messageChannelSuffix) {
  messageChannelSuffix = messageChannelSuffix.length > 0 ? [NSString stringWithFormat: @".%@", messageChannelSuffix] : @"";
  /// 播放器初始化，创建共享纹理、初始化播放器
  /// @param onlyAudio 是否是纯音频模式
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.initialize", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(initializeOnlyAudio:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(initializeOnlyAudio:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        BoolPlayerMsg *arg_onlyAudio = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        IntMsg *output = [api initializeOnlyAudio:arg_onlyAudio error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  ///
  /// 当设置[LivePlayer] 类型播放器时
  /// 10.7版本开始，startPlay变更为startLivePlay，需要通过 {@link SuperPlayerPlugin#setGlobalLicense} 设置 Licence 后方可成功播放，
  /// 否则将播放失败（黑屏），全局仅设置一次即可。直播 Licence、短视频 Licence 和视频播放 Licence 均可使用，若您暂未获取上述 Licence ，
  /// 可[快速免费申请测试版 Licence](https://cloud.tencent.com/act/event/License) 以正常播放，正式版 License 需[购买]
  /// (https://cloud.tencent.com/document/product/881/74588#.E8.B4.AD.E4.B9.B0.E5.B9.B6.E6.96.B0.E5.BB.BA.E6.AD.A3.E5.BC.8F.E7.89.88-license)。
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.startLivePlay", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(startLivePlayPlayerMsg:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(startLivePlayPlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        StringPlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        BoolMsg *output = [api startLivePlayPlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 停止播放
  /// return 是否停止成功
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.stop", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(stopIsNeedClear:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(stopIsNeedClear:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        BoolPlayerMsg *arg_isNeedClear = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        BoolMsg *output = [api stopIsNeedClear:arg_isNeedClear error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 视频是否处于正在播放中
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.isPlaying", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(isPlayingPlayerMsg:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(isPlayingPlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        BoolMsg *output = [api isPlayingPlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 视频暂停，必须在播放器开始播放的时候调用
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.pause", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(pausePlayerMsg:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(pausePlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api pausePlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 继续播放，在暂停的时候调用
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.resume", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(resumePlayerMsg:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(resumePlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api resumePlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置直播模式，see TXPlayerLiveMode
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.setLiveMode", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setLiveModeMode:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(setLiveModeMode:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        IntPlayerMsg *arg_mode = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setLiveModeMode:arg_mode error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置视频声音 0~100
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.setVolume", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setVolumeVolume:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(setVolumeVolume:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        IntPlayerMsg *arg_volume = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setVolumeVolume:arg_volume error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置是否静音
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.setMute", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setMuteMute:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(setMuteMute:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        BoolPlayerMsg *arg_mute = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setMuteMute:arg_mute error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 切换播放流
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.switchStream", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(switchStreamUrl:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(switchStreamUrl:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        StringPlayerMsg *arg_url = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        IntMsg *output = [api switchStreamUrl:arg_url error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置appId
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.setAppID", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setAppIDAppId:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(setAppIDAppId:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        StringPlayerMsg *arg_appId = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setAppIDAppId:arg_appId error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置播放器配置
  /// config @see [FTXLivePlayConfig]
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.setConfig", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setConfigConfig:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(setConfigConfig:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        FTXLivePlayConfigPlayerMsg *arg_config = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setConfigConfig:arg_config error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 开启/关闭硬件编码
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.enableHardwareDecode", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(enableHardwareDecodeEnable:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(enableHardwareDecodeEnable:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        BoolPlayerMsg *arg_enable = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        BoolMsg *output = [api enableHardwareDecodeEnable:arg_enable error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 进入画中画模式，进入画中画模式，需要适配画中画模式的界面，安卓只支持7.0以上机型
  /// <h1>
  /// 由于android系统限制，传递的图标大小不得超过1M，否则无法显示
  /// </h1>
  /// @param backIcon playIcon pauseIcon forwardIcon 为播放后退、播放、暂停、前进的图标，仅适用于android，如果赋值的话，将会使用传递的图标，否则
  /// 使用系统默认图标，只支持flutter本地资源图片，传递的时候，与flutter使用图片资源一致，例如： images/back_icon.png
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.enterPictureInPictureMode", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(enterPictureInPictureModePipParamsMsg:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(enterPictureInPictureModePipParamsMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        PipParamsPlayerMsg *arg_pipParamsMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        IntMsg *output = [api enterPictureInPictureModePipParamsMsg:arg_pipParamsMsg error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 退出画中画，如果该播放器处于画中画模式
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.exitPictureInPictureMode", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(exitPictureInPictureModePlayerMsg:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(exitPictureInPictureModePlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api exitPictureInPictureModePlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.enableReceiveSeiMessage", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(enableReceiveSeiMessagePlayerMsg:isEnabled:payloadType:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(enableReceiveSeiMessagePlayerMsg:isEnabled:payloadType:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        BOOL arg_isEnabled = [GetNullableObjectAtIndex(args, 1) boolValue];
        NSInteger arg_payloadType = [GetNullableObjectAtIndex(args, 2) integerValue];
        FlutterError *error;
        NSNumber *output = [api enableReceiveSeiMessagePlayerMsg:arg_playerMsg isEnabled:arg_isEnabled payloadType:arg_payloadType error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.showDebugView", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(showDebugViewPlayerMsg:isShow:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(showDebugViewPlayerMsg:isShow:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        BOOL arg_isShow = [GetNullableObjectAtIndex(args, 1) boolValue];
        FlutterError *error;
        [api showDebugViewPlayerMsg:arg_playerMsg isShow:arg_isShow error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.setProperty", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setPropertyPlayerMsg:key:value:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(setPropertyPlayerMsg:key:value:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        NSString *arg_key = GetNullableObjectAtIndex(args, 1);
        id arg_value = GetNullableObjectAtIndex(args, 2);
        FlutterError *error;
        NSNumber *output = [api setPropertyPlayerMsg:arg_playerMsg key:arg_key value:arg_value error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.getSupportedBitrate", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getSupportedBitratePlayerMsg:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(getSupportedBitratePlayerMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        ListMsg *output = [api getSupportedBitratePlayerMsg:arg_playerMsg error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.setCacheParams", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setCacheParamsPlayerMsg:minTime:maxTime:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(setCacheParamsPlayerMsg:minTime:maxTime:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        PlayerMsg *arg_playerMsg = GetNullableObjectAtIndex(args, 0);
        double arg_minTime = [GetNullableObjectAtIndex(args, 1) doubleValue];
        double arg_maxTime = [GetNullableObjectAtIndex(args, 2) doubleValue];
        FlutterError *error;
        NSNumber *output = [api setCacheParamsPlayerMsg:arg_playerMsg minTime:arg_minTime maxTime:arg_maxTime error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.enablePictureInPicture", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(enablePictureInPictureMsg:error:)], @"TXFlutterLivePlayerApi api (%@) doesn't respond to @selector(enablePictureInPictureMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        BoolPlayerMsg *arg_msg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        NSNumber *output = [api enablePictureInPictureMsg:arg_msg error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
}
void SetUpTXFlutterDownloadApi(id<FlutterBinaryMessenger> binaryMessenger, NSObject<TXFlutterDownloadApi> *api) {
  SetUpTXFlutterDownloadApiWithSuffix(binaryMessenger, api, @"");
}

void SetUpTXFlutterDownloadApiWithSuffix(id<FlutterBinaryMessenger> binaryMessenger, NSObject<TXFlutterDownloadApi> *api, NSString *messageChannelSuffix) {
  messageChannelSuffix = messageChannelSuffix.length > 0 ? [NSString stringWithFormat: @".%@", messageChannelSuffix] : @"";
  /// 启动预下载。
  /// playUrl: 要预下载的url
  /// preloadSizeMB: 预下载的大小（单位：MB）
  /// preferredResolution 期望分辨率，long类型，值为高x宽。可参考如720*1080。不支持多分辨率或不需指定时，传-1。
  /// 返回值：任务ID，可用这个任务ID停止预下载 [stopPreload]
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterDownloadApi.startPreLoad", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(startPreLoadMsg:error:)], @"TXFlutterDownloadApi api (%@) doesn't respond to @selector(startPreLoadMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        PreLoadMsg *arg_msg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        IntMsg *output = [api startPreLoadMsg:arg_msg error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterDownloadApi.startPreLoadByParams", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(startPreLoadByParamsMsg:error:)], @"TXFlutterDownloadApi api (%@) doesn't respond to @selector(startPreLoadByParamsMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        PreLoadInfoMsg *arg_msg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api startPreLoadByParamsMsg:arg_msg error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 停止预下载。
  /// taskId： 任务id
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterDownloadApi.stopPreLoad", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(stopPreLoadMsg:error:)], @"TXFlutterDownloadApi api (%@) doesn't respond to @selector(stopPreLoadMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        IntMsg *arg_msg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api stopPreLoadMsg:arg_msg error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 开始下载
  /// videoDownloadModel: 下载构造体
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterDownloadApi.startDownload", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(startDownloadMsg:error:)], @"TXFlutterDownloadApi api (%@) doesn't respond to @selector(startDownloadMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        TXVodDownloadMediaMsg *arg_msg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api startDownloadMsg:arg_msg error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 继续下载，与开始下载接口有区别，该接口会寻找对应的缓存，复用之前的缓存来续点下载，
  /// 而开始下载接口会启动一个全新的下载
  /// videoDownloadModel: 下载构造体
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterDownloadApi.resumeDownload", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(resumeDownloadMsg:error:)], @"TXFlutterDownloadApi api (%@) doesn't respond to @selector(resumeDownloadMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        TXVodDownloadMediaMsg *arg_msg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api resumeDownloadMsg:arg_msg error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 停止下载
  /// videoDownloadModel: 下载构造体
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterDownloadApi.stopDownload", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(stopDownloadMsg:error:)], @"TXFlutterDownloadApi api (%@) doesn't respond to @selector(stopDownloadMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        TXVodDownloadMediaMsg *arg_msg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api stopDownloadMsg:arg_msg error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 设置下载请求头
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterDownloadApi.setDownloadHeaders", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(setDownloadHeadersHeaders:error:)], @"TXFlutterDownloadApi api (%@) doesn't respond to @selector(setDownloadHeadersHeaders:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        MapMsg *arg_headers = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        [api setDownloadHeadersHeaders:arg_headers error:&error];
        callback(wrapResult(nil, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 获取所有视频下载列表
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterDownloadApi.getDownloadList", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getDownloadListWithError:)], @"TXFlutterDownloadApi api (%@) doesn't respond to @selector(getDownloadListWithError:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        FlutterError *error;
        TXDownloadListMsg *output = [api getDownloadListWithError:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 获得指定视频的下载信息
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterDownloadApi.getDownloadInfo", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(getDownloadInfoMsg:error:)], @"TXFlutterDownloadApi api (%@) doesn't respond to @selector(getDownloadInfoMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        TXVodDownloadMediaMsg *arg_msg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        TXVodDownloadMediaMsg *output = [api getDownloadInfoMsg:arg_msg error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
  /// 删除下载任务
  {
    FlutterBasicMessageChannel *channel =
      [[FlutterBasicMessageChannel alloc]
        initWithName:[NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXFlutterDownloadApi.deleteDownloadMediaInfo", messageChannelSuffix]
        binaryMessenger:binaryMessenger
        codec:nullGetFtxMessagesCodec()];
    if (api) {
      NSCAssert([api respondsToSelector:@selector(deleteDownloadMediaInfoMsg:error:)], @"TXFlutterDownloadApi api (%@) doesn't respond to @selector(deleteDownloadMediaInfoMsg:error:)", api);
      [channel setMessageHandler:^(id _Nullable message, FlutterReply callback) {
        NSArray<id> *args = message;
        TXVodDownloadMediaMsg *arg_msg = GetNullableObjectAtIndex(args, 0);
        FlutterError *error;
        BoolMsg *output = [api deleteDownloadMediaInfoMsg:arg_msg error:&error];
        callback(wrapResult(output, error));
      }];
    } else {
      [channel setMessageHandler:nil];
    }
  }
}
@interface TXDownloadFlutterAPI ()
@property(nonatomic, strong) NSObject<FlutterBinaryMessenger> *binaryMessenger;
@property(nonatomic, strong) NSString *messageChannelSuffix;
@end

@implementation TXDownloadFlutterAPI

- (instancetype)initWithBinaryMessenger:(NSObject<FlutterBinaryMessenger> *)binaryMessenger {
  return [self initWithBinaryMessenger:binaryMessenger messageChannelSuffix:@""];
}
- (instancetype)initWithBinaryMessenger:(NSObject<FlutterBinaryMessenger> *)binaryMessenger messageChannelSuffix:(nullable NSString*)messageChannelSuffix{
  self = [self init];
  if (self) {
    _binaryMessenger = binaryMessenger;
    _messageChannelSuffix = [messageChannelSuffix length] == 0 ? @"" : [NSString stringWithFormat: @".%@", messageChannelSuffix];
  }
  return self;
}
- (void)onDownloadEventEvent:(NSDictionary<NSString *, id> *)arg_event completion:(void (^)(FlutterError *_Nullable))completion {
  NSString *channelName = [NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXDownloadFlutterAPI.onDownloadEvent", _messageChannelSuffix];
  FlutterBasicMessageChannel *channel =
    [FlutterBasicMessageChannel
      messageChannelWithName:channelName
      binaryMessenger:self.binaryMessenger
      codec:nullGetFtxMessagesCodec()];
  [channel sendMessage:@[arg_event ?: [NSNull null]] reply:^(NSArray<id> *reply) {
    if (reply != nil) {
      if (reply.count > 1) {
        completion([FlutterError errorWithCode:reply[0] message:reply[1] details:reply[2]]);
      } else {
        completion(nil);
      }
    } else {
      completion(createConnectionError(channelName));
    } 
  }];
}
- (void)onPreDownloadEventEvent:(NSDictionary<NSString *, id> *)arg_event completion:(void (^)(FlutterError *_Nullable))completion {
  NSString *channelName = [NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXDownloadFlutterAPI.onPreDownloadEvent", _messageChannelSuffix];
  FlutterBasicMessageChannel *channel =
    [FlutterBasicMessageChannel
      messageChannelWithName:channelName
      binaryMessenger:self.binaryMessenger
      codec:nullGetFtxMessagesCodec()];
  [channel sendMessage:@[arg_event ?: [NSNull null]] reply:^(NSArray<id> *reply) {
    if (reply != nil) {
      if (reply.count > 1) {
        completion([FlutterError errorWithCode:reply[0] message:reply[1] details:reply[2]]);
      } else {
        completion(nil);
      }
    } else {
      completion(createConnectionError(channelName));
    } 
  }];
}
@end

@interface TXPluginFlutterAPI ()
@property(nonatomic, strong) NSObject<FlutterBinaryMessenger> *binaryMessenger;
@property(nonatomic, strong) NSString *messageChannelSuffix;
@end

@implementation TXPluginFlutterAPI

- (instancetype)initWithBinaryMessenger:(NSObject<FlutterBinaryMessenger> *)binaryMessenger {
  return [self initWithBinaryMessenger:binaryMessenger messageChannelSuffix:@""];
}
- (instancetype)initWithBinaryMessenger:(NSObject<FlutterBinaryMessenger> *)binaryMessenger messageChannelSuffix:(nullable NSString*)messageChannelSuffix{
  self = [self init];
  if (self) {
    _binaryMessenger = binaryMessenger;
    _messageChannelSuffix = [messageChannelSuffix length] == 0 ? @"" : [NSString stringWithFormat: @".%@", messageChannelSuffix];
  }
  return self;
}
- (void)onSDKListenerEvent:(NSDictionary<NSString *, id> *)arg_event completion:(void (^)(FlutterError *_Nullable))completion {
  NSString *channelName = [NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXPluginFlutterAPI.onSDKListener", _messageChannelSuffix];
  FlutterBasicMessageChannel *channel =
    [FlutterBasicMessageChannel
      messageChannelWithName:channelName
      binaryMessenger:self.binaryMessenger
      codec:nullGetFtxMessagesCodec()];
  [channel sendMessage:@[arg_event ?: [NSNull null]] reply:^(NSArray<id> *reply) {
    if (reply != nil) {
      if (reply.count > 1) {
        completion([FlutterError errorWithCode:reply[0] message:reply[1] details:reply[2]]);
      } else {
        completion(nil);
      }
    } else {
      completion(createConnectionError(channelName));
    } 
  }];
}
- (void)onNativeEventEvent:(NSDictionary<NSString *, id> *)arg_event completion:(void (^)(FlutterError *_Nullable))completion {
  NSString *channelName = [NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXPluginFlutterAPI.onNativeEvent", _messageChannelSuffix];
  FlutterBasicMessageChannel *channel =
    [FlutterBasicMessageChannel
      messageChannelWithName:channelName
      binaryMessenger:self.binaryMessenger
      codec:nullGetFtxMessagesCodec()];
  [channel sendMessage:@[arg_event ?: [NSNull null]] reply:^(NSArray<id> *reply) {
    if (reply != nil) {
      if (reply.count > 1) {
        completion([FlutterError errorWithCode:reply[0] message:reply[1] details:reply[2]]);
      } else {
        completion(nil);
      }
    } else {
      completion(createConnectionError(channelName));
    } 
  }];
}
@end

@interface TXPipFlutterAPI ()
@property(nonatomic, strong) NSObject<FlutterBinaryMessenger> *binaryMessenger;
@property(nonatomic, strong) NSString *messageChannelSuffix;
@end

@implementation TXPipFlutterAPI

- (instancetype)initWithBinaryMessenger:(NSObject<FlutterBinaryMessenger> *)binaryMessenger {
  return [self initWithBinaryMessenger:binaryMessenger messageChannelSuffix:@""];
}
- (instancetype)initWithBinaryMessenger:(NSObject<FlutterBinaryMessenger> *)binaryMessenger messageChannelSuffix:(nullable NSString*)messageChannelSuffix{
  self = [self init];
  if (self) {
    _binaryMessenger = binaryMessenger;
    _messageChannelSuffix = [messageChannelSuffix length] == 0 ? @"" : [NSString stringWithFormat: @".%@", messageChannelSuffix];
  }
  return self;
}
- (void)onPipEventEvent:(NSDictionary<NSString *, id> *)arg_event completion:(void (^)(FlutterError *_Nullable))completion {
  NSString *channelName = [NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXPipFlutterAPI.onPipEvent", _messageChannelSuffix];
  FlutterBasicMessageChannel *channel =
    [FlutterBasicMessageChannel
      messageChannelWithName:channelName
      binaryMessenger:self.binaryMessenger
      codec:nullGetFtxMessagesCodec()];
  [channel sendMessage:@[arg_event ?: [NSNull null]] reply:^(NSArray<id> *reply) {
    if (reply != nil) {
      if (reply.count > 1) {
        completion([FlutterError errorWithCode:reply[0] message:reply[1] details:reply[2]]);
      } else {
        completion(nil);
      }
    } else {
      completion(createConnectionError(channelName));
    } 
  }];
}
@end

@interface TXVodPlayerFlutterAPI ()
@property(nonatomic, strong) NSObject<FlutterBinaryMessenger> *binaryMessenger;
@property(nonatomic, strong) NSString *messageChannelSuffix;
@end

@implementation TXVodPlayerFlutterAPI

- (instancetype)initWithBinaryMessenger:(NSObject<FlutterBinaryMessenger> *)binaryMessenger {
  return [self initWithBinaryMessenger:binaryMessenger messageChannelSuffix:@""];
}
- (instancetype)initWithBinaryMessenger:(NSObject<FlutterBinaryMessenger> *)binaryMessenger messageChannelSuffix:(nullable NSString*)messageChannelSuffix{
  self = [self init];
  if (self) {
    _binaryMessenger = binaryMessenger;
    _messageChannelSuffix = [messageChannelSuffix length] == 0 ? @"" : [NSString stringWithFormat: @".%@", messageChannelSuffix];
  }
  return self;
}
- (void)onPlayerEventEvent:(NSDictionary<NSString *, id> *)arg_event completion:(void (^)(FlutterError *_Nullable))completion {
  NSString *channelName = [NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXVodPlayerFlutterAPI.onPlayerEvent", _messageChannelSuffix];
  FlutterBasicMessageChannel *channel =
    [FlutterBasicMessageChannel
      messageChannelWithName:channelName
      binaryMessenger:self.binaryMessenger
      codec:nullGetFtxMessagesCodec()];
  [channel sendMessage:@[arg_event ?: [NSNull null]] reply:^(NSArray<id> *reply) {
    if (reply != nil) {
      if (reply.count > 1) {
        completion([FlutterError errorWithCode:reply[0] message:reply[1] details:reply[2]]);
      } else {
        completion(nil);
      }
    } else {
      completion(createConnectionError(channelName));
    } 
  }];
}
- (void)onNetEventEvent:(NSDictionary<NSString *, id> *)arg_event completion:(void (^)(FlutterError *_Nullable))completion {
  NSString *channelName = [NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXVodPlayerFlutterAPI.onNetEvent", _messageChannelSuffix];
  FlutterBasicMessageChannel *channel =
    [FlutterBasicMessageChannel
      messageChannelWithName:channelName
      binaryMessenger:self.binaryMessenger
      codec:nullGetFtxMessagesCodec()];
  [channel sendMessage:@[arg_event ?: [NSNull null]] reply:^(NSArray<id> *reply) {
    if (reply != nil) {
      if (reply.count > 1) {
        completion([FlutterError errorWithCode:reply[0] message:reply[1] details:reply[2]]);
      } else {
        completion(nil);
      }
    } else {
      completion(createConnectionError(channelName));
    } 
  }];
}
@end

@interface TXLivePlayerFlutterAPI ()
@property(nonatomic, strong) NSObject<FlutterBinaryMessenger> *binaryMessenger;
@property(nonatomic, strong) NSString *messageChannelSuffix;
@end

@implementation TXLivePlayerFlutterAPI

- (instancetype)initWithBinaryMessenger:(NSObject<FlutterBinaryMessenger> *)binaryMessenger {
  return [self initWithBinaryMessenger:binaryMessenger messageChannelSuffix:@""];
}
- (instancetype)initWithBinaryMessenger:(NSObject<FlutterBinaryMessenger> *)binaryMessenger messageChannelSuffix:(nullable NSString*)messageChannelSuffix{
  self = [self init];
  if (self) {
    _binaryMessenger = binaryMessenger;
    _messageChannelSuffix = [messageChannelSuffix length] == 0 ? @"" : [NSString stringWithFormat: @".%@", messageChannelSuffix];
  }
  return self;
}
- (void)onPlayerEventEvent:(NSDictionary<NSString *, id> *)arg_event completion:(void (^)(FlutterError *_Nullable))completion {
  NSString *channelName = [NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXLivePlayerFlutterAPI.onPlayerEvent", _messageChannelSuffix];
  FlutterBasicMessageChannel *channel =
    [FlutterBasicMessageChannel
      messageChannelWithName:channelName
      binaryMessenger:self.binaryMessenger
      codec:nullGetFtxMessagesCodec()];
  [channel sendMessage:@[arg_event ?: [NSNull null]] reply:^(NSArray<id> *reply) {
    if (reply != nil) {
      if (reply.count > 1) {
        completion([FlutterError errorWithCode:reply[0] message:reply[1] details:reply[2]]);
      } else {
        completion(nil);
      }
    } else {
      completion(createConnectionError(channelName));
    } 
  }];
}
- (void)onNetEventEvent:(NSDictionary<NSString *, id> *)arg_event completion:(void (^)(FlutterError *_Nullable))completion {
  NSString *channelName = [NSString stringWithFormat:@"%@%@", @"dev.flutter.pigeon.super_player.TXLivePlayerFlutterAPI.onNetEvent", _messageChannelSuffix];
  FlutterBasicMessageChannel *channel =
    [FlutterBasicMessageChannel
      messageChannelWithName:channelName
      binaryMessenger:self.binaryMessenger
      codec:nullGetFtxMessagesCodec()];
  [channel sendMessage:@[arg_event ?: [NSNull null]] reply:^(NSArray<id> *reply) {
    if (reply != nil) {
      if (reply.count > 1) {
        completion([FlutterError errorWithCode:reply[0] message:reply[1] details:reply[2]]);
      } else {
        completion(nil);
      }
    } else {
      completion(createConnectionError(channelName));
    } 
  }];
}
@end

