// Copyright (c) 2022 Tencent. All rights reserved.
part of SuperPlayer;
// Autogenerated from Pigeon (v22.6.0), do not edit directly.
// See also: https://pub.dev/packages/pigeon
// ignore_for_file: public_member_api_docs, non_constant_identifier_names, avoid_as, unused_import, unnecessary_parenthesis, prefer_null_aware_operators, omit_local_variable_types, unused_shown_name, unnecessary_import, no_leading_underscores_for_local_identifiers

PlatformException _createConnectionError(String channelName) {
  return PlatformException(
    code: 'channel-error',
    message: 'Unable to establish connection on channel: "$channelName".',
  );
}

List<Object?> wrapResponse({Object? result, PlatformException? error, bool empty = false}) {
  if (empty) {
    return <Object?>[];
  }
  if (error == null) {
    return <Object?>[result];
  }
  return <Object?>[error.code, error.message, error.details];
}

/// Pigeon original component, used to generate native communication code for `messages`.
/// The generation command is as follows. When using the generation command,
/// the two import statements above need to be implemented or commented out.
///
/// pigeon原始原件，由此文件生成messages原生通信代码
/// 生成命令如下，使用生成命令的时候，需要实现注释掉以上两个import导入
class PlayerMsg {
  PlayerMsg({
    this.playerId,
  });

  int? playerId;

  Object encode() {
    return <Object?>[
      playerId,
    ];
  }

  static PlayerMsg decode(Object result) {
    result as List<Object?>;
    return PlayerMsg(
      playerId: result[0] as int?,
    );
  }
}

class LicenseMsg {
  LicenseMsg({
    this.licenseUrl,
    this.licenseKey,
  });

  String? licenseUrl;

  String? licenseKey;

  Object encode() {
    return <Object?>[
      licenseUrl,
      licenseKey,
    ];
  }

  static LicenseMsg decode(Object result) {
    result as List<Object?>;
    return LicenseMsg(
      licenseUrl: result[0] as String?,
      licenseKey: result[1] as String?,
    );
  }
}

class TXPlayInfoParamsPlayerMsg {
  TXPlayInfoParamsPlayerMsg({
    this.playerId,
    this.appId,
    this.fileId,
    this.psign,
    this.url,
  });

  int? playerId;

  int? appId;

  String? fileId;

  String? psign;

  String? url;

  Object encode() {
    return <Object?>[
      playerId,
      appId,
      fileId,
      psign,
      url,
    ];
  }

  static TXPlayInfoParamsPlayerMsg decode(Object result) {
    result as List<Object?>;
    return TXPlayInfoParamsPlayerMsg(
      playerId: result[0] as int?,
      appId: result[1] as int?,
      fileId: result[2] as String?,
      psign: result[3] as String?,
      url: result[4] as String?,
    );
  }
}

class TXPlayerDrmMsg {
  TXPlayerDrmMsg({
    required this.licenseUrl,
    required this.playUrl,
    this.playerId,
    this.deviceCertificateUrl,
  });

  String licenseUrl;

  String playUrl;

  int? playerId;

  String? deviceCertificateUrl;

  Object encode() {
    return <Object?>[
      licenseUrl,
      playUrl,
      playerId,
      deviceCertificateUrl,
    ];
  }

  static TXPlayerDrmMsg decode(Object result) {
    result as List<Object?>;
    return TXPlayerDrmMsg(
      licenseUrl: result[0]! as String,
      playUrl: result[1]! as String,
      playerId: result[2] as int?,
      deviceCertificateUrl: result[3] as String?,
    );
  }
}

class PipParamsPlayerMsg {
  PipParamsPlayerMsg({
    this.playerId,
    this.backIconForAndroid,
    this.playIconForAndroid,
    this.pauseIconForAndroid,
    this.forwardIconForAndroid,
  });

  int? playerId;

  String? backIconForAndroid;

  String? playIconForAndroid;

  String? pauseIconForAndroid;

  String? forwardIconForAndroid;

  Object encode() {
    return <Object?>[
      playerId,
      backIconForAndroid,
      playIconForAndroid,
      pauseIconForAndroid,
      forwardIconForAndroid,
    ];
  }

  static PipParamsPlayerMsg decode(Object result) {
    result as List<Object?>;
    return PipParamsPlayerMsg(
      playerId: result[0] as int?,
      backIconForAndroid: result[1] as String?,
      playIconForAndroid: result[2] as String?,
      pauseIconForAndroid: result[3] as String?,
      forwardIconForAndroid: result[4] as String?,
    );
  }
}

class StringListPlayerMsg {
  StringListPlayerMsg({
    this.playerId,
    this.vvtUrl,
    this.imageUrls,
  });

  int? playerId;

  String? vvtUrl;

  List<String?>? imageUrls;

  Object encode() {
    return <Object?>[
      playerId,
      vvtUrl,
      imageUrls,
    ];
  }

  static StringListPlayerMsg decode(Object result) {
    result as List<Object?>;
    return StringListPlayerMsg(
      playerId: result[0] as int?,
      vvtUrl: result[1] as String?,
      imageUrls: (result[2] as List<Object?>?)?.cast<String?>(),
    );
  }
}

class BoolPlayerMsg {
  BoolPlayerMsg({
    this.playerId,
    this.value,
  });

  int? playerId;

  bool? value;

  Object encode() {
    return <Object?>[
      playerId,
      value,
    ];
  }

  static BoolPlayerMsg decode(Object result) {
    result as List<Object?>;
    return BoolPlayerMsg(
      playerId: result[0] as int?,
      value: result[1] as bool?,
    );
  }
}

class StringIntPlayerMsg {
  StringIntPlayerMsg({
    this.playerId,
    this.strValue,
    this.intValue,
  });

  int? playerId;

  String? strValue;

  int? intValue;

  Object encode() {
    return <Object?>[
      playerId,
      strValue,
      intValue,
    ];
  }

  static StringIntPlayerMsg decode(Object result) {
    result as List<Object?>;
    return StringIntPlayerMsg(
      playerId: result[0] as int?,
      strValue: result[1] as String?,
      intValue: result[2] as int?,
    );
  }
}

class StringPlayerMsg {
  StringPlayerMsg({
    this.playerId,
    this.value,
  });

  int? playerId;

  String? value;

  Object encode() {
    return <Object?>[
      playerId,
      value,
    ];
  }

  static StringPlayerMsg decode(Object result) {
    result as List<Object?>;
    return StringPlayerMsg(
      playerId: result[0] as int?,
      value: result[1] as String?,
    );
  }
}

class DoublePlayerMsg {
  DoublePlayerMsg({
    this.playerId,
    this.value,
  });

  int? playerId;

  double? value;

  Object encode() {
    return <Object?>[
      playerId,
      value,
    ];
  }

  static DoublePlayerMsg decode(Object result) {
    result as List<Object?>;
    return DoublePlayerMsg(
      playerId: result[0] as int?,
      value: result[1] as double?,
    );
  }
}

class IntPlayerMsg {
  IntPlayerMsg({
    this.playerId,
    this.value,
  });

  int? playerId;

  int? value;

  Object encode() {
    return <Object?>[
      playerId,
      value,
    ];
  }

  static IntPlayerMsg decode(Object result) {
    result as List<Object?>;
    return IntPlayerMsg(
      playerId: result[0] as int?,
      value: result[1] as int?,
    );
  }
}

class FTXVodPlayConfigPlayerMsg {
  FTXVodPlayConfigPlayerMsg({
    this.playerId,
    this.connectRetryCount,
    this.connectRetryInterval,
    this.timeout,
    this.playerType,
    this.headers,
    this.enableAccurateSeek,
    this.autoRotate,
    this.smoothSwitchBitrate,
    this.cacheMp4ExtName,
    this.progressInterval,
    this.maxBufferSize,
    this.maxPreloadSize,
    this.firstStartPlayBufferTime,
    this.nextStartPlayBufferTime,
    this.overlayKey,
    this.overlayIv,
    this.extInfoMap,
    this.enableRenderProcess,
    this.preferredResolution,
    this.mediaType,
    this.encryptedMp4Level,
  });

  int? playerId;

  int? connectRetryCount;

  int? connectRetryInterval;

  int? timeout;

  int? playerType;

  Map<String?, String?>? headers;

  bool? enableAccurateSeek;

  bool? autoRotate;

  bool? smoothSwitchBitrate;

  String? cacheMp4ExtName;

  int? progressInterval;

  double? maxBufferSize;

  double? maxPreloadSize;

  int? firstStartPlayBufferTime;

  int? nextStartPlayBufferTime;

  String? overlayKey;

  String? overlayIv;

  Map<String?, Object?>? extInfoMap;

  bool? enableRenderProcess;

  int? preferredResolution;

  /// Media asset type, default auto type, refer to value see[TXVodPlayEvent]
  /// 媒资类型，默认auto类型, 取值参考 see[TXVodPlayEvent]
  int? mediaType;

  /// MP4 encryption playback:  Supported since version 12.2.
  int? encryptedMp4Level;

  Object encode() {
    return <Object?>[
      playerId,
      connectRetryCount,
      connectRetryInterval,
      timeout,
      playerType,
      headers,
      enableAccurateSeek,
      autoRotate,
      smoothSwitchBitrate,
      cacheMp4ExtName,
      progressInterval,
      maxBufferSize,
      maxPreloadSize,
      firstStartPlayBufferTime,
      nextStartPlayBufferTime,
      overlayKey,
      overlayIv,
      extInfoMap,
      enableRenderProcess,
      preferredResolution,
      mediaType,
      encryptedMp4Level,
    ];
  }

  static FTXVodPlayConfigPlayerMsg decode(Object result) {
    result as List<Object?>;
    return FTXVodPlayConfigPlayerMsg(
      playerId: result[0] as int?,
      connectRetryCount: result[1] as int?,
      connectRetryInterval: result[2] as int?,
      timeout: result[3] as int?,
      playerType: result[4] as int?,
      headers: (result[5] as Map<Object?, Object?>?)?.cast<String?, String?>(),
      enableAccurateSeek: result[6] as bool?,
      autoRotate: result[7] as bool?,
      smoothSwitchBitrate: result[8] as bool?,
      cacheMp4ExtName: result[9] as String?,
      progressInterval: result[10] as int?,
      maxBufferSize: result[11] as double?,
      maxPreloadSize: result[12] as double?,
      firstStartPlayBufferTime: result[13] as int?,
      nextStartPlayBufferTime: result[14] as int?,
      overlayKey: result[15] as String?,
      overlayIv: result[16] as String?,
      extInfoMap: (result[17] as Map<Object?, Object?>?)?.cast<String?, Object?>(),
      enableRenderProcess: result[18] as bool?,
      preferredResolution: result[19] as int?,
      mediaType: result[20] as int?,
      encryptedMp4Level: result[21] as int?,
    );
  }
}

class FTXLivePlayConfigPlayerMsg {
  FTXLivePlayConfigPlayerMsg({
    this.playerId,
    this.cacheTime,
    this.maxAutoAdjustCacheTime,
    this.minAutoAdjustCacheTime,
    this.videoBlockThreshold,
    this.connectRetryCount,
    this.connectRetryInterval,
    this.autoAdjustCacheTime,
    this.enableAec,
    this.enableMessage,
    this.enableMetaData,
    this.flvSessionKey,
  });

  int? playerId;

  double? cacheTime;

  double? maxAutoAdjustCacheTime;

  double? minAutoAdjustCacheTime;

  int? videoBlockThreshold;

  int? connectRetryCount;

  int? connectRetryInterval;

  bool? autoAdjustCacheTime;

  bool? enableAec;

  bool? enableMessage;

  bool? enableMetaData;

  String? flvSessionKey;

  Object encode() {
    return <Object?>[
      playerId,
      cacheTime,
      maxAutoAdjustCacheTime,
      minAutoAdjustCacheTime,
      videoBlockThreshold,
      connectRetryCount,
      connectRetryInterval,
      autoAdjustCacheTime,
      enableAec,
      enableMessage,
      enableMetaData,
      flvSessionKey,
    ];
  }

  static FTXLivePlayConfigPlayerMsg decode(Object result) {
    result as List<Object?>;
    return FTXLivePlayConfigPlayerMsg(
      playerId: result[0] as int?,
      cacheTime: result[1] as double?,
      maxAutoAdjustCacheTime: result[2] as double?,
      minAutoAdjustCacheTime: result[3] as double?,
      videoBlockThreshold: result[4] as int?,
      connectRetryCount: result[5] as int?,
      connectRetryInterval: result[6] as int?,
      autoAdjustCacheTime: result[7] as bool?,
      enableAec: result[8] as bool?,
      enableMessage: result[9] as bool?,
      enableMetaData: result[10] as bool?,
      flvSessionKey: result[11] as String?,
    );
  }
}

class TXVodDownloadMediaMsg {
  TXVodDownloadMediaMsg({
    this.playPath,
    this.progress,
    this.downloadState,
    this.userName,
    this.duration,
    this.playableDuration,
    this.size,
    this.downloadSize,
    this.url,
    this.appId,
    this.fileId,
    this.pSign,
    this.quality,
    this.token,
    this.speed,
    this.isResourceBroken,
  });

  /// 缓存地址
  String? playPath;

  /// 下载进度
  double? progress;

  /// 下载状态
  int? downloadState;

  /// 账户名称,用于url下载设置账户名称
  String? userName;

  /// 总时长
  int? duration;

  /// 已下载的可播放时长
  int? playableDuration;

  /// 文件总大小，单位：byte
  int? size;

  /// 已下载大小，单位：byte
  int? downloadSize;

  /// 需要下载的视频url，url下载必填
  /// <h1>
  /// url下载不支持嵌套m3u8和mp4下载
  /// </h1>
  String? url;

  /// 下载文件对应的appId，fileId下载必填
  int? appId;

  /// 下载文件Id，fileId下载必填
  String? fileId;

  /// 加密签名，加密视频必填
  String? pSign;

  /// 清晰度ID
  int? quality;

  /// 加密token
  String? token;

  /// 下载速度，单位：KByte/秒
  int? speed;

  /// 资源是否已损坏, 如：资源被删除了
  bool? isResourceBroken;

  Object encode() {
    return <Object?>[
      playPath,
      progress,
      downloadState,
      userName,
      duration,
      playableDuration,
      size,
      downloadSize,
      url,
      appId,
      fileId,
      pSign,
      quality,
      token,
      speed,
      isResourceBroken,
    ];
  }

  static TXVodDownloadMediaMsg decode(Object result) {
    result as List<Object?>;
    return TXVodDownloadMediaMsg(
      playPath: result[0] as String?,
      progress: result[1] as double?,
      downloadState: result[2] as int?,
      userName: result[3] as String?,
      duration: result[4] as int?,
      playableDuration: result[5] as int?,
      size: result[6] as int?,
      downloadSize: result[7] as int?,
      url: result[8] as String?,
      appId: result[9] as int?,
      fileId: result[10] as String?,
      pSign: result[11] as String?,
      quality: result[12] as int?,
      token: result[13] as String?,
      speed: result[14] as int?,
      isResourceBroken: result[15] as bool?,
    );
  }
}

class TXDownloadListMsg {
  TXDownloadListMsg({
    this.infoList,
  });

  List<TXVodDownloadMediaMsg?>? infoList;

  Object encode() {
    return <Object?>[
      infoList,
    ];
  }

  static TXDownloadListMsg decode(Object result) {
    result as List<Object?>;
    return TXDownloadListMsg(
      infoList: (result[0] as List<Object?>?)?.cast<TXVodDownloadMediaMsg?>(),
    );
  }
}

class UInt8ListMsg {
  UInt8ListMsg({
    this.value,
  });

  Uint8List? value;

  Object encode() {
    return <Object?>[
      value,
    ];
  }

  static UInt8ListMsg decode(Object result) {
    result as List<Object?>;
    return UInt8ListMsg(
      value: result[0] as Uint8List?,
    );
  }
}

class ListMsg {
  ListMsg({
    this.value,
  });

  List<Object?>? value;

  Object encode() {
    return <Object?>[
      value,
    ];
  }

  static ListMsg decode(Object result) {
    result as List<Object?>;
    return ListMsg(
      value: result[0] as List<Object?>?,
    );
  }
}

class BoolMsg {
  BoolMsg({
    this.value,
  });

  bool? value;

  Object encode() {
    return <Object?>[
      value,
    ];
  }

  static BoolMsg decode(Object result) {
    result as List<Object?>;
    return BoolMsg(
      value: result[0] as bool?,
    );
  }
}

class IntMsg {
  IntMsg({
    this.value,
  });

  int? value;

  Object encode() {
    return <Object?>[
      value,
    ];
  }

  static IntMsg decode(Object result) {
    result as List<Object?>;
    return IntMsg(
      value: result[0] as int?,
    );
  }
}

class StringMsg {
  StringMsg({
    this.value,
  });

  String? value;

  Object encode() {
    return <Object?>[
      value,
    ];
  }

  static StringMsg decode(Object result) {
    result as List<Object?>;
    return StringMsg(
      value: result[0] as String?,
    );
  }
}

class CachePathMsg {
  CachePathMsg({
    this.androidAbsolutePath,
    this.iOSAbsolutePath,
  });

  String? androidAbsolutePath;

  String? iOSAbsolutePath;

  Object encode() {
    return <Object?>[
      androidAbsolutePath,
      iOSAbsolutePath,
    ];
  }

  static CachePathMsg decode(Object result) {
    result as List<Object?>;
    return CachePathMsg(
      androidAbsolutePath: result[0] as String?,
      iOSAbsolutePath: result[1] as String?,
    );
  }
}

class DoubleMsg {
  DoubleMsg({
    this.value,
  });

  double? value;

  Object encode() {
    return <Object?>[
      value,
    ];
  }

  static DoubleMsg decode(Object result) {
    result as List<Object?>;
    return DoubleMsg(
      value: result[0] as double?,
    );
  }
}

class PreLoadMsg {
  PreLoadMsg({
    this.playUrl,
    this.preloadSizeMB,
    this.preferredResolution,
  });

  String? playUrl;

  double? preloadSizeMB;

  int? preferredResolution;

  Object encode() {
    return <Object?>[
      playUrl,
      preloadSizeMB,
      preferredResolution,
    ];
  }

  static PreLoadMsg decode(Object result) {
    result as List<Object?>;
    return PreLoadMsg(
      playUrl: result[0] as String?,
      preloadSizeMB: result[1] as double?,
      preferredResolution: result[2] as int?,
    );
  }
}

class PreLoadInfoMsg {
  PreLoadInfoMsg({
    this.appId,
    this.fileId,
    this.pSign,
    this.playUrl,
    this.preloadSizeMB,
    this.preferredResolution,
    this.tmpPreloadTaskId,
    this.httpHeader,
  });

  int? appId;

  String? fileId;

  String? pSign;

  String? playUrl;

  double? preloadSizeMB;

  int? preferredResolution;

  int? tmpPreloadTaskId;

  Map<String?, String?>? httpHeader;

  Object encode() {
    return <Object?>[
      appId,
      fileId,
      pSign,
      playUrl,
      preloadSizeMB,
      preferredResolution,
      tmpPreloadTaskId,
      httpHeader,
    ];
  }

  static PreLoadInfoMsg decode(Object result) {
    result as List<Object?>;
    return PreLoadInfoMsg(
      appId: result[0] as int?,
      fileId: result[1] as String?,
      pSign: result[2] as String?,
      playUrl: result[3] as String?,
      preloadSizeMB: result[4] as double?,
      preferredResolution: result[5] as int?,
      tmpPreloadTaskId: result[6] as int?,
      httpHeader: (result[7] as Map<Object?, Object?>?)?.cast<String?, String?>(),
    );
  }
}

class MapMsg {
  MapMsg({
    this.map,
  });

  Map<String?, String?>? map;

  Object encode() {
    return <Object?>[
      map,
    ];
  }

  static MapMsg decode(Object result) {
    result as List<Object?>;
    return MapMsg(
      map: (result[0] as Map<Object?, Object?>?)?.cast<String?, String?>(),
    );
  }
}

class SubTitlePlayerMsg {
  SubTitlePlayerMsg({
    required this.url,
    required this.name,
    this.mimeType,
    this.playerId,
  });

  String url;

  String name;

  String? mimeType;

  int? playerId;

  Object encode() {
    return <Object?>[
      url,
      name,
      mimeType,
      playerId,
    ];
  }

  static SubTitlePlayerMsg decode(Object result) {
    result as List<Object?>;
    return SubTitlePlayerMsg(
      url: result[0]! as String,
      name: result[1]! as String,
      mimeType: result[2] as String?,
      playerId: result[3] as int?,
    );
  }
}

class SubTitleRenderModelPlayerMsg {
  SubTitleRenderModelPlayerMsg({
    this.canvasWidth,
    this.canvasHeight,
    this.familyName,
    this.fontSize,
    this.fontScale,
    this.fontColor,
    this.isBondFontStyle,
    this.outlineWidth,
    this.outlineColor,
    this.lineSpace,
    this.startMargin,
    this.endMargin,
    this.verticalMargin,
    this.playerId,
  });

  int? canvasWidth;

  int? canvasHeight;

  String? familyName;

  double? fontSize;

  double? fontScale;

  int? fontColor;

  bool? isBondFontStyle;

  double? outlineWidth;

  int? outlineColor;

  double? lineSpace;

  double? startMargin;

  double? endMargin;

  double? verticalMargin;

  int? playerId;

  Object encode() {
    return <Object?>[
      canvasWidth,
      canvasHeight,
      familyName,
      fontSize,
      fontScale,
      fontColor,
      isBondFontStyle,
      outlineWidth,
      outlineColor,
      lineSpace,
      startMargin,
      endMargin,
      verticalMargin,
      playerId,
    ];
  }

  static SubTitleRenderModelPlayerMsg decode(Object result) {
    result as List<Object?>;
    return SubTitleRenderModelPlayerMsg(
      canvasWidth: result[0] as int?,
      canvasHeight: result[1] as int?,
      familyName: result[2] as String?,
      fontSize: result[3] as double?,
      fontScale: result[4] as double?,
      fontColor: result[5] as int?,
      isBondFontStyle: result[6] as bool?,
      outlineWidth: result[7] as double?,
      outlineColor: result[8] as int?,
      lineSpace: result[9] as double?,
      startMargin: result[10] as double?,
      endMargin: result[11] as double?,
      verticalMargin: result[12] as double?,
      playerId: result[13] as int?,
    );
  }
}

class StringOptionPlayerMsg {
  StringOptionPlayerMsg({
    this.key,
    this.value,
    this.playerId,
  });

  String? key;

  List<Object?>? value;

  int? playerId;

  Object encode() {
    return <Object?>[
      key,
      value,
      playerId,
    ];
  }

  static StringOptionPlayerMsg decode(Object result) {
    result as List<Object?>;
    return StringOptionPlayerMsg(
      key: result[0] as String?,
      value: (result[1] as List<Object?>?)?.cast<Object?>(),
      playerId: result[2] as int?,
    );
  }
}


class _PigeonCodec extends StandardMessageCodec {
  const _PigeonCodec();
  @override
  void writeValue(WriteBuffer buffer, Object? value) {
    if (value is int) {
      buffer.putUint8(4);
      buffer.putInt64(value);
    }    else if (value is PlayerMsg) {
      buffer.putUint8(129);
      writeValue(buffer, value.encode());
    }    else if (value is LicenseMsg) {
      buffer.putUint8(130);
      writeValue(buffer, value.encode());
    }    else if (value is TXPlayInfoParamsPlayerMsg) {
      buffer.putUint8(131);
      writeValue(buffer, value.encode());
    }    else if (value is TXPlayerDrmMsg) {
      buffer.putUint8(132);
      writeValue(buffer, value.encode());
    }    else if (value is PipParamsPlayerMsg) {
      buffer.putUint8(133);
      writeValue(buffer, value.encode());
    }    else if (value is StringListPlayerMsg) {
      buffer.putUint8(134);
      writeValue(buffer, value.encode());
    }    else if (value is BoolPlayerMsg) {
      buffer.putUint8(135);
      writeValue(buffer, value.encode());
    }    else if (value is StringIntPlayerMsg) {
      buffer.putUint8(136);
      writeValue(buffer, value.encode());
    }    else if (value is StringPlayerMsg) {
      buffer.putUint8(137);
      writeValue(buffer, value.encode());
    }    else if (value is DoublePlayerMsg) {
      buffer.putUint8(138);
      writeValue(buffer, value.encode());
    }    else if (value is IntPlayerMsg) {
      buffer.putUint8(139);
      writeValue(buffer, value.encode());
    }    else if (value is FTXVodPlayConfigPlayerMsg) {
      buffer.putUint8(140);
      writeValue(buffer, value.encode());
    }    else if (value is FTXLivePlayConfigPlayerMsg) {
      buffer.putUint8(141);
      writeValue(buffer, value.encode());
    }    else if (value is TXVodDownloadMediaMsg) {
      buffer.putUint8(142);
      writeValue(buffer, value.encode());
    }    else if (value is TXDownloadListMsg) {
      buffer.putUint8(143);
      writeValue(buffer, value.encode());
    }    else if (value is UInt8ListMsg) {
      buffer.putUint8(144);
      writeValue(buffer, value.encode());
    }    else if (value is ListMsg) {
      buffer.putUint8(145);
      writeValue(buffer, value.encode());
    }    else if (value is BoolMsg) {
      buffer.putUint8(146);
      writeValue(buffer, value.encode());
    }    else if (value is IntMsg) {
      buffer.putUint8(147);
      writeValue(buffer, value.encode());
    }    else if (value is StringMsg) {
      buffer.putUint8(148);
      writeValue(buffer, value.encode());
    }    else if (value is CachePathMsg) {
      buffer.putUint8(149);
      writeValue(buffer, value.encode());
    }    else if (value is DoubleMsg) {
      buffer.putUint8(150);
      writeValue(buffer, value.encode());
    }    else if (value is PreLoadMsg) {
      buffer.putUint8(151);
      writeValue(buffer, value.encode());
    }    else if (value is PreLoadInfoMsg) {
      buffer.putUint8(152);
      writeValue(buffer, value.encode());
    }    else if (value is MapMsg) {
      buffer.putUint8(153);
      writeValue(buffer, value.encode());
    }    else if (value is SubTitlePlayerMsg) {
      buffer.putUint8(154);
      writeValue(buffer, value.encode());
    }    else if (value is SubTitleRenderModelPlayerMsg) {
      buffer.putUint8(155);
      writeValue(buffer, value.encode());
    }    else if (value is StringOptionPlayerMsg) {
      buffer.putUint8(156);
      writeValue(buffer, value.encode());
    } else {
      super.writeValue(buffer, value);
    }
  }

  @override
  Object? readValueOfType(int type, ReadBuffer buffer) {
    switch (type) {
      case 129: 
        return PlayerMsg.decode(readValue(buffer)!);
      case 130: 
        return LicenseMsg.decode(readValue(buffer)!);
      case 131: 
        return TXPlayInfoParamsPlayerMsg.decode(readValue(buffer)!);
      case 132: 
        return TXPlayerDrmMsg.decode(readValue(buffer)!);
      case 133: 
        return PipParamsPlayerMsg.decode(readValue(buffer)!);
      case 134: 
        return StringListPlayerMsg.decode(readValue(buffer)!);
      case 135: 
        return BoolPlayerMsg.decode(readValue(buffer)!);
      case 136: 
        return StringIntPlayerMsg.decode(readValue(buffer)!);
      case 137: 
        return StringPlayerMsg.decode(readValue(buffer)!);
      case 138: 
        return DoublePlayerMsg.decode(readValue(buffer)!);
      case 139: 
        return IntPlayerMsg.decode(readValue(buffer)!);
      case 140: 
        return FTXVodPlayConfigPlayerMsg.decode(readValue(buffer)!);
      case 141: 
        return FTXLivePlayConfigPlayerMsg.decode(readValue(buffer)!);
      case 142: 
        return TXVodDownloadMediaMsg.decode(readValue(buffer)!);
      case 143: 
        return TXDownloadListMsg.decode(readValue(buffer)!);
      case 144: 
        return UInt8ListMsg.decode(readValue(buffer)!);
      case 145: 
        return ListMsg.decode(readValue(buffer)!);
      case 146: 
        return BoolMsg.decode(readValue(buffer)!);
      case 147: 
        return IntMsg.decode(readValue(buffer)!);
      case 148: 
        return StringMsg.decode(readValue(buffer)!);
      case 149: 
        return CachePathMsg.decode(readValue(buffer)!);
      case 150: 
        return DoubleMsg.decode(readValue(buffer)!);
      case 151: 
        return PreLoadMsg.decode(readValue(buffer)!);
      case 152: 
        return PreLoadInfoMsg.decode(readValue(buffer)!);
      case 153: 
        return MapMsg.decode(readValue(buffer)!);
      case 154: 
        return SubTitlePlayerMsg.decode(readValue(buffer)!);
      case 155: 
        return SubTitleRenderModelPlayerMsg.decode(readValue(buffer)!);
      case 156: 
        return StringOptionPlayerMsg.decode(readValue(buffer)!);
      default:
        return super.readValueOfType(type, buffer);
    }
  }
}

class TXFlutterSuperPlayerPluginAPI {
  /// Constructor for [TXFlutterSuperPlayerPluginAPI].  The [binaryMessenger] named argument is
  /// available for dependency injection.  If it is left null, the default
  /// BinaryMessenger will be used which routes to the host platform.
  TXFlutterSuperPlayerPluginAPI({BinaryMessenger? binaryMessenger, String messageChannelSuffix = ''})
      : pigeonVar_binaryMessenger = binaryMessenger,
        pigeonVar_messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
  final BinaryMessenger? pigeonVar_binaryMessenger;

  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  final String pigeonVar_messageChannelSuffix;

  Future<StringMsg> getPlatformVersion() async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.getPlatformVersion$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(null) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as StringMsg?)!;
    }
  }

  /// 创建点播播放器
  Future<PlayerMsg> createVodPlayer() async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.createVodPlayer$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(null) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as PlayerMsg?)!;
    }
  }

  /// 创建直播播放器
  Future<PlayerMsg> createLivePlayer() async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.createLivePlayer$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(null) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as PlayerMsg?)!;
    }
  }

  /// 开关log输出
  Future<void> setConsoleEnabled(BoolMsg enabled) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.setConsoleEnabled$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[enabled]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// 释放播放器资源
  Future<void> releasePlayer(PlayerMsg playerId) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.releasePlayer$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[playerId]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// 设置播放引擎的最大缓存大小。设置后会根据设定值自动清理Cache目录的文件
  /// @param size 最大缓存大小（单位：MB)
  Future<void> setGlobalMaxCacheSize(IntMsg size) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.setGlobalMaxCacheSize$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[size]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// 在短视频播放场景中，视频文件的本地缓存是很刚需的一个特性，对于普通用户而言，一个已经看过的视频再次观看时，不应该再消耗一次流量。
  ///  @格式支持：SDK 支持 HLS(m3u8) 和 MP4 两种常见点播格式的缓存功能。
  ///  @开启时机：SDK 并不默认开启缓存功能，对于用户回看率不高的场景，也并不推荐您开启此功能。
  ///  @开启方式：全局生效，在使用播放器开启。开启此功能需要配置两个参数：本地缓存目录及缓存大小。
  ///
  /// 该缓存路径默认设置到app沙盒目录下，postfixPath只需要传递相对缓存目录即可，不需要传递整个绝对路径。
  /// e.g. postfixPath = 'testCache'
  /// Android 平台：视频将会缓存到sdcard的Android/data/your-pkg-name/files/testCache 目录。
  /// iOS 平台：视频将会缓存到沙盒的Documents/testCache 目录。
  /// @param postfixPath 缓存目录
  /// @return true 设置成功 false 设置失败
  Future<BoolMsg> setGlobalCacheFolderPath(StringMsg postfixPath) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.setGlobalCacheFolderPath$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[postfixPath]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as BoolMsg?)!;
    }
  }

  /// 设置播放器资源缓存目录绝对路径，该方法会与 setGlobalCacheFolderPath(String postfixPath) 相互覆盖，调用其中一个即可
  Future<BoolMsg> setGlobalCacheFolderCustomPath(CachePathMsg cacheMsg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.setGlobalCacheFolderCustomPath$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[cacheMsg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as BoolMsg?)!;
    }
  }

  /// 设置全局license
  Future<void> setGlobalLicense(LicenseMsg licenseMsg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.setGlobalLicense$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[licenseMsg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// 设置log输出级别 [TXLogLevel]
  Future<void> setLogLevel(IntMsg logLevel) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.setLogLevel$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[logLevel]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// 获取依赖Native端的 LiteAVSDK 的版本
  Future<StringMsg> getLiteAVSDKVersion() async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.getLiteAVSDKVersion$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(null) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as StringMsg?)!;
    }
  }

  ///
  /// 设置 liteav SDK 接入的环境。
  /// 腾讯云在全球各地区部署的环境，按照各地区政策法规要求，需要接入不同地区接入点。
  ///
  /// @param envConfig 需要接入的环境，SDK 默认接入的环境是：默认正式环境。
  /// @return 0：成功；其他：错误
  /// @note 目标市场为中国大陆的客户请不要调用此接口，如果目标市场为海外用户，请通过技术支持联系我们，了解 env_config 的配置方法，以确保 App 遵守 GDPR 标准。
  ///
  Future<IntMsg> setGlobalEnv(StringMsg envConfig) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.setGlobalEnv$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[envConfig]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as IntMsg?)!;
    }
  }

  ///
  /// 开始监听设备旋转方向，开启之后，如果设备自动旋转打开，播放器会自动根据当前设备方向来旋转视频方向。
  /// <h1>该接口目前只适用安卓端，IOS端会自动开启该能力</h1>
  /// 在调用该接口前，请务必向用户告知隐私风险。
  /// 如有需要，请确认是否有获取旋转sensor的权限。
  /// @return true : 开启成功
  ///         false : 开启失败，如开启过早，还未等到上下文初始化、获取sensor失败等原因
  Future<BoolMsg> startVideoOrientationService() async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.startVideoOrientationService$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(null) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as BoolMsg?)!;
    }
  }

  Future<void> setUserId(StringMsg msg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.setUserId$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[msg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> setLicenseFlexibleValid(BoolMsg msg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.setLicenseFlexibleValid$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[msg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }
}

class TXFlutterNativeAPI {
  /// Constructor for [TXFlutterNativeAPI].  The [binaryMessenger] named argument is
  /// available for dependency injection.  If it is left null, the default
  /// BinaryMessenger will be used which routes to the host platform.
  TXFlutterNativeAPI({BinaryMessenger? binaryMessenger, String messageChannelSuffix = ''})
      : pigeonVar_binaryMessenger = binaryMessenger,
        pigeonVar_messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
  final BinaryMessenger? pigeonVar_binaryMessenger;

  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  final String pigeonVar_messageChannelSuffix;

  /// 修改当前界面亮度
  Future<void> setBrightness(DoubleMsg brightness) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterNativeAPI.setBrightness$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[brightness]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// 恢复当前界面亮度
  Future<void> restorePageBrightness() async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterNativeAPI.restorePageBrightness$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(null) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// 获得当前界面亮度 0.0 ~ 1.0
  Future<DoubleMsg> getBrightness() async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterNativeAPI.getBrightness$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(null) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as DoubleMsg?)!;
    }
  }

  /// 获取系统界面亮度，IOS系统与界面亮度一致，安卓可能会有差异
  Future<DoubleMsg> getSysBrightness() async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterNativeAPI.getSysBrightness$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(null) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as DoubleMsg?)!;
    }
  }

  /// 设置当前系统音量，0.0 ~ 1.0
  Future<void> setSystemVolume(DoubleMsg volume) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterNativeAPI.setSystemVolume$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[volume]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// 获得当前系统音量，范围：0.0 ~ 1.0
  Future<DoubleMsg> getSystemVolume() async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterNativeAPI.getSystemVolume$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(null) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as DoubleMsg?)!;
    }
  }

  /// 释放音频焦点，只用于安卓端
  Future<void> abandonAudioFocus() async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterNativeAPI.abandonAudioFocus$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(null) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// 请求获得音频焦点，只用于安卓端
  Future<void> requestAudioFocus() async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterNativeAPI.requestAudioFocus$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(null) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// 当前设备是否支持画中画模式
  /// @return [TXVodPlayEvent]
  ///  0 可开启画中画模式
  ///  -101  android版本过低
  ///  -102  画中画权限关闭/设备不支持画中画
  ///  -103  当前界面已销毁
  Future<IntMsg> isDeviceSupportPip() async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterNativeAPI.isDeviceSupportPip$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(null) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as IntMsg?)!;
    }
  }

  ///
  /// register or unregister system brightness
  ///
  Future<void> registerSysBrightness(BoolMsg isRegister) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterNativeAPI.registerSysBrightness$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[isRegister]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }
}

class TXFlutterVodPlayerApi {
  /// Constructor for [TXFlutterVodPlayerApi].  The [binaryMessenger] named argument is
  /// available for dependency injection.  If it is left null, the default
  /// BinaryMessenger will be used which routes to the host platform.
  TXFlutterVodPlayerApi({BinaryMessenger? binaryMessenger, String messageChannelSuffix = ''})
      : pigeonVar_binaryMessenger = binaryMessenger,
        pigeonVar_messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
  final BinaryMessenger? pigeonVar_binaryMessenger;

  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  final String pigeonVar_messageChannelSuffix;

  /// 播放器初始化，创建共享纹理、初始化播放器
  ///
  /// To initialize the player, you would need to create a shared texture and initialize the player.
  /// @param onlyAudio 是否是纯音频模式 if pure audio mode
  Future<IntMsg> initialize(BoolPlayerMsg onlyAudio) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.initialize$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[onlyAudio]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as IntMsg?)!;
    }
  }

  /// 通过url开始播放视频
  /// 10.7版本开始，startPlay变更为startVodPlay，需要通过 {@link SuperPlayerPlugin#setGlobalLicense} 设置 Licence 后方可成功播放，
  /// 否则将播放失败（黑屏），全局仅设置一次即可。直播 Licence、短视频 Licence 和视频播放 Licence 均可使用，若您暂未获取上述 Licence ，
  /// 可[快速免费申请测试版 Licence](https://cloud.tencent.com/act/event/License) 以正常播放，正式版 License 需[购买]
  /// (https://cloud.tencent.com/document/product/881/74588#.E8.B4.AD.E4.B9.B0.E5.B9.B6.E6.96.B0.E5.BB.BA.E6.AD.A3.E5.BC.8F.E7.89.88-license)。
  ///
  /// Starting from version 10.7, the method `startPlay` has been changed to `startVodPlay` for playing videos via a URL.
  /// To play videos successfully, it is necessary to set the license by using the method `SuperPlayerPlugin#setGlobalLicense`.
  /// Failure to set the license will result in video playback failure (a black screen).
  /// Live streaming, short video, and video playback licenses can all be used. If you do not have any of the above licenses,
  /// you can apply for a free trial license to play videos normally[Quickly apply for a free trial version Licence]
  /// (https://cloud.tencent.com/act/event/License).Official licenses can be purchased
  /// (https://cloud.tencent.com/document/product/881/74588#.E8.B4.AD.E4.B9.B0.E5.B9.B6.E6.96.B0.E5.BB.BA.E6.AD.A3.E5.BC.8F.E7.89.88-license).
  /// @param url : 视频播放地址 video playback address
  /// return 是否播放成功 if play successfully
  Future<BoolMsg> startVodPlay(StringPlayerMsg url) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.startVodPlay$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[url]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as BoolMsg?)!;
    }
  }

  /// 通过fileId播放视频
  /// 10.7版本开始，startPlayWithParams变更为startVodPlayWithParams，需要通过 {@link SuperPlayerPlugin#setGlobalLicense} 设置 Licence 后方可成功播放，
  /// 否则将播放失败（黑屏），全局仅设置一次即可。直播 Licence、短视频 Licence 和视频播放 Licence 均可使用，若您暂未获取上述 Licence ，
  /// 可[快速免费申请测试版 Licence](https://cloud.tencent.com/act/event/License) 以正常播放，正式版 License 需[购买]
  /// (https://cloud.tencent.com/document/product/881/74588#.E8.B4.AD.E4.B9.B0.E5.B9.B6.E6.96.B0.E5.BB.BA.E6.AD.A3.E5.BC.8F.E7.89.88-license)。
  ///
  /// Starting from version 10.7, the method "startPlayWithParams" has been changed to "startVodPlayWithParams" for playing videos using fileId.
  /// To play the video successfully, you need to set the Licence using "SuperPlayerPlugin#setGlobalLicense" method before playing the video.
  /// If you do not set the Licence, the video will not play (black screen). The Licence for live streaming,
  /// short video, and video playback can all be used. If you have not obtained the Licence, you can apply for a free trial version [here]
  /// (https://cloud.tencent.com/act/event/License) for normal playback. To use the official version, you need to [purchase]
  /// (https://cloud.tencent.com/document/product/881/74588#.E8.B4.AD.E4.B9.B0.E5.B9.B6.E6.96.B0.E5.BB.BA.E6.AD.A3.E5.BC.8F.E7.89.88-license).
  /// @params : see[TXPlayInfoParams]
  /// return 是否播放成功  if play successful
  Future<void> startVodPlayWithParams(TXPlayInfoParamsPlayerMsg params) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.startVodPlayWithParams$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[params]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// 播放 DRM 加密视频
  ///
  /// Playing DRM-encrypted video.
  Future<IntMsg> startPlayDrm(TXPlayerDrmMsg params) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.startPlayDrm$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[params]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as IntMsg?)!;
    }
  }

  /// 设置是否自动播放
  ///
  /// set autoplay
  Future<void> setAutoPlay(BoolPlayerMsg isAutoPlay) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.setAutoPlay$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[isAutoPlay]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// 停止播放
  ///
  /// Stop playback
  /// return 是否停止成功 if stop successful
  Future<BoolMsg> stop(BoolPlayerMsg isNeedClear) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.stop$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[isNeedClear]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as BoolMsg?)!;
    }
  }

  /// 视频是否处于正在播放中
  ///
  /// Is the video currently playing
  Future<BoolMsg> isPlaying(PlayerMsg playerMsg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.isPlaying$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[playerMsg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as BoolMsg?)!;
    }
  }

  /// 视频暂停，必须在播放器开始播放的时候调用
  ///
  /// pause video, it must be called when the player starts playing
  Future<void> pause(PlayerMsg playerMsg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.pause$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[playerMsg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// 继续播放，在暂停的时候调用
  ///
  /// resume playback, it should be called when the video is paused
  Future<void> resume(PlayerMsg playerMsg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.resume$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[playerMsg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// 设置是否静音
  ///
  /// Set whether to mute or not
  Future<void> setMute(BoolPlayerMsg mute) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.setMute$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[mute]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// 设置是否循环播放
  ///
  /// Set whether to loop playback or not
  Future<void> setLoop(BoolPlayerMsg loop) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.setLoop$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[loop]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// 将视频播放进度定位到指定的进度进行播放
  ///
  /// Set the video playback progress to a specific time and start playing.
  /// progress 要定位的视频时间，单位 秒 The video playback time to be located, in seconds
  Future<void> seek(DoublePlayerMsg progress) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.seek$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[progress]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// 跳转到视频流指定PDT时间点, 可实现视频快进,快退,进度条跳转等功能
  /// 单位毫秒(ms)
  /// 播放器高级版 11.6 版本开始支持
  ///
  /// Jump to the specified PDT time point of the video stream, which can realize video fast forward, fast rewind, progress bar jump and other functions.
  /// Unit millisecond (ms)
  /// Player Premium version 11.6 starts to support
  Future<void> seekToPdtTime(IntPlayerMsg pdtTimeMs) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.seekToPdtTime$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[pdtTimeMs]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// 设置播放速率，默认速率 1
  ///
  /// Set the playback speed, with a default speed of 1.
  Future<void> setRate(DoublePlayerMsg rate) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.setRate$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[rate]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// 获得播放视频解析出来的码率信息
  ///
  /// get the bitrate information extracted from playing a video
  /// return List<Map>
  /// Bitrate：index 码率序号，
  ///         width 码率对应视频宽度，
  ///         height 码率对应视频高度,
  ///         bitrate 码率值
  ///
  /// Bitrate：index:bitrate index，
  ///         width:the video with of this bitrate，
  ///         height:the video height of this bitrate,
  ///         bitrate:bitrate value
  Future<ListMsg> getSupportedBitrate(PlayerMsg playerMsg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.getSupportedBitrate$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[playerMsg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as ListMsg?)!;
    }
  }

  /// 获得当前设置的码率序号
  ///
  /// Get the index of the current bitrate setting
  Future<IntMsg> getBitrateIndex(PlayerMsg playerMsg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.getBitrateIndex$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[playerMsg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as IntMsg?)!;
    }
  }

  /// 设置码率序号
  ///
  /// Set the index of the bitrate setting.
  Future<void> setBitrateIndex(IntPlayerMsg index) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.setBitrateIndex$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[index]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// 设置视频播放开始时间，单位 秒
  ///
  /// Set the start time of the video playback, in seconds.
  Future<void> setStartTime(DoublePlayerMsg startTime) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.setStartTime$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[startTime]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// 设置视频声音 0~100
  ///
  /// Set the volume of the video, ranging from 0 to 100.
  Future<void> setAudioPlayOutVolume(IntPlayerMsg volume) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.setAudioPlayOutVolume$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[volume]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// 请求获得音频焦点
  ///
  /// Request audio focus.
  Future<BoolMsg> setRequestAudioFocus(BoolPlayerMsg focus) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.setRequestAudioFocus$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[focus]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as BoolMsg?)!;
    }
  }

  /// 设置播放器配置
  ///
  /// Set player configuration
  /// config @see [FTXVodPlayConfig]
  Future<void> setConfig(FTXVodPlayConfigPlayerMsg config) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.setConfig$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[config]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// 获得当前已经播放的时间，单位 秒
  ///
  /// Get the current playback time, in seconds.
  Future<DoubleMsg> getCurrentPlaybackTime(PlayerMsg playerMsg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.getCurrentPlaybackTime$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[playerMsg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as DoubleMsg?)!;
    }
  }

  /// 获得当前视频已缓存的时间
  ///
  /// Get the current amount of video that has been buffered.
  Future<DoubleMsg> getBufferDuration(PlayerMsg playerMsg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.getBufferDuration$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[playerMsg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as DoubleMsg?)!;
    }
  }

  /// 获得当前视频的可播放时间
  ///
  /// Get the current playable duration of the video.
  Future<DoubleMsg> getPlayableDuration(PlayerMsg playerMsg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.getPlayableDuration$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[playerMsg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as DoubleMsg?)!;
    }
  }

  /// 获得当前播放视频的宽度
  ///
  /// Get the width of the currently playing video.
  Future<IntMsg> getWidth(PlayerMsg playerMsg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.getWidth$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[playerMsg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as IntMsg?)!;
    }
  }

  /// 获得当前播放视频的高度
  ///
  /// Get the height of the currently playing video.
  Future<IntMsg> getHeight(PlayerMsg playerMsg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.getHeight$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[playerMsg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as IntMsg?)!;
    }
  }

  /// 设置播放视频的token
  ///
  /// Set the token for playing the video.
  Future<void> setToken(StringPlayerMsg token) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.setToken$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[token]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// 当前播放的视频是否循环播放
  ///
  /// Is the currently playing video set to loop
  Future<BoolMsg> isLoop(PlayerMsg playerMsg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.isLoop$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[playerMsg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as BoolMsg?)!;
    }
  }

  /// 开启/关闭硬件编码
  ///
  /// Enable/Disable hardware encoding.
  Future<BoolMsg> enableHardwareDecode(BoolPlayerMsg enable) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.enableHardwareDecode$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[enable]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as BoolMsg?)!;
    }
  }

  /// 进入画中画模式，进入画中画模式，需要适配画中画模式的界面，安卓只支持7.0以上机型
  /// <h1>
  /// 由于android系统限制，传递的图标大小不得超过1M，否则无法显示
  /// </h1>
  /// @param backIcon playIcon pauseIcon forwardIcon 为播放后退、播放、暂停、前进的图标，如果赋值的话，将会使用传递的图标，否则
  /// 使用系统默认图标，只支持flutter本地资源图片，传递的时候，与flutter使用图片资源一致，例如： images/back_icon.png
  Future<IntMsg> enterPictureInPictureMode(PipParamsPlayerMsg pipParamsMsg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.enterPictureInPictureMode$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[pipParamsMsg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as IntMsg?)!;
    }
  }

  /// 退出画中画，如果该播放器处于画中画模式
  ///
  /// Exit picture-in-picture mode if the video player is in picture-in-picture mode.
  Future<void> exitPictureInPictureMode(PlayerMsg playerMsg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.exitPictureInPictureMode$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[playerMsg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> initImageSprite(StringListPlayerMsg spriteInfo) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.initImageSprite$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[spriteInfo]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<UInt8ListMsg> getImageSprite(DoublePlayerMsg time) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.getImageSprite$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[time]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as UInt8ListMsg?)!;
    }
  }

  /// 获取总时长
  ///
  /// To get the total duration
  Future<DoubleMsg> getDuration(PlayerMsg playerMsg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.getDuration$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[playerMsg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as DoubleMsg?)!;
    }
  }

  Future<void> addSubtitleSource(SubTitlePlayerMsg playerMsg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.addSubtitleSource$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[playerMsg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<ListMsg> getSubtitleTrackInfo(PlayerMsg playerMsg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.getSubtitleTrackInfo$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[playerMsg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as ListMsg?)!;
    }
  }

  Future<ListMsg> getAudioTrackInfo(PlayerMsg playerMsg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.getAudioTrackInfo$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[playerMsg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as ListMsg?)!;
    }
  }

  Future<void> selectTrack(IntPlayerMsg playerMsg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.selectTrack$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[playerMsg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> deselectTrack(IntPlayerMsg playerMsg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.deselectTrack$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[playerMsg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> setSubtitleStyle(SubTitleRenderModelPlayerMsg playerMsg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.setSubtitleStyle$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[playerMsg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<void> setStringOption(StringOptionPlayerMsg playerMsg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.setStringOption$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[playerMsg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }
}

class TXFlutterLivePlayerApi {
  /// Constructor for [TXFlutterLivePlayerApi].  The [binaryMessenger] named argument is
  /// available for dependency injection.  If it is left null, the default
  /// BinaryMessenger will be used which routes to the host platform.
  TXFlutterLivePlayerApi({BinaryMessenger? binaryMessenger, String messageChannelSuffix = ''})
      : pigeonVar_binaryMessenger = binaryMessenger,
        pigeonVar_messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
  final BinaryMessenger? pigeonVar_binaryMessenger;

  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  final String pigeonVar_messageChannelSuffix;

  /// 播放器初始化，创建共享纹理、初始化播放器
  /// @param onlyAudio 是否是纯音频模式
  Future<IntMsg> initialize(BoolPlayerMsg onlyAudio) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.initialize$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[onlyAudio]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as IntMsg?)!;
    }
  }

  ///
  /// 当设置[LivePlayer] 类型播放器时
  /// 10.7版本开始，startPlay变更为startLivePlay，需要通过 {@link SuperPlayerPlugin#setGlobalLicense} 设置 Licence 后方可成功播放，
  /// 否则将播放失败（黑屏），全局仅设置一次即可。直播 Licence、短视频 Licence 和视频播放 Licence 均可使用，若您暂未获取上述 Licence ，
  /// 可[快速免费申请测试版 Licence](https://cloud.tencent.com/act/event/License) 以正常播放，正式版 License 需[购买]
  /// (https://cloud.tencent.com/document/product/881/74588#.E8.B4.AD.E4.B9.B0.E5.B9.B6.E6.96.B0.E5.BB.BA.E6.AD.A3.E5.BC.8F.E7.89.88-license)。
  Future<BoolMsg> startLivePlay(StringPlayerMsg playerMsg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.startLivePlay$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[playerMsg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as BoolMsg?)!;
    }
  }

  /// 停止播放
  /// return 是否停止成功
  Future<BoolMsg> stop(BoolPlayerMsg isNeedClear) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.stop$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[isNeedClear]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as BoolMsg?)!;
    }
  }

  /// 视频是否处于正在播放中
  Future<BoolMsg> isPlaying(PlayerMsg playerMsg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.isPlaying$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[playerMsg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as BoolMsg?)!;
    }
  }

  /// 视频暂停，必须在播放器开始播放的时候调用
  Future<void> pause(PlayerMsg playerMsg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.pause$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[playerMsg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// 继续播放，在暂停的时候调用
  Future<void> resume(PlayerMsg playerMsg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.resume$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[playerMsg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// 设置直播模式，see TXPlayerLiveMode
  Future<void> setLiveMode(IntPlayerMsg mode) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.setLiveMode$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[mode]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// 设置视频声音 0~100
  Future<void> setVolume(IntPlayerMsg volume) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.setVolume$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[volume]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// 设置是否静音
  Future<void> setMute(BoolPlayerMsg mute) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.setMute$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[mute]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// 切换播放流
  Future<IntMsg> switchStream(StringPlayerMsg url) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.switchStream$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[url]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as IntMsg?)!;
    }
  }

  /// 设置appId
  Future<void> setAppID(StringPlayerMsg appId) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.setAppID$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[appId]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// 设置播放器配置
  /// config @see [FTXLivePlayConfig]
  Future<void> setConfig(FTXLivePlayConfigPlayerMsg config) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.setConfig$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[config]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// 开启/关闭硬件编码
  Future<BoolMsg> enableHardwareDecode(BoolPlayerMsg enable) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.enableHardwareDecode$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[enable]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as BoolMsg?)!;
    }
  }

  /// 进入画中画模式，进入画中画模式，需要适配画中画模式的界面，安卓只支持7.0以上机型
  /// <h1>
  /// 由于android系统限制，传递的图标大小不得超过1M，否则无法显示
  /// </h1>
  /// @param backIcon playIcon pauseIcon forwardIcon 为播放后退、播放、暂停、前进的图标，仅适用于android，如果赋值的话，将会使用传递的图标，否则
  /// 使用系统默认图标，只支持flutter本地资源图片，传递的时候，与flutter使用图片资源一致，例如： images/back_icon.png
  Future<IntMsg> enterPictureInPictureMode(PipParamsPlayerMsg pipParamsMsg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.enterPictureInPictureMode$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[pipParamsMsg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as IntMsg?)!;
    }
  }

  /// 退出画中画，如果该播放器处于画中画模式
  Future<void> exitPictureInPictureMode(PlayerMsg playerMsg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.exitPictureInPictureMode$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[playerMsg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<int> enableReceiveSeiMessage(PlayerMsg playerMsg, bool isEnabled, int payloadType) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.enableReceiveSeiMessage$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[playerMsg, isEnabled, payloadType]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as int?)!;
    }
  }

  Future<void> showDebugView(PlayerMsg playerMsg, bool isShow) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.showDebugView$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[playerMsg, isShow]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  Future<int> setProperty(PlayerMsg playerMsg, String key, Object value) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.setProperty$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[playerMsg, key, value]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as int?)!;
    }
  }

  Future<ListMsg> getSupportedBitrate(PlayerMsg playerMsg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.getSupportedBitrate$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[playerMsg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as ListMsg?)!;
    }
  }

  Future<int> setCacheParams(PlayerMsg playerMsg, double minTime, double maxTime) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.setCacheParams$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[playerMsg, minTime, maxTime]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as int?)!;
    }
  }

  Future<int> enablePictureInPicture(BoolPlayerMsg msg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.enablePictureInPicture$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[msg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as int?)!;
    }
  }
}

class TXFlutterDownloadApi {
  /// Constructor for [TXFlutterDownloadApi].  The [binaryMessenger] named argument is
  /// available for dependency injection.  If it is left null, the default
  /// BinaryMessenger will be used which routes to the host platform.
  TXFlutterDownloadApi({BinaryMessenger? binaryMessenger, String messageChannelSuffix = ''})
      : pigeonVar_binaryMessenger = binaryMessenger,
        pigeonVar_messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
  final BinaryMessenger? pigeonVar_binaryMessenger;

  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  final String pigeonVar_messageChannelSuffix;

  /// 启动预下载。
  /// playUrl: 要预下载的url
  /// preloadSizeMB: 预下载的大小（单位：MB）
  /// preferredResolution 期望分辨率，long类型，值为高x宽。可参考如720*1080。不支持多分辨率或不需指定时，传-1。
  /// 返回值：任务ID，可用这个任务ID停止预下载 [stopPreload]
  Future<IntMsg> startPreLoad(PreLoadMsg msg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterDownloadApi.startPreLoad$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[msg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as IntMsg?)!;
    }
  }

  Future<void> startPreLoadByParams(PreLoadInfoMsg msg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterDownloadApi.startPreLoadByParams$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[msg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// 停止预下载。
  /// taskId： 任务id
  Future<void> stopPreLoad(IntMsg msg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterDownloadApi.stopPreLoad$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[msg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// 开始下载
  /// videoDownloadModel: 下载构造体
  Future<void> startDownload(TXVodDownloadMediaMsg msg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterDownloadApi.startDownload$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[msg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// 继续下载，与开始下载接口有区别，该接口会寻找对应的缓存，复用之前的缓存来续点下载，
  /// 而开始下载接口会启动一个全新的下载
  /// videoDownloadModel: 下载构造体
  Future<void> resumeDownload(TXVodDownloadMediaMsg msg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterDownloadApi.resumeDownload$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[msg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// 停止下载
  /// videoDownloadModel: 下载构造体
  Future<void> stopDownload(TXVodDownloadMediaMsg msg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterDownloadApi.stopDownload$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[msg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// 设置下载请求头
  Future<void> setDownloadHeaders(MapMsg headers) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterDownloadApi.setDownloadHeaders$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[headers]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else {
      return;
    }
  }

  /// 获取所有视频下载列表
  Future<TXDownloadListMsg> getDownloadList() async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterDownloadApi.getDownloadList$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(null) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as TXDownloadListMsg?)!;
    }
  }

  /// 获得指定视频的下载信息
  Future<TXVodDownloadMediaMsg> getDownloadInfo(TXVodDownloadMediaMsg msg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterDownloadApi.getDownloadInfo$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[msg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as TXVodDownloadMediaMsg?)!;
    }
  }

  /// 删除下载任务
  Future<BoolMsg> deleteDownloadMediaInfo(TXVodDownloadMediaMsg msg) async {
    final String pigeonVar_channelName = 'dev.flutter.pigeon.super_player.TXFlutterDownloadApi.deleteDownloadMediaInfo$pigeonVar_messageChannelSuffix';
    final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
      pigeonVar_channelName,
      pigeonChannelCodec,
      binaryMessenger: pigeonVar_binaryMessenger,
    );
    final List<Object?>? pigeonVar_replyList =
        await pigeonVar_channel.send(<Object?>[msg]) as List<Object?>?;
    if (pigeonVar_replyList == null) {
      throw _createConnectionError(pigeonVar_channelName);
    } else if (pigeonVar_replyList.length > 1) {
      throw PlatformException(
        code: pigeonVar_replyList[0]! as String,
        message: pigeonVar_replyList[1] as String?,
        details: pigeonVar_replyList[2],
      );
    } else if (pigeonVar_replyList[0] == null) {
      throw PlatformException(
        code: 'null-error',
        message: 'Host platform returned null value for non-null return value.',
      );
    } else {
      return (pigeonVar_replyList[0] as BoolMsg?)!;
    }
  }
}

abstract class TXDownloadFlutterAPI {
  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  void onDownloadEvent(Map<String, Object> event);

  void onPreDownloadEvent(Map<String, Object> event);

  static void setUp(TXDownloadFlutterAPI? api, {BinaryMessenger? binaryMessenger, String messageChannelSuffix = '',}) {
    messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
    {
      final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.super_player.TXDownloadFlutterAPI.onDownloadEvent$messageChannelSuffix', pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
          'Argument for dev.flutter.pigeon.super_player.TXDownloadFlutterAPI.onDownloadEvent was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final Map<String, Object>? arg_event = (args[0] as Map<Object?, Object?>?)?.cast<String, Object>();
          assert(arg_event != null,
              'Argument for dev.flutter.pigeon.super_player.TXDownloadFlutterAPI.onDownloadEvent was null, expected non-null Map<String, Object>.');
          try {
            api.onDownloadEvent(arg_event!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          }          catch (e) {
            return wrapResponse(error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.super_player.TXDownloadFlutterAPI.onPreDownloadEvent$messageChannelSuffix', pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
          'Argument for dev.flutter.pigeon.super_player.TXDownloadFlutterAPI.onPreDownloadEvent was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final Map<String, Object>? arg_event = (args[0] as Map<Object?, Object?>?)?.cast<String, Object>();
          assert(arg_event != null,
              'Argument for dev.flutter.pigeon.super_player.TXDownloadFlutterAPI.onPreDownloadEvent was null, expected non-null Map<String, Object>.');
          try {
            api.onPreDownloadEvent(arg_event!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          }          catch (e) {
            return wrapResponse(error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
  }
}

abstract class TXPluginFlutterAPI {
  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  void onSDKListener(Map<String, Object> event);

  void onNativeEvent(Map<String, Object> event);

  static void setUp(TXPluginFlutterAPI? api, {BinaryMessenger? binaryMessenger, String messageChannelSuffix = '',}) {
    messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
    {
      final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.super_player.TXPluginFlutterAPI.onSDKListener$messageChannelSuffix', pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
          'Argument for dev.flutter.pigeon.super_player.TXPluginFlutterAPI.onSDKListener was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final Map<String, Object>? arg_event = (args[0] as Map<Object?, Object?>?)?.cast<String, Object>();
          assert(arg_event != null,
              'Argument for dev.flutter.pigeon.super_player.TXPluginFlutterAPI.onSDKListener was null, expected non-null Map<String, Object>.');
          try {
            api.onSDKListener(arg_event!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          }          catch (e) {
            return wrapResponse(error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.super_player.TXPluginFlutterAPI.onNativeEvent$messageChannelSuffix', pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
          'Argument for dev.flutter.pigeon.super_player.TXPluginFlutterAPI.onNativeEvent was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final Map<String, Object>? arg_event = (args[0] as Map<Object?, Object?>?)?.cast<String, Object>();
          assert(arg_event != null,
              'Argument for dev.flutter.pigeon.super_player.TXPluginFlutterAPI.onNativeEvent was null, expected non-null Map<String, Object>.');
          try {
            api.onNativeEvent(arg_event!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          }          catch (e) {
            return wrapResponse(error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
  }
}

abstract class TXPipFlutterAPI {
  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  void onPipEvent(Map<String, Object> event);

  static void setUp(TXPipFlutterAPI? api, {BinaryMessenger? binaryMessenger, String messageChannelSuffix = '',}) {
    messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
    {
      final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.super_player.TXPipFlutterAPI.onPipEvent$messageChannelSuffix', pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
          'Argument for dev.flutter.pigeon.super_player.TXPipFlutterAPI.onPipEvent was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final Map<String, Object>? arg_event = (args[0] as Map<Object?, Object?>?)?.cast<String, Object>();
          assert(arg_event != null,
              'Argument for dev.flutter.pigeon.super_player.TXPipFlutterAPI.onPipEvent was null, expected non-null Map<String, Object>.');
          try {
            api.onPipEvent(arg_event!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          }          catch (e) {
            return wrapResponse(error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
  }
}

abstract class TXVodPlayerFlutterAPI {
  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  void onPlayerEvent(Map<String, Object> event);

  void onNetEvent(Map<String, Object> event);

  static void setUp(TXVodPlayerFlutterAPI? api, {BinaryMessenger? binaryMessenger, String messageChannelSuffix = '',}) {
    messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
    {
      final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.super_player.TXVodPlayerFlutterAPI.onPlayerEvent$messageChannelSuffix', pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
          'Argument for dev.flutter.pigeon.super_player.TXVodPlayerFlutterAPI.onPlayerEvent was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final Map<String, Object>? arg_event = (args[0] as Map<Object?, Object?>?)?.cast<String, Object>();
          assert(arg_event != null,
              'Argument for dev.flutter.pigeon.super_player.TXVodPlayerFlutterAPI.onPlayerEvent was null, expected non-null Map<String, Object>.');
          try {
            api.onPlayerEvent(arg_event!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          }          catch (e) {
            return wrapResponse(error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.super_player.TXVodPlayerFlutterAPI.onNetEvent$messageChannelSuffix', pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
          'Argument for dev.flutter.pigeon.super_player.TXVodPlayerFlutterAPI.onNetEvent was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final Map<String, Object>? arg_event = (args[0] as Map<Object?, Object?>?)?.cast<String, Object>();
          assert(arg_event != null,
              'Argument for dev.flutter.pigeon.super_player.TXVodPlayerFlutterAPI.onNetEvent was null, expected non-null Map<String, Object>.');
          try {
            api.onNetEvent(arg_event!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          }          catch (e) {
            return wrapResponse(error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
  }
}

abstract class TXLivePlayerFlutterAPI {
  static const MessageCodec<Object?> pigeonChannelCodec = _PigeonCodec();

  void onPlayerEvent(Map<String, Object> event);

  void onNetEvent(Map<String, Object> event);

  static void setUp(TXLivePlayerFlutterAPI? api, {BinaryMessenger? binaryMessenger, String messageChannelSuffix = '',}) {
    messageChannelSuffix = messageChannelSuffix.isNotEmpty ? '.$messageChannelSuffix' : '';
    {
      final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.super_player.TXLivePlayerFlutterAPI.onPlayerEvent$messageChannelSuffix', pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
          'Argument for dev.flutter.pigeon.super_player.TXLivePlayerFlutterAPI.onPlayerEvent was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final Map<String, Object>? arg_event = (args[0] as Map<Object?, Object?>?)?.cast<String, Object>();
          assert(arg_event != null,
              'Argument for dev.flutter.pigeon.super_player.TXLivePlayerFlutterAPI.onPlayerEvent was null, expected non-null Map<String, Object>.');
          try {
            api.onPlayerEvent(arg_event!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          }          catch (e) {
            return wrapResponse(error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
    {
      final BasicMessageChannel<Object?> pigeonVar_channel = BasicMessageChannel<Object?>(
          'dev.flutter.pigeon.super_player.TXLivePlayerFlutterAPI.onNetEvent$messageChannelSuffix', pigeonChannelCodec,
          binaryMessenger: binaryMessenger);
      if (api == null) {
        pigeonVar_channel.setMessageHandler(null);
      } else {
        pigeonVar_channel.setMessageHandler((Object? message) async {
          assert(message != null,
          'Argument for dev.flutter.pigeon.super_player.TXLivePlayerFlutterAPI.onNetEvent was null.');
          final List<Object?> args = (message as List<Object?>?)!;
          final Map<String, Object>? arg_event = (args[0] as Map<Object?, Object?>?)?.cast<String, Object>();
          assert(arg_event != null,
              'Argument for dev.flutter.pigeon.super_player.TXLivePlayerFlutterAPI.onNetEvent was null, expected non-null Map<String, Object>.');
          try {
            api.onNetEvent(arg_event!);
            return wrapResponse(empty: true);
          } on PlatformException catch (e) {
            return wrapResponse(error: e);
          }          catch (e) {
            return wrapResponse(error: PlatformException(code: 'error', message: e.toString()));
          }
        });
      }
    }
  }
}
