// Copyright (c) 2022 Tencent. All rights reserved.
// Autogenerated from Pigeon (v22.7.4), do not edit directly.
// See also: https://pub.dev/packages/pigeon

package com.tencent.vod.flutter.messages;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.CLASS;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.plugin.common.BasicMessageChannel;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.MessageCodec;
import io.flutter.plugin.common.StandardMessageCodec;
import java.io.ByteArrayOutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/** Generated class from Pigeon. */
@SuppressWarnings({"unused", "unchecked", "CodeBlock2Expr", "RedundantSuppression", "serial"})
public class FtxMessages {

  /** Error class for passing custom error details to Flutter via a thrown PlatformException. */
  public static class FlutterError extends RuntimeException {

    /** The error code. */
    public final String code;

    /** The error details. Must be a datatype supported by the api codec. */
    public final Object details;

    public FlutterError(@NonNull String code, @Nullable String message, @Nullable Object details) 
    {
      super(message);
      this.code = code;
      this.details = details;
    }
  }

  @NonNull
  protected static ArrayList<Object> wrapError(@NonNull Throwable exception) {
    ArrayList<Object> errorList = new ArrayList<>(3);
    if (exception instanceof FlutterError) {
      FlutterError error = (FlutterError) exception;
      errorList.add(error.code);
      errorList.add(error.getMessage());
      errorList.add(error.details);
    } else {
      errorList.add(exception.toString());
      errorList.add(exception.getClass().getSimpleName());
      errorList.add(
        "Cause: " + exception.getCause() + ", Stacktrace: " + Log.getStackTraceString(exception));
    }
    return errorList;
  }

  @NonNull
  protected static FlutterError createConnectionError(@NonNull String channelName) {
    return new FlutterError("channel-error",  "Unable to establish connection on channel: " + channelName + ".", "");
  }

  @Target(METHOD)
  @Retention(CLASS)
  @interface CanIgnoreReturnValue {}

  /**
   * Pigeon original component, used to generate native communication code for `messages`.
   * The generation command is as follows. When using the generation command,
   * the two import statements above need to be implemented or commented out.
   *
   * pigeon原始原件，由此文件生成messages原生通信代码
   * 生成命令如下，使用生成命令的时候，需要实现注释掉以上两个import导入
   *
   * Generated class from Pigeon that represents data sent in messages.
   */
  public static final class PlayerMsg {
    private @Nullable Long playerId;

    public @Nullable Long getPlayerId() {
      return playerId;
    }

    public void setPlayerId(@Nullable Long setterArg) {
      this.playerId = setterArg;
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) { return true; }
      if (o == null || getClass() != o.getClass()) { return false; }
      PlayerMsg that = (PlayerMsg) o;
      return Objects.equals(playerId, that.playerId);
    }

    @Override
    public int hashCode() {
      return Objects.hash(playerId);
    }

    public static final class Builder {

      private @Nullable Long playerId;

      @CanIgnoreReturnValue
      public @NonNull Builder setPlayerId(@Nullable Long setterArg) {
        this.playerId = setterArg;
        return this;
      }

      public @NonNull PlayerMsg build() {
        PlayerMsg pigeonReturn = new PlayerMsg();
        pigeonReturn.setPlayerId(playerId);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(1);
      toListResult.add(playerId);
      return toListResult;
    }

    static @NonNull PlayerMsg fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      PlayerMsg pigeonResult = new PlayerMsg();
      Object playerId = pigeonVar_list.get(0);
      pigeonResult.setPlayerId((Long) playerId);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class LicenseMsg {
    private @Nullable String licenseUrl;

    public @Nullable String getLicenseUrl() {
      return licenseUrl;
    }

    public void setLicenseUrl(@Nullable String setterArg) {
      this.licenseUrl = setterArg;
    }

    private @Nullable String licenseKey;

    public @Nullable String getLicenseKey() {
      return licenseKey;
    }

    public void setLicenseKey(@Nullable String setterArg) {
      this.licenseKey = setterArg;
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) { return true; }
      if (o == null || getClass() != o.getClass()) { return false; }
      LicenseMsg that = (LicenseMsg) o;
      return Objects.equals(licenseUrl, that.licenseUrl) && Objects.equals(licenseKey, that.licenseKey);
    }

    @Override
    public int hashCode() {
      return Objects.hash(licenseUrl, licenseKey);
    }

    public static final class Builder {

      private @Nullable String licenseUrl;

      @CanIgnoreReturnValue
      public @NonNull Builder setLicenseUrl(@Nullable String setterArg) {
        this.licenseUrl = setterArg;
        return this;
      }

      private @Nullable String licenseKey;

      @CanIgnoreReturnValue
      public @NonNull Builder setLicenseKey(@Nullable String setterArg) {
        this.licenseKey = setterArg;
        return this;
      }

      public @NonNull LicenseMsg build() {
        LicenseMsg pigeonReturn = new LicenseMsg();
        pigeonReturn.setLicenseUrl(licenseUrl);
        pigeonReturn.setLicenseKey(licenseKey);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(2);
      toListResult.add(licenseUrl);
      toListResult.add(licenseKey);
      return toListResult;
    }

    static @NonNull LicenseMsg fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      LicenseMsg pigeonResult = new LicenseMsg();
      Object licenseUrl = pigeonVar_list.get(0);
      pigeonResult.setLicenseUrl((String) licenseUrl);
      Object licenseKey = pigeonVar_list.get(1);
      pigeonResult.setLicenseKey((String) licenseKey);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class TXPlayInfoParamsPlayerMsg {
    private @Nullable Long playerId;

    public @Nullable Long getPlayerId() {
      return playerId;
    }

    public void setPlayerId(@Nullable Long setterArg) {
      this.playerId = setterArg;
    }

    private @Nullable Long appId;

    public @Nullable Long getAppId() {
      return appId;
    }

    public void setAppId(@Nullable Long setterArg) {
      this.appId = setterArg;
    }

    private @Nullable String fileId;

    public @Nullable String getFileId() {
      return fileId;
    }

    public void setFileId(@Nullable String setterArg) {
      this.fileId = setterArg;
    }

    private @Nullable String psign;

    public @Nullable String getPsign() {
      return psign;
    }

    public void setPsign(@Nullable String setterArg) {
      this.psign = setterArg;
    }

    private @Nullable String url;

    public @Nullable String getUrl() {
      return url;
    }

    public void setUrl(@Nullable String setterArg) {
      this.url = setterArg;
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) { return true; }
      if (o == null || getClass() != o.getClass()) { return false; }
      TXPlayInfoParamsPlayerMsg that = (TXPlayInfoParamsPlayerMsg) o;
      return Objects.equals(playerId, that.playerId) && Objects.equals(appId, that.appId) && Objects.equals(fileId, that.fileId) && Objects.equals(psign, that.psign) && Objects.equals(url, that.url);
    }

    @Override
    public int hashCode() {
      return Objects.hash(playerId, appId, fileId, psign, url);
    }

    public static final class Builder {

      private @Nullable Long playerId;

      @CanIgnoreReturnValue
      public @NonNull Builder setPlayerId(@Nullable Long setterArg) {
        this.playerId = setterArg;
        return this;
      }

      private @Nullable Long appId;

      @CanIgnoreReturnValue
      public @NonNull Builder setAppId(@Nullable Long setterArg) {
        this.appId = setterArg;
        return this;
      }

      private @Nullable String fileId;

      @CanIgnoreReturnValue
      public @NonNull Builder setFileId(@Nullable String setterArg) {
        this.fileId = setterArg;
        return this;
      }

      private @Nullable String psign;

      @CanIgnoreReturnValue
      public @NonNull Builder setPsign(@Nullable String setterArg) {
        this.psign = setterArg;
        return this;
      }

      private @Nullable String url;

      @CanIgnoreReturnValue
      public @NonNull Builder setUrl(@Nullable String setterArg) {
        this.url = setterArg;
        return this;
      }

      public @NonNull TXPlayInfoParamsPlayerMsg build() {
        TXPlayInfoParamsPlayerMsg pigeonReturn = new TXPlayInfoParamsPlayerMsg();
        pigeonReturn.setPlayerId(playerId);
        pigeonReturn.setAppId(appId);
        pigeonReturn.setFileId(fileId);
        pigeonReturn.setPsign(psign);
        pigeonReturn.setUrl(url);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(5);
      toListResult.add(playerId);
      toListResult.add(appId);
      toListResult.add(fileId);
      toListResult.add(psign);
      toListResult.add(url);
      return toListResult;
    }

    static @NonNull TXPlayInfoParamsPlayerMsg fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      TXPlayInfoParamsPlayerMsg pigeonResult = new TXPlayInfoParamsPlayerMsg();
      Object playerId = pigeonVar_list.get(0);
      pigeonResult.setPlayerId((Long) playerId);
      Object appId = pigeonVar_list.get(1);
      pigeonResult.setAppId((Long) appId);
      Object fileId = pigeonVar_list.get(2);
      pigeonResult.setFileId((String) fileId);
      Object psign = pigeonVar_list.get(3);
      pigeonResult.setPsign((String) psign);
      Object url = pigeonVar_list.get(4);
      pigeonResult.setUrl((String) url);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class TXPlayerDrmMsg {
    private @NonNull String licenseUrl;

    public @NonNull String getLicenseUrl() {
      return licenseUrl;
    }

    public void setLicenseUrl(@NonNull String setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"licenseUrl\" is null.");
      }
      this.licenseUrl = setterArg;
    }

    private @NonNull String playUrl;

    public @NonNull String getPlayUrl() {
      return playUrl;
    }

    public void setPlayUrl(@NonNull String setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"playUrl\" is null.");
      }
      this.playUrl = setterArg;
    }

    private @Nullable Long playerId;

    public @Nullable Long getPlayerId() {
      return playerId;
    }

    public void setPlayerId(@Nullable Long setterArg) {
      this.playerId = setterArg;
    }

    private @Nullable String deviceCertificateUrl;

    public @Nullable String getDeviceCertificateUrl() {
      return deviceCertificateUrl;
    }

    public void setDeviceCertificateUrl(@Nullable String setterArg) {
      this.deviceCertificateUrl = setterArg;
    }

    /** Constructor is non-public to enforce null safety; use Builder. */
    TXPlayerDrmMsg() {}

    @Override
    public boolean equals(Object o) {
      if (this == o) { return true; }
      if (o == null || getClass() != o.getClass()) { return false; }
      TXPlayerDrmMsg that = (TXPlayerDrmMsg) o;
      return licenseUrl.equals(that.licenseUrl) && playUrl.equals(that.playUrl) && Objects.equals(playerId, that.playerId) && Objects.equals(deviceCertificateUrl, that.deviceCertificateUrl);
    }

    @Override
    public int hashCode() {
      return Objects.hash(licenseUrl, playUrl, playerId, deviceCertificateUrl);
    }

    public static final class Builder {

      private @Nullable String licenseUrl;

      @CanIgnoreReturnValue
      public @NonNull Builder setLicenseUrl(@NonNull String setterArg) {
        this.licenseUrl = setterArg;
        return this;
      }

      private @Nullable String playUrl;

      @CanIgnoreReturnValue
      public @NonNull Builder setPlayUrl(@NonNull String setterArg) {
        this.playUrl = setterArg;
        return this;
      }

      private @Nullable Long playerId;

      @CanIgnoreReturnValue
      public @NonNull Builder setPlayerId(@Nullable Long setterArg) {
        this.playerId = setterArg;
        return this;
      }

      private @Nullable String deviceCertificateUrl;

      @CanIgnoreReturnValue
      public @NonNull Builder setDeviceCertificateUrl(@Nullable String setterArg) {
        this.deviceCertificateUrl = setterArg;
        return this;
      }

      public @NonNull TXPlayerDrmMsg build() {
        TXPlayerDrmMsg pigeonReturn = new TXPlayerDrmMsg();
        pigeonReturn.setLicenseUrl(licenseUrl);
        pigeonReturn.setPlayUrl(playUrl);
        pigeonReturn.setPlayerId(playerId);
        pigeonReturn.setDeviceCertificateUrl(deviceCertificateUrl);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(4);
      toListResult.add(licenseUrl);
      toListResult.add(playUrl);
      toListResult.add(playerId);
      toListResult.add(deviceCertificateUrl);
      return toListResult;
    }

    static @NonNull TXPlayerDrmMsg fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      TXPlayerDrmMsg pigeonResult = new TXPlayerDrmMsg();
      Object licenseUrl = pigeonVar_list.get(0);
      pigeonResult.setLicenseUrl((String) licenseUrl);
      Object playUrl = pigeonVar_list.get(1);
      pigeonResult.setPlayUrl((String) playUrl);
      Object playerId = pigeonVar_list.get(2);
      pigeonResult.setPlayerId((Long) playerId);
      Object deviceCertificateUrl = pigeonVar_list.get(3);
      pigeonResult.setDeviceCertificateUrl((String) deviceCertificateUrl);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class PipParamsPlayerMsg {
    private @Nullable Long playerId;

    public @Nullable Long getPlayerId() {
      return playerId;
    }

    public void setPlayerId(@Nullable Long setterArg) {
      this.playerId = setterArg;
    }

    private @Nullable String backIconForAndroid;

    public @Nullable String getBackIconForAndroid() {
      return backIconForAndroid;
    }

    public void setBackIconForAndroid(@Nullable String setterArg) {
      this.backIconForAndroid = setterArg;
    }

    private @Nullable String playIconForAndroid;

    public @Nullable String getPlayIconForAndroid() {
      return playIconForAndroid;
    }

    public void setPlayIconForAndroid(@Nullable String setterArg) {
      this.playIconForAndroid = setterArg;
    }

    private @Nullable String pauseIconForAndroid;

    public @Nullable String getPauseIconForAndroid() {
      return pauseIconForAndroid;
    }

    public void setPauseIconForAndroid(@Nullable String setterArg) {
      this.pauseIconForAndroid = setterArg;
    }

    private @Nullable String forwardIconForAndroid;

    public @Nullable String getForwardIconForAndroid() {
      return forwardIconForAndroid;
    }

    public void setForwardIconForAndroid(@Nullable String setterArg) {
      this.forwardIconForAndroid = setterArg;
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) { return true; }
      if (o == null || getClass() != o.getClass()) { return false; }
      PipParamsPlayerMsg that = (PipParamsPlayerMsg) o;
      return Objects.equals(playerId, that.playerId) && Objects.equals(backIconForAndroid, that.backIconForAndroid) && Objects.equals(playIconForAndroid, that.playIconForAndroid) && Objects.equals(pauseIconForAndroid, that.pauseIconForAndroid) && Objects.equals(forwardIconForAndroid, that.forwardIconForAndroid);
    }

    @Override
    public int hashCode() {
      return Objects.hash(playerId, backIconForAndroid, playIconForAndroid, pauseIconForAndroid, forwardIconForAndroid);
    }

    public static final class Builder {

      private @Nullable Long playerId;

      @CanIgnoreReturnValue
      public @NonNull Builder setPlayerId(@Nullable Long setterArg) {
        this.playerId = setterArg;
        return this;
      }

      private @Nullable String backIconForAndroid;

      @CanIgnoreReturnValue
      public @NonNull Builder setBackIconForAndroid(@Nullable String setterArg) {
        this.backIconForAndroid = setterArg;
        return this;
      }

      private @Nullable String playIconForAndroid;

      @CanIgnoreReturnValue
      public @NonNull Builder setPlayIconForAndroid(@Nullable String setterArg) {
        this.playIconForAndroid = setterArg;
        return this;
      }

      private @Nullable String pauseIconForAndroid;

      @CanIgnoreReturnValue
      public @NonNull Builder setPauseIconForAndroid(@Nullable String setterArg) {
        this.pauseIconForAndroid = setterArg;
        return this;
      }

      private @Nullable String forwardIconForAndroid;

      @CanIgnoreReturnValue
      public @NonNull Builder setForwardIconForAndroid(@Nullable String setterArg) {
        this.forwardIconForAndroid = setterArg;
        return this;
      }

      public @NonNull PipParamsPlayerMsg build() {
        PipParamsPlayerMsg pigeonReturn = new PipParamsPlayerMsg();
        pigeonReturn.setPlayerId(playerId);
        pigeonReturn.setBackIconForAndroid(backIconForAndroid);
        pigeonReturn.setPlayIconForAndroid(playIconForAndroid);
        pigeonReturn.setPauseIconForAndroid(pauseIconForAndroid);
        pigeonReturn.setForwardIconForAndroid(forwardIconForAndroid);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(5);
      toListResult.add(playerId);
      toListResult.add(backIconForAndroid);
      toListResult.add(playIconForAndroid);
      toListResult.add(pauseIconForAndroid);
      toListResult.add(forwardIconForAndroid);
      return toListResult;
    }

    static @NonNull PipParamsPlayerMsg fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      PipParamsPlayerMsg pigeonResult = new PipParamsPlayerMsg();
      Object playerId = pigeonVar_list.get(0);
      pigeonResult.setPlayerId((Long) playerId);
      Object backIconForAndroid = pigeonVar_list.get(1);
      pigeonResult.setBackIconForAndroid((String) backIconForAndroid);
      Object playIconForAndroid = pigeonVar_list.get(2);
      pigeonResult.setPlayIconForAndroid((String) playIconForAndroid);
      Object pauseIconForAndroid = pigeonVar_list.get(3);
      pigeonResult.setPauseIconForAndroid((String) pauseIconForAndroid);
      Object forwardIconForAndroid = pigeonVar_list.get(4);
      pigeonResult.setForwardIconForAndroid((String) forwardIconForAndroid);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class StringListPlayerMsg {
    private @Nullable Long playerId;

    public @Nullable Long getPlayerId() {
      return playerId;
    }

    public void setPlayerId(@Nullable Long setterArg) {
      this.playerId = setterArg;
    }

    private @Nullable String vvtUrl;

    public @Nullable String getVvtUrl() {
      return vvtUrl;
    }

    public void setVvtUrl(@Nullable String setterArg) {
      this.vvtUrl = setterArg;
    }

    private @Nullable List<String> imageUrls;

    public @Nullable List<String> getImageUrls() {
      return imageUrls;
    }

    public void setImageUrls(@Nullable List<String> setterArg) {
      this.imageUrls = setterArg;
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) { return true; }
      if (o == null || getClass() != o.getClass()) { return false; }
      StringListPlayerMsg that = (StringListPlayerMsg) o;
      return Objects.equals(playerId, that.playerId) && Objects.equals(vvtUrl, that.vvtUrl) && Objects.equals(imageUrls, that.imageUrls);
    }

    @Override
    public int hashCode() {
      return Objects.hash(playerId, vvtUrl, imageUrls);
    }

    public static final class Builder {

      private @Nullable Long playerId;

      @CanIgnoreReturnValue
      public @NonNull Builder setPlayerId(@Nullable Long setterArg) {
        this.playerId = setterArg;
        return this;
      }

      private @Nullable String vvtUrl;

      @CanIgnoreReturnValue
      public @NonNull Builder setVvtUrl(@Nullable String setterArg) {
        this.vvtUrl = setterArg;
        return this;
      }

      private @Nullable List<String> imageUrls;

      @CanIgnoreReturnValue
      public @NonNull Builder setImageUrls(@Nullable List<String> setterArg) {
        this.imageUrls = setterArg;
        return this;
      }

      public @NonNull StringListPlayerMsg build() {
        StringListPlayerMsg pigeonReturn = new StringListPlayerMsg();
        pigeonReturn.setPlayerId(playerId);
        pigeonReturn.setVvtUrl(vvtUrl);
        pigeonReturn.setImageUrls(imageUrls);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(3);
      toListResult.add(playerId);
      toListResult.add(vvtUrl);
      toListResult.add(imageUrls);
      return toListResult;
    }

    static @NonNull StringListPlayerMsg fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      StringListPlayerMsg pigeonResult = new StringListPlayerMsg();
      Object playerId = pigeonVar_list.get(0);
      pigeonResult.setPlayerId((Long) playerId);
      Object vvtUrl = pigeonVar_list.get(1);
      pigeonResult.setVvtUrl((String) vvtUrl);
      Object imageUrls = pigeonVar_list.get(2);
      pigeonResult.setImageUrls((List<String>) imageUrls);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class BoolPlayerMsg {
    private @Nullable Long playerId;

    public @Nullable Long getPlayerId() {
      return playerId;
    }

    public void setPlayerId(@Nullable Long setterArg) {
      this.playerId = setterArg;
    }

    private @Nullable Boolean value;

    public @Nullable Boolean getValue() {
      return value;
    }

    public void setValue(@Nullable Boolean setterArg) {
      this.value = setterArg;
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) { return true; }
      if (o == null || getClass() != o.getClass()) { return false; }
      BoolPlayerMsg that = (BoolPlayerMsg) o;
      return Objects.equals(playerId, that.playerId) && Objects.equals(value, that.value);
    }

    @Override
    public int hashCode() {
      return Objects.hash(playerId, value);
    }

    public static final class Builder {

      private @Nullable Long playerId;

      @CanIgnoreReturnValue
      public @NonNull Builder setPlayerId(@Nullable Long setterArg) {
        this.playerId = setterArg;
        return this;
      }

      private @Nullable Boolean value;

      @CanIgnoreReturnValue
      public @NonNull Builder setValue(@Nullable Boolean setterArg) {
        this.value = setterArg;
        return this;
      }

      public @NonNull BoolPlayerMsg build() {
        BoolPlayerMsg pigeonReturn = new BoolPlayerMsg();
        pigeonReturn.setPlayerId(playerId);
        pigeonReturn.setValue(value);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(2);
      toListResult.add(playerId);
      toListResult.add(value);
      return toListResult;
    }

    static @NonNull BoolPlayerMsg fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      BoolPlayerMsg pigeonResult = new BoolPlayerMsg();
      Object playerId = pigeonVar_list.get(0);
      pigeonResult.setPlayerId((Long) playerId);
      Object value = pigeonVar_list.get(1);
      pigeonResult.setValue((Boolean) value);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class StringPlayerMsg {
    private @Nullable Long playerId;

    public @Nullable Long getPlayerId() {
      return playerId;
    }

    public void setPlayerId(@Nullable Long setterArg) {
      this.playerId = setterArg;
    }

    private @Nullable String value;

    public @Nullable String getValue() {
      return value;
    }

    public void setValue(@Nullable String setterArg) {
      this.value = setterArg;
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) { return true; }
      if (o == null || getClass() != o.getClass()) { return false; }
      StringPlayerMsg that = (StringPlayerMsg) o;
      return Objects.equals(playerId, that.playerId) && Objects.equals(value, that.value);
    }

    @Override
    public int hashCode() {
      return Objects.hash(playerId, value);
    }

    public static final class Builder {

      private @Nullable Long playerId;

      @CanIgnoreReturnValue
      public @NonNull Builder setPlayerId(@Nullable Long setterArg) {
        this.playerId = setterArg;
        return this;
      }

      private @Nullable String value;

      @CanIgnoreReturnValue
      public @NonNull Builder setValue(@Nullable String setterArg) {
        this.value = setterArg;
        return this;
      }

      public @NonNull StringPlayerMsg build() {
        StringPlayerMsg pigeonReturn = new StringPlayerMsg();
        pigeonReturn.setPlayerId(playerId);
        pigeonReturn.setValue(value);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(2);
      toListResult.add(playerId);
      toListResult.add(value);
      return toListResult;
    }

    static @NonNull StringPlayerMsg fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      StringPlayerMsg pigeonResult = new StringPlayerMsg();
      Object playerId = pigeonVar_list.get(0);
      pigeonResult.setPlayerId((Long) playerId);
      Object value = pigeonVar_list.get(1);
      pigeonResult.setValue((String) value);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class DoublePlayerMsg {
    private @Nullable Long playerId;

    public @Nullable Long getPlayerId() {
      return playerId;
    }

    public void setPlayerId(@Nullable Long setterArg) {
      this.playerId = setterArg;
    }

    private @Nullable Double value;

    public @Nullable Double getValue() {
      return value;
    }

    public void setValue(@Nullable Double setterArg) {
      this.value = setterArg;
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) { return true; }
      if (o == null || getClass() != o.getClass()) { return false; }
      DoublePlayerMsg that = (DoublePlayerMsg) o;
      return Objects.equals(playerId, that.playerId) && Objects.equals(value, that.value);
    }

    @Override
    public int hashCode() {
      return Objects.hash(playerId, value);
    }

    public static final class Builder {

      private @Nullable Long playerId;

      @CanIgnoreReturnValue
      public @NonNull Builder setPlayerId(@Nullable Long setterArg) {
        this.playerId = setterArg;
        return this;
      }

      private @Nullable Double value;

      @CanIgnoreReturnValue
      public @NonNull Builder setValue(@Nullable Double setterArg) {
        this.value = setterArg;
        return this;
      }

      public @NonNull DoublePlayerMsg build() {
        DoublePlayerMsg pigeonReturn = new DoublePlayerMsg();
        pigeonReturn.setPlayerId(playerId);
        pigeonReturn.setValue(value);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(2);
      toListResult.add(playerId);
      toListResult.add(value);
      return toListResult;
    }

    static @NonNull DoublePlayerMsg fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      DoublePlayerMsg pigeonResult = new DoublePlayerMsg();
      Object playerId = pigeonVar_list.get(0);
      pigeonResult.setPlayerId((Long) playerId);
      Object value = pigeonVar_list.get(1);
      pigeonResult.setValue((Double) value);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class IntPlayerMsg {
    private @Nullable Long playerId;

    public @Nullable Long getPlayerId() {
      return playerId;
    }

    public void setPlayerId(@Nullable Long setterArg) {
      this.playerId = setterArg;
    }

    private @Nullable Long value;

    public @Nullable Long getValue() {
      return value;
    }

    public void setValue(@Nullable Long setterArg) {
      this.value = setterArg;
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) { return true; }
      if (o == null || getClass() != o.getClass()) { return false; }
      IntPlayerMsg that = (IntPlayerMsg) o;
      return Objects.equals(playerId, that.playerId) && Objects.equals(value, that.value);
    }

    @Override
    public int hashCode() {
      return Objects.hash(playerId, value);
    }

    public static final class Builder {

      private @Nullable Long playerId;

      @CanIgnoreReturnValue
      public @NonNull Builder setPlayerId(@Nullable Long setterArg) {
        this.playerId = setterArg;
        return this;
      }

      private @Nullable Long value;

      @CanIgnoreReturnValue
      public @NonNull Builder setValue(@Nullable Long setterArg) {
        this.value = setterArg;
        return this;
      }

      public @NonNull IntPlayerMsg build() {
        IntPlayerMsg pigeonReturn = new IntPlayerMsg();
        pigeonReturn.setPlayerId(playerId);
        pigeonReturn.setValue(value);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(2);
      toListResult.add(playerId);
      toListResult.add(value);
      return toListResult;
    }

    static @NonNull IntPlayerMsg fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      IntPlayerMsg pigeonResult = new IntPlayerMsg();
      Object playerId = pigeonVar_list.get(0);
      pigeonResult.setPlayerId((Long) playerId);
      Object value = pigeonVar_list.get(1);
      pigeonResult.setValue((Long) value);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class FTXVodPlayConfigPlayerMsg {
    private @Nullable Long playerId;

    public @Nullable Long getPlayerId() {
      return playerId;
    }

    public void setPlayerId(@Nullable Long setterArg) {
      this.playerId = setterArg;
    }

    private @Nullable Long connectRetryCount;

    public @Nullable Long getConnectRetryCount() {
      return connectRetryCount;
    }

    public void setConnectRetryCount(@Nullable Long setterArg) {
      this.connectRetryCount = setterArg;
    }

    private @Nullable Long connectRetryInterval;

    public @Nullable Long getConnectRetryInterval() {
      return connectRetryInterval;
    }

    public void setConnectRetryInterval(@Nullable Long setterArg) {
      this.connectRetryInterval = setterArg;
    }

    private @Nullable Long timeout;

    public @Nullable Long getTimeout() {
      return timeout;
    }

    public void setTimeout(@Nullable Long setterArg) {
      this.timeout = setterArg;
    }

    private @Nullable Long playerType;

    public @Nullable Long getPlayerType() {
      return playerType;
    }

    public void setPlayerType(@Nullable Long setterArg) {
      this.playerType = setterArg;
    }

    private @Nullable Map<String, String> headers;

    public @Nullable Map<String, String> getHeaders() {
      return headers;
    }

    public void setHeaders(@Nullable Map<String, String> setterArg) {
      this.headers = setterArg;
    }

    private @Nullable Boolean enableAccurateSeek;

    public @Nullable Boolean getEnableAccurateSeek() {
      return enableAccurateSeek;
    }

    public void setEnableAccurateSeek(@Nullable Boolean setterArg) {
      this.enableAccurateSeek = setterArg;
    }

    private @Nullable Boolean autoRotate;

    public @Nullable Boolean getAutoRotate() {
      return autoRotate;
    }

    public void setAutoRotate(@Nullable Boolean setterArg) {
      this.autoRotate = setterArg;
    }

    private @Nullable Boolean smoothSwitchBitrate;

    public @Nullable Boolean getSmoothSwitchBitrate() {
      return smoothSwitchBitrate;
    }

    public void setSmoothSwitchBitrate(@Nullable Boolean setterArg) {
      this.smoothSwitchBitrate = setterArg;
    }

    private @Nullable String cacheMp4ExtName;

    public @Nullable String getCacheMp4ExtName() {
      return cacheMp4ExtName;
    }

    public void setCacheMp4ExtName(@Nullable String setterArg) {
      this.cacheMp4ExtName = setterArg;
    }

    private @Nullable Long progressInterval;

    public @Nullable Long getProgressInterval() {
      return progressInterval;
    }

    public void setProgressInterval(@Nullable Long setterArg) {
      this.progressInterval = setterArg;
    }

    private @Nullable Double maxBufferSize;

    public @Nullable Double getMaxBufferSize() {
      return maxBufferSize;
    }

    public void setMaxBufferSize(@Nullable Double setterArg) {
      this.maxBufferSize = setterArg;
    }

    private @Nullable Double maxPreloadSize;

    public @Nullable Double getMaxPreloadSize() {
      return maxPreloadSize;
    }

    public void setMaxPreloadSize(@Nullable Double setterArg) {
      this.maxPreloadSize = setterArg;
    }

    private @Nullable Long firstStartPlayBufferTime;

    public @Nullable Long getFirstStartPlayBufferTime() {
      return firstStartPlayBufferTime;
    }

    public void setFirstStartPlayBufferTime(@Nullable Long setterArg) {
      this.firstStartPlayBufferTime = setterArg;
    }

    private @Nullable Long nextStartPlayBufferTime;

    public @Nullable Long getNextStartPlayBufferTime() {
      return nextStartPlayBufferTime;
    }

    public void setNextStartPlayBufferTime(@Nullable Long setterArg) {
      this.nextStartPlayBufferTime = setterArg;
    }

    private @Nullable String overlayKey;

    public @Nullable String getOverlayKey() {
      return overlayKey;
    }

    public void setOverlayKey(@Nullable String setterArg) {
      this.overlayKey = setterArg;
    }

    private @Nullable String overlayIv;

    public @Nullable String getOverlayIv() {
      return overlayIv;
    }

    public void setOverlayIv(@Nullable String setterArg) {
      this.overlayIv = setterArg;
    }

    private @Nullable Map<String, Object> extInfoMap;

    public @Nullable Map<String, Object> getExtInfoMap() {
      return extInfoMap;
    }

    public void setExtInfoMap(@Nullable Map<String, Object> setterArg) {
      this.extInfoMap = setterArg;
    }

    private @Nullable Boolean enableRenderProcess;

    public @Nullable Boolean getEnableRenderProcess() {
      return enableRenderProcess;
    }

    public void setEnableRenderProcess(@Nullable Boolean setterArg) {
      this.enableRenderProcess = setterArg;
    }

    private @Nullable Long preferredResolution;

    public @Nullable Long getPreferredResolution() {
      return preferredResolution;
    }

    public void setPreferredResolution(@Nullable Long setterArg) {
      this.preferredResolution = setterArg;
    }

    /**
     * Media asset type, default auto type, refer to value see[TXVodPlayEvent]
     * 媒资类型，默认auto类型, 取值参考 see[TXVodPlayEvent]
     */
    private @Nullable Long mediaType;

    public @Nullable Long getMediaType() {
      return mediaType;
    }

    public void setMediaType(@Nullable Long setterArg) {
      this.mediaType = setterArg;
    }

    /** MP4 encryption playback:  Supported since version 12.2. */
    private @Nullable Long encryptedMp4Level;

    public @Nullable Long getEncryptedMp4Level() {
      return encryptedMp4Level;
    }

    public void setEncryptedMp4Level(@Nullable Long setterArg) {
      this.encryptedMp4Level = setterArg;
    }

    private @Nullable String preferAudioTrack;

    public @Nullable String getPreferAudioTrack() {
      return preferAudioTrack;
    }

    public void setPreferAudioTrack(@Nullable String setterArg) {
      this.preferAudioTrack = setterArg;
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) { return true; }
      if (o == null || getClass() != o.getClass()) { return false; }
      FTXVodPlayConfigPlayerMsg that = (FTXVodPlayConfigPlayerMsg) o;
      return Objects.equals(playerId, that.playerId) && Objects.equals(connectRetryCount, that.connectRetryCount) && Objects.equals(connectRetryInterval, that.connectRetryInterval) && Objects.equals(timeout, that.timeout) && Objects.equals(playerType, that.playerType) && Objects.equals(headers, that.headers) && Objects.equals(enableAccurateSeek, that.enableAccurateSeek) && Objects.equals(autoRotate, that.autoRotate) && Objects.equals(smoothSwitchBitrate, that.smoothSwitchBitrate) && Objects.equals(cacheMp4ExtName, that.cacheMp4ExtName) && Objects.equals(progressInterval, that.progressInterval) && Objects.equals(maxBufferSize, that.maxBufferSize) && Objects.equals(maxPreloadSize, that.maxPreloadSize) && Objects.equals(firstStartPlayBufferTime, that.firstStartPlayBufferTime) && Objects.equals(nextStartPlayBufferTime, that.nextStartPlayBufferTime) && Objects.equals(overlayKey, that.overlayKey) && Objects.equals(overlayIv, that.overlayIv) && Objects.equals(extInfoMap, that.extInfoMap) && Objects.equals(enableRenderProcess, that.enableRenderProcess) && Objects.equals(preferredResolution, that.preferredResolution) && Objects.equals(mediaType, that.mediaType) && Objects.equals(encryptedMp4Level, that.encryptedMp4Level) && Objects.equals(preferAudioTrack, that.preferAudioTrack);
    }

    @Override
    public int hashCode() {
      return Objects.hash(playerId, connectRetryCount, connectRetryInterval, timeout, playerType, headers, enableAccurateSeek, autoRotate, smoothSwitchBitrate, cacheMp4ExtName, progressInterval, maxBufferSize, maxPreloadSize, firstStartPlayBufferTime, nextStartPlayBufferTime, overlayKey, overlayIv, extInfoMap, enableRenderProcess, preferredResolution, mediaType, encryptedMp4Level, preferAudioTrack);
    }

    public static final class Builder {

      private @Nullable Long playerId;

      @CanIgnoreReturnValue
      public @NonNull Builder setPlayerId(@Nullable Long setterArg) {
        this.playerId = setterArg;
        return this;
      }

      private @Nullable Long connectRetryCount;

      @CanIgnoreReturnValue
      public @NonNull Builder setConnectRetryCount(@Nullable Long setterArg) {
        this.connectRetryCount = setterArg;
        return this;
      }

      private @Nullable Long connectRetryInterval;

      @CanIgnoreReturnValue
      public @NonNull Builder setConnectRetryInterval(@Nullable Long setterArg) {
        this.connectRetryInterval = setterArg;
        return this;
      }

      private @Nullable Long timeout;

      @CanIgnoreReturnValue
      public @NonNull Builder setTimeout(@Nullable Long setterArg) {
        this.timeout = setterArg;
        return this;
      }

      private @Nullable Long playerType;

      @CanIgnoreReturnValue
      public @NonNull Builder setPlayerType(@Nullable Long setterArg) {
        this.playerType = setterArg;
        return this;
      }

      private @Nullable Map<String, String> headers;

      @CanIgnoreReturnValue
      public @NonNull Builder setHeaders(@Nullable Map<String, String> setterArg) {
        this.headers = setterArg;
        return this;
      }

      private @Nullable Boolean enableAccurateSeek;

      @CanIgnoreReturnValue
      public @NonNull Builder setEnableAccurateSeek(@Nullable Boolean setterArg) {
        this.enableAccurateSeek = setterArg;
        return this;
      }

      private @Nullable Boolean autoRotate;

      @CanIgnoreReturnValue
      public @NonNull Builder setAutoRotate(@Nullable Boolean setterArg) {
        this.autoRotate = setterArg;
        return this;
      }

      private @Nullable Boolean smoothSwitchBitrate;

      @CanIgnoreReturnValue
      public @NonNull Builder setSmoothSwitchBitrate(@Nullable Boolean setterArg) {
        this.smoothSwitchBitrate = setterArg;
        return this;
      }

      private @Nullable String cacheMp4ExtName;

      @CanIgnoreReturnValue
      public @NonNull Builder setCacheMp4ExtName(@Nullable String setterArg) {
        this.cacheMp4ExtName = setterArg;
        return this;
      }

      private @Nullable Long progressInterval;

      @CanIgnoreReturnValue
      public @NonNull Builder setProgressInterval(@Nullable Long setterArg) {
        this.progressInterval = setterArg;
        return this;
      }

      private @Nullable Double maxBufferSize;

      @CanIgnoreReturnValue
      public @NonNull Builder setMaxBufferSize(@Nullable Double setterArg) {
        this.maxBufferSize = setterArg;
        return this;
      }

      private @Nullable Double maxPreloadSize;

      @CanIgnoreReturnValue
      public @NonNull Builder setMaxPreloadSize(@Nullable Double setterArg) {
        this.maxPreloadSize = setterArg;
        return this;
      }

      private @Nullable Long firstStartPlayBufferTime;

      @CanIgnoreReturnValue
      public @NonNull Builder setFirstStartPlayBufferTime(@Nullable Long setterArg) {
        this.firstStartPlayBufferTime = setterArg;
        return this;
      }

      private @Nullable Long nextStartPlayBufferTime;

      @CanIgnoreReturnValue
      public @NonNull Builder setNextStartPlayBufferTime(@Nullable Long setterArg) {
        this.nextStartPlayBufferTime = setterArg;
        return this;
      }

      private @Nullable String overlayKey;

      @CanIgnoreReturnValue
      public @NonNull Builder setOverlayKey(@Nullable String setterArg) {
        this.overlayKey = setterArg;
        return this;
      }

      private @Nullable String overlayIv;

      @CanIgnoreReturnValue
      public @NonNull Builder setOverlayIv(@Nullable String setterArg) {
        this.overlayIv = setterArg;
        return this;
      }

      private @Nullable Map<String, Object> extInfoMap;

      @CanIgnoreReturnValue
      public @NonNull Builder setExtInfoMap(@Nullable Map<String, Object> setterArg) {
        this.extInfoMap = setterArg;
        return this;
      }

      private @Nullable Boolean enableRenderProcess;

      @CanIgnoreReturnValue
      public @NonNull Builder setEnableRenderProcess(@Nullable Boolean setterArg) {
        this.enableRenderProcess = setterArg;
        return this;
      }

      private @Nullable Long preferredResolution;

      @CanIgnoreReturnValue
      public @NonNull Builder setPreferredResolution(@Nullable Long setterArg) {
        this.preferredResolution = setterArg;
        return this;
      }

      private @Nullable Long mediaType;

      @CanIgnoreReturnValue
      public @NonNull Builder setMediaType(@Nullable Long setterArg) {
        this.mediaType = setterArg;
        return this;
      }

      private @Nullable Long encryptedMp4Level;

      @CanIgnoreReturnValue
      public @NonNull Builder setEncryptedMp4Level(@Nullable Long setterArg) {
        this.encryptedMp4Level = setterArg;
        return this;
      }

      private @Nullable String preferAudioTrack;

      @CanIgnoreReturnValue
      public @NonNull Builder setPreferAudioTrack(@Nullable String setterArg) {
        this.preferAudioTrack = setterArg;
        return this;
      }

      public @NonNull FTXVodPlayConfigPlayerMsg build() {
        FTXVodPlayConfigPlayerMsg pigeonReturn = new FTXVodPlayConfigPlayerMsg();
        pigeonReturn.setPlayerId(playerId);
        pigeonReturn.setConnectRetryCount(connectRetryCount);
        pigeonReturn.setConnectRetryInterval(connectRetryInterval);
        pigeonReturn.setTimeout(timeout);
        pigeonReturn.setPlayerType(playerType);
        pigeonReturn.setHeaders(headers);
        pigeonReturn.setEnableAccurateSeek(enableAccurateSeek);
        pigeonReturn.setAutoRotate(autoRotate);
        pigeonReturn.setSmoothSwitchBitrate(smoothSwitchBitrate);
        pigeonReturn.setCacheMp4ExtName(cacheMp4ExtName);
        pigeonReturn.setProgressInterval(progressInterval);
        pigeonReturn.setMaxBufferSize(maxBufferSize);
        pigeonReturn.setMaxPreloadSize(maxPreloadSize);
        pigeonReturn.setFirstStartPlayBufferTime(firstStartPlayBufferTime);
        pigeonReturn.setNextStartPlayBufferTime(nextStartPlayBufferTime);
        pigeonReturn.setOverlayKey(overlayKey);
        pigeonReturn.setOverlayIv(overlayIv);
        pigeonReturn.setExtInfoMap(extInfoMap);
        pigeonReturn.setEnableRenderProcess(enableRenderProcess);
        pigeonReturn.setPreferredResolution(preferredResolution);
        pigeonReturn.setMediaType(mediaType);
        pigeonReturn.setEncryptedMp4Level(encryptedMp4Level);
        pigeonReturn.setPreferAudioTrack(preferAudioTrack);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(23);
      toListResult.add(playerId);
      toListResult.add(connectRetryCount);
      toListResult.add(connectRetryInterval);
      toListResult.add(timeout);
      toListResult.add(playerType);
      toListResult.add(headers);
      toListResult.add(enableAccurateSeek);
      toListResult.add(autoRotate);
      toListResult.add(smoothSwitchBitrate);
      toListResult.add(cacheMp4ExtName);
      toListResult.add(progressInterval);
      toListResult.add(maxBufferSize);
      toListResult.add(maxPreloadSize);
      toListResult.add(firstStartPlayBufferTime);
      toListResult.add(nextStartPlayBufferTime);
      toListResult.add(overlayKey);
      toListResult.add(overlayIv);
      toListResult.add(extInfoMap);
      toListResult.add(enableRenderProcess);
      toListResult.add(preferredResolution);
      toListResult.add(mediaType);
      toListResult.add(encryptedMp4Level);
      toListResult.add(preferAudioTrack);
      return toListResult;
    }

    static @NonNull FTXVodPlayConfigPlayerMsg fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      FTXVodPlayConfigPlayerMsg pigeonResult = new FTXVodPlayConfigPlayerMsg();
      Object playerId = pigeonVar_list.get(0);
      pigeonResult.setPlayerId((Long) playerId);
      Object connectRetryCount = pigeonVar_list.get(1);
      pigeonResult.setConnectRetryCount((Long) connectRetryCount);
      Object connectRetryInterval = pigeonVar_list.get(2);
      pigeonResult.setConnectRetryInterval((Long) connectRetryInterval);
      Object timeout = pigeonVar_list.get(3);
      pigeonResult.setTimeout((Long) timeout);
      Object playerType = pigeonVar_list.get(4);
      pigeonResult.setPlayerType((Long) playerType);
      Object headers = pigeonVar_list.get(5);
      pigeonResult.setHeaders((Map<String, String>) headers);
      Object enableAccurateSeek = pigeonVar_list.get(6);
      pigeonResult.setEnableAccurateSeek((Boolean) enableAccurateSeek);
      Object autoRotate = pigeonVar_list.get(7);
      pigeonResult.setAutoRotate((Boolean) autoRotate);
      Object smoothSwitchBitrate = pigeonVar_list.get(8);
      pigeonResult.setSmoothSwitchBitrate((Boolean) smoothSwitchBitrate);
      Object cacheMp4ExtName = pigeonVar_list.get(9);
      pigeonResult.setCacheMp4ExtName((String) cacheMp4ExtName);
      Object progressInterval = pigeonVar_list.get(10);
      pigeonResult.setProgressInterval((Long) progressInterval);
      Object maxBufferSize = pigeonVar_list.get(11);
      pigeonResult.setMaxBufferSize((Double) maxBufferSize);
      Object maxPreloadSize = pigeonVar_list.get(12);
      pigeonResult.setMaxPreloadSize((Double) maxPreloadSize);
      Object firstStartPlayBufferTime = pigeonVar_list.get(13);
      pigeonResult.setFirstStartPlayBufferTime((Long) firstStartPlayBufferTime);
      Object nextStartPlayBufferTime = pigeonVar_list.get(14);
      pigeonResult.setNextStartPlayBufferTime((Long) nextStartPlayBufferTime);
      Object overlayKey = pigeonVar_list.get(15);
      pigeonResult.setOverlayKey((String) overlayKey);
      Object overlayIv = pigeonVar_list.get(16);
      pigeonResult.setOverlayIv((String) overlayIv);
      Object extInfoMap = pigeonVar_list.get(17);
      pigeonResult.setExtInfoMap((Map<String, Object>) extInfoMap);
      Object enableRenderProcess = pigeonVar_list.get(18);
      pigeonResult.setEnableRenderProcess((Boolean) enableRenderProcess);
      Object preferredResolution = pigeonVar_list.get(19);
      pigeonResult.setPreferredResolution((Long) preferredResolution);
      Object mediaType = pigeonVar_list.get(20);
      pigeonResult.setMediaType((Long) mediaType);
      Object encryptedMp4Level = pigeonVar_list.get(21);
      pigeonResult.setEncryptedMp4Level((Long) encryptedMp4Level);
      Object preferAudioTrack = pigeonVar_list.get(22);
      pigeonResult.setPreferAudioTrack((String) preferAudioTrack);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class FTXLivePlayConfigPlayerMsg {
    private @Nullable Long playerId;

    public @Nullable Long getPlayerId() {
      return playerId;
    }

    public void setPlayerId(@Nullable Long setterArg) {
      this.playerId = setterArg;
    }

    private @Nullable Double cacheTime;

    public @Nullable Double getCacheTime() {
      return cacheTime;
    }

    public void setCacheTime(@Nullable Double setterArg) {
      this.cacheTime = setterArg;
    }

    private @Nullable Double maxAutoAdjustCacheTime;

    public @Nullable Double getMaxAutoAdjustCacheTime() {
      return maxAutoAdjustCacheTime;
    }

    public void setMaxAutoAdjustCacheTime(@Nullable Double setterArg) {
      this.maxAutoAdjustCacheTime = setterArg;
    }

    private @Nullable Double minAutoAdjustCacheTime;

    public @Nullable Double getMinAutoAdjustCacheTime() {
      return minAutoAdjustCacheTime;
    }

    public void setMinAutoAdjustCacheTime(@Nullable Double setterArg) {
      this.minAutoAdjustCacheTime = setterArg;
    }

    private @Nullable Long videoBlockThreshold;

    public @Nullable Long getVideoBlockThreshold() {
      return videoBlockThreshold;
    }

    public void setVideoBlockThreshold(@Nullable Long setterArg) {
      this.videoBlockThreshold = setterArg;
    }

    private @Nullable Long connectRetryCount;

    public @Nullable Long getConnectRetryCount() {
      return connectRetryCount;
    }

    public void setConnectRetryCount(@Nullable Long setterArg) {
      this.connectRetryCount = setterArg;
    }

    private @Nullable Long connectRetryInterval;

    public @Nullable Long getConnectRetryInterval() {
      return connectRetryInterval;
    }

    public void setConnectRetryInterval(@Nullable Long setterArg) {
      this.connectRetryInterval = setterArg;
    }

    private @Nullable Boolean autoAdjustCacheTime;

    public @Nullable Boolean getAutoAdjustCacheTime() {
      return autoAdjustCacheTime;
    }

    public void setAutoAdjustCacheTime(@Nullable Boolean setterArg) {
      this.autoAdjustCacheTime = setterArg;
    }

    private @Nullable Boolean enableAec;

    public @Nullable Boolean getEnableAec() {
      return enableAec;
    }

    public void setEnableAec(@Nullable Boolean setterArg) {
      this.enableAec = setterArg;
    }

    private @Nullable Boolean enableMessage;

    public @Nullable Boolean getEnableMessage() {
      return enableMessage;
    }

    public void setEnableMessage(@Nullable Boolean setterArg) {
      this.enableMessage = setterArg;
    }

    private @Nullable Boolean enableMetaData;

    public @Nullable Boolean getEnableMetaData() {
      return enableMetaData;
    }

    public void setEnableMetaData(@Nullable Boolean setterArg) {
      this.enableMetaData = setterArg;
    }

    private @Nullable String flvSessionKey;

    public @Nullable String getFlvSessionKey() {
      return flvSessionKey;
    }

    public void setFlvSessionKey(@Nullable String setterArg) {
      this.flvSessionKey = setterArg;
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) { return true; }
      if (o == null || getClass() != o.getClass()) { return false; }
      FTXLivePlayConfigPlayerMsg that = (FTXLivePlayConfigPlayerMsg) o;
      return Objects.equals(playerId, that.playerId) && Objects.equals(cacheTime, that.cacheTime) && Objects.equals(maxAutoAdjustCacheTime, that.maxAutoAdjustCacheTime) && Objects.equals(minAutoAdjustCacheTime, that.minAutoAdjustCacheTime) && Objects.equals(videoBlockThreshold, that.videoBlockThreshold) && Objects.equals(connectRetryCount, that.connectRetryCount) && Objects.equals(connectRetryInterval, that.connectRetryInterval) && Objects.equals(autoAdjustCacheTime, that.autoAdjustCacheTime) && Objects.equals(enableAec, that.enableAec) && Objects.equals(enableMessage, that.enableMessage) && Objects.equals(enableMetaData, that.enableMetaData) && Objects.equals(flvSessionKey, that.flvSessionKey);
    }

    @Override
    public int hashCode() {
      return Objects.hash(playerId, cacheTime, maxAutoAdjustCacheTime, minAutoAdjustCacheTime, videoBlockThreshold, connectRetryCount, connectRetryInterval, autoAdjustCacheTime, enableAec, enableMessage, enableMetaData, flvSessionKey);
    }

    public static final class Builder {

      private @Nullable Long playerId;

      @CanIgnoreReturnValue
      public @NonNull Builder setPlayerId(@Nullable Long setterArg) {
        this.playerId = setterArg;
        return this;
      }

      private @Nullable Double cacheTime;

      @CanIgnoreReturnValue
      public @NonNull Builder setCacheTime(@Nullable Double setterArg) {
        this.cacheTime = setterArg;
        return this;
      }

      private @Nullable Double maxAutoAdjustCacheTime;

      @CanIgnoreReturnValue
      public @NonNull Builder setMaxAutoAdjustCacheTime(@Nullable Double setterArg) {
        this.maxAutoAdjustCacheTime = setterArg;
        return this;
      }

      private @Nullable Double minAutoAdjustCacheTime;

      @CanIgnoreReturnValue
      public @NonNull Builder setMinAutoAdjustCacheTime(@Nullable Double setterArg) {
        this.minAutoAdjustCacheTime = setterArg;
        return this;
      }

      private @Nullable Long videoBlockThreshold;

      @CanIgnoreReturnValue
      public @NonNull Builder setVideoBlockThreshold(@Nullable Long setterArg) {
        this.videoBlockThreshold = setterArg;
        return this;
      }

      private @Nullable Long connectRetryCount;

      @CanIgnoreReturnValue
      public @NonNull Builder setConnectRetryCount(@Nullable Long setterArg) {
        this.connectRetryCount = setterArg;
        return this;
      }

      private @Nullable Long connectRetryInterval;

      @CanIgnoreReturnValue
      public @NonNull Builder setConnectRetryInterval(@Nullable Long setterArg) {
        this.connectRetryInterval = setterArg;
        return this;
      }

      private @Nullable Boolean autoAdjustCacheTime;

      @CanIgnoreReturnValue
      public @NonNull Builder setAutoAdjustCacheTime(@Nullable Boolean setterArg) {
        this.autoAdjustCacheTime = setterArg;
        return this;
      }

      private @Nullable Boolean enableAec;

      @CanIgnoreReturnValue
      public @NonNull Builder setEnableAec(@Nullable Boolean setterArg) {
        this.enableAec = setterArg;
        return this;
      }

      private @Nullable Boolean enableMessage;

      @CanIgnoreReturnValue
      public @NonNull Builder setEnableMessage(@Nullable Boolean setterArg) {
        this.enableMessage = setterArg;
        return this;
      }

      private @Nullable Boolean enableMetaData;

      @CanIgnoreReturnValue
      public @NonNull Builder setEnableMetaData(@Nullable Boolean setterArg) {
        this.enableMetaData = setterArg;
        return this;
      }

      private @Nullable String flvSessionKey;

      @CanIgnoreReturnValue
      public @NonNull Builder setFlvSessionKey(@Nullable String setterArg) {
        this.flvSessionKey = setterArg;
        return this;
      }

      public @NonNull FTXLivePlayConfigPlayerMsg build() {
        FTXLivePlayConfigPlayerMsg pigeonReturn = new FTXLivePlayConfigPlayerMsg();
        pigeonReturn.setPlayerId(playerId);
        pigeonReturn.setCacheTime(cacheTime);
        pigeonReturn.setMaxAutoAdjustCacheTime(maxAutoAdjustCacheTime);
        pigeonReturn.setMinAutoAdjustCacheTime(minAutoAdjustCacheTime);
        pigeonReturn.setVideoBlockThreshold(videoBlockThreshold);
        pigeonReturn.setConnectRetryCount(connectRetryCount);
        pigeonReturn.setConnectRetryInterval(connectRetryInterval);
        pigeonReturn.setAutoAdjustCacheTime(autoAdjustCacheTime);
        pigeonReturn.setEnableAec(enableAec);
        pigeonReturn.setEnableMessage(enableMessage);
        pigeonReturn.setEnableMetaData(enableMetaData);
        pigeonReturn.setFlvSessionKey(flvSessionKey);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(12);
      toListResult.add(playerId);
      toListResult.add(cacheTime);
      toListResult.add(maxAutoAdjustCacheTime);
      toListResult.add(minAutoAdjustCacheTime);
      toListResult.add(videoBlockThreshold);
      toListResult.add(connectRetryCount);
      toListResult.add(connectRetryInterval);
      toListResult.add(autoAdjustCacheTime);
      toListResult.add(enableAec);
      toListResult.add(enableMessage);
      toListResult.add(enableMetaData);
      toListResult.add(flvSessionKey);
      return toListResult;
    }

    static @NonNull FTXLivePlayConfigPlayerMsg fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      FTXLivePlayConfigPlayerMsg pigeonResult = new FTXLivePlayConfigPlayerMsg();
      Object playerId = pigeonVar_list.get(0);
      pigeonResult.setPlayerId((Long) playerId);
      Object cacheTime = pigeonVar_list.get(1);
      pigeonResult.setCacheTime((Double) cacheTime);
      Object maxAutoAdjustCacheTime = pigeonVar_list.get(2);
      pigeonResult.setMaxAutoAdjustCacheTime((Double) maxAutoAdjustCacheTime);
      Object minAutoAdjustCacheTime = pigeonVar_list.get(3);
      pigeonResult.setMinAutoAdjustCacheTime((Double) minAutoAdjustCacheTime);
      Object videoBlockThreshold = pigeonVar_list.get(4);
      pigeonResult.setVideoBlockThreshold((Long) videoBlockThreshold);
      Object connectRetryCount = pigeonVar_list.get(5);
      pigeonResult.setConnectRetryCount((Long) connectRetryCount);
      Object connectRetryInterval = pigeonVar_list.get(6);
      pigeonResult.setConnectRetryInterval((Long) connectRetryInterval);
      Object autoAdjustCacheTime = pigeonVar_list.get(7);
      pigeonResult.setAutoAdjustCacheTime((Boolean) autoAdjustCacheTime);
      Object enableAec = pigeonVar_list.get(8);
      pigeonResult.setEnableAec((Boolean) enableAec);
      Object enableMessage = pigeonVar_list.get(9);
      pigeonResult.setEnableMessage((Boolean) enableMessage);
      Object enableMetaData = pigeonVar_list.get(10);
      pigeonResult.setEnableMetaData((Boolean) enableMetaData);
      Object flvSessionKey = pigeonVar_list.get(11);
      pigeonResult.setFlvSessionKey((String) flvSessionKey);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class TXVodDownloadMediaMsg {
    /** 缓存地址 */
    private @Nullable String playPath;

    public @Nullable String getPlayPath() {
      return playPath;
    }

    public void setPlayPath(@Nullable String setterArg) {
      this.playPath = setterArg;
    }

    /** 下载进度 */
    private @Nullable Double progress;

    public @Nullable Double getProgress() {
      return progress;
    }

    public void setProgress(@Nullable Double setterArg) {
      this.progress = setterArg;
    }

    /** 下载状态 */
    private @Nullable Long downloadState;

    public @Nullable Long getDownloadState() {
      return downloadState;
    }

    public void setDownloadState(@Nullable Long setterArg) {
      this.downloadState = setterArg;
    }

    /** 账户名称,用于url下载设置账户名称 */
    private @Nullable String userName;

    public @Nullable String getUserName() {
      return userName;
    }

    public void setUserName(@Nullable String setterArg) {
      this.userName = setterArg;
    }

    /** 总时长 */
    private @Nullable Long duration;

    public @Nullable Long getDuration() {
      return duration;
    }

    public void setDuration(@Nullable Long setterArg) {
      this.duration = setterArg;
    }

    /** 已下载的可播放时长 */
    private @Nullable Long playableDuration;

    public @Nullable Long getPlayableDuration() {
      return playableDuration;
    }

    public void setPlayableDuration(@Nullable Long setterArg) {
      this.playableDuration = setterArg;
    }

    /** 文件总大小，单位：byte */
    private @Nullable Long size;

    public @Nullable Long getSize() {
      return size;
    }

    public void setSize(@Nullable Long setterArg) {
      this.size = setterArg;
    }

    /** 已下载大小，单位：byte */
    private @Nullable Long downloadSize;

    public @Nullable Long getDownloadSize() {
      return downloadSize;
    }

    public void setDownloadSize(@Nullable Long setterArg) {
      this.downloadSize = setterArg;
    }

    /**
     * 需要下载的视频url，url下载必填
     * <h1>
     * url下载不支持嵌套m3u8和mp4下载
     * </h1>
     */
    private @Nullable String url;

    public @Nullable String getUrl() {
      return url;
    }

    public void setUrl(@Nullable String setterArg) {
      this.url = setterArg;
    }

    /** 下载文件对应的appId，fileId下载必填 */
    private @Nullable Long appId;

    public @Nullable Long getAppId() {
      return appId;
    }

    public void setAppId(@Nullable Long setterArg) {
      this.appId = setterArg;
    }

    /** 下载文件Id，fileId下载必填 */
    private @Nullable String fileId;

    public @Nullable String getFileId() {
      return fileId;
    }

    public void setFileId(@Nullable String setterArg) {
      this.fileId = setterArg;
    }

    /** 加密签名，加密视频必填 */
    private @Nullable String pSign;

    public @Nullable String getPSign() {
      return pSign;
    }

    public void setPSign(@Nullable String setterArg) {
      this.pSign = setterArg;
    }

    /** 清晰度ID */
    private @Nullable Long quality;

    public @Nullable Long getQuality() {
      return quality;
    }

    public void setQuality(@Nullable Long setterArg) {
      this.quality = setterArg;
    }

    /** 加密token */
    private @Nullable String token;

    public @Nullable String getToken() {
      return token;
    }

    public void setToken(@Nullable String setterArg) {
      this.token = setterArg;
    }

    /** 下载速度，单位：KByte/秒 */
    private @Nullable Long speed;

    public @Nullable Long getSpeed() {
      return speed;
    }

    public void setSpeed(@Nullable Long setterArg) {
      this.speed = setterArg;
    }

    /** 资源是否已损坏, 如：资源被删除了 */
    private @Nullable Boolean isResourceBroken;

    public @Nullable Boolean getIsResourceBroken() {
      return isResourceBroken;
    }

    public void setIsResourceBroken(@Nullable Boolean setterArg) {
      this.isResourceBroken = setterArg;
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) { return true; }
      if (o == null || getClass() != o.getClass()) { return false; }
      TXVodDownloadMediaMsg that = (TXVodDownloadMediaMsg) o;
      return Objects.equals(playPath, that.playPath) && Objects.equals(progress, that.progress) && Objects.equals(downloadState, that.downloadState) && Objects.equals(userName, that.userName) && Objects.equals(duration, that.duration) && Objects.equals(playableDuration, that.playableDuration) && Objects.equals(size, that.size) && Objects.equals(downloadSize, that.downloadSize) && Objects.equals(url, that.url) && Objects.equals(appId, that.appId) && Objects.equals(fileId, that.fileId) && Objects.equals(pSign, that.pSign) && Objects.equals(quality, that.quality) && Objects.equals(token, that.token) && Objects.equals(speed, that.speed) && Objects.equals(isResourceBroken, that.isResourceBroken);
    }

    @Override
    public int hashCode() {
      return Objects.hash(playPath, progress, downloadState, userName, duration, playableDuration, size, downloadSize, url, appId, fileId, pSign, quality, token, speed, isResourceBroken);
    }

    public static final class Builder {

      private @Nullable String playPath;

      @CanIgnoreReturnValue
      public @NonNull Builder setPlayPath(@Nullable String setterArg) {
        this.playPath = setterArg;
        return this;
      }

      private @Nullable Double progress;

      @CanIgnoreReturnValue
      public @NonNull Builder setProgress(@Nullable Double setterArg) {
        this.progress = setterArg;
        return this;
      }

      private @Nullable Long downloadState;

      @CanIgnoreReturnValue
      public @NonNull Builder setDownloadState(@Nullable Long setterArg) {
        this.downloadState = setterArg;
        return this;
      }

      private @Nullable String userName;

      @CanIgnoreReturnValue
      public @NonNull Builder setUserName(@Nullable String setterArg) {
        this.userName = setterArg;
        return this;
      }

      private @Nullable Long duration;

      @CanIgnoreReturnValue
      public @NonNull Builder setDuration(@Nullable Long setterArg) {
        this.duration = setterArg;
        return this;
      }

      private @Nullable Long playableDuration;

      @CanIgnoreReturnValue
      public @NonNull Builder setPlayableDuration(@Nullable Long setterArg) {
        this.playableDuration = setterArg;
        return this;
      }

      private @Nullable Long size;

      @CanIgnoreReturnValue
      public @NonNull Builder setSize(@Nullable Long setterArg) {
        this.size = setterArg;
        return this;
      }

      private @Nullable Long downloadSize;

      @CanIgnoreReturnValue
      public @NonNull Builder setDownloadSize(@Nullable Long setterArg) {
        this.downloadSize = setterArg;
        return this;
      }

      private @Nullable String url;

      @CanIgnoreReturnValue
      public @NonNull Builder setUrl(@Nullable String setterArg) {
        this.url = setterArg;
        return this;
      }

      private @Nullable Long appId;

      @CanIgnoreReturnValue
      public @NonNull Builder setAppId(@Nullable Long setterArg) {
        this.appId = setterArg;
        return this;
      }

      private @Nullable String fileId;

      @CanIgnoreReturnValue
      public @NonNull Builder setFileId(@Nullable String setterArg) {
        this.fileId = setterArg;
        return this;
      }

      private @Nullable String pSign;

      @CanIgnoreReturnValue
      public @NonNull Builder setPSign(@Nullable String setterArg) {
        this.pSign = setterArg;
        return this;
      }

      private @Nullable Long quality;

      @CanIgnoreReturnValue
      public @NonNull Builder setQuality(@Nullable Long setterArg) {
        this.quality = setterArg;
        return this;
      }

      private @Nullable String token;

      @CanIgnoreReturnValue
      public @NonNull Builder setToken(@Nullable String setterArg) {
        this.token = setterArg;
        return this;
      }

      private @Nullable Long speed;

      @CanIgnoreReturnValue
      public @NonNull Builder setSpeed(@Nullable Long setterArg) {
        this.speed = setterArg;
        return this;
      }

      private @Nullable Boolean isResourceBroken;

      @CanIgnoreReturnValue
      public @NonNull Builder setIsResourceBroken(@Nullable Boolean setterArg) {
        this.isResourceBroken = setterArg;
        return this;
      }

      public @NonNull TXVodDownloadMediaMsg build() {
        TXVodDownloadMediaMsg pigeonReturn = new TXVodDownloadMediaMsg();
        pigeonReturn.setPlayPath(playPath);
        pigeonReturn.setProgress(progress);
        pigeonReturn.setDownloadState(downloadState);
        pigeonReturn.setUserName(userName);
        pigeonReturn.setDuration(duration);
        pigeonReturn.setPlayableDuration(playableDuration);
        pigeonReturn.setSize(size);
        pigeonReturn.setDownloadSize(downloadSize);
        pigeonReturn.setUrl(url);
        pigeonReturn.setAppId(appId);
        pigeonReturn.setFileId(fileId);
        pigeonReturn.setPSign(pSign);
        pigeonReturn.setQuality(quality);
        pigeonReturn.setToken(token);
        pigeonReturn.setSpeed(speed);
        pigeonReturn.setIsResourceBroken(isResourceBroken);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(16);
      toListResult.add(playPath);
      toListResult.add(progress);
      toListResult.add(downloadState);
      toListResult.add(userName);
      toListResult.add(duration);
      toListResult.add(playableDuration);
      toListResult.add(size);
      toListResult.add(downloadSize);
      toListResult.add(url);
      toListResult.add(appId);
      toListResult.add(fileId);
      toListResult.add(pSign);
      toListResult.add(quality);
      toListResult.add(token);
      toListResult.add(speed);
      toListResult.add(isResourceBroken);
      return toListResult;
    }

    static @NonNull TXVodDownloadMediaMsg fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      TXVodDownloadMediaMsg pigeonResult = new TXVodDownloadMediaMsg();
      Object playPath = pigeonVar_list.get(0);
      pigeonResult.setPlayPath((String) playPath);
      Object progress = pigeonVar_list.get(1);
      pigeonResult.setProgress((Double) progress);
      Object downloadState = pigeonVar_list.get(2);
      pigeonResult.setDownloadState((Long) downloadState);
      Object userName = pigeonVar_list.get(3);
      pigeonResult.setUserName((String) userName);
      Object duration = pigeonVar_list.get(4);
      pigeonResult.setDuration((Long) duration);
      Object playableDuration = pigeonVar_list.get(5);
      pigeonResult.setPlayableDuration((Long) playableDuration);
      Object size = pigeonVar_list.get(6);
      pigeonResult.setSize((Long) size);
      Object downloadSize = pigeonVar_list.get(7);
      pigeonResult.setDownloadSize((Long) downloadSize);
      Object url = pigeonVar_list.get(8);
      pigeonResult.setUrl((String) url);
      Object appId = pigeonVar_list.get(9);
      pigeonResult.setAppId((Long) appId);
      Object fileId = pigeonVar_list.get(10);
      pigeonResult.setFileId((String) fileId);
      Object pSign = pigeonVar_list.get(11);
      pigeonResult.setPSign((String) pSign);
      Object quality = pigeonVar_list.get(12);
      pigeonResult.setQuality((Long) quality);
      Object token = pigeonVar_list.get(13);
      pigeonResult.setToken((String) token);
      Object speed = pigeonVar_list.get(14);
      pigeonResult.setSpeed((Long) speed);
      Object isResourceBroken = pigeonVar_list.get(15);
      pigeonResult.setIsResourceBroken((Boolean) isResourceBroken);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class TXDownloadListMsg {
    private @Nullable List<TXVodDownloadMediaMsg> infoList;

    public @Nullable List<TXVodDownloadMediaMsg> getInfoList() {
      return infoList;
    }

    public void setInfoList(@Nullable List<TXVodDownloadMediaMsg> setterArg) {
      this.infoList = setterArg;
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) { return true; }
      if (o == null || getClass() != o.getClass()) { return false; }
      TXDownloadListMsg that = (TXDownloadListMsg) o;
      return Objects.equals(infoList, that.infoList);
    }

    @Override
    public int hashCode() {
      return Objects.hash(infoList);
    }

    public static final class Builder {

      private @Nullable List<TXVodDownloadMediaMsg> infoList;

      @CanIgnoreReturnValue
      public @NonNull Builder setInfoList(@Nullable List<TXVodDownloadMediaMsg> setterArg) {
        this.infoList = setterArg;
        return this;
      }

      public @NonNull TXDownloadListMsg build() {
        TXDownloadListMsg pigeonReturn = new TXDownloadListMsg();
        pigeonReturn.setInfoList(infoList);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(1);
      toListResult.add(infoList);
      return toListResult;
    }

    static @NonNull TXDownloadListMsg fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      TXDownloadListMsg pigeonResult = new TXDownloadListMsg();
      Object infoList = pigeonVar_list.get(0);
      pigeonResult.setInfoList((List<TXVodDownloadMediaMsg>) infoList);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class UInt8ListMsg {
    private @Nullable byte[] value;

    public @Nullable byte[] getValue() {
      return value;
    }

    public void setValue(@Nullable byte[] setterArg) {
      this.value = setterArg;
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) { return true; }
      if (o == null || getClass() != o.getClass()) { return false; }
      UInt8ListMsg that = (UInt8ListMsg) o;
      return Arrays.equals(value, that.value);
    }

    @Override
    public int hashCode() {
      int pigeonVar_result = 0;
      pigeonVar_result = 31 * pigeonVar_result + Arrays.hashCode(value);
      return pigeonVar_result;
    }

    public static final class Builder {

      private @Nullable byte[] value;

      @CanIgnoreReturnValue
      public @NonNull Builder setValue(@Nullable byte[] setterArg) {
        this.value = setterArg;
        return this;
      }

      public @NonNull UInt8ListMsg build() {
        UInt8ListMsg pigeonReturn = new UInt8ListMsg();
        pigeonReturn.setValue(value);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(1);
      toListResult.add(value);
      return toListResult;
    }

    static @NonNull UInt8ListMsg fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      UInt8ListMsg pigeonResult = new UInt8ListMsg();
      Object value = pigeonVar_list.get(0);
      pigeonResult.setValue((byte[]) value);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class ListMsg {
    private @Nullable List<Object> value;

    public @Nullable List<Object> getValue() {
      return value;
    }

    public void setValue(@Nullable List<Object> setterArg) {
      this.value = setterArg;
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) { return true; }
      if (o == null || getClass() != o.getClass()) { return false; }
      ListMsg that = (ListMsg) o;
      return Objects.equals(value, that.value);
    }

    @Override
    public int hashCode() {
      return Objects.hash(value);
    }

    public static final class Builder {

      private @Nullable List<Object> value;

      @CanIgnoreReturnValue
      public @NonNull Builder setValue(@Nullable List<Object> setterArg) {
        this.value = setterArg;
        return this;
      }

      public @NonNull ListMsg build() {
        ListMsg pigeonReturn = new ListMsg();
        pigeonReturn.setValue(value);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(1);
      toListResult.add(value);
      return toListResult;
    }

    static @NonNull ListMsg fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      ListMsg pigeonResult = new ListMsg();
      Object value = pigeonVar_list.get(0);
      pigeonResult.setValue((List<Object>) value);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class BoolMsg {
    private @Nullable Boolean value;

    public @Nullable Boolean getValue() {
      return value;
    }

    public void setValue(@Nullable Boolean setterArg) {
      this.value = setterArg;
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) { return true; }
      if (o == null || getClass() != o.getClass()) { return false; }
      BoolMsg that = (BoolMsg) o;
      return Objects.equals(value, that.value);
    }

    @Override
    public int hashCode() {
      return Objects.hash(value);
    }

    public static final class Builder {

      private @Nullable Boolean value;

      @CanIgnoreReturnValue
      public @NonNull Builder setValue(@Nullable Boolean setterArg) {
        this.value = setterArg;
        return this;
      }

      public @NonNull BoolMsg build() {
        BoolMsg pigeonReturn = new BoolMsg();
        pigeonReturn.setValue(value);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(1);
      toListResult.add(value);
      return toListResult;
    }

    static @NonNull BoolMsg fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      BoolMsg pigeonResult = new BoolMsg();
      Object value = pigeonVar_list.get(0);
      pigeonResult.setValue((Boolean) value);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class IntMsg {
    private @Nullable Long value;

    public @Nullable Long getValue() {
      return value;
    }

    public void setValue(@Nullable Long setterArg) {
      this.value = setterArg;
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) { return true; }
      if (o == null || getClass() != o.getClass()) { return false; }
      IntMsg that = (IntMsg) o;
      return Objects.equals(value, that.value);
    }

    @Override
    public int hashCode() {
      return Objects.hash(value);
    }

    public static final class Builder {

      private @Nullable Long value;

      @CanIgnoreReturnValue
      public @NonNull Builder setValue(@Nullable Long setterArg) {
        this.value = setterArg;
        return this;
      }

      public @NonNull IntMsg build() {
        IntMsg pigeonReturn = new IntMsg();
        pigeonReturn.setValue(value);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(1);
      toListResult.add(value);
      return toListResult;
    }

    static @NonNull IntMsg fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      IntMsg pigeonResult = new IntMsg();
      Object value = pigeonVar_list.get(0);
      pigeonResult.setValue((Long) value);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class StringMsg {
    private @Nullable String value;

    public @Nullable String getValue() {
      return value;
    }

    public void setValue(@Nullable String setterArg) {
      this.value = setterArg;
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) { return true; }
      if (o == null || getClass() != o.getClass()) { return false; }
      StringMsg that = (StringMsg) o;
      return Objects.equals(value, that.value);
    }

    @Override
    public int hashCode() {
      return Objects.hash(value);
    }

    public static final class Builder {

      private @Nullable String value;

      @CanIgnoreReturnValue
      public @NonNull Builder setValue(@Nullable String setterArg) {
        this.value = setterArg;
        return this;
      }

      public @NonNull StringMsg build() {
        StringMsg pigeonReturn = new StringMsg();
        pigeonReturn.setValue(value);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(1);
      toListResult.add(value);
      return toListResult;
    }

    static @NonNull StringMsg fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      StringMsg pigeonResult = new StringMsg();
      Object value = pigeonVar_list.get(0);
      pigeonResult.setValue((String) value);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class CachePathMsg {
    private @Nullable String androidAbsolutePath;

    public @Nullable String getAndroidAbsolutePath() {
      return androidAbsolutePath;
    }

    public void setAndroidAbsolutePath(@Nullable String setterArg) {
      this.androidAbsolutePath = setterArg;
    }

    private @Nullable String iOSAbsolutePath;

    public @Nullable String getIOSAbsolutePath() {
      return iOSAbsolutePath;
    }

    public void setIOSAbsolutePath(@Nullable String setterArg) {
      this.iOSAbsolutePath = setterArg;
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) { return true; }
      if (o == null || getClass() != o.getClass()) { return false; }
      CachePathMsg that = (CachePathMsg) o;
      return Objects.equals(androidAbsolutePath, that.androidAbsolutePath) && Objects.equals(iOSAbsolutePath, that.iOSAbsolutePath);
    }

    @Override
    public int hashCode() {
      return Objects.hash(androidAbsolutePath, iOSAbsolutePath);
    }

    public static final class Builder {

      private @Nullable String androidAbsolutePath;

      @CanIgnoreReturnValue
      public @NonNull Builder setAndroidAbsolutePath(@Nullable String setterArg) {
        this.androidAbsolutePath = setterArg;
        return this;
      }

      private @Nullable String iOSAbsolutePath;

      @CanIgnoreReturnValue
      public @NonNull Builder setIOSAbsolutePath(@Nullable String setterArg) {
        this.iOSAbsolutePath = setterArg;
        return this;
      }

      public @NonNull CachePathMsg build() {
        CachePathMsg pigeonReturn = new CachePathMsg();
        pigeonReturn.setAndroidAbsolutePath(androidAbsolutePath);
        pigeonReturn.setIOSAbsolutePath(iOSAbsolutePath);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(2);
      toListResult.add(androidAbsolutePath);
      toListResult.add(iOSAbsolutePath);
      return toListResult;
    }

    static @NonNull CachePathMsg fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      CachePathMsg pigeonResult = new CachePathMsg();
      Object androidAbsolutePath = pigeonVar_list.get(0);
      pigeonResult.setAndroidAbsolutePath((String) androidAbsolutePath);
      Object iOSAbsolutePath = pigeonVar_list.get(1);
      pigeonResult.setIOSAbsolutePath((String) iOSAbsolutePath);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class DoubleMsg {
    private @Nullable Double value;

    public @Nullable Double getValue() {
      return value;
    }

    public void setValue(@Nullable Double setterArg) {
      this.value = setterArg;
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) { return true; }
      if (o == null || getClass() != o.getClass()) { return false; }
      DoubleMsg that = (DoubleMsg) o;
      return Objects.equals(value, that.value);
    }

    @Override
    public int hashCode() {
      return Objects.hash(value);
    }

    public static final class Builder {

      private @Nullable Double value;

      @CanIgnoreReturnValue
      public @NonNull Builder setValue(@Nullable Double setterArg) {
        this.value = setterArg;
        return this;
      }

      public @NonNull DoubleMsg build() {
        DoubleMsg pigeonReturn = new DoubleMsg();
        pigeonReturn.setValue(value);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(1);
      toListResult.add(value);
      return toListResult;
    }

    static @NonNull DoubleMsg fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      DoubleMsg pigeonResult = new DoubleMsg();
      Object value = pigeonVar_list.get(0);
      pigeonResult.setValue((Double) value);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class PreLoadMsg {
    private @Nullable String playUrl;

    public @Nullable String getPlayUrl() {
      return playUrl;
    }

    public void setPlayUrl(@Nullable String setterArg) {
      this.playUrl = setterArg;
    }

    private @Nullable Double preloadSizeMB;

    public @Nullable Double getPreloadSizeMB() {
      return preloadSizeMB;
    }

    public void setPreloadSizeMB(@Nullable Double setterArg) {
      this.preloadSizeMB = setterArg;
    }

    private @Nullable Long preferredResolution;

    public @Nullable Long getPreferredResolution() {
      return preferredResolution;
    }

    public void setPreferredResolution(@Nullable Long setterArg) {
      this.preferredResolution = setterArg;
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) { return true; }
      if (o == null || getClass() != o.getClass()) { return false; }
      PreLoadMsg that = (PreLoadMsg) o;
      return Objects.equals(playUrl, that.playUrl) && Objects.equals(preloadSizeMB, that.preloadSizeMB) && Objects.equals(preferredResolution, that.preferredResolution);
    }

    @Override
    public int hashCode() {
      return Objects.hash(playUrl, preloadSizeMB, preferredResolution);
    }

    public static final class Builder {

      private @Nullable String playUrl;

      @CanIgnoreReturnValue
      public @NonNull Builder setPlayUrl(@Nullable String setterArg) {
        this.playUrl = setterArg;
        return this;
      }

      private @Nullable Double preloadSizeMB;

      @CanIgnoreReturnValue
      public @NonNull Builder setPreloadSizeMB(@Nullable Double setterArg) {
        this.preloadSizeMB = setterArg;
        return this;
      }

      private @Nullable Long preferredResolution;

      @CanIgnoreReturnValue
      public @NonNull Builder setPreferredResolution(@Nullable Long setterArg) {
        this.preferredResolution = setterArg;
        return this;
      }

      public @NonNull PreLoadMsg build() {
        PreLoadMsg pigeonReturn = new PreLoadMsg();
        pigeonReturn.setPlayUrl(playUrl);
        pigeonReturn.setPreloadSizeMB(preloadSizeMB);
        pigeonReturn.setPreferredResolution(preferredResolution);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(3);
      toListResult.add(playUrl);
      toListResult.add(preloadSizeMB);
      toListResult.add(preferredResolution);
      return toListResult;
    }

    static @NonNull PreLoadMsg fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      PreLoadMsg pigeonResult = new PreLoadMsg();
      Object playUrl = pigeonVar_list.get(0);
      pigeonResult.setPlayUrl((String) playUrl);
      Object preloadSizeMB = pigeonVar_list.get(1);
      pigeonResult.setPreloadSizeMB((Double) preloadSizeMB);
      Object preferredResolution = pigeonVar_list.get(2);
      pigeonResult.setPreferredResolution((Long) preferredResolution);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class PreLoadInfoMsg {
    private @Nullable Long appId;

    public @Nullable Long getAppId() {
      return appId;
    }

    public void setAppId(@Nullable Long setterArg) {
      this.appId = setterArg;
    }

    private @Nullable String fileId;

    public @Nullable String getFileId() {
      return fileId;
    }

    public void setFileId(@Nullable String setterArg) {
      this.fileId = setterArg;
    }

    private @Nullable String pSign;

    public @Nullable String getPSign() {
      return pSign;
    }

    public void setPSign(@Nullable String setterArg) {
      this.pSign = setterArg;
    }

    private @Nullable String playUrl;

    public @Nullable String getPlayUrl() {
      return playUrl;
    }

    public void setPlayUrl(@Nullable String setterArg) {
      this.playUrl = setterArg;
    }

    private @Nullable Double preloadSizeMB;

    public @Nullable Double getPreloadSizeMB() {
      return preloadSizeMB;
    }

    public void setPreloadSizeMB(@Nullable Double setterArg) {
      this.preloadSizeMB = setterArg;
    }

    private @Nullable Long preferredResolution;

    public @Nullable Long getPreferredResolution() {
      return preferredResolution;
    }

    public void setPreferredResolution(@Nullable Long setterArg) {
      this.preferredResolution = setterArg;
    }

    private @Nullable Long tmpPreloadTaskId;

    public @Nullable Long getTmpPreloadTaskId() {
      return tmpPreloadTaskId;
    }

    public void setTmpPreloadTaskId(@Nullable Long setterArg) {
      this.tmpPreloadTaskId = setterArg;
    }

    private @Nullable Map<String, String> httpHeader;

    public @Nullable Map<String, String> getHttpHeader() {
      return httpHeader;
    }

    public void setHttpHeader(@Nullable Map<String, String> setterArg) {
      this.httpHeader = setterArg;
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) { return true; }
      if (o == null || getClass() != o.getClass()) { return false; }
      PreLoadInfoMsg that = (PreLoadInfoMsg) o;
      return Objects.equals(appId, that.appId) && Objects.equals(fileId, that.fileId) && Objects.equals(pSign, that.pSign) && Objects.equals(playUrl, that.playUrl) && Objects.equals(preloadSizeMB, that.preloadSizeMB) && Objects.equals(preferredResolution, that.preferredResolution) && Objects.equals(tmpPreloadTaskId, that.tmpPreloadTaskId) && Objects.equals(httpHeader, that.httpHeader);
    }

    @Override
    public int hashCode() {
      return Objects.hash(appId, fileId, pSign, playUrl, preloadSizeMB, preferredResolution, tmpPreloadTaskId, httpHeader);
    }

    public static final class Builder {

      private @Nullable Long appId;

      @CanIgnoreReturnValue
      public @NonNull Builder setAppId(@Nullable Long setterArg) {
        this.appId = setterArg;
        return this;
      }

      private @Nullable String fileId;

      @CanIgnoreReturnValue
      public @NonNull Builder setFileId(@Nullable String setterArg) {
        this.fileId = setterArg;
        return this;
      }

      private @Nullable String pSign;

      @CanIgnoreReturnValue
      public @NonNull Builder setPSign(@Nullable String setterArg) {
        this.pSign = setterArg;
        return this;
      }

      private @Nullable String playUrl;

      @CanIgnoreReturnValue
      public @NonNull Builder setPlayUrl(@Nullable String setterArg) {
        this.playUrl = setterArg;
        return this;
      }

      private @Nullable Double preloadSizeMB;

      @CanIgnoreReturnValue
      public @NonNull Builder setPreloadSizeMB(@Nullable Double setterArg) {
        this.preloadSizeMB = setterArg;
        return this;
      }

      private @Nullable Long preferredResolution;

      @CanIgnoreReturnValue
      public @NonNull Builder setPreferredResolution(@Nullable Long setterArg) {
        this.preferredResolution = setterArg;
        return this;
      }

      private @Nullable Long tmpPreloadTaskId;

      @CanIgnoreReturnValue
      public @NonNull Builder setTmpPreloadTaskId(@Nullable Long setterArg) {
        this.tmpPreloadTaskId = setterArg;
        return this;
      }

      private @Nullable Map<String, String> httpHeader;

      @CanIgnoreReturnValue
      public @NonNull Builder setHttpHeader(@Nullable Map<String, String> setterArg) {
        this.httpHeader = setterArg;
        return this;
      }

      public @NonNull PreLoadInfoMsg build() {
        PreLoadInfoMsg pigeonReturn = new PreLoadInfoMsg();
        pigeonReturn.setAppId(appId);
        pigeonReturn.setFileId(fileId);
        pigeonReturn.setPSign(pSign);
        pigeonReturn.setPlayUrl(playUrl);
        pigeonReturn.setPreloadSizeMB(preloadSizeMB);
        pigeonReturn.setPreferredResolution(preferredResolution);
        pigeonReturn.setTmpPreloadTaskId(tmpPreloadTaskId);
        pigeonReturn.setHttpHeader(httpHeader);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(8);
      toListResult.add(appId);
      toListResult.add(fileId);
      toListResult.add(pSign);
      toListResult.add(playUrl);
      toListResult.add(preloadSizeMB);
      toListResult.add(preferredResolution);
      toListResult.add(tmpPreloadTaskId);
      toListResult.add(httpHeader);
      return toListResult;
    }

    static @NonNull PreLoadInfoMsg fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      PreLoadInfoMsg pigeonResult = new PreLoadInfoMsg();
      Object appId = pigeonVar_list.get(0);
      pigeonResult.setAppId((Long) appId);
      Object fileId = pigeonVar_list.get(1);
      pigeonResult.setFileId((String) fileId);
      Object pSign = pigeonVar_list.get(2);
      pigeonResult.setPSign((String) pSign);
      Object playUrl = pigeonVar_list.get(3);
      pigeonResult.setPlayUrl((String) playUrl);
      Object preloadSizeMB = pigeonVar_list.get(4);
      pigeonResult.setPreloadSizeMB((Double) preloadSizeMB);
      Object preferredResolution = pigeonVar_list.get(5);
      pigeonResult.setPreferredResolution((Long) preferredResolution);
      Object tmpPreloadTaskId = pigeonVar_list.get(6);
      pigeonResult.setTmpPreloadTaskId((Long) tmpPreloadTaskId);
      Object httpHeader = pigeonVar_list.get(7);
      pigeonResult.setHttpHeader((Map<String, String>) httpHeader);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class MapMsg {
    private @Nullable Map<String, String> map;

    public @Nullable Map<String, String> getMap() {
      return map;
    }

    public void setMap(@Nullable Map<String, String> setterArg) {
      this.map = setterArg;
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) { return true; }
      if (o == null || getClass() != o.getClass()) { return false; }
      MapMsg that = (MapMsg) o;
      return Objects.equals(map, that.map);
    }

    @Override
    public int hashCode() {
      return Objects.hash(map);
    }

    public static final class Builder {

      private @Nullable Map<String, String> map;

      @CanIgnoreReturnValue
      public @NonNull Builder setMap(@Nullable Map<String, String> setterArg) {
        this.map = setterArg;
        return this;
      }

      public @NonNull MapMsg build() {
        MapMsg pigeonReturn = new MapMsg();
        pigeonReturn.setMap(map);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(1);
      toListResult.add(map);
      return toListResult;
    }

    static @NonNull MapMsg fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      MapMsg pigeonResult = new MapMsg();
      Object map = pigeonVar_list.get(0);
      pigeonResult.setMap((Map<String, String>) map);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class SubTitlePlayerMsg {
    private @NonNull String url;

    public @NonNull String getUrl() {
      return url;
    }

    public void setUrl(@NonNull String setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"url\" is null.");
      }
      this.url = setterArg;
    }

    private @NonNull String name;

    public @NonNull String getName() {
      return name;
    }

    public void setName(@NonNull String setterArg) {
      if (setterArg == null) {
        throw new IllegalStateException("Nonnull field \"name\" is null.");
      }
      this.name = setterArg;
    }

    private @Nullable String mimeType;

    public @Nullable String getMimeType() {
      return mimeType;
    }

    public void setMimeType(@Nullable String setterArg) {
      this.mimeType = setterArg;
    }

    private @Nullable Long playerId;

    public @Nullable Long getPlayerId() {
      return playerId;
    }

    public void setPlayerId(@Nullable Long setterArg) {
      this.playerId = setterArg;
    }

    /** Constructor is non-public to enforce null safety; use Builder. */
    SubTitlePlayerMsg() {}

    @Override
    public boolean equals(Object o) {
      if (this == o) { return true; }
      if (o == null || getClass() != o.getClass()) { return false; }
      SubTitlePlayerMsg that = (SubTitlePlayerMsg) o;
      return url.equals(that.url) && name.equals(that.name) && Objects.equals(mimeType, that.mimeType) && Objects.equals(playerId, that.playerId);
    }

    @Override
    public int hashCode() {
      return Objects.hash(url, name, mimeType, playerId);
    }

    public static final class Builder {

      private @Nullable String url;

      @CanIgnoreReturnValue
      public @NonNull Builder setUrl(@NonNull String setterArg) {
        this.url = setterArg;
        return this;
      }

      private @Nullable String name;

      @CanIgnoreReturnValue
      public @NonNull Builder setName(@NonNull String setterArg) {
        this.name = setterArg;
        return this;
      }

      private @Nullable String mimeType;

      @CanIgnoreReturnValue
      public @NonNull Builder setMimeType(@Nullable String setterArg) {
        this.mimeType = setterArg;
        return this;
      }

      private @Nullable Long playerId;

      @CanIgnoreReturnValue
      public @NonNull Builder setPlayerId(@Nullable Long setterArg) {
        this.playerId = setterArg;
        return this;
      }

      public @NonNull SubTitlePlayerMsg build() {
        SubTitlePlayerMsg pigeonReturn = new SubTitlePlayerMsg();
        pigeonReturn.setUrl(url);
        pigeonReturn.setName(name);
        pigeonReturn.setMimeType(mimeType);
        pigeonReturn.setPlayerId(playerId);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(4);
      toListResult.add(url);
      toListResult.add(name);
      toListResult.add(mimeType);
      toListResult.add(playerId);
      return toListResult;
    }

    static @NonNull SubTitlePlayerMsg fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      SubTitlePlayerMsg pigeonResult = new SubTitlePlayerMsg();
      Object url = pigeonVar_list.get(0);
      pigeonResult.setUrl((String) url);
      Object name = pigeonVar_list.get(1);
      pigeonResult.setName((String) name);
      Object mimeType = pigeonVar_list.get(2);
      pigeonResult.setMimeType((String) mimeType);
      Object playerId = pigeonVar_list.get(3);
      pigeonResult.setPlayerId((Long) playerId);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class SubTitleRenderModelPlayerMsg {
    private @Nullable Long canvasWidth;

    public @Nullable Long getCanvasWidth() {
      return canvasWidth;
    }

    public void setCanvasWidth(@Nullable Long setterArg) {
      this.canvasWidth = setterArg;
    }

    private @Nullable Long canvasHeight;

    public @Nullable Long getCanvasHeight() {
      return canvasHeight;
    }

    public void setCanvasHeight(@Nullable Long setterArg) {
      this.canvasHeight = setterArg;
    }

    private @Nullable String familyName;

    public @Nullable String getFamilyName() {
      return familyName;
    }

    public void setFamilyName(@Nullable String setterArg) {
      this.familyName = setterArg;
    }

    private @Nullable Double fontSize;

    public @Nullable Double getFontSize() {
      return fontSize;
    }

    public void setFontSize(@Nullable Double setterArg) {
      this.fontSize = setterArg;
    }

    private @Nullable Double fontScale;

    public @Nullable Double getFontScale() {
      return fontScale;
    }

    public void setFontScale(@Nullable Double setterArg) {
      this.fontScale = setterArg;
    }

    private @Nullable Long fontColor;

    public @Nullable Long getFontColor() {
      return fontColor;
    }

    public void setFontColor(@Nullable Long setterArg) {
      this.fontColor = setterArg;
    }

    private @Nullable Boolean isBondFontStyle;

    public @Nullable Boolean getIsBondFontStyle() {
      return isBondFontStyle;
    }

    public void setIsBondFontStyle(@Nullable Boolean setterArg) {
      this.isBondFontStyle = setterArg;
    }

    private @Nullable Double outlineWidth;

    public @Nullable Double getOutlineWidth() {
      return outlineWidth;
    }

    public void setOutlineWidth(@Nullable Double setterArg) {
      this.outlineWidth = setterArg;
    }

    private @Nullable Long outlineColor;

    public @Nullable Long getOutlineColor() {
      return outlineColor;
    }

    public void setOutlineColor(@Nullable Long setterArg) {
      this.outlineColor = setterArg;
    }

    private @Nullable Double lineSpace;

    public @Nullable Double getLineSpace() {
      return lineSpace;
    }

    public void setLineSpace(@Nullable Double setterArg) {
      this.lineSpace = setterArg;
    }

    private @Nullable Double startMargin;

    public @Nullable Double getStartMargin() {
      return startMargin;
    }

    public void setStartMargin(@Nullable Double setterArg) {
      this.startMargin = setterArg;
    }

    private @Nullable Double endMargin;

    public @Nullable Double getEndMargin() {
      return endMargin;
    }

    public void setEndMargin(@Nullable Double setterArg) {
      this.endMargin = setterArg;
    }

    private @Nullable Double verticalMargin;

    public @Nullable Double getVerticalMargin() {
      return verticalMargin;
    }

    public void setVerticalMargin(@Nullable Double setterArg) {
      this.verticalMargin = setterArg;
    }

    private @Nullable Long playerId;

    public @Nullable Long getPlayerId() {
      return playerId;
    }

    public void setPlayerId(@Nullable Long setterArg) {
      this.playerId = setterArg;
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) { return true; }
      if (o == null || getClass() != o.getClass()) { return false; }
      SubTitleRenderModelPlayerMsg that = (SubTitleRenderModelPlayerMsg) o;
      return Objects.equals(canvasWidth, that.canvasWidth) && Objects.equals(canvasHeight, that.canvasHeight) && Objects.equals(familyName, that.familyName) && Objects.equals(fontSize, that.fontSize) && Objects.equals(fontScale, that.fontScale) && Objects.equals(fontColor, that.fontColor) && Objects.equals(isBondFontStyle, that.isBondFontStyle) && Objects.equals(outlineWidth, that.outlineWidth) && Objects.equals(outlineColor, that.outlineColor) && Objects.equals(lineSpace, that.lineSpace) && Objects.equals(startMargin, that.startMargin) && Objects.equals(endMargin, that.endMargin) && Objects.equals(verticalMargin, that.verticalMargin) && Objects.equals(playerId, that.playerId);
    }

    @Override
    public int hashCode() {
      return Objects.hash(canvasWidth, canvasHeight, familyName, fontSize, fontScale, fontColor, isBondFontStyle, outlineWidth, outlineColor, lineSpace, startMargin, endMargin, verticalMargin, playerId);
    }

    public static final class Builder {

      private @Nullable Long canvasWidth;

      @CanIgnoreReturnValue
      public @NonNull Builder setCanvasWidth(@Nullable Long setterArg) {
        this.canvasWidth = setterArg;
        return this;
      }

      private @Nullable Long canvasHeight;

      @CanIgnoreReturnValue
      public @NonNull Builder setCanvasHeight(@Nullable Long setterArg) {
        this.canvasHeight = setterArg;
        return this;
      }

      private @Nullable String familyName;

      @CanIgnoreReturnValue
      public @NonNull Builder setFamilyName(@Nullable String setterArg) {
        this.familyName = setterArg;
        return this;
      }

      private @Nullable Double fontSize;

      @CanIgnoreReturnValue
      public @NonNull Builder setFontSize(@Nullable Double setterArg) {
        this.fontSize = setterArg;
        return this;
      }

      private @Nullable Double fontScale;

      @CanIgnoreReturnValue
      public @NonNull Builder setFontScale(@Nullable Double setterArg) {
        this.fontScale = setterArg;
        return this;
      }

      private @Nullable Long fontColor;

      @CanIgnoreReturnValue
      public @NonNull Builder setFontColor(@Nullable Long setterArg) {
        this.fontColor = setterArg;
        return this;
      }

      private @Nullable Boolean isBondFontStyle;

      @CanIgnoreReturnValue
      public @NonNull Builder setIsBondFontStyle(@Nullable Boolean setterArg) {
        this.isBondFontStyle = setterArg;
        return this;
      }

      private @Nullable Double outlineWidth;

      @CanIgnoreReturnValue
      public @NonNull Builder setOutlineWidth(@Nullable Double setterArg) {
        this.outlineWidth = setterArg;
        return this;
      }

      private @Nullable Long outlineColor;

      @CanIgnoreReturnValue
      public @NonNull Builder setOutlineColor(@Nullable Long setterArg) {
        this.outlineColor = setterArg;
        return this;
      }

      private @Nullable Double lineSpace;

      @CanIgnoreReturnValue
      public @NonNull Builder setLineSpace(@Nullable Double setterArg) {
        this.lineSpace = setterArg;
        return this;
      }

      private @Nullable Double startMargin;

      @CanIgnoreReturnValue
      public @NonNull Builder setStartMargin(@Nullable Double setterArg) {
        this.startMargin = setterArg;
        return this;
      }

      private @Nullable Double endMargin;

      @CanIgnoreReturnValue
      public @NonNull Builder setEndMargin(@Nullable Double setterArg) {
        this.endMargin = setterArg;
        return this;
      }

      private @Nullable Double verticalMargin;

      @CanIgnoreReturnValue
      public @NonNull Builder setVerticalMargin(@Nullable Double setterArg) {
        this.verticalMargin = setterArg;
        return this;
      }

      private @Nullable Long playerId;

      @CanIgnoreReturnValue
      public @NonNull Builder setPlayerId(@Nullable Long setterArg) {
        this.playerId = setterArg;
        return this;
      }

      public @NonNull SubTitleRenderModelPlayerMsg build() {
        SubTitleRenderModelPlayerMsg pigeonReturn = new SubTitleRenderModelPlayerMsg();
        pigeonReturn.setCanvasWidth(canvasWidth);
        pigeonReturn.setCanvasHeight(canvasHeight);
        pigeonReturn.setFamilyName(familyName);
        pigeonReturn.setFontSize(fontSize);
        pigeonReturn.setFontScale(fontScale);
        pigeonReturn.setFontColor(fontColor);
        pigeonReturn.setIsBondFontStyle(isBondFontStyle);
        pigeonReturn.setOutlineWidth(outlineWidth);
        pigeonReturn.setOutlineColor(outlineColor);
        pigeonReturn.setLineSpace(lineSpace);
        pigeonReturn.setStartMargin(startMargin);
        pigeonReturn.setEndMargin(endMargin);
        pigeonReturn.setVerticalMargin(verticalMargin);
        pigeonReturn.setPlayerId(playerId);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(14);
      toListResult.add(canvasWidth);
      toListResult.add(canvasHeight);
      toListResult.add(familyName);
      toListResult.add(fontSize);
      toListResult.add(fontScale);
      toListResult.add(fontColor);
      toListResult.add(isBondFontStyle);
      toListResult.add(outlineWidth);
      toListResult.add(outlineColor);
      toListResult.add(lineSpace);
      toListResult.add(startMargin);
      toListResult.add(endMargin);
      toListResult.add(verticalMargin);
      toListResult.add(playerId);
      return toListResult;
    }

    static @NonNull SubTitleRenderModelPlayerMsg fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      SubTitleRenderModelPlayerMsg pigeonResult = new SubTitleRenderModelPlayerMsg();
      Object canvasWidth = pigeonVar_list.get(0);
      pigeonResult.setCanvasWidth((Long) canvasWidth);
      Object canvasHeight = pigeonVar_list.get(1);
      pigeonResult.setCanvasHeight((Long) canvasHeight);
      Object familyName = pigeonVar_list.get(2);
      pigeonResult.setFamilyName((String) familyName);
      Object fontSize = pigeonVar_list.get(3);
      pigeonResult.setFontSize((Double) fontSize);
      Object fontScale = pigeonVar_list.get(4);
      pigeonResult.setFontScale((Double) fontScale);
      Object fontColor = pigeonVar_list.get(5);
      pigeonResult.setFontColor((Long) fontColor);
      Object isBondFontStyle = pigeonVar_list.get(6);
      pigeonResult.setIsBondFontStyle((Boolean) isBondFontStyle);
      Object outlineWidth = pigeonVar_list.get(7);
      pigeonResult.setOutlineWidth((Double) outlineWidth);
      Object outlineColor = pigeonVar_list.get(8);
      pigeonResult.setOutlineColor((Long) outlineColor);
      Object lineSpace = pigeonVar_list.get(9);
      pigeonResult.setLineSpace((Double) lineSpace);
      Object startMargin = pigeonVar_list.get(10);
      pigeonResult.setStartMargin((Double) startMargin);
      Object endMargin = pigeonVar_list.get(11);
      pigeonResult.setEndMargin((Double) endMargin);
      Object verticalMargin = pigeonVar_list.get(12);
      pigeonResult.setVerticalMargin((Double) verticalMargin);
      Object playerId = pigeonVar_list.get(13);
      pigeonResult.setPlayerId((Long) playerId);
      return pigeonResult;
    }
  }

  /** Generated class from Pigeon that represents data sent in messages. */
  public static final class StringOptionPlayerMsg {
    private @Nullable String key;

    public @Nullable String getKey() {
      return key;
    }

    public void setKey(@Nullable String setterArg) {
      this.key = setterArg;
    }

    private @Nullable List<Object> value;

    public @Nullable List<Object> getValue() {
      return value;
    }

    public void setValue(@Nullable List<Object> setterArg) {
      this.value = setterArg;
    }

    private @Nullable Long playerId;

    public @Nullable Long getPlayerId() {
      return playerId;
    }

    public void setPlayerId(@Nullable Long setterArg) {
      this.playerId = setterArg;
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) { return true; }
      if (o == null || getClass() != o.getClass()) { return false; }
      StringOptionPlayerMsg that = (StringOptionPlayerMsg) o;
      return Objects.equals(key, that.key) && Objects.equals(value, that.value) && Objects.equals(playerId, that.playerId);
    }

    @Override
    public int hashCode() {
      return Objects.hash(key, value, playerId);
    }

    public static final class Builder {

      private @Nullable String key;

      @CanIgnoreReturnValue
      public @NonNull Builder setKey(@Nullable String setterArg) {
        this.key = setterArg;
        return this;
      }

      private @Nullable List<Object> value;

      @CanIgnoreReturnValue
      public @NonNull Builder setValue(@Nullable List<Object> setterArg) {
        this.value = setterArg;
        return this;
      }

      private @Nullable Long playerId;

      @CanIgnoreReturnValue
      public @NonNull Builder setPlayerId(@Nullable Long setterArg) {
        this.playerId = setterArg;
        return this;
      }

      public @NonNull StringOptionPlayerMsg build() {
        StringOptionPlayerMsg pigeonReturn = new StringOptionPlayerMsg();
        pigeonReturn.setKey(key);
        pigeonReturn.setValue(value);
        pigeonReturn.setPlayerId(playerId);
        return pigeonReturn;
      }
    }

    @NonNull
    ArrayList<Object> toList() {
      ArrayList<Object> toListResult = new ArrayList<>(3);
      toListResult.add(key);
      toListResult.add(value);
      toListResult.add(playerId);
      return toListResult;
    }

    static @NonNull StringOptionPlayerMsg fromList(@NonNull ArrayList<Object> pigeonVar_list) {
      StringOptionPlayerMsg pigeonResult = new StringOptionPlayerMsg();
      Object key = pigeonVar_list.get(0);
      pigeonResult.setKey((String) key);
      Object value = pigeonVar_list.get(1);
      pigeonResult.setValue((List<Object>) value);
      Object playerId = pigeonVar_list.get(2);
      pigeonResult.setPlayerId((Long) playerId);
      return pigeonResult;
    }
  }

  private static class PigeonCodec extends StandardMessageCodec {
    public static final PigeonCodec INSTANCE = new PigeonCodec();

    private PigeonCodec() {}

    @Override
    protected Object readValueOfType(byte type, @NonNull ByteBuffer buffer) {
      switch (type) {
        case (byte) 129:
          return PlayerMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 130:
          return LicenseMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 131:
          return TXPlayInfoParamsPlayerMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 132:
          return TXPlayerDrmMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 133:
          return PipParamsPlayerMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 134:
          return StringListPlayerMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 135:
          return BoolPlayerMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 136:
          return StringPlayerMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 137:
          return DoublePlayerMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 138:
          return IntPlayerMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 139:
          return FTXVodPlayConfigPlayerMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 140:
          return FTXLivePlayConfigPlayerMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 141:
          return TXVodDownloadMediaMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 142:
          return TXDownloadListMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 143:
          return UInt8ListMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 144:
          return ListMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 145:
          return BoolMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 146:
          return IntMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 147:
          return StringMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 148:
          return CachePathMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 149:
          return DoubleMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 150:
          return PreLoadMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 151:
          return PreLoadInfoMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 152:
          return MapMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 153:
          return SubTitlePlayerMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 154:
          return SubTitleRenderModelPlayerMsg.fromList((ArrayList<Object>) readValue(buffer));
        case (byte) 155:
          return StringOptionPlayerMsg.fromList((ArrayList<Object>) readValue(buffer));
        default:
          return super.readValueOfType(type, buffer);
      }
    }

    @Override
    protected void writeValue(@NonNull ByteArrayOutputStream stream, Object value) {
      if (value instanceof PlayerMsg) {
        stream.write(129);
        writeValue(stream, ((PlayerMsg) value).toList());
      } else if (value instanceof LicenseMsg) {
        stream.write(130);
        writeValue(stream, ((LicenseMsg) value).toList());
      } else if (value instanceof TXPlayInfoParamsPlayerMsg) {
        stream.write(131);
        writeValue(stream, ((TXPlayInfoParamsPlayerMsg) value).toList());
      } else if (value instanceof TXPlayerDrmMsg) {
        stream.write(132);
        writeValue(stream, ((TXPlayerDrmMsg) value).toList());
      } else if (value instanceof PipParamsPlayerMsg) {
        stream.write(133);
        writeValue(stream, ((PipParamsPlayerMsg) value).toList());
      } else if (value instanceof StringListPlayerMsg) {
        stream.write(134);
        writeValue(stream, ((StringListPlayerMsg) value).toList());
      } else if (value instanceof BoolPlayerMsg) {
        stream.write(135);
        writeValue(stream, ((BoolPlayerMsg) value).toList());
      } else if (value instanceof StringPlayerMsg) {
        stream.write(136);
        writeValue(stream, ((StringPlayerMsg) value).toList());
      } else if (value instanceof DoublePlayerMsg) {
        stream.write(137);
        writeValue(stream, ((DoublePlayerMsg) value).toList());
      } else if (value instanceof IntPlayerMsg) {
        stream.write(138);
        writeValue(stream, ((IntPlayerMsg) value).toList());
      } else if (value instanceof FTXVodPlayConfigPlayerMsg) {
        stream.write(139);
        writeValue(stream, ((FTXVodPlayConfigPlayerMsg) value).toList());
      } else if (value instanceof FTXLivePlayConfigPlayerMsg) {
        stream.write(140);
        writeValue(stream, ((FTXLivePlayConfigPlayerMsg) value).toList());
      } else if (value instanceof TXVodDownloadMediaMsg) {
        stream.write(141);
        writeValue(stream, ((TXVodDownloadMediaMsg) value).toList());
      } else if (value instanceof TXDownloadListMsg) {
        stream.write(142);
        writeValue(stream, ((TXDownloadListMsg) value).toList());
      } else if (value instanceof UInt8ListMsg) {
        stream.write(143);
        writeValue(stream, ((UInt8ListMsg) value).toList());
      } else if (value instanceof ListMsg) {
        stream.write(144);
        writeValue(stream, ((ListMsg) value).toList());
      } else if (value instanceof BoolMsg) {
        stream.write(145);
        writeValue(stream, ((BoolMsg) value).toList());
      } else if (value instanceof IntMsg) {
        stream.write(146);
        writeValue(stream, ((IntMsg) value).toList());
      } else if (value instanceof StringMsg) {
        stream.write(147);
        writeValue(stream, ((StringMsg) value).toList());
      } else if (value instanceof CachePathMsg) {
        stream.write(148);
        writeValue(stream, ((CachePathMsg) value).toList());
      } else if (value instanceof DoubleMsg) {
        stream.write(149);
        writeValue(stream, ((DoubleMsg) value).toList());
      } else if (value instanceof PreLoadMsg) {
        stream.write(150);
        writeValue(stream, ((PreLoadMsg) value).toList());
      } else if (value instanceof PreLoadInfoMsg) {
        stream.write(151);
        writeValue(stream, ((PreLoadInfoMsg) value).toList());
      } else if (value instanceof MapMsg) {
        stream.write(152);
        writeValue(stream, ((MapMsg) value).toList());
      } else if (value instanceof SubTitlePlayerMsg) {
        stream.write(153);
        writeValue(stream, ((SubTitlePlayerMsg) value).toList());
      } else if (value instanceof SubTitleRenderModelPlayerMsg) {
        stream.write(154);
        writeValue(stream, ((SubTitleRenderModelPlayerMsg) value).toList());
      } else if (value instanceof StringOptionPlayerMsg) {
        stream.write(155);
        writeValue(stream, ((StringOptionPlayerMsg) value).toList());
      } else {
        super.writeValue(stream, value);
      }
    }
  }


  /** Asynchronous error handling return type for non-nullable API method returns. */
  public interface Result<T> {
    /** Success case callback method for handling returns. */
    void success(@NonNull T result);

    /** Failure case callback method for handling errors. */
    void error(@NonNull Throwable error);
  }
  /** Asynchronous error handling return type for nullable API method returns. */
  public interface NullableResult<T> {
    /** Success case callback method for handling returns. */
    void success(@Nullable T result);

    /** Failure case callback method for handling errors. */
    void error(@NonNull Throwable error);
  }
  /** Asynchronous error handling return type for void API method returns. */
  public interface VoidResult {
    /** Success case callback method for handling returns. */
    void success();

    /** Failure case callback method for handling errors. */
    void error(@NonNull Throwable error);
  }
  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface TXFlutterSuperPlayerPluginAPI {

    @NonNull 
    StringMsg getPlatformVersion();
    /** 创建点播播放器 */
    @NonNull 
    PlayerMsg createVodPlayer(@NonNull Boolean onlyAudio);
    /** 创建直播播放器 */
    @NonNull 
    PlayerMsg createLivePlayer(@NonNull Boolean onlyAudio);
    /** 开关log输出 */
    void setConsoleEnabled(@NonNull BoolMsg enabled);
    /** 释放播放器资源 */
    void releasePlayer(@NonNull PlayerMsg playerId);
    /**
     * 设置播放引擎的最大缓存大小。设置后会根据设定值自动清理Cache目录的文件
     * @param size 最大缓存大小（单位：MB)
     */
    void setGlobalMaxCacheSize(@NonNull IntMsg size);
    /**
     * 在短视频播放场景中，视频文件的本地缓存是很刚需的一个特性，对于普通用户而言，一个已经看过的视频再次观看时，不应该再消耗一次流量。
     *  @格式支持：SDK 支持 HLS(m3u8) 和 MP4 两种常见点播格式的缓存功能。
     *  @开启时机：SDK 并不默认开启缓存功能，对于用户回看率不高的场景，也并不推荐您开启此功能。
     *  @开启方式：全局生效，在使用播放器开启。开启此功能需要配置两个参数：本地缓存目录及缓存大小。
     *
     * 该缓存路径默认设置到app沙盒目录下，postfixPath只需要传递相对缓存目录即可，不需要传递整个绝对路径。
     * e.g. postfixPath = 'testCache'
     * Android 平台：视频将会缓存到sdcard的Android/data/your-pkg-name/files/testCache 目录。
     * iOS 平台：视频将会缓存到沙盒的Documents/testCache 目录。
     * @param postfixPath 缓存目录
     * @return true 设置成功 false 设置失败
     */
    @NonNull 
    BoolMsg setGlobalCacheFolderPath(@NonNull StringMsg postfixPath);
    /** 设置播放器资源缓存目录绝对路径，该方法会与 setGlobalCacheFolderPath(String postfixPath) 相互覆盖，调用其中一个即可 */
    @NonNull 
    BoolMsg setGlobalCacheFolderCustomPath(@NonNull CachePathMsg cacheMsg);
    /** 设置全局license */
    void setGlobalLicense(@NonNull LicenseMsg licenseMsg);
    /** 设置log输出级别 [TXLogLevel] */
    void setLogLevel(@NonNull IntMsg logLevel);
    /** 获取依赖Native端的 LiteAVSDK 的版本 */
    @NonNull 
    StringMsg getLiteAVSDKVersion();
    /**
     *
     * 设置 liteav SDK 接入的环境。
     * 腾讯云在全球各地区部署的环境，按照各地区政策法规要求，需要接入不同地区接入点。
     *
     * @param envConfig 需要接入的环境，SDK 默认接入的环境是：默认正式环境。
     * @return 0：成功；其他：错误
     * @note 目标市场为中国大陆的客户请不要调用此接口，如果目标市场为海外用户，请通过技术支持联系我们，了解 env_config 的配置方法，以确保 App 遵守 GDPR 标准。
     *
     */
    @NonNull 
    IntMsg setGlobalEnv(@NonNull StringMsg envConfig);
    /**
     *
     * 开始监听设备旋转方向，开启之后，如果设备自动旋转打开，播放器会自动根据当前设备方向来旋转视频方向。
     * <h1>该接口目前只适用安卓端，IOS端会自动开启该能力</h1>
     * 在调用该接口前，请务必向用户告知隐私风险。
     * 如有需要，请确认是否有获取旋转sensor的权限。
     * @return true : 开启成功
     *         false : 开启失败，如开启过早，还未等到上下文初始化、获取sensor失败等原因
     */
    @NonNull 
    BoolMsg startVideoOrientationService();

    void setUserId(@NonNull StringMsg msg);

    void setLicenseFlexibleValid(@NonNull BoolMsg msg);

    void setDrmProvisionEnv(@NonNull Long env);

    /** The codec used by TXFlutterSuperPlayerPluginAPI. */
    static @NonNull MessageCodec<Object> getCodec() {
      return PigeonCodec.INSTANCE;
    }
    /**Sets up an instance of `TXFlutterSuperPlayerPluginAPI` to handle messages through the `binaryMessenger`. */
    static void setUp(@NonNull BinaryMessenger binaryMessenger, @Nullable TXFlutterSuperPlayerPluginAPI api) {
      setUp(binaryMessenger, "", api);
    }
    static void setUp(@NonNull BinaryMessenger binaryMessenger, @NonNull String messageChannelSuffix, @Nullable TXFlutterSuperPlayerPluginAPI api) {
      messageChannelSuffix = messageChannelSuffix.isEmpty() ? "" : "." + messageChannelSuffix;
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.getPlatformVersion" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                try {
                  StringMsg output = api.getPlatformVersion();
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.createVodPlayer" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Boolean onlyAudioArg = (Boolean) args.get(0);
                try {
                  PlayerMsg output = api.createVodPlayer(onlyAudioArg);
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.createLivePlayer" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Boolean onlyAudioArg = (Boolean) args.get(0);
                try {
                  PlayerMsg output = api.createLivePlayer(onlyAudioArg);
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.setConsoleEnabled" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                BoolMsg enabledArg = (BoolMsg) args.get(0);
                try {
                  api.setConsoleEnabled(enabledArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.releasePlayer" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                PlayerMsg playerIdArg = (PlayerMsg) args.get(0);
                try {
                  api.releasePlayer(playerIdArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.setGlobalMaxCacheSize" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                IntMsg sizeArg = (IntMsg) args.get(0);
                try {
                  api.setGlobalMaxCacheSize(sizeArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.setGlobalCacheFolderPath" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                StringMsg postfixPathArg = (StringMsg) args.get(0);
                try {
                  BoolMsg output = api.setGlobalCacheFolderPath(postfixPathArg);
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.setGlobalCacheFolderCustomPath" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                CachePathMsg cacheMsgArg = (CachePathMsg) args.get(0);
                try {
                  BoolMsg output = api.setGlobalCacheFolderCustomPath(cacheMsgArg);
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.setGlobalLicense" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                LicenseMsg licenseMsgArg = (LicenseMsg) args.get(0);
                try {
                  api.setGlobalLicense(licenseMsgArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.setLogLevel" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                IntMsg logLevelArg = (IntMsg) args.get(0);
                try {
                  api.setLogLevel(logLevelArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.getLiteAVSDKVersion" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                try {
                  StringMsg output = api.getLiteAVSDKVersion();
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.setGlobalEnv" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                StringMsg envConfigArg = (StringMsg) args.get(0);
                try {
                  IntMsg output = api.setGlobalEnv(envConfigArg);
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.startVideoOrientationService" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                try {
                  BoolMsg output = api.startVideoOrientationService();
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.setUserId" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                StringMsg msgArg = (StringMsg) args.get(0);
                try {
                  api.setUserId(msgArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.setLicenseFlexibleValid" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                BoolMsg msgArg = (BoolMsg) args.get(0);
                try {
                  api.setLicenseFlexibleValid(msgArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterSuperPlayerPluginAPI.setDrmProvisionEnv" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Long envArg = (Long) args.get(0);
                try {
                  api.setDrmProvisionEnv(envArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface TXFlutterNativeAPI {
    /** 修改当前界面亮度 */
    void setBrightness(@NonNull DoubleMsg brightness);
    /** 恢复当前界面亮度 */
    void restorePageBrightness();
    /** 获得当前界面亮度 0.0 ~ 1.0 */
    @NonNull 
    DoubleMsg getBrightness();
    /** 获取系统界面亮度，IOS系统与界面亮度一致，安卓可能会有差异 */
    @NonNull 
    DoubleMsg getSysBrightness();
    /** 设置当前系统音量，0.0 ~ 1.0 */
    void setSystemVolume(@NonNull DoubleMsg volume);
    /** 获得当前系统音量，范围：0.0 ~ 1.0 */
    @NonNull 
    DoubleMsg getSystemVolume();
    /** 释放音频焦点，只用于安卓端 */
    void abandonAudioFocus();
    /** 请求获得音频焦点，只用于安卓端 */
    void requestAudioFocus();
    /**
     * 当前设备是否支持画中画模式
     * @return [TXVodPlayEvent]
     *  0 可开启画中画模式
     *  -101  android版本过低
     *  -102  画中画权限关闭/设备不支持画中画
     *  -103  当前界面已销毁
     */
    @NonNull 
    IntMsg isDeviceSupportPip();
    /**
     *
     * register or unregister system brightness
     *
     */
    void registerSysBrightness(@NonNull BoolMsg isRegister);

    /** The codec used by TXFlutterNativeAPI. */
    static @NonNull MessageCodec<Object> getCodec() {
      return PigeonCodec.INSTANCE;
    }
    /**Sets up an instance of `TXFlutterNativeAPI` to handle messages through the `binaryMessenger`. */
    static void setUp(@NonNull BinaryMessenger binaryMessenger, @Nullable TXFlutterNativeAPI api) {
      setUp(binaryMessenger, "", api);
    }
    static void setUp(@NonNull BinaryMessenger binaryMessenger, @NonNull String messageChannelSuffix, @Nullable TXFlutterNativeAPI api) {
      messageChannelSuffix = messageChannelSuffix.isEmpty() ? "" : "." + messageChannelSuffix;
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterNativeAPI.setBrightness" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                DoubleMsg brightnessArg = (DoubleMsg) args.get(0);
                try {
                  api.setBrightness(brightnessArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterNativeAPI.restorePageBrightness" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                try {
                  api.restorePageBrightness();
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterNativeAPI.getBrightness" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                try {
                  DoubleMsg output = api.getBrightness();
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterNativeAPI.getSysBrightness" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                try {
                  DoubleMsg output = api.getSysBrightness();
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterNativeAPI.setSystemVolume" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                DoubleMsg volumeArg = (DoubleMsg) args.get(0);
                try {
                  api.setSystemVolume(volumeArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterNativeAPI.getSystemVolume" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                try {
                  DoubleMsg output = api.getSystemVolume();
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterNativeAPI.abandonAudioFocus" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                try {
                  api.abandonAudioFocus();
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterNativeAPI.requestAudioFocus" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                try {
                  api.requestAudioFocus();
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterNativeAPI.isDeviceSupportPip" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                try {
                  IntMsg output = api.isDeviceSupportPip();
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterNativeAPI.registerSysBrightness" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                BoolMsg isRegisterArg = (BoolMsg) args.get(0);
                try {
                  api.registerSysBrightness(isRegisterArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface TXFlutterVodPlayerApi {
    /**
     * 播放器初始化，创建共享纹理、初始化播放器
     *
     * To initialize the player, you would need to create a shared texture and initialize the player.
     * @param onlyAudio 是否是纯音频模式 if pure audio mode
     */
    @NonNull 
    IntMsg initialize(@NonNull BoolPlayerMsg onlyAudio);
    /**
     * 通过url开始播放视频
     * 10.7版本开始，startPlay变更为startVodPlay，需要通过 {@link SuperPlayerPlugin#setGlobalLicense} 设置 Licence 后方可成功播放，
     * 否则将播放失败（黑屏），全局仅设置一次即可。直播 Licence、短视频 Licence 和视频播放 Licence 均可使用，若您暂未获取上述 Licence ，
     * 可[快速免费申请测试版 Licence](https://cloud.tencent.com/act/event/License) 以正常播放，正式版 License 需[购买]
     * (https://cloud.tencent.com/document/product/881/74588#.E8.B4.AD.E4.B9.B0.E5.B9.B6.E6.96.B0.E5.BB.BA.E6.AD.A3.E5.BC.8F.E7.89.88-license)。
     *
     * Starting from version 10.7, the method `startPlay` has been changed to `startVodPlay` for playing videos via a URL.
     * To play videos successfully, it is necessary to set the license by using the method `SuperPlayerPlugin#setGlobalLicense`.
     * Failure to set the license will result in video playback failure (a black screen).
     * Live streaming, short video, and video playback licenses can all be used. If you do not have any of the above licenses,
     * you can apply for a free trial license to play videos normally[Quickly apply for a free trial version Licence]
     * (https://cloud.tencent.com/act/event/License).Official licenses can be purchased
     * (https://cloud.tencent.com/document/product/881/74588#.E8.B4.AD.E4.B9.B0.E5.B9.B6.E6.96.B0.E5.BB.BA.E6.AD.A3.E5.BC.8F.E7.89.88-license).
     * @param url : 视频播放地址 video playback address
     * return 是否播放成功 if play successfully
     */
    @NonNull 
    BoolMsg startVodPlay(@NonNull StringPlayerMsg url);
    /**
     * 通过fileId播放视频
     * 10.7版本开始，startPlayWithParams变更为startVodPlayWithParams，需要通过 {@link SuperPlayerPlugin#setGlobalLicense} 设置 Licence 后方可成功播放，
     * 否则将播放失败（黑屏），全局仅设置一次即可。直播 Licence、短视频 Licence 和视频播放 Licence 均可使用，若您暂未获取上述 Licence ，
     * 可[快速免费申请测试版 Licence](https://cloud.tencent.com/act/event/License) 以正常播放，正式版 License 需[购买]
     * (https://cloud.tencent.com/document/product/881/74588#.E8.B4.AD.E4.B9.B0.E5.B9.B6.E6.96.B0.E5.BB.BA.E6.AD.A3.E5.BC.8F.E7.89.88-license)。
     *
     * Starting from version 10.7, the method "startPlayWithParams" has been changed to "startVodPlayWithParams" for playing videos using fileId.
     * To play the video successfully, you need to set the Licence using "SuperPlayerPlugin#setGlobalLicense" method before playing the video.
     * If you do not set the Licence, the video will not play (black screen). The Licence for live streaming,
     * short video, and video playback can all be used. If you have not obtained the Licence, you can apply for a free trial version [here]
     * (https://cloud.tencent.com/act/event/License) for normal playback. To use the official version, you need to [purchase]
     * (https://cloud.tencent.com/document/product/881/74588#.E8.B4.AD.E4.B9.B0.E5.B9.B6.E6.96.B0.E5.BB.BA.E6.AD.A3.E5.BC.8F.E7.89.88-license).
     * @params : see[TXPlayInfoParams]
     * return 是否播放成功  if play successful
     */
    void startVodPlayWithParams(@NonNull TXPlayInfoParamsPlayerMsg params);
    /**
     * 播放 DRM 加密视频
     *
     * Playing DRM-encrypted video.
     */
    @NonNull 
    IntMsg startPlayDrm(@NonNull TXPlayerDrmMsg params);
    /**
     * 设置是否自动播放
     *
     * set autoplay
     */
    void setAutoPlay(@NonNull BoolPlayerMsg isAutoPlay);
    /**
     * 停止播放
     *
     * Stop playback
     * return 是否停止成功 if stop successful
     */
    @NonNull 
    BoolMsg stop(@NonNull BoolPlayerMsg isNeedClear);
    /**
     * 视频是否处于正在播放中
     *
     * Is the video currently playing
     */
    @NonNull 
    BoolMsg isPlaying(@NonNull PlayerMsg playerMsg);
    /**
     * 视频暂停，必须在播放器开始播放的时候调用
     *
     * pause video, it must be called when the player starts playing
     */
    void pause(@NonNull PlayerMsg playerMsg);
    /**
     * 继续播放，在暂停的时候调用
     *
     * resume playback, it should be called when the video is paused
     */
    void resume(@NonNull PlayerMsg playerMsg);
    /**
     * 设置是否静音
     *
     * Set whether to mute or not
     */
    void setMute(@NonNull BoolPlayerMsg mute);
    /**
     * 设置是否循环播放
     *
     * Set whether to loop playback or not
     */
    void setLoop(@NonNull BoolPlayerMsg loop);
    /**
     * 将视频播放进度定位到指定的进度进行播放
     *
     * Set the video playback progress to a specific time and start playing.
     * progress 要定位的视频时间，单位 秒 The video playback time to be located, in seconds
     */
    void seek(@NonNull DoublePlayerMsg progress);
    /**
     * 跳转到视频流指定PDT时间点, 可实现视频快进,快退,进度条跳转等功能
     * 单位毫秒(ms)
     * 播放器高级版 11.6 版本开始支持
     *
     * Jump to the specified PDT time point of the video stream, which can realize video fast forward, fast rewind, progress bar jump and other functions.
     * Unit millisecond (ms)
     * Player Premium version 11.6 starts to support
     */
    void seekToPdtTime(@NonNull IntPlayerMsg pdtTimeMs);
    /**
     * 设置播放速率，默认速率 1
     *
     * Set the playback speed, with a default speed of 1.
     */
    void setRate(@NonNull DoublePlayerMsg rate);
    /**
     * 获得播放视频解析出来的码率信息
     *
     * get the bitrate information extracted from playing a video
     * return List<Map>
     * Bitrate：index 码率序号，
     *         width 码率对应视频宽度，
     *         height 码率对应视频高度,
     *         bitrate 码率值
     *
     * Bitrate：index:bitrate index，
     *         width:the video with of this bitrate，
     *         height:the video height of this bitrate,
     *         bitrate:bitrate value
     */
    @NonNull 
    ListMsg getSupportedBitrate(@NonNull PlayerMsg playerMsg);
    /**
     * 获得当前设置的码率序号
     *
     * Get the index of the current bitrate setting
     */
    @NonNull 
    IntMsg getBitrateIndex(@NonNull PlayerMsg playerMsg);
    /**
     * 设置码率序号
     *
     * Set the index of the bitrate setting.
     */
    void setBitrateIndex(@NonNull IntPlayerMsg index);
    /**
     * 设置视频播放开始时间，单位 秒
     *
     * Set the start time of the video playback, in seconds.
     */
    void setStartTime(@NonNull DoublePlayerMsg startTime);
    /**
     * 设置视频声音 0~100
     *
     * Set the volume of the video, ranging from 0 to 100.
     */
    void setAudioPlayOutVolume(@NonNull IntPlayerMsg volume);
    /**
     * 请求获得音频焦点
     *
     * Request audio focus.
     */
    @NonNull 
    BoolMsg setRequestAudioFocus(@NonNull BoolPlayerMsg focus);
    /**
     * 设置播放器配置
     *
     * Set player configuration
     * config @see [FTXVodPlayConfig]
     */
    void setConfig(@NonNull FTXVodPlayConfigPlayerMsg config);
    /**
     * 获得当前已经播放的时间，单位 秒
     *
     * Get the current playback time, in seconds.
     */
    @NonNull 
    DoubleMsg getCurrentPlaybackTime(@NonNull PlayerMsg playerMsg);
    /**
     * 获得当前视频已缓存的时间
     *
     * Get the current amount of video that has been buffered.
     */
    @NonNull 
    DoubleMsg getBufferDuration(@NonNull PlayerMsg playerMsg);
    /**
     * 获得当前视频的可播放时间
     *
     * Get the current playable duration of the video.
     */
    @NonNull 
    DoubleMsg getPlayableDuration(@NonNull PlayerMsg playerMsg);
    /**
     * 获得当前播放视频的宽度
     *
     * Get the width of the currently playing video.
     */
    @NonNull 
    IntMsg getWidth(@NonNull PlayerMsg playerMsg);
    /**
     * 获得当前播放视频的高度
     *
     * Get the height of the currently playing video.
     */
    @NonNull 
    IntMsg getHeight(@NonNull PlayerMsg playerMsg);
    /**
     * 设置播放视频的token
     *
     * Set the token for playing the video.
     */
    void setToken(@NonNull StringPlayerMsg token);
    /**
     * 当前播放的视频是否循环播放
     *
     * Is the currently playing video set to loop
     */
    @NonNull 
    BoolMsg isLoop(@NonNull PlayerMsg playerMsg);
    /**
     * 开启/关闭硬件编码
     *
     * Enable/Disable hardware encoding.
     */
    @NonNull 
    BoolMsg enableHardwareDecode(@NonNull BoolPlayerMsg enable);
    /**
     * 进入画中画模式，进入画中画模式，需要适配画中画模式的界面，安卓只支持7.0以上机型
     * <h1>
     * 由于android系统限制，传递的图标大小不得超过1M，否则无法显示
     * </h1>
     * @param backIcon playIcon pauseIcon forwardIcon 为播放后退、播放、暂停、前进的图标，如果赋值的话，将会使用传递的图标，否则
     * 使用系统默认图标，只支持flutter本地资源图片，传递的时候，与flutter使用图片资源一致，例如： images/back_icon.png
     */
    @NonNull 
    IntMsg enterPictureInPictureMode(@NonNull PipParamsPlayerMsg pipParamsMsg);
    /**
     * 退出画中画，如果该播放器处于画中画模式
     *
     * Exit picture-in-picture mode if the video player is in picture-in-picture mode.
     */
    void exitPictureInPictureMode(@NonNull PlayerMsg playerMsg);

    void initImageSprite(@NonNull StringListPlayerMsg spriteInfo);

    @NonNull 
    UInt8ListMsg getImageSprite(@NonNull DoublePlayerMsg time);
    /**
     * 获取总时长
     *
     * To get the total duration
     */
    @NonNull 
    DoubleMsg getDuration(@NonNull PlayerMsg playerMsg);

    void addSubtitleSource(@NonNull SubTitlePlayerMsg playerMsg);

    @NonNull 
    ListMsg getSubtitleTrackInfo(@NonNull PlayerMsg playerMsg);

    @NonNull 
    ListMsg getAudioTrackInfo(@NonNull PlayerMsg playerMsg);

    void selectTrack(@NonNull IntPlayerMsg playerMsg);

    void deselectTrack(@NonNull IntPlayerMsg playerMsg);

    void setSubtitleStyle(@NonNull SubTitleRenderModelPlayerMsg playerMsg);

    void setStringOption(@NonNull StringOptionPlayerMsg playerMsg);

    void setPlayerView(@NonNull Long renderViewId);

    void setRenderMode(@NonNull Long renderMode);

    void reDraw();

    /** The codec used by TXFlutterVodPlayerApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return PigeonCodec.INSTANCE;
    }
    /**Sets up an instance of `TXFlutterVodPlayerApi` to handle messages through the `binaryMessenger`. */
    static void setUp(@NonNull BinaryMessenger binaryMessenger, @Nullable TXFlutterVodPlayerApi api) {
      setUp(binaryMessenger, "", api);
    }
    static void setUp(@NonNull BinaryMessenger binaryMessenger, @NonNull String messageChannelSuffix, @Nullable TXFlutterVodPlayerApi api) {
      messageChannelSuffix = messageChannelSuffix.isEmpty() ? "" : "." + messageChannelSuffix;
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.initialize" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                BoolPlayerMsg onlyAudioArg = (BoolPlayerMsg) args.get(0);
                try {
                  IntMsg output = api.initialize(onlyAudioArg);
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.startVodPlay" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                StringPlayerMsg urlArg = (StringPlayerMsg) args.get(0);
                try {
                  BoolMsg output = api.startVodPlay(urlArg);
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.startVodPlayWithParams" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                TXPlayInfoParamsPlayerMsg paramsArg = (TXPlayInfoParamsPlayerMsg) args.get(0);
                try {
                  api.startVodPlayWithParams(paramsArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.startPlayDrm" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                TXPlayerDrmMsg paramsArg = (TXPlayerDrmMsg) args.get(0);
                try {
                  IntMsg output = api.startPlayDrm(paramsArg);
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.setAutoPlay" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                BoolPlayerMsg isAutoPlayArg = (BoolPlayerMsg) args.get(0);
                try {
                  api.setAutoPlay(isAutoPlayArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.stop" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                BoolPlayerMsg isNeedClearArg = (BoolPlayerMsg) args.get(0);
                try {
                  BoolMsg output = api.stop(isNeedClearArg);
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.isPlaying" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                try {
                  BoolMsg output = api.isPlaying(playerMsgArg);
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.pause" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                try {
                  api.pause(playerMsgArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.resume" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                try {
                  api.resume(playerMsgArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.setMute" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                BoolPlayerMsg muteArg = (BoolPlayerMsg) args.get(0);
                try {
                  api.setMute(muteArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.setLoop" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                BoolPlayerMsg loopArg = (BoolPlayerMsg) args.get(0);
                try {
                  api.setLoop(loopArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.seek" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                DoublePlayerMsg progressArg = (DoublePlayerMsg) args.get(0);
                try {
                  api.seek(progressArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.seekToPdtTime" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                IntPlayerMsg pdtTimeMsArg = (IntPlayerMsg) args.get(0);
                try {
                  api.seekToPdtTime(pdtTimeMsArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.setRate" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                DoublePlayerMsg rateArg = (DoublePlayerMsg) args.get(0);
                try {
                  api.setRate(rateArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.getSupportedBitrate" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                try {
                  ListMsg output = api.getSupportedBitrate(playerMsgArg);
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.getBitrateIndex" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                try {
                  IntMsg output = api.getBitrateIndex(playerMsgArg);
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.setBitrateIndex" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                IntPlayerMsg indexArg = (IntPlayerMsg) args.get(0);
                try {
                  api.setBitrateIndex(indexArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.setStartTime" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                DoublePlayerMsg startTimeArg = (DoublePlayerMsg) args.get(0);
                try {
                  api.setStartTime(startTimeArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.setAudioPlayOutVolume" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                IntPlayerMsg volumeArg = (IntPlayerMsg) args.get(0);
                try {
                  api.setAudioPlayOutVolume(volumeArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.setRequestAudioFocus" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                BoolPlayerMsg focusArg = (BoolPlayerMsg) args.get(0);
                try {
                  BoolMsg output = api.setRequestAudioFocus(focusArg);
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.setConfig" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                FTXVodPlayConfigPlayerMsg configArg = (FTXVodPlayConfigPlayerMsg) args.get(0);
                try {
                  api.setConfig(configArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.getCurrentPlaybackTime" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                try {
                  DoubleMsg output = api.getCurrentPlaybackTime(playerMsgArg);
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.getBufferDuration" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                try {
                  DoubleMsg output = api.getBufferDuration(playerMsgArg);
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.getPlayableDuration" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                try {
                  DoubleMsg output = api.getPlayableDuration(playerMsgArg);
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.getWidth" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                try {
                  IntMsg output = api.getWidth(playerMsgArg);
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.getHeight" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                try {
                  IntMsg output = api.getHeight(playerMsgArg);
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.setToken" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                StringPlayerMsg tokenArg = (StringPlayerMsg) args.get(0);
                try {
                  api.setToken(tokenArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.isLoop" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                try {
                  BoolMsg output = api.isLoop(playerMsgArg);
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.enableHardwareDecode" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                BoolPlayerMsg enableArg = (BoolPlayerMsg) args.get(0);
                try {
                  BoolMsg output = api.enableHardwareDecode(enableArg);
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.enterPictureInPictureMode" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                PipParamsPlayerMsg pipParamsMsgArg = (PipParamsPlayerMsg) args.get(0);
                try {
                  IntMsg output = api.enterPictureInPictureMode(pipParamsMsgArg);
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.exitPictureInPictureMode" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                try {
                  api.exitPictureInPictureMode(playerMsgArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.initImageSprite" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                StringListPlayerMsg spriteInfoArg = (StringListPlayerMsg) args.get(0);
                try {
                  api.initImageSprite(spriteInfoArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.getImageSprite" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                DoublePlayerMsg timeArg = (DoublePlayerMsg) args.get(0);
                try {
                  UInt8ListMsg output = api.getImageSprite(timeArg);
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.getDuration" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                try {
                  DoubleMsg output = api.getDuration(playerMsgArg);
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.addSubtitleSource" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                SubTitlePlayerMsg playerMsgArg = (SubTitlePlayerMsg) args.get(0);
                try {
                  api.addSubtitleSource(playerMsgArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.getSubtitleTrackInfo" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                try {
                  ListMsg output = api.getSubtitleTrackInfo(playerMsgArg);
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.getAudioTrackInfo" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                try {
                  ListMsg output = api.getAudioTrackInfo(playerMsgArg);
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.selectTrack" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                IntPlayerMsg playerMsgArg = (IntPlayerMsg) args.get(0);
                try {
                  api.selectTrack(playerMsgArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.deselectTrack" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                IntPlayerMsg playerMsgArg = (IntPlayerMsg) args.get(0);
                try {
                  api.deselectTrack(playerMsgArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.setSubtitleStyle" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                SubTitleRenderModelPlayerMsg playerMsgArg = (SubTitleRenderModelPlayerMsg) args.get(0);
                try {
                  api.setSubtitleStyle(playerMsgArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.setStringOption" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                StringOptionPlayerMsg playerMsgArg = (StringOptionPlayerMsg) args.get(0);
                try {
                  api.setStringOption(playerMsgArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.setPlayerView" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Long renderViewIdArg = (Long) args.get(0);
                try {
                  api.setPlayerView(renderViewIdArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.setRenderMode" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Long renderModeArg = (Long) args.get(0);
                try {
                  api.setRenderMode(renderModeArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterVodPlayerApi.reDraw" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                try {
                  api.reDraw();
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface TXFlutterLivePlayerApi {
    /**
     * 播放器初始化，创建共享纹理、初始化播放器
     * @param onlyAudio 是否是纯音频模式
     */
    @NonNull 
    IntMsg initialize(@NonNull BoolPlayerMsg onlyAudio);
    /**
     *
     * 当设置[LivePlayer] 类型播放器时
     * 10.7版本开始，startPlay变更为startLivePlay，需要通过 {@link SuperPlayerPlugin#setGlobalLicense} 设置 Licence 后方可成功播放，
     * 否则将播放失败（黑屏），全局仅设置一次即可。直播 Licence、短视频 Licence 和视频播放 Licence 均可使用，若您暂未获取上述 Licence ，
     * 可[快速免费申请测试版 Licence](https://cloud.tencent.com/act/event/License) 以正常播放，正式版 License 需[购买]
     * (https://cloud.tencent.com/document/product/881/74588#.E8.B4.AD.E4.B9.B0.E5.B9.B6.E6.96.B0.E5.BB.BA.E6.AD.A3.E5.BC.8F.E7.89.88-license)。
     */
    @NonNull 
    BoolMsg startLivePlay(@NonNull StringPlayerMsg playerMsg);
    /**
     * 停止播放
     * return 是否停止成功
     */
    @NonNull 
    BoolMsg stop(@NonNull BoolPlayerMsg isNeedClear);
    /** 视频是否处于正在播放中 */
    @NonNull 
    BoolMsg isPlaying(@NonNull PlayerMsg playerMsg);
    /** 视频暂停，必须在播放器开始播放的时候调用 */
    void pause(@NonNull PlayerMsg playerMsg);
    /** 继续播放，在暂停的时候调用 */
    void resume(@NonNull PlayerMsg playerMsg);
    /** 设置直播模式，see TXPlayerLiveMode */
    void setLiveMode(@NonNull IntPlayerMsg mode);
    /** 设置视频声音 0~100 */
    void setVolume(@NonNull IntPlayerMsg volume);
    /** 设置是否静音 */
    void setMute(@NonNull BoolPlayerMsg mute);
    /** 切换播放流 */
    @NonNull 
    IntMsg switchStream(@NonNull StringPlayerMsg url);
    /** 设置appId */
    void setAppID(@NonNull StringPlayerMsg appId);
    /**
     * 设置播放器配置
     * config @see [FTXLivePlayConfig]
     */
    void setConfig(@NonNull FTXLivePlayConfigPlayerMsg config);
    /** 开启/关闭硬件编码 */
    @NonNull 
    BoolMsg enableHardwareDecode(@NonNull BoolPlayerMsg enable);
    /**
     * 进入画中画模式，进入画中画模式，需要适配画中画模式的界面，安卓只支持7.0以上机型
     * <h1>
     * 由于android系统限制，传递的图标大小不得超过1M，否则无法显示
     * </h1>
     * @param backIcon playIcon pauseIcon forwardIcon 为播放后退、播放、暂停、前进的图标，仅适用于android，如果赋值的话，将会使用传递的图标，否则
     * 使用系统默认图标，只支持flutter本地资源图片，传递的时候，与flutter使用图片资源一致，例如： images/back_icon.png
     */
    @NonNull 
    IntMsg enterPictureInPictureMode(@NonNull PipParamsPlayerMsg pipParamsMsg);
    /** 退出画中画，如果该播放器处于画中画模式 */
    void exitPictureInPictureMode(@NonNull PlayerMsg playerMsg);

    @NonNull 
    Long enableReceiveSeiMessage(@NonNull PlayerMsg playerMsg, @NonNull Boolean isEnabled, @NonNull Long payloadType);

    void showDebugView(@NonNull PlayerMsg playerMsg, @NonNull Boolean isShow);

    @NonNull 
    Long setProperty(@NonNull PlayerMsg playerMsg, @NonNull String key, @NonNull Object value);

    @NonNull 
    ListMsg getSupportedBitrate(@NonNull PlayerMsg playerMsg);

    @NonNull 
    Long setCacheParams(@NonNull PlayerMsg playerMsg, @NonNull Double minTime, @NonNull Double maxTime);

    @NonNull 
    Long enablePictureInPicture(@NonNull BoolPlayerMsg msg);

    void setPlayerView(@NonNull Long renderViewId);

    void setRenderMode(@NonNull Long renderMode);

    /** The codec used by TXFlutterLivePlayerApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return PigeonCodec.INSTANCE;
    }
    /**Sets up an instance of `TXFlutterLivePlayerApi` to handle messages through the `binaryMessenger`. */
    static void setUp(@NonNull BinaryMessenger binaryMessenger, @Nullable TXFlutterLivePlayerApi api) {
      setUp(binaryMessenger, "", api);
    }
    static void setUp(@NonNull BinaryMessenger binaryMessenger, @NonNull String messageChannelSuffix, @Nullable TXFlutterLivePlayerApi api) {
      messageChannelSuffix = messageChannelSuffix.isEmpty() ? "" : "." + messageChannelSuffix;
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.initialize" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                BoolPlayerMsg onlyAudioArg = (BoolPlayerMsg) args.get(0);
                try {
                  IntMsg output = api.initialize(onlyAudioArg);
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.startLivePlay" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                StringPlayerMsg playerMsgArg = (StringPlayerMsg) args.get(0);
                try {
                  BoolMsg output = api.startLivePlay(playerMsgArg);
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.stop" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                BoolPlayerMsg isNeedClearArg = (BoolPlayerMsg) args.get(0);
                try {
                  BoolMsg output = api.stop(isNeedClearArg);
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.isPlaying" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                try {
                  BoolMsg output = api.isPlaying(playerMsgArg);
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.pause" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                try {
                  api.pause(playerMsgArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.resume" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                try {
                  api.resume(playerMsgArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.setLiveMode" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                IntPlayerMsg modeArg = (IntPlayerMsg) args.get(0);
                try {
                  api.setLiveMode(modeArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.setVolume" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                IntPlayerMsg volumeArg = (IntPlayerMsg) args.get(0);
                try {
                  api.setVolume(volumeArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.setMute" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                BoolPlayerMsg muteArg = (BoolPlayerMsg) args.get(0);
                try {
                  api.setMute(muteArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.switchStream" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                StringPlayerMsg urlArg = (StringPlayerMsg) args.get(0);
                try {
                  IntMsg output = api.switchStream(urlArg);
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.setAppID" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                StringPlayerMsg appIdArg = (StringPlayerMsg) args.get(0);
                try {
                  api.setAppID(appIdArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.setConfig" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                FTXLivePlayConfigPlayerMsg configArg = (FTXLivePlayConfigPlayerMsg) args.get(0);
                try {
                  api.setConfig(configArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.enableHardwareDecode" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                BoolPlayerMsg enableArg = (BoolPlayerMsg) args.get(0);
                try {
                  BoolMsg output = api.enableHardwareDecode(enableArg);
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.enterPictureInPictureMode" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                PipParamsPlayerMsg pipParamsMsgArg = (PipParamsPlayerMsg) args.get(0);
                try {
                  IntMsg output = api.enterPictureInPictureMode(pipParamsMsgArg);
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.exitPictureInPictureMode" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                try {
                  api.exitPictureInPictureMode(playerMsgArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.enableReceiveSeiMessage" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                Boolean isEnabledArg = (Boolean) args.get(1);
                Long payloadTypeArg = (Long) args.get(2);
                try {
                  Long output = api.enableReceiveSeiMessage(playerMsgArg, isEnabledArg, payloadTypeArg);
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.showDebugView" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                Boolean isShowArg = (Boolean) args.get(1);
                try {
                  api.showDebugView(playerMsgArg, isShowArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.setProperty" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                String keyArg = (String) args.get(1);
                Object valueArg = args.get(2);
                try {
                  Long output = api.setProperty(playerMsgArg, keyArg, valueArg);
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.getSupportedBitrate" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                try {
                  ListMsg output = api.getSupportedBitrate(playerMsgArg);
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.setCacheParams" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                PlayerMsg playerMsgArg = (PlayerMsg) args.get(0);
                Double minTimeArg = (Double) args.get(1);
                Double maxTimeArg = (Double) args.get(2);
                try {
                  Long output = api.setCacheParams(playerMsgArg, minTimeArg, maxTimeArg);
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.enablePictureInPicture" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                BoolPlayerMsg msgArg = (BoolPlayerMsg) args.get(0);
                try {
                  Long output = api.enablePictureInPicture(msgArg);
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.setPlayerView" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Long renderViewIdArg = (Long) args.get(0);
                try {
                  api.setPlayerView(renderViewIdArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterLivePlayerApi.setRenderMode" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                Long renderModeArg = (Long) args.get(0);
                try {
                  api.setRenderMode(renderModeArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /** Generated interface from Pigeon that represents a handler of messages from Flutter. */
  public interface TXFlutterDownloadApi {
    /**
     * 启动预下载。
     * playUrl: 要预下载的url
     * preloadSizeMB: 预下载的大小（单位：MB）
     * preferredResolution 期望分辨率，long类型，值为高x宽。可参考如720*1080。不支持多分辨率或不需指定时，传-1。
     * 返回值：任务ID，可用这个任务ID停止预下载 [stopPreload]
     */
    @NonNull 
    IntMsg startPreLoad(@NonNull PreLoadMsg msg);

    void startPreLoadByParams(@NonNull PreLoadInfoMsg msg);
    /**
     * 停止预下载。
     * taskId： 任务id
     */
    void stopPreLoad(@NonNull IntMsg msg);
    /**
     * 开始下载
     * videoDownloadModel: 下载构造体
     */
    void startDownload(@NonNull TXVodDownloadMediaMsg msg);
    /**
     * 继续下载，与开始下载接口有区别，该接口会寻找对应的缓存，复用之前的缓存来续点下载，
     * 而开始下载接口会启动一个全新的下载
     * videoDownloadModel: 下载构造体
     */
    void resumeDownload(@NonNull TXVodDownloadMediaMsg msg);
    /**
     * 停止下载
     * videoDownloadModel: 下载构造体
     */
    void stopDownload(@NonNull TXVodDownloadMediaMsg msg);
    /** 设置下载请求头 */
    void setDownloadHeaders(@NonNull MapMsg headers);
    /** 获取所有视频下载列表 */
    @NonNull 
    TXDownloadListMsg getDownloadList();
    /** 获得指定视频的下载信息 */
    @NonNull 
    TXVodDownloadMediaMsg getDownloadInfo(@NonNull TXVodDownloadMediaMsg msg);
    /** 删除下载任务 */
    @NonNull 
    BoolMsg deleteDownloadMediaInfo(@NonNull TXVodDownloadMediaMsg msg);

    /** The codec used by TXFlutterDownloadApi. */
    static @NonNull MessageCodec<Object> getCodec() {
      return PigeonCodec.INSTANCE;
    }
    /**Sets up an instance of `TXFlutterDownloadApi` to handle messages through the `binaryMessenger`. */
    static void setUp(@NonNull BinaryMessenger binaryMessenger, @Nullable TXFlutterDownloadApi api) {
      setUp(binaryMessenger, "", api);
    }
    static void setUp(@NonNull BinaryMessenger binaryMessenger, @NonNull String messageChannelSuffix, @Nullable TXFlutterDownloadApi api) {
      messageChannelSuffix = messageChannelSuffix.isEmpty() ? "" : "." + messageChannelSuffix;
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterDownloadApi.startPreLoad" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                PreLoadMsg msgArg = (PreLoadMsg) args.get(0);
                try {
                  IntMsg output = api.startPreLoad(msgArg);
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterDownloadApi.startPreLoadByParams" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                PreLoadInfoMsg msgArg = (PreLoadInfoMsg) args.get(0);
                try {
                  api.startPreLoadByParams(msgArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterDownloadApi.stopPreLoad" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                IntMsg msgArg = (IntMsg) args.get(0);
                try {
                  api.stopPreLoad(msgArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterDownloadApi.startDownload" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                TXVodDownloadMediaMsg msgArg = (TXVodDownloadMediaMsg) args.get(0);
                try {
                  api.startDownload(msgArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterDownloadApi.resumeDownload" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                TXVodDownloadMediaMsg msgArg = (TXVodDownloadMediaMsg) args.get(0);
                try {
                  api.resumeDownload(msgArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterDownloadApi.stopDownload" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                TXVodDownloadMediaMsg msgArg = (TXVodDownloadMediaMsg) args.get(0);
                try {
                  api.stopDownload(msgArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterDownloadApi.setDownloadHeaders" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                MapMsg headersArg = (MapMsg) args.get(0);
                try {
                  api.setDownloadHeaders(headersArg);
                  wrapped.add(0, null);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterDownloadApi.getDownloadList" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                try {
                  TXDownloadListMsg output = api.getDownloadList();
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterDownloadApi.getDownloadInfo" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                TXVodDownloadMediaMsg msgArg = (TXVodDownloadMediaMsg) args.get(0);
                try {
                  TXVodDownloadMediaMsg output = api.getDownloadInfo(msgArg);
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
      {
        BasicMessageChannel<Object> channel =
            new BasicMessageChannel<>(
                binaryMessenger, "dev.flutter.pigeon.super_player.TXFlutterDownloadApi.deleteDownloadMediaInfo" + messageChannelSuffix, getCodec());
        if (api != null) {
          channel.setMessageHandler(
              (message, reply) -> {
                ArrayList<Object> wrapped = new ArrayList<>();
                ArrayList<Object> args = (ArrayList<Object>) message;
                TXVodDownloadMediaMsg msgArg = (TXVodDownloadMediaMsg) args.get(0);
                try {
                  BoolMsg output = api.deleteDownloadMediaInfo(msgArg);
                  wrapped.add(0, output);
                }
 catch (Throwable exception) {
                  wrapped = wrapError(exception);
                }
                reply.reply(wrapped);
              });
        } else {
          channel.setMessageHandler(null);
        }
      }
    }
  }
  /** Generated class from Pigeon that represents Flutter messages that can be called from Java. */
  public static class TXDownloadFlutterAPI {
    private final @NonNull BinaryMessenger binaryMessenger;
    private final String messageChannelSuffix;

    public TXDownloadFlutterAPI(@NonNull BinaryMessenger argBinaryMessenger) {
      this(argBinaryMessenger, "");
    }
    public TXDownloadFlutterAPI(@NonNull BinaryMessenger argBinaryMessenger, @NonNull String messageChannelSuffix) {
      this.binaryMessenger = argBinaryMessenger;
      this.messageChannelSuffix = messageChannelSuffix.isEmpty() ? "" : "." + messageChannelSuffix;
    }

    /**
     * Public interface for sending reply.
     * The codec used by TXDownloadFlutterAPI.
     */
    static @NonNull MessageCodec<Object> getCodec() {
      return PigeonCodec.INSTANCE;
    }
    public void onDownloadEvent(@NonNull Map<String, Object> eventArg, @NonNull VoidResult result) {
      final String channelName = "dev.flutter.pigeon.super_player.TXDownloadFlutterAPI.onDownloadEvent" + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(eventArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(new FlutterError((String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else {
                result.success();
              }
            }  else {
              result.error(createConnectionError(channelName));
            } 
          });
    }
    public void onPreDownloadEvent(@NonNull Map<String, Object> eventArg, @NonNull VoidResult result) {
      final String channelName = "dev.flutter.pigeon.super_player.TXDownloadFlutterAPI.onPreDownloadEvent" + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(eventArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(new FlutterError((String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else {
                result.success();
              }
            }  else {
              result.error(createConnectionError(channelName));
            } 
          });
    }
  }
  /** Generated class from Pigeon that represents Flutter messages that can be called from Java. */
  public static class TXPluginFlutterAPI {
    private final @NonNull BinaryMessenger binaryMessenger;
    private final String messageChannelSuffix;

    public TXPluginFlutterAPI(@NonNull BinaryMessenger argBinaryMessenger) {
      this(argBinaryMessenger, "");
    }
    public TXPluginFlutterAPI(@NonNull BinaryMessenger argBinaryMessenger, @NonNull String messageChannelSuffix) {
      this.binaryMessenger = argBinaryMessenger;
      this.messageChannelSuffix = messageChannelSuffix.isEmpty() ? "" : "." + messageChannelSuffix;
    }

    /**
     * Public interface for sending reply.
     * The codec used by TXPluginFlutterAPI.
     */
    static @NonNull MessageCodec<Object> getCodec() {
      return PigeonCodec.INSTANCE;
    }
    public void onSDKListener(@NonNull Map<String, Object> eventArg, @NonNull VoidResult result) {
      final String channelName = "dev.flutter.pigeon.super_player.TXPluginFlutterAPI.onSDKListener" + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(eventArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(new FlutterError((String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else {
                result.success();
              }
            }  else {
              result.error(createConnectionError(channelName));
            } 
          });
    }
    public void onNativeEvent(@NonNull Map<String, Object> eventArg, @NonNull VoidResult result) {
      final String channelName = "dev.flutter.pigeon.super_player.TXPluginFlutterAPI.onNativeEvent" + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(eventArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(new FlutterError((String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else {
                result.success();
              }
            }  else {
              result.error(createConnectionError(channelName));
            } 
          });
    }
  }
  /** Generated class from Pigeon that represents Flutter messages that can be called from Java. */
  public static class TXPipFlutterAPI {
    private final @NonNull BinaryMessenger binaryMessenger;
    private final String messageChannelSuffix;

    public TXPipFlutterAPI(@NonNull BinaryMessenger argBinaryMessenger) {
      this(argBinaryMessenger, "");
    }
    public TXPipFlutterAPI(@NonNull BinaryMessenger argBinaryMessenger, @NonNull String messageChannelSuffix) {
      this.binaryMessenger = argBinaryMessenger;
      this.messageChannelSuffix = messageChannelSuffix.isEmpty() ? "" : "." + messageChannelSuffix;
    }

    /**
     * Public interface for sending reply.
     * The codec used by TXPipFlutterAPI.
     */
    static @NonNull MessageCodec<Object> getCodec() {
      return PigeonCodec.INSTANCE;
    }
    public void onPipEvent(@NonNull Map<String, Object> eventArg, @NonNull VoidResult result) {
      final String channelName = "dev.flutter.pigeon.super_player.TXPipFlutterAPI.onPipEvent" + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(eventArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(new FlutterError((String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else {
                result.success();
              }
            }  else {
              result.error(createConnectionError(channelName));
            } 
          });
    }
  }
  /** Generated class from Pigeon that represents Flutter messages that can be called from Java. */
  public static class TXVodPlayerFlutterAPI {
    private final @NonNull BinaryMessenger binaryMessenger;
    private final String messageChannelSuffix;

    public TXVodPlayerFlutterAPI(@NonNull BinaryMessenger argBinaryMessenger) {
      this(argBinaryMessenger, "");
    }
    public TXVodPlayerFlutterAPI(@NonNull BinaryMessenger argBinaryMessenger, @NonNull String messageChannelSuffix) {
      this.binaryMessenger = argBinaryMessenger;
      this.messageChannelSuffix = messageChannelSuffix.isEmpty() ? "" : "." + messageChannelSuffix;
    }

    /**
     * Public interface for sending reply.
     * The codec used by TXVodPlayerFlutterAPI.
     */
    static @NonNull MessageCodec<Object> getCodec() {
      return PigeonCodec.INSTANCE;
    }
    public void onPlayerEvent(@NonNull Map<String, Object> eventArg, @NonNull VoidResult result) {
      final String channelName = "dev.flutter.pigeon.super_player.TXVodPlayerFlutterAPI.onPlayerEvent" + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(eventArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(new FlutterError((String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else {
                result.success();
              }
            }  else {
              result.error(createConnectionError(channelName));
            } 
          });
    }
    public void onNetEvent(@NonNull Map<String, Object> eventArg, @NonNull VoidResult result) {
      final String channelName = "dev.flutter.pigeon.super_player.TXVodPlayerFlutterAPI.onNetEvent" + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(eventArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(new FlutterError((String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else {
                result.success();
              }
            }  else {
              result.error(createConnectionError(channelName));
            } 
          });
    }
  }
  /** Generated class from Pigeon that represents Flutter messages that can be called from Java. */
  public static class TXLivePlayerFlutterAPI {
    private final @NonNull BinaryMessenger binaryMessenger;
    private final String messageChannelSuffix;

    public TXLivePlayerFlutterAPI(@NonNull BinaryMessenger argBinaryMessenger) {
      this(argBinaryMessenger, "");
    }
    public TXLivePlayerFlutterAPI(@NonNull BinaryMessenger argBinaryMessenger, @NonNull String messageChannelSuffix) {
      this.binaryMessenger = argBinaryMessenger;
      this.messageChannelSuffix = messageChannelSuffix.isEmpty() ? "" : "." + messageChannelSuffix;
    }

    /**
     * Public interface for sending reply.
     * The codec used by TXLivePlayerFlutterAPI.
     */
    static @NonNull MessageCodec<Object> getCodec() {
      return PigeonCodec.INSTANCE;
    }
    public void onPlayerEvent(@NonNull Map<String, Object> eventArg, @NonNull VoidResult result) {
      final String channelName = "dev.flutter.pigeon.super_player.TXLivePlayerFlutterAPI.onPlayerEvent" + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(eventArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(new FlutterError((String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else {
                result.success();
              }
            }  else {
              result.error(createConnectionError(channelName));
            } 
          });
    }
    public void onNetEvent(@NonNull Map<String, Object> eventArg, @NonNull VoidResult result) {
      final String channelName = "dev.flutter.pigeon.super_player.TXLivePlayerFlutterAPI.onNetEvent" + messageChannelSuffix;
      BasicMessageChannel<Object> channel =
          new BasicMessageChannel<>(
              binaryMessenger, channelName, getCodec());
      channel.send(
          new ArrayList<>(Collections.singletonList(eventArg)),
          channelReply -> {
            if (channelReply instanceof List) {
              List<Object> listReply = (List<Object>) channelReply;
              if (listReply.size() > 1) {
                result.error(new FlutterError((String) listReply.get(0), (String) listReply.get(1), listReply.get(2)));
              } else {
                result.success();
              }
            }  else {
              result.error(createConnectionError(channelName));
            } 
          });
    }
  }
}
