import { App, PropertyEvent, UI } from 'leafer-editor'
import { assign } from './leafer.helper'

/**
 * 将元素的x,y,width,height属性进行四舍五入,确保没有小数点
 */
export class AdsorptionBinding {
  private _app!: App
  private _boundPropertyHandler!: (e: PropertyEvent) => void

  /**
   * 加载服务
   * @param app 容器
   * @param gridSize 网格尺寸
   */
  public install(app: App) {
    this._app = app
    this._boundPropertyHandler = this.onPropertyEvent.bind(this)
    //监听tree层图元更改事件
    this._app.tree.on(PropertyEvent.CHANGE, this._boundPropertyHandler)
  }

  /**
   * 卸载服务
   */
  public uninstall() {
    if (this._app?.tree && this._boundPropertyHandler) {
      this._app.tree.off(PropertyEvent.CHANGE, this._boundPropertyHandler)
    }
    this._boundPropertyHandler = null as any
    this._app = null as any
  }

  private onPropertyEvent(e: PropertyEvent) {
    //仅处理x,y,width,height属性更改事件
    if (e.attrName != 'x' && e.attrName != 'y' && e.attrName != 'width' && e.attrName != 'height') return

    //有时会有undefined的情况
    if (e.newValue == undefined || e.oldValue == undefined) return
    //仅处理新旧值不一致的对象
    if (e.newValue == e.oldValue) return
    let v: number
    let size: number = 1

    v = Math.round((e.newValue as number) / size) * size

    let o: UI = e.target as UI
    assign(o, e.attrName, v)
  }
}
