/*
 * @Author: zengzhe
 * @Date: 2025-08-18 18:53:16
 * @LastEditors: zengzhe
 * @LastEditTime: 2025-08-18 21:49:59
 * @Description: Leafer 配置常量
 */

import type { IRectInputData, IAppConfig } from 'leafer-editor'
import type { SnapConfig } from './plugins/snap/types'

/**
 * 主题配置
 */
export const DEFAULT_THEME = {
  backgroundColor: '#E8E8E9',
  stroke: '#31b8fc',
  hoverStroke: 'rgba(49, 184, 252, 0.2)',
  activeStroke: 'rgba(49, 184, 252, 0.05)',
  unSetDataStroke: '#FF9500',
  unSetDataHoverStroke: 'rgba(255, 149, 0, 0.2)',
  unSetDataActiveStroke: 'rgba(255, 149, 0, 0.05)'
}

/**
 * 默认 Leafer 应用配置
 */
export const DEFAULT_LEAFER_CONFIG: IAppConfig = {
  fill: DEFAULT_THEME.backgroundColor,
  tree: { type: 'design' as const },
  zoom: { min: 0.2, max: 3 },
  wheel: {
    zoomSpeed: 0.02
  },
  editor: {
    moveable: true,
    skewable: false,
    rotateable: false,
    boxSelect: false,
    multipleSelect: false,
    stroke: '#31b8fc',
    strokeWidth: 3,
    pointSize: 4
  },
  smooth: true,
  pixelSnap: true
}

/**
 * 默认吸附配置
 */
export const DEFAULT_SNAP_CONFIG: Partial<SnapConfig> = {
  lineColor: DEFAULT_THEME.stroke,
  snapSize: 8,
  showEqualSpacingBoxes: true,
  pointSize: 6
}

/**
 * 默认标尺配置
 */
export const DEFAULT_RULER_CONFIG = {
  unit: 'px' as const
}

/**
 * 默认矩形配置
 */
export const DEFAULT_RECT_CONFIG: Partial<IRectInputData> = {
  hitSelf: false,
  cursor: 'move',
  className: 'mark',
  stroke: DEFAULT_THEME.unSetDataStroke,
  strokeWidth: 2,
  editable: true,
  dragBounds: 'parent' as const
}

/**
 * Canvas 选择器
 */
export const CANVAS_SELECTOR = '#leafer-container'

/**
 * 最小矩形尺寸
 */
export const MIN_RECT_SIZE = 5
