# 单位转换

## 1.标注单位的转换


### 1.1 逻辑单位 (px - 像素)

**定义**: 逻辑单位是在数字环境中使用的抽象单位，通常指像素点(pixel)。

**特点**:
- 是Canvas绘图系统的基础单位
- 相对单位，其物理尺寸取决于显示设备的像素密度
- 在不同设备上显示的实际大小会有差异

### 1.2 物理单位 (mm/in - 毫米/英寸)

**定义**: 物理单位是现实世界中使用的标准长度单位，具有固定的物理尺寸。

**常用物理单位**:
- **毫米(mm)**: 最常用的物理单位
- **厘米(cm)**: 1cm = 10mm
- **英寸(in)**: 国际标准单位，1in = 25.4mm

**实际应用场景**:
- A5纸尺寸: 210mm × 148mm
- A4纸尺寸: 297mm × 210mm
- 照片打印尺寸: 6英寸 × 4英寸

### 1.3 像素密度 (PPI - Pixels Per Inch)

**定义**: PPI(Pixels Per Inch)表示每英寸长度内包含的像素点数量，是连接逻辑单位和物理单位的桥梁。

**计算公式**:
```
PPI = 像素总数 / 物理尺寸(英寸)
```
**PPI的意义**:
- PPI越高，显示效果越细腻
- 同样的物理尺寸，PPI越高的设备需要的像素点越多
- 是单位转换的核心参数

### 1.4 单位转换公式

**核心转换关系**:
```
1英寸(in) = 25.4毫米(mm)

像素数量 = 物理尺寸(英寸) × PPI
物理尺寸(英寸) = 像素数量 ÷ PPI
物理尺寸(毫米) = 像素数量 ÷ PPI × 25.4
```

## 2. 棒棒帮中的单位体系与转换

1. 棒棒帮内部使用的ppi是300
2. 标注系统中使用的单位是逻辑单位(px)
3. 智慧笔产生的单位是物理尺寸(mm)

### 2.1 标注单位到物理单位的转换公式
```js
/**
 * 将 px 坐标点转换为 mm 坐标点
 * @param point 坐标点
 * @param ppi ppi
 * @param mm 毫米
 * @returns
 */
export function processPxToMmPoint(point: IMarkPoint, ppi: number = 300, mm: number = 25.4): IMarkPoint {
  return {
    x: (point.x / ppi) * mm,
    y: (point.y / ppi) * mm
  }
}

/**
 * 将 mm 坐标点转换为 px 坐标点
 * @param {Object} point 坐标点
 * @param {number} ppi ppi
 * @param {number} mm 毫米
 * @returns {Object}
 */
export function processMmToPxPoint(point, ppi = 300, mm = 25.4) {
  return {
    x: (point.x * ppi) / mm,
    y: (point.y * ppi) / mm
  }
}
```