# Leafer Mark Core 项目架构

## 概述

Leafer Mark Core 是一个基于 Leafer 编辑器的智能标注系统，提供图片标注、矩形创建、拖拽操作、吸附对齐等功能。项目采用模块化设计，核心功能通过插件化方式实现。

## 核心文件结构

```
core/
├── index.ts                    # 主入口文件，LeaferAnnotate 核心类
├── leafer.type.ts             # 类型定义文件
├── leafer.config.ts           # 配置常量文件
├── leafer.helper.ts           # 工具函数集合
├── leafer.proxyData.ts        # 响应式数据代理
├── leafer.createRect.ts       # 矩形创建功能
├── leafer.drop.ts             # 拖拽功能
├── leafer.copyRect.ts         # 矩形复制功能
├── leafer.adsorption.ts       # 吸附对齐功能
└── plugins/                   # 插件目录
    └── snap/                  # 智能吸附插件
        ├── index.ts           # 吸附功能主模块
```

## 文件功能说明

### 核心模块

#### `index.ts` - 主入口文件

- **功能**: LeaferAnnotate 核心类，整个标注系统的主控制器
- **职责**:
  - 初始化 Leafer 应用和画布
  - 管理图片加载和标注数据
  - 协调各个功能模块
  - 提供模式切换（view/edit）
  - 管理插件生命周期

#### `leafer.type.ts` - 类型定义

- **功能**: 定义整个系统的 TypeScript 接口和类型
- **包含**:
  - `IMark`: 标注数据结构
  - `LeaferAnnotateConfig`: 配置接口
  - `ILeaferAnnotate`: 核心类接口
  - `IImageInfo`: 图片信息接口

#### `leafer.config.ts` - 配置常量

- **功能**: 集中管理所有配置常量
- **包含**:
  - `DEFAULT_LEAFER_CONFIG`: Leafer 应用默认配置
  - `DEFAULT_RECT_CONFIG`: 矩形元素默认配置
  - `DEFAULT_SNAP_CONFIG`: 吸附功能默认配置
  - `DEFAULT_RULER_CONFIG`: 标尺默认配置

#### `leafer.helper.ts` - 工具函数

- **功能**: 提供各种通用工具函数
- **主要函数**:
  - `loadImage()`: 图片加载处理
  - `processMarksToRects()`: 标注数据转换为矩形
  - `createRect()`: 创建矩形元素
  - `calculateRectBounds()`: 计算矩形边界
  - `configureInteractionMode()`: 配置交互模式

### 功能模块

#### `leafer.createRect.ts` - 矩形创建

- **功能**: 处理用户拖拽创建矩形的交互逻辑
- **核心类**: `CreateRectBinding`
- **特性**:
  - 支持拖拽预览
  - 实时吸附对齐
  - 尺寸限制
  - 事件回调

#### `leafer.drop.ts` - 拖拽功能

- **功能**: 处理从工具栏拖拽元素到画布的功能
- **核心类**: `DropBinding`
- **特性**:
  - 支持外部元素拖拽
  - 边界约束
  - 坐标转换
  - 元素创建

#### `leafer.copyRect.ts` - 矩形复制

- **功能**: 支持 Ctrl+拖拽复制矩形元素
- **核心类**: `CopyRectBinding`
- **特性**:
  - 键盘事件监听
  - 元素克隆
  - 数据交换

#### `leafer.adsorption.ts` - 吸附对齐

- **功能**: 提供像素级精确对齐功能
- **核心类**: `AdsorptionBinding`
- **特性**:
  - 属性变化监听
  - 坐标四舍五入
  - 精确控制

#### `leafer.proxyData.ts` - 响应式数据

- **功能**: 为 Leafer 元素提供 Vue 响应式数据支持
- **特性**:
  - 浅层响应式处理
  - 深度监听 data 字段
  - 自动同步更新

### 插件系统

#### `plugins/snap/` - 智能吸附插件

- **功能**: 提供智能吸附对齐功能
- **核心特性**:
  - 元素边界点检测
  - 吸附线计算
  - 碰撞检测
  - 可视化渲染
  - 等间距计算

## 使用流程

1. **初始化**: 创建 LeaferAnnotate 实例
2. **配置**: 设置画布、图片、标注数据
3. **启动**: 调用 init() 方法初始化
4. **交互**: 用户进行标注操作
5. **销毁**: 调用 destroy() 清理资源

## 扩展性

- 新增功能模块只需实现对应的 Binding 类
- 插件系统支持自定义吸附算法
- 配置系统支持运行时调整
- 事件系统支持自定义回调

## 扩展指南

如需添加新功能，请参考 [04-添加新功能.md](./04-添加新功能.md) 文档，该文档详细说明了如何通过 Binding 方式或 Class 扩展方式来添加新功能。
