# PDF出血处理

## 1. 什么是出血(Bleed)

**出血(Bleed)**是印刷行业的重要概念，指的是印刷品边缘向外延伸的区域，用于确保在裁切后不会有白边。

### 1.1 出血的作用

**防止裁切误差**：
- 印刷厂在裁切纸张时存在±1-2mm的机械误差
- 如果没有出血，裁切后可能出现白边
- 出血确保了即使有轻微裁切偏移，背景色/图像也能覆盖到边缘

**视觉完整性**：
- 保证印刷品的色彩或设计元素能够完整延伸到页面边缘
- 避免裁切后留下不美观的白色边框

### 1.2 标准出血尺寸

**国际标准**：
- **常见出血值**: 3mm (约0.125英寸)
- **美式标准**: 0.125英寸 (约3.2mm)
- **欧洲标准**: 3-5mm

**实际应用**：
- A4纸成品: 210×297mm
- A4纸含出血: 216×303mm (每边加3mm出血)


## 2. 出血处理
```js
// 出血处理公式
const offsetX = bleed * (dpi / 25.4)
const offsetY = bleed * (dpi / 25.4)

// px = mm * (dpi / 25.4) + 出血
const pxX = x * scaleX + offsetX
const pxY = y * scaleY + offsetY
```