/*
 * @Author: zengzhe
 * @Date: 2025-08-18 09:29:26
 * @LastEditors: zengzhe
 * @LastEditTime: 2025-10-28 09:19:39
 * @Description: 
 */
import { Resource } from "leafer-ui";
export function loadImage(src) {
  return new Promise((resolve, reject) => {
    const image = new window.Image()
    if (src.includes(';base64')) {
      image.src = src
    } else {
      if (!src.includes('?')) {
        src += '?time=' + new Date().valueOf()
      } else {
        src += '&time=' + new Date().valueOf()
      }
      image.src = src
      image.crossOrigin = 'Anonymous'
    }

    image.onload = () => {
      const { url } = Resource.setImage(`leafer://bg.png`, image)
      resolve({
        url: url,
        width: image.width,
        height: image.height
      })
    }
    image.onerror = () => {
      console.error('底图加载失败')
      reject('file load iamge')
    }
  })
  }

/**
* 直接从strokes字符串生成Path路径数据，按顺序连接所有点
* @param {string} strokesStr strokes字符串
* @param {number} scaleX X轴坐标换算比例
* @param {number} scaleY Y轴坐标换算比例
* @param {number} offsetX X轴出血偏移量
* @param {number} offsetY Y轴出血偏移量
* @returns {string} 路径字符串
*/
export function optimizedCreatePathsFromStrokes(strokesStr, scaleX, scaleY, offsetX = 0, offsetY = 0) {
  if (!strokesStr || typeof strokesStr !== 'string') return ''

  const strokePoints = strokesStr.split(';')
  if (strokePoints.length === 0) return ''

  const pathParts = []
  let needMoveTo = true // 是否需要移动到新起点

  // 一次遍历完成：解析、坐标转换、构建路径
  for (let i = 0; i < strokePoints.length; i++) {
    const pointStr = strokePoints[i].trim()
    if (!pointStr) continue

    const parts = pointStr.split(',')
    if (parts.length < 6) continue
    const x = parseFloat(parts[0])
    const y = parseFloat(parts[1])
    if (x <= 0 && y <= 0) continue
    const strokeStart = parts[3] === 'true'
    const strokeEnd = parts[4] === 'true'

    // 如果是抬笔，跳过该点并重置状态
    if (strokeEnd) {
      needMoveTo = true
      continue
    }

    // 直接使用比例换算坐标
    const pxX = x * scaleX + offsetX
    const pxY = y * scaleY + offsetY

    // 构建路径字符串
    if (needMoveTo || strokeStart) {
      pathParts.push(`M ${pxX} ${pxY}`)
      needMoveTo = false
    } else {
      pathParts.push(`L ${pxX} ${pxY}`)
    }
  }

  return pathParts.join(' ')
}