/* eslint-disable no-unused-vars */
import { Leafer, App, Debug, Rect, Image, Frame, Platform, Box, Group,Path } from "leafer-ui";
import '@leafer-in/editor' // 导入交互状态插件
import '@leafer-in/viewport' // 导入视口插件
import '@leafer-in/view' // 导入视口插件
import '@leafer-in/state' // 导入交互状态插件
import '@leafer-in/resize' // 导入交互状态插件
import '@leafer-in/find'
import { cloneDeep } from 'lodash'
import { loadImage,optimizedCreatePathsFromStrokes } from './leafer-util'
class LeaferAnnotate {
  constructor(config) {
    this.config = cloneDeep(config)
  }
  async init() {
    let { view, pageUrl, marks,points } = this.config
    this.leafer = new App({
      view: view,
      fill: '#333',
      // type: 'viewport',
      zoom: { min: 0.1, max: 10 },

      editor: { rotateable: false }
    })
    let { url, width, height } = await loadImage(pageUrl)
    this.pageFrame = new Frame({
      width: width,
      height: height,

    })
    this.leafer.tree.add(this.pageFrame)
    this.pageFrame.add(new Image({ url: url }, width, height))
    this.leafer.zoom('fit', 0)

    this.initMarks(marks)
    this.initPoints(points)
  }

  initMarks(marks) {
    if (!Array.isArray(marks) || !this.pageFrame) return
    const layer = this.pageFrame
    for (const mark of marks) {
      const hasPoint = mark && mark.top && mark.bottom
      if (!hasPoint) continue
      const left = Math.min(mark.top.x, mark.bottom.x)
      const right = Math.max(mark.top.x, mark.bottom.x)
      const top = Math.min(mark.top.y, mark.bottom.y)
      const bottom = Math.max(mark.top.y, mark.bottom.y)

      const p1 = { x: left, y: top }
      const p2 = { x: right, y: bottom }

      const rect = new Rect({
        className: 'mark',
        x: p1.x,
        y: p1.y,
        width: Math.max(0, Math.abs(p2.x - p1.x)),
        height: Math.max(0, Math.abs(p2.y - p1.y)),
        fill: 'transparent',
        stroke: '#ff0000',
        strokeWidth: 1,
        cornerRadius: 0,

      })
      layer.add(rect)
    }
  }

  initPoints(datas) {
    if (!Array.isArray(datas) || datas.length === 0) return
    datas.forEach((point, index) => {
      if (!point.strokes) return

      // 使用预计算的比例进行坐标换算，按需添加出血偏移
      let offsetX = 0
      let offsetY = 0
      if (this.needBleed) {
        const bleedMm = Number(import.meta.env.VITE_BLEED_SIZE ?? 3)
        offsetX = bleedMm * this.coordinateScaleX
        offsetY = bleedMm * this.coordinateScaleY
      }
      const path = optimizedCreatePathsFromStrokes(
        point.strokes,
        300 / 25.4,
        300 / 25.4,
        offsetX,
        offsetY
      )

      const pathElement = new Path({
        id: `point-${index}`,
        path: path,
        stroke: '#000000',
        strokeWidth: 1 * 3,
        fill: null,
        closed: false,
        strokeCap: 'round',
        strokeJoin: 'round'
      })
      this.pageFrame.add(pathElement)
    })
  }
}


export const createLeaferAnnotate = async (config) => {
  const instance = new LeaferAnnotate(cloneDeep(config))
  await instance.init()
  return instance
};


