/*
 * @Author: zengzhe
 * @Date: 2024-08-15 14:18:08
 * @LastEditors: zengzhe
 * @LastEditTime: 2024-08-27 16:46:00
 * @Description:
 */
import { clone } from 'lodash'
import { loadImage } from './konva'
import dayjs from 'dayjs'
const toolImage4 = require('./tools-image/tool-icon-4.svg')
const toolImage5 = require('./tools-image/tool-icon-5.svg')
const toolImage6 = require('./tools-image/tool-icon-6.svg')
const toolImage7 = require('./tools-image/tool-icon-7.svg')

export const toolGroups1 = [
  {
    label: '错误',
    icon: 'tool-icon-4',
    configPanelVisible: false,
    config: {
      width: 48,
      height: 48,
      draggable: true,
      imageUrl: 'toolImage4',
      component: 'v-image'
    },
    instance: null,
    onActive(app) {
      app.cursor = 'crosshair'
    },
    onInactive(app) {
      app.cursor = ''
    },
    mouseup(event, app, tool) {
      // const { image } = await loadImage(toolImage1)
      tool.instance = {
        time: dayjs().format('YYYY-MM-DD HH:mm'),
        icon: tool.icon,
        label: tool.label,
        id: `v-image-${new Date().getTime()}`,
        name: `v-image-${new Date().getTime()}`,
        x: app.pointer.x - tool.config.width / 2,
        y: app.pointer.y - tool.config.height / 2,
        ...tool.config
      }
      loadImage(toolImage4).then(({ image }) => {
        let index = app.store.findIndex(v => v.id == tool.instance.id)
        app.config.getCompThis().$set(app.store, index, {
          ...app.store[index],
          image: image
        })
      })
      let ids = app.store.map(v => v.id)
      if (!ids.includes(tool.instance.id)) {
        if (app.debug) {
          console.log('错误工具push进入了store')
        }
        app.store.push(tool.instance)
        app.saveStoreState()
      }
    }
  },
  {
    label: '正确',
    icon: 'tool-icon-5',
    configPanelVisible: false,
    config: {
      width: 48,
      height: 48,
      draggable: true,
      imageUrl: 'toolImage5',
      component: 'v-image'
    },
    instance: null,
    onActive(app) {
      app.cursor = 'crosshair'
    },
    onInactive(app) {
      app.cursor = ''
    },
    mouseup(event, app, tool) {
      // const { image } = await loadImage(toolImage1)
      tool.instance = {
        time: dayjs().format('YYYY-MM-DD HH:mm'),
        icon: tool.icon,
        label: tool.label,
        id: `v-image-${new Date().getTime()}`,
        name: `v-image-${new Date().getTime()}`,
        x: app.pointer.x - tool.config.width / 2,
        y: app.pointer.y - tool.config.height / 2,
        ...tool.config
      }
      loadImage(toolImage5).then(({ image }) => {
        let index = app.store.findIndex(v => v.id == tool.instance.id)
        app.config.getCompThis().$set(app.store, index, {
          ...app.store[index],
          image: image
        })
      })
      let ids = app.store.map(v => v.id)
      if (!ids.includes(tool.instance.id)) {
        if (app.debug) {
          console.log('正确工具push进入了store')
        }
        app.store.push(tool.instance)
        app.saveStoreState()
      }
    }
  },
  {
    label: '半对',
    icon: 'tool-icon-6',
    configPanelVisible: false,
    config: {
      width: 48,
      height: 48,
      draggable: true,
      imageUrl: 'toolImage6',
      component: 'v-image'
    },
    instance: null,
    onActive(app) {
      app.cursor = 'crosshair'
    },
    onInactive(app) {
      app.cursor = ''
    },
    mouseup(event, app, tool) {
      // const { image } = await loadImage(toolImage1)
      tool.instance = {
        time: dayjs().format('YYYY-MM-DD HH:mm'),
        icon: tool.icon,
        label: tool.label,
        id: `v-image-${new Date().getTime()}`,
        name: `v-image-${new Date().getTime()}`,
        x: app.pointer.x - tool.config.width / 2,
        y: app.pointer.y - tool.config.height / 2,
        ...tool.config
      }
      loadImage(toolImage6).then(({ image }) => {
        let index = app.store.findIndex(v => v.id == tool.instance.id)
        app.config.getCompThis().$set(app.store, index, {
          ...app.store[index],
          image: image
        })
      })
      let ids = app.store.map(v => v.id)
      if (!ids.includes(tool.instance.id)) {
        if (app.debug) {
          console.log('半对工具push进入了store')
        }
        app.store.push(tool.instance)
        app.saveStoreState()
      }
    }
  },
  {
    label: '疑问',
    icon: 'tool-icon-7',
    configPanelVisible: false,
    config: {
      width: 48,
      height: 48,
      draggable: true,
      imageUrl: 'toolImage7',
      component: 'v-image'
    },
    instance: null,
    onActive(app) {
      app.cursor = 'crosshair'
    },
    onInactive(app) {
      app.cursor = ''
    },
    mouseup(event, app, tool) {
      // const { image } = await loadImage(toolImage1)
      tool.instance = {
        time: dayjs().format('YYYY-MM-DD HH:mm'),
        icon: tool.icon,
        label: tool.label,
        id: `v-image-${new Date().getTime()}`,
        name: `v-image-${new Date().getTime()}`,
        x: app.pointer.x - tool.config.width / 2,
        y: app.pointer.y - tool.config.height / 2,
        ...tool.config
      }
      loadImage(toolImage7).then(({ image }) => {
        let index = app.store.findIndex(v => v.id == tool.instance.id)
        app.config.getCompThis().$set(app.store, index, {
          ...app.store[index],
          image: image
        })
      })
      let ids = app.store.map(v => v.id)
      if (!ids.includes(tool.instance.id)) {
        if (app.debug) {
          console.log('疑问工具push进入了store')
        }
        app.store.push(tool.instance)
        app.saveStoreState()
      }
    }
  }
]
export const toolGroups2 = [
  {
    label: '直线',
    icon: 'tool-icon-8',
    config: {
      points: [0, 0, 0, 0], // 初始点设置为(0, 0) 到 (0, 0)
      stroke: 'red',
      strokeWidth: 2,
      lineCap: 'round',
      lineJoin: 'round',
      draggable: true,
      component: 'v-line'
    },
    instance: null,
    onActive(app) {
      app.cursor = 'crosshair'
      //选择工具时，设置默认颜色和粗细
      app.panelConfig.stroke = '#FA5151'
      app.panelConfig.strokeWidth = 2
    },
    onInactive(app) {
      app.cursor = ''
    },
    mousedown: (event, app, tool) => {
      if (tool.instance) {
        return
      }
      app.startPointer = clone(app.pointer)
      tool.instance = {
        time: dayjs().format('YYYY-MM-DD HH:mm'),
        icon: tool.icon,
        label: tool.label,
        id: `v-line-${new Date().getTime()}`,
        name: `v-line-${new Date().getTime()}`,
        points: [
          app.startPointer.x,
          app.startPointer.y,
          app.startPointer.x,
          app.startPointer.y
        ],
        ...tool.config,
        ...app.panelConfig
      }
      let ids = app.store.map(v => v.id)
      if (!ids.includes(tool.instance.id)) {
        if (app.debug) {
          console.log('直线工具push进入了store')
        }
        app.store.push(tool.instance)
      }
    },
    mousemove: (event, app, tool) => {
      if (!tool.instance) {
        return
      }
      const endX = app.pointer.x
      const endY = app.pointer.y
      let index = app.store.findIndex(v => v.id == tool.instance.id)
      app.config.getCompThis().$set(app.store, index, {
        ...app.store[index],
        points: [app.startPointer.x, app.startPointer.y, endX, endY]
      })
    },
    mouseup: (event, app, tool) => {
      if (!tool.instance) {
        return
      }
      if (
        app.startPointer.x == app.pointer.x &&
        app.startPointer.y == app.pointer.y
      ) {
        app.store = app.store.filter(v => v.id != tool.instance.id)
        tool.instance = null
        if (app.debug) {
          console.log('直线工具的起始位置相同，被销毁,从store里移除')
        }
        return
      }
      app.saveStoreState()
      tool.instance = null
    }
  },
  {
    label: '箭头',
    icon: 'tool-icon-9',
    config: {
      points: [0, 0, 0, 0], // 初始点设置为(0, 0) 到 (0, 0)
      pointerLength: 10, // 箭头头部长度
      pointerWidth: 10, // 箭头头部宽度
      stroke: 'red',
      strokeWidth: 2,
      lineCap: 'round',
      lineJoin: 'round',
      draggable: true,
      component: 'v-arrow'
    },
    instance: null,
    onActive(app) {
      app.cursor = 'crosshair'
      //选择工具时，设置默认颜色和粗细
      app.panelConfig.stroke = '#FA5151'
      app.panelConfig.strokeWidth = 2
    },
    onInactive(app) {
      app.cursor = ''
    },
    mousedown: (event, app, tool) => {
      if (tool.instance) {
        return
      }
      app.startPointer = clone(app.pointer)
      tool.instance = {
        time: dayjs().format('YYYY-MM-DD HH:mm'),
        icon: tool.icon,
        label: tool.label,
        id: `v-arrow-${new Date().getTime()}`,
        name: `v-arrow-${new Date().getTime()}`,
        points: [
          app.startPointer.x,
          app.startPointer.y,
          app.startPointer.x,
          app.startPointer.y
        ],
        ...tool.config,
        ...app.panelConfig
      }
      let ids = app.store.map(v => v.id)
      if (!ids.includes(tool.instance.id)) {
        if (app.debug) {
          console.log('箭头工具push进入了store')
        }
        app.store.push(tool.instance)
      }
    },
    mousemove: (event, app, tool) => {
      if (!tool.instance) {
        return
      }
      const endX = app.pointer.x
      const endY = app.pointer.y
      let index = app.store.findIndex(v => v.id == tool.instance.id)
      app.config.getCompThis().$set(app.store, index, {
        ...app.store[index],
        points: [app.startPointer.x, app.startPointer.y, endX, endY]
      })
    },
    mouseup: (event, app, tool) => {
      if (!tool.instance) {
        return
      }
      if (
        app.startPointer.x == app.pointer.x &&
        app.startPointer.y == app.pointer.y
      ) {
        app.store = app.store.filter(v => v.id != tool.instance.id)
        tool.instance = null
        if (app.debug) {
          console.log('箭头工具的起始位置相同，被销毁,从store里移除')
        }
        return
      }
      app.saveStoreState()
      tool.instance = null
    }
  },
  {
    label: '矩形',
    icon: 'tool-icon-10',
    config: {
      cornerRadius: 4,
      stroke: 'red',
      strokeWidth: 4,
      strokeScaleEnabled: true,
      draggable: true,
      component: 'v-rect'
    },
    instance: null,
    onActive(app) {
      app.cursor = 'crosshair'
      //选择工具时，设置默认颜色和粗细
      app.panelConfig.stroke = '#FA5151'
      app.panelConfig.strokeWidth = 2
    },
    onInactive(app) {
      app.cursor = ''
    },
    // onActive(app, tool) {},
    mousedown: (event, app, tool) => {
      if (tool.instance) {
        return
      }
      app.startPointer = clone(app.pointer)
      tool.instance = {
        time: dayjs().format('YYYY-MM-DD HH:mm'),
        icon: tool.icon,
        label: tool.label,
        id: `v-rect-${new Date().getTime()}`,
        name: `v-rect-${new Date().getTime()}`,
        width: 0,
        height: 0,
        ...tool.config,
        ...app.startPointer,
        ...app.panelConfig
      }
      let ids = app.store.map(v => v.id)
      if (!ids.includes(tool.instance.id)) {
        if (app.debug) {
          console.log('矩形工具push进入了store')
        }
        app.store.push(tool.instance)
      }
    },
    mousemove: (event, app, tool) => {
      if (!tool.instance) {
        return
      }
      let index = app.store.findIndex(v => v.id == tool.instance.id)
      app.config.getCompThis().$set(app.store, index, {
        ...app.store[index],
        x: Math.min(app.startPointer.x, app.pointer.x),
        y: Math.min(app.startPointer.y, app.pointer.y),
        width: Math.abs(app.pointer.x - app.startPointer.x),
        height: Math.abs(app.pointer.y - app.startPointer.y)
      })
    },
    mouseup: (event, app, tool) => {
      if (!tool.instance) {
        return
      }
      if (
        app.startPointer.x == app.pointer.x &&
        app.startPointer.y == app.pointer.y
      ) {
        app.store = app.store.filter(v => v.id != tool.instance.id)
        tool.instance = null
        if (app.debug) {
          console.log('矩形工具的起始位置相同，被销毁,从store里移除')
        }
        return
      }
      app.saveStoreState()
      tool.instance = null
    }
  },
  {
    label: '椭圆',
    icon: 'tool-icon-11',
    config: {
      sides: 4,
      // radius: 0,
      cornerRadius: 4,
      stroke: 'red',
      draggable: true,
      component: 'v-ellipse'
    },
    instance: null,
    onActive(app) {
      app.cursor = 'crosshair'
      //选择工具时，设置默认颜色和粗细
      app.panelConfig.stroke = '#FA5151'
      app.panelConfig.strokeWidth = 2
    },
    onInactive(app) {
      app.cursor = ''
    },
    mousedown: (event, app, tool) => {
      if (tool.instance) {
        return
      }
      app.startPointer = clone(app.pointer)
      tool.instance = {
        time: dayjs().format('YYYY-MM-DD HH:mm'),
        icon: tool.icon,
        label: tool.label,
        id: `v-ellipse-${new Date().getTime()}`,
        name: `v-ellipse-${new Date().getTime()}`,
        radiusX: 0,
        radiusY: 0,
        x: app.startPointer.x,
        y: app.startPointer.y,
        ...tool.config,
        ...app.panelConfig
      }
      let ids = app.store.map(v => v.id)
      if (!ids.includes(tool.instance.id)) {
        if (app.debug) {
          console.log('圆形工具push进入了store')
        }
        app.store.push(tool.instance)
      }
    },
    mousemove: (event, app, tool) => {
      if (!tool.instance) {
        return
      }
      const dx = app.pointer.x - app.startPointer.x
      const dy = app.pointer.y - app.startPointer.y
      let index = app.store.findIndex(v => v.id == tool.instance.id)
      app.config.getCompThis().$set(app.store, index, {
        ...app.store[index],
        x: app.startPointer.x + dx / 2,
        y: app.startPointer.y + dy / 2,
        radiusX: Math.abs(dx) / 2,
        radiusY: Math.abs(dy) / 2
      })
    },
    mouseup: (event, app, tool) => {
      if (!tool.instance) {
        return
      }
      if (
        app.startPointer.x == app.pointer.x &&
        app.startPointer.y == app.pointer.y
      ) {
        app.store = app.store.filter(v => v.id != tool.instance.id)
        tool.instance = null
        if (app.debug) {
          console.log('圆形工具的起始位置相同，被销毁,从store里移除')
        }
        return
      }
      app.saveStoreState()
      tool.instance = null
    }
  }
]
export const toolGroups3 = [
  {
    label: '画笔',
    icon: 'tool-icon-12',
    config: {
      points: [], // 初始点为空
      stroke: 'red',
      strokeWidth: 2,
      lineCap: 'round',
      lineJoin: 'round',
      tension: 0.5, // 使线条更光滑
      draggable: true,
      component: 'v-line'
    },
    instance: null,
    onActive(app) {
      app.cursor = 'crosshair'
      //选择工具时，设置默认颜色和粗细
      app.panelConfig.stroke = '#FA5151'
      app.panelConfig.strokeWidth = 2
    },
    onInactive(app) {
      app.cursor = ''
    },
    mousedown: (event, app, tool) => {
      if (tool.instance) {
        return
      }
      app.startPointer = clone(app.pointer)
      tool.instance = {
        time: dayjs().format('YYYY-MM-DD HH:mm'),
        icon: tool.icon,
        label: tool.label,
        id: `v-line-${new Date().getTime()}`,
        name: `v-line-${new Date().getTime()}`,
        points: [app.startPointer.x, app.startPointer.y],
        ...tool.config,
        ...app.panelConfig
      }
      let ids = app.store.map(v => v.id)
      if (!ids.includes(tool.instance.id)) {
        if (app.debug) {
          console.log('画笔工具push进入了store')
        }
        app.store.push(tool.instance)
      }
    },
    mousemove: (event, app, tool) => {
      if (!tool.instance) {
        return
      }
      const newPoint = [app.pointer.x, app.pointer.y]
      tool.instance.points = tool.instance.points.concat(newPoint)
      let index = app.store.findIndex(v => v.id == tool.instance.id)
      app.config.getCompThis().$set(app.store, index, {
        ...app.store[index],
        points: tool.instance.points
      })
    },
    mouseup: (event, app, tool) => {
      if (!tool.instance) {
        return
      }
      if (tool.instance.points.length <= 2) {
        app.store = app.store.filter(v => v.id != tool.instance.id)
        tool.instance = null
        if (app.debug) {
          console.log('画笔工具的起始位置相同或线段太短，被销毁,从store里移除')
        }
        return
      }
      app.saveStoreState()
      tool.instance = null
    }
  },

  {
    label: '文字',
    icon: 'tool-icon-13',
    config: {
      text: '',
      fontSize: 18,
      fontFamily: 'Arial',
      fill: 'red',
      padding: 0,
      align: 'left',
      draggable: true,
      component: 'v-text'
    },
    instance: null,
    onActive(app) {
      app.cursor = 'crosshair'
      //选择工具时，设置默认颜色和粗细
      app.panelConfig.stroke = '#FA5151'
      app.panelConfig.strokeWidth = 2
    },
    onInactive(app) {
      app.cursor = ''
    },

    dblclick(event, app, tool) {
      // if (tool.instance) {
      //   return
      // }

      // 保存起始位置
      app.startPointer = clone(app.pointer)

      // 创建新的文本节点实例
      let instance = {
        time: dayjs().format('YYYY-MM-DD HH:mm'),
        icon: tool.icon,
        label: tool.label,
        id: `v-text-${new Date().getTime()}`,
        name: `v-text-${new Date().getTime()}`,
        x: app.startPointer.x,
        y: app.startPointer.y,
        // width: 80,
        // height: 18,
        ...tool.config,
        fill: app.panelConfig.stroke
        // ...app.panelConfig
      }

      // 将文本节点添加到 store
      let ids = app.store.map(v => v.id)
      if (!ids.includes(instance.id)) {
        if (app.debug) {
          console.log('文字工具push进入了store')
        }
        app.store.push(instance)
        // app.activeTool = null
        app.setActiveTool(null)
        setTimeout(() => {
          let textNode = app.stage.findOne('#' + instance.id)
          let index = app.store.findIndex(v => v.id == instance.id)

          textNode.on('dblclick', ({ target }) => {
            createTextarea(app, target, index, () => {
              app.saveStoreState()
            })
          })
          textNode.fire('dblclick')
        })
      }
    }
  }
]

export const createTextarea = (app, textNode, index, onUpdated) => {
  textNode.hide()

  const textPosition = textNode.getClientRect()
  const areaPosition = {
    x: app.stage.container().offsetLeft + textPosition.x,
    y: app.stage.container().offsetTop + textPosition.y
  }

  const textarea = document.createElement('textarea')
  app.stage.container().appendChild(textarea)

  const transform = `translateY(-${Math.round(textNode.fontSize() / 20)}px)`

  Object.assign(textarea.style, {
    position: 'absolute',
    display: 'inline-block',
    minHeight: '1em',
    minWidth: '8em',
    backfaceVisibility: 'hidden',
    resize: 'none',
    background: 'transparent',
    overflow: 'hidden',
    overflowWrap: 'break-word',
    boxSizing: 'content-box',
    top: `${areaPosition.y}px`,
    left: `${areaPosition.x}px`,
    width: `${
      textNode.width() * textNode.scaleX() - textNode.padding() * 2 + 10
    }px`,
    height: `${
      textNode.height() * textNode.scaleY() - textNode.padding() * 2 + 5
    }px`,
    fontSize: `${textNode.fontSize() * textNode.scaleX()}px`,
    border: 0,
    padding: 0,
    margin: 0,
    outline: 0,
    lineHeight: textNode.lineHeight().toString(),
    fontFamily: textNode.fontFamily(),
    textAlign: textNode.align(),
    color: textNode.fill(),
    caretColor: textNode.fill(),
    zIndex: '99999',
    transformOrigin: 'left top',
    transform: transform
  })

  textarea.value = textNode.text()
  textarea.style.height = `${textarea.scrollHeight + 3}px`
  textarea.placeholder = '请填写'
  textarea.focus()

  function removeTextarea() {
    textarea.parentNode?.removeChild(textarea)
    window.removeEventListener('click', handleOutsideClick)
    textNode.show()
  }

  textarea.addEventListener('keydown', e => {
    e.stopPropagation()
    if (e.key === 'Escape') {
      removeTextarea()
    }
  })

  textarea.addEventListener('input', () => {
    const text = textarea.value.replace(/\n/g, '<br/>')
    const tempDiv = document.createElement('div')
    tempDiv.innerHTML = text
    tempDiv.style.position = 'absolute'
    tempDiv.style.visibility = 'hidden'
    tempDiv.style.whiteSpace = 'pre-wrap'
    document.body.appendChild(tempDiv)

    const newWidth = tempDiv.offsetWidth + 10
    textarea.style.width = `${newWidth}px`
    document.body.removeChild(tempDiv)

    // const lineHeight = parseFloat(getComputedStyle(textarea).lineHeight)
    // const rows = textarea.value.split('\n').length
    textarea.style.height = 'auto'
    const newHeight = textarea.scrollHeight
    textarea.style.height = `${newHeight}px`
    textNode.width(newWidth / textNode.scaleX())
    textNode.height(newHeight / textNode.scaleY())
  })

  function handleOutsideClick(e) {
    if (e.target !== textarea) {
      if (textarea.value.trim().length >= 1) {
        // textNode.text(textarea.value)
        app.config.getCompThis().$set(app.store, index, {
          ...app.store[index],
          width: textarea.clientWidth / textNode.scaleX(),
          height: textarea.clientHeight / textNode.scaleY(),
          text: textarea.value
        })
      } else {
        app.store = app.store.filter((v, i) => i != index)
      }

      removeTextarea()
      onUpdated()
    }
  }

  setTimeout(() => {
    window.addEventListener('click', handleOutsideClick)
  })
}
