/* eslint-disable no-unused-vars */
import { Leafer,App, Debug, Rect, Image, Frame, Platform, Box,Resource,Group } from "leafer-ui";
import '@leafer-in/editor' // 导入交互状态插件
import '@leafer-in/viewport' // 导入视口插件
import '@leafer-in/view' // 导入视口插件
import '@leafer-in/state' // 导入交互状态插件
import '@leafer-in/resize' // 导入交互状态插件
import { cloneDeep } from 'lodash'
class LeaferAnnotate {
  constructor(config) {
    this.config = cloneDeep(config)
  }
  changeMode(mode) {
    this.mode = mode
    if (mode === 'view') {
      this.pageFrame.hitChildren = true
      this.pageFrame.children.forEach(child => {
        if (child.className === 'mark') {
          child.hoverStyle = {
            fill: 'rgba(50,205,121, 0.8)'
          }
        }
      })
    } else if (mode === 'edit') {
      this.pageFrame.hitChildren = false
      this.pageFrame.children.forEach(child => {
        if (child.className === 'mark') {
          child.hoverStyle = {
            fill: ''
          }
        }
      })
    }
  }
  async init() {
    let { view, pageUrl, marks } = this.config
    this.leafer = new App({
      view: view,
      fill: '#333',
      type: 'viewport',
      zoom: { min: 0.1, max: 10 },
      wheel: { zoomMode: true },
      move: {drag: 'auto' },
      editor: {  }
    })
    let { url, width, height } = await loadImage(pageUrl)
    this.pageFrame = new Frame({
      width: width,
      height: height,
   
    })
    // this.leafer.tree.zoomLayer = this.pageFrame
    this.leafer.tree.add(this.pageFrame)
    this.pageFrame.add(new Image({ url: url }, width, height))
    this.leafer.zoom('fit', 0)
    this.initMarks(marks)
    this.changeMode('view')



  }
  /**
   * 基于世界坐标批量绘制标注矩形
   * @param {Array<{top:{x:number,y:number},bottom:{x:number,y:number}}>} marks
   */
  initMarks(marks) {
    if (!Array.isArray(marks) || !this.pageFrame) return
    const layer = this.pageFrame
    for (const mark of marks) {
      const hasPoint = mark && mark.top && mark.bottom
      if (!hasPoint) continue
      const left = Math.min(mark.top.x, mark.bottom.x)
      const right = Math.max(mark.top.x, mark.bottom.x)
      const top = Math.min(mark.top.y, mark.bottom.y)
      const bottom = Math.max(mark.top.y, mark.bottom.y)

      const p1 = { x: left, y: top }
      const p2 = { x: right, y: bottom }

      const rect = new Rect({
        className: 'mark',
        x: p1.x,
        y: p1.y,
        width: Math.max(0, Math.abs(p2.x - p1.x)),
        height: Math.max(0, Math.abs(p2.y - p1.y)),
        fill: 'transparent',
        stroke: '#ff0000',
        strokeWidth: 1,
        cornerRadius: 0,
        editable:false,
     
      })
      layer.add(rect)
    }
  }
}


export const createLeaferAnnotate = async (config) => {
  const instance = new LeaferAnnotate(cloneDeep(config))
  await instance.init()
  return instance
};

export function loadImage(src) {
  return new Promise((resolve, reject) => {
    const image = new window.Image()
    if (src.includes(';base64')) {
      image.src = src // 直接使用 base64 字符串
    } else {
      image.src = src + '?time=' + new Date().valueOf()
      image.crossOrigin = 'Anonymous'
    }

    image.onload = () => {
      const { url } = Resource.setImage('leafer://test1.jpg', image) 
      resolve({
        url: url,
        width: image.width,
        height: image.height
      })
    }
    image.onerror = () => {
      console.error('底图加载失败')
      reject('file load iamge')
    }
  })
}
